/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.beanProperties.BeanProperty;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.refactoring.rename.BeanPropertyRenameHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CommonEditorReferenceBeanPropertyRenameHandler
extends BeanPropertyRenameHandler {
    private final Class<? extends PsiReference> acceptableReferenceClass;

    protected CommonEditorReferenceBeanPropertyRenameHandler(Class<? extends PsiReference> acceptableReference) {
        this.acceptableReferenceClass = acceptableReference;
    }

    protected CommonEditorReferenceBeanPropertyRenameHandler() {
        this.acceptableReferenceClass = PsiReference.class;
    }

    @Override
    @Nullable
    protected BeanProperty getProperty(DataContext context) {
        return this.getBeanProperty(context);
    }

    @Nullable
    protected BeanProperty getBeanProperty(DataContext dataContext) {
        Project project;
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (file == null && editor != null && ApplicationManager.getApplication().isUnitTestMode() && (project = editor.getProject()) != null) {
            file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        }
        if (editor != null && file != null) {
            return this.getBeanProperty(editor, file);
        }
        return null;
    }

    @Nullable
    protected BeanProperty getBeanProperty(@NotNull Editor editor, @NotNull PsiFile file) {
        int offset;
        PsiReference reference;
        if (editor == null) {
            CommonEditorReferenceBeanPropertyRenameHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            CommonEditorReferenceBeanPropertyRenameHandler.$$$reportNull$$$0(1);
        }
        if ((reference = file.findReferenceAt(offset = editor.getCaretModel().getOffset())) == null) {
            return null;
        }
        return this.getBeanProperty(reference);
    }

    @Nullable
    protected BeanProperty getBeanProperty(@Nullable PsiElement psiElement) {
        if (psiElement instanceof PsiMethod && PropertyUtilBase.isSimplePropertyAccessor((PsiMethod)((PsiMethod)psiElement))) {
            return BeanProperty.createBeanProperty((PsiMethod)((PsiMethod)psiElement));
        }
        return null;
    }

    @Nullable
    protected BeanProperty getBeanProperty(@NotNull PsiReference reference) {
        if (reference == null) {
            CommonEditorReferenceBeanPropertyRenameHandler.$$$reportNull$$$0(2);
        }
        if (this.acceptableReferenceClass.isAssignableFrom(reference.getClass())) {
            PsiElement psiElement = reference.resolve();
            return this.getBeanProperty(psiElement);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "reference";
                break;
            }
        }
        objectArray[1] = "com/intellij/refactoring/rename/CommonEditorReferenceBeanPropertyRenameHandler";
        objectArray[2] = "getBeanProperty";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

