/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveDirectoryWithClassesProcessor;
import com.intellij.refactoring.rename.DirectoryAsPackageRenameHandlerBase;
import org.jetbrains.annotations.NotNull;

public class DirectoryAsPackageRenameHandler
extends DirectoryAsPackageRenameHandlerBase<PsiPackage> {
    protected VirtualFile[] occursInPackagePrefixes(PsiPackage aPackage) {
        return aPackage.occursInPackagePrefixes();
    }

    protected boolean isIdentifier(String name, Project project) {
        return PsiNameHelper.getInstance((Project)project).isIdentifier(name);
    }

    @NotNull
    protected String getQualifiedName(PsiPackage aPackage) {
        String string = aPackage.getQualifiedName();
        if (string == null) {
            DirectoryAsPackageRenameHandler.$$$reportNull$$$0(0);
        }
        return string;
    }

    protected PsiPackage getPackage(PsiDirectory psiDirectory) {
        return JavaDirectoryService.getInstance().getPackageInSources(psiDirectory);
    }

    protected BaseRefactoringProcessor createProcessor(final String newQName, Project project, final PsiDirectory[] dirsToRename, boolean searchInComments, boolean searchInNonJavaFiles) {
        return new MoveDirectoryWithClassesProcessor(this, project, dirsToRename, null, searchInComments, searchInNonJavaFiles, false, null){

            @NotNull
            public MoveDirectoryWithClassesProcessor.TargetDirectoryWrapper getTargetDirectory(PsiDirectory dir) {
                return new MoveDirectoryWithClassesProcessor.TargetDirectoryWrapper(dir.getParentDirectory(), StringUtil.getShortName((String)newQName));
            }

            protected String getTargetName() {
                return newQName;
            }

            @NotNull
            protected String getCommandName() {
                String string = RefactoringBundle.message((String)(dirsToRename.length == 1 ? "rename.directory.command.name" : "rename.directories.command.name"));
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/rename/DirectoryAsPackageRenameHandler$1", "getCommandName"));
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/rename/DirectoryAsPackageRenameHandler", "getQualifiedName"));
    }
}

