/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.rename.LocalHidesRenamedLocalUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.CommonJavaRefactoringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class JavaUnresolvableLocalCollisionDetector {
    private static final Logger LOG = Logger.getInstance(JavaUnresolvableLocalCollisionDetector.class);

    private JavaUnresolvableLocalCollisionDetector() {
    }

    public static void findCollisions(final PsiElement element, final String newName, final List<? super UsageInfo> result) {
        PsiParameter parameter;
        PsiElement scope;
        if (!PsiUtil.isJvmLocalVariable((PsiElement)element)) {
            return;
        }
        PsiVariable variable = (PsiVariable)element;
        if (variable instanceof PsiLocalVariable) {
            PsiLocalVariable local = (PsiLocalVariable)variable;
            scope = CommonJavaRefactoringUtil.getVariableScope((PsiLocalVariable)local);
        } else {
            scope = ((PsiParameter)element).getDeclarationScope();
        }
        final String oldName = variable.getName();
        LOG.assertTrue(scope != null, (Object)element.getClass().getName());
        final boolean methodParameter = element instanceof PsiParameter && (parameter = (PsiParameter)element).getDeclarationScope() instanceof PsiMethod;
        final PsiResolveHelper helper = PsiResolveHelper.getInstance((Project)element.getProject());
        CollidingVariableVisitor collidingNameVisitor = new CollidingVariableVisitor(){

            @Override
            public void visitCollidingElement(PsiVariable collidingVariable) {
                if (collidingVariable.equals((Object)element)) {
                    return;
                }
                if (collidingVariable.isUnnamed()) {
                    return;
                }
                if (!methodParameter && helper.resolveAccessibleReferencedVariable(newName, element) != collidingVariable && helper.resolveAccessibleReferencedVariable(oldName, (PsiElement)collidingVariable) != element) {
                    return;
                }
                LocalHidesRenamedLocalUsageInfo collision = new LocalHidesRenamedLocalUsageInfo(collidingVariable, element);
                result.add(collision);
            }
        };
        JavaUnresolvableLocalCollisionDetector.visitLocalsCollisions(element, newName, scope, null, collidingNameVisitor);
    }

    public static void visitLocalsCollisions(PsiElement element, String newName, PsiElement scope, PsiElement place, CollidingVariableVisitor collidingNameVisitor) {
        if (scope == null) {
            return;
        }
        JavaUnresolvableLocalCollisionDetector.visitDownstreamCollisions(scope, place, newName, collidingNameVisitor);
        JavaUnresolvableLocalCollisionDetector.visitUpstreamLocalCollisions(element, scope, newName, collidingNameVisitor);
    }

    private static void visitDownstreamCollisions(PsiElement scope, PsiElement place, String newName, CollidingVariableVisitor collidingNameVisitor) {
        ConflictingLocalVariablesVisitor collector = new ConflictingLocalVariablesVisitor(newName, collidingNameVisitor);
        if (place == null) {
            scope.accept((PsiElementVisitor)collector);
        } else {
            LOG.assertTrue(place.getParent() == scope);
            for (PsiElement sibling = place; sibling != null; sibling = sibling.getNextSibling()) {
                sibling.accept((PsiElementVisitor)collector);
            }
        }
    }

    private static void visitUpstreamLocalCollisions(PsiElement element, PsiElement scope, String newName, CollidingVariableVisitor collidingNameVisitor) {
        PsiVariable collidingVariable = JavaPsiFacade.getInstance((Project)scope.getProject()).getResolveHelper().resolveAccessibleReferencedVariable(newName, scope);
        if (collidingVariable instanceof PsiLocalVariable || collidingVariable instanceof PsiParameter) {
            PsiElement commonParent = PsiTreeUtil.findCommonParent((PsiElement)element, (PsiElement)collidingVariable);
            if (commonParent != null) {
                for (PsiElement current = element; current != null && current != commonParent; current = current.getParent()) {
                    if (!(current instanceof PsiMethod) && !(current instanceof PsiClass)) continue;
                    return;
                }
            }
            collidingNameVisitor.visitCollidingElement(collidingVariable);
        }
    }

    public static interface CollidingVariableVisitor {
        public void visitCollidingElement(PsiVariable var1);
    }

    public static class ConflictingLocalVariablesVisitor
    extends JavaRecursiveElementWalkingVisitor {
        protected final String myName;
        protected CollidingVariableVisitor myCollidingNameVisitor;

        public ConflictingLocalVariablesVisitor(String newName, CollidingVariableVisitor collidingNameVisitor) {
            this.myName = newName;
            this.myCollidingNameVisitor = collidingNameVisitor;
        }

        public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
            if (expression == null) {
                ConflictingLocalVariablesVisitor.$$$reportNull$$$0(0);
            }
            this.visitElement((PsiElement)expression);
        }

        public void visitField(@NotNull PsiField field) {
            if (field == null) {
                ConflictingLocalVariablesVisitor.$$$reportNull$$$0(1);
            }
            if (this.myName.equals(field.getName())) {
                this.myCollidingNameVisitor.visitCollidingElement((PsiVariable)field);
            }
        }

        public void visitVariable(@NotNull PsiVariable variable) {
            if (variable == null) {
                ConflictingLocalVariablesVisitor.$$$reportNull$$$0(2);
            }
            if (this.myName.equals(variable.getName())) {
                this.myCollidingNameVisitor.visitCollidingElement(variable);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "expression";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "field";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variable";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/refactoring/rename/JavaUnresolvableLocalCollisionDetector$ConflictingLocalVariablesVisitor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitReferenceExpression";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitField";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visitVariable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

