/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.TitledHandler;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleWithNameAlreadyExists;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringSettings;
import com.intellij.refactoring.rename.PlainDirectoryRenameHandler;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenameProcessor;
import com.intellij.refactoring.rename.RenamePsiDirectoryProcessor;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.rename.RenamePsiElementProcessorBase;
import com.intellij.refactoring.rename.RenameWithOptionalReferencesDialog;
import com.intellij.usageView.UsageInfo;
import org.jetbrains.annotations.NotNull;

public final class RenameModuleAndDirectoryHandler
implements RenameHandler,
TitledHandler {
    private static final Logger LOG = Logger.getInstance(RenameModuleAndDirectoryHandler.class);

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            RenameModuleAndDirectoryHandler.$$$reportNull$$$0(0);
        }
        LOG.error("Must not be called");
    }

    public String getActionTitle() {
        return JavaRefactoringBundle.message((String)"rename.module.directory.title", (Object[])new Object[0]);
    }

    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        Module module;
        if (dataContext == null) {
            RenameModuleAndDirectoryHandler.$$$reportNull$$$0(1);
        }
        if ((module = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext)) == null) {
            return false;
        }
        PsiElement element = PsiElementRenameHandler.getElement((DataContext)dataContext);
        if (!(element instanceof PsiDirectory)) {
            return false;
        }
        PsiDirectory directory = (PsiDirectory)element;
        if (directory.getVirtualFile().equals(directory.getProject().getBaseDir())) {
            return false;
        }
        if (!PlainDirectoryRenameHandler.isPlainDirectory((PsiDirectory)directory)) {
            return false;
        }
        if (RenamePsiElementProcessor.forElement((PsiElement)directory).getClass() != RenamePsiDirectoryProcessor.class) {
            return false;
        }
        return module.getName().equals(directory.getName());
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        Module module;
        if (project == null) {
            RenameModuleAndDirectoryHandler.$$$reportNull$$$0(2);
        }
        if (elements == null) {
            RenameModuleAndDirectoryHandler.$$$reportNull$$$0(3);
        }
        LOG.assertTrue((module = (Module)LangDataKeys.MODULE_CONTEXT.getData(dataContext)) != null);
        PsiElement element = elements.length == 1 ? elements[0] : PsiElementRenameHandler.getElement((DataContext)dataContext);
        LOG.assertTrue(element != null);
        PsiElementRenameHandler.rename((PsiElement)element, (Project)project, (PsiElement)element, (Editor)((Editor)CommonDataKeys.EDITOR.getData(dataContext)), (String)((String)dataContext.getData(PsiElementRenameHandler.DEFAULT_NAME)), (RenamePsiElementProcessorBase)new RenameModuleAndDirectoryProcessor(module));
    }

    private static void checkRenameModule(@NotNull Module module, @NotNull String newName) throws ConfigurationException {
        if (module == null) {
            RenameModuleAndDirectoryHandler.$$$reportNull$$$0(4);
        }
        if (newName == null) {
            RenameModuleAndDirectoryHandler.$$$reportNull$$$0(5);
        }
        ModifiableModuleModel modifiableModel = ModuleManager.getInstance((Project)module.getProject()).getModifiableModel();
        try {
            modifiableModel.renameModule(module, newName);
        }
        catch (ModuleWithNameAlreadyExists moduleWithNameAlreadyExists) {
            throw new ConfigurationException(IdeBundle.message((String)"error.module.already.exists", (Object[])new Object[]{newName}));
        }
    }

    private static void renameModule(@NotNull Module module, @NotNull String newName) {
        if (module == null) {
            RenameModuleAndDirectoryHandler.$$$reportNull$$$0(6);
        }
        if (newName == null) {
            RenameModuleAndDirectoryHandler.$$$reportNull$$$0(7);
        }
        if (!module.isDisposed()) {
            try {
                ModifiableModuleModel model = ModuleManager.getInstance((Project)module.getProject()).getModifiableModel();
                model.renameModule(module, newName);
                model.commit();
            }
            catch (ModuleWithNameAlreadyExists moduleWithNameAlreadyExists) {
                // empty catch block
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/rename/RenameModuleAndDirectoryHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableOnDataContext";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkRenameModule";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "renameModule";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class RenameModuleAndDirectoryProcessor
    extends RenamePsiDirectoryProcessor {
        private final Module myModule;

        private RenameModuleAndDirectoryProcessor(@NotNull Module module) {
            if (module == null) {
                RenameModuleAndDirectoryProcessor.$$$reportNull$$$0(0);
            }
            this.myModule = module;
        }

        @Override
        @NotNull
        public RenameDialog createRenameDialog(@NotNull Project project, @NotNull PsiElement element, PsiElement nameSuggestionContext, Editor editor) {
            if (project == null) {
                RenameModuleAndDirectoryProcessor.$$$reportNull$$$0(1);
            }
            if (element == null) {
                RenameModuleAndDirectoryProcessor.$$$reportNull$$$0(2);
            }
            return new RenameWithOptionalReferencesDialog(project, element, nameSuggestionContext, editor){

                protected boolean getSearchForReferences() {
                    return RefactoringSettings.getInstance().RENAME_SEARCH_FOR_REFERENCES_FOR_DIRECTORY;
                }

                protected void setSearchForReferences(boolean value) {
                    RefactoringSettings.getInstance().RENAME_SEARCH_FOR_REFERENCES_FOR_DIRECTORY = value;
                }

                protected void canRun() throws ConfigurationException {
                    super.canRun();
                    RenameModuleAndDirectoryHandler.checkRenameModule(myModule, this.getNewName());
                }

                protected RenameProcessor createRenameProcessor(final @NotNull String newName) {
                    if (newName == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return new RenameProcessor(this.getProject(), this.getPsiElement(), newName, this.getRefactoringScope(), this.isSearchInComments(), this.isSearchInNonJavaFiles()){

                        public void performRefactoring(UsageInfo @NotNull [] usages) {
                            if (usages == null) {
                                RenameModuleAndDirectoryProcessor.1.$$$reportNull$$$0(0);
                            }
                            RenameModuleAndDirectoryHandler.renameModule(myModule, newName);
                            super.performRefactoring(usages);
                        }

                        @NotNull
                        protected String getCommandName() {
                            String string = JavaRefactoringBundle.message((String)"rename.module.directory.command", (Object[])new Object[]{newName});
                            if (string == null) {
                                RenameModuleAndDirectoryProcessor.1.$$$reportNull$$$0(1);
                            }
                            return string;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[switch (n) {
                                default -> 3;
                                case 1 -> 2;
                            }];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "usages";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "com/intellij/refactoring/rename/RenameModuleAndDirectoryHandler$RenameModuleAndDirectoryProcessor$1$1";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "com/intellij/refactoring/rename/RenameModuleAndDirectoryHandler$RenameModuleAndDirectoryProcessor$1$1";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "getCommandName";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray;
                                    objectArray[2] = "performRefactoring";
                                    break;
                                }
                                case 1: {
                                    break;
                                }
                            }
                            String string = String.format(v0, objectArray);
                            throw switch (n) {
                                default -> new IllegalArgumentException(string);
                                case 1 -> new IllegalStateException(string);
                            };
                        }
                    };
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/refactoring/rename/RenameModuleAndDirectoryHandler$RenameModuleAndDirectoryProcessor$1", "createRenameProcessor"));
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/refactoring/rename/RenameModuleAndDirectoryHandler$RenameModuleAndDirectoryProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createRenameDialog";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

