/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.inplace;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.refactoring.rename.RenameJavaMemberProcessor;
import com.intellij.refactoring.rename.ResolveSnapshotProvider;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

class JavaResolveSnapshot
extends ResolveSnapshotProvider.ResolveSnapshot {
    private final Map<SmartPsiElementPointer<?>, SmartPsiElementPointer<?>> myReferencesMap = new HashMap();
    private final Project myProject;
    private final Document myDocument;

    JavaResolveSnapshot(PsiElement scope) {
        this.myProject = scope.getProject();
        this.myDocument = FileDocumentManager.getInstance().getDocument(scope.getContainingFile().getViewProvider().getVirtualFile(), this.myProject);
        final SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)this.myProject);
        final HashMap pointers = new HashMap();
        scope.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitReferenceExpression(@NotNull PsiReferenceExpression refExpr) {
                JavaResolveResult resolveResult;
                PsiElement resolved;
                if (refExpr == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!refExpr.isQualified() && ((resolved = (resolveResult = refExpr.advancedResolve(false)).getElement()) instanceof PsiField || resolved instanceof PsiClass) && resolveResult.isStaticsScopeCorrect()) {
                    SmartPsiElementPointer key = pointerManager.createSmartPsiElementPointer((PsiElement)refExpr);
                    SmartPsiElementPointer value = (SmartPsiElementPointer)pointers.get(resolved);
                    if (value == null) {
                        value = pointerManager.createSmartPsiElementPointer(resolved);
                        pointers.put(resolved, value);
                    }
                    JavaResolveSnapshot.this.myReferencesMap.put(key, value);
                }
                super.visitReferenceExpression(refExpr);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refExpr", "com/intellij/refactoring/rename/inplace/JavaResolveSnapshot$1", "visitReferenceExpression"));
            }
        });
    }

    public void apply(String hidingLocalName) {
        PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(this.myDocument);
        for (Map.Entry<SmartPsiElementPointer<?>, SmartPsiElementPointer<?>> entry : this.myReferencesMap.entrySet()) {
            JavaResolveSnapshot.qualify(entry.getKey().getElement(), entry.getValue().getElement(), hidingLocalName);
        }
    }

    private static void qualify(PsiElement referent, PsiElement referee, String hidingLocalName) {
        if (referent instanceof PsiReferenceExpression) {
            PsiReferenceExpression ref = (PsiReferenceExpression)referent;
            if (referee instanceof PsiMember && !ref.isQualified() && hidingLocalName.equals(ref.getReferenceName())) {
                PsiElement newlyResolved = ref.resolve();
                if (referee.getManager().areElementsEquivalent(newlyResolved, referee)) {
                    return;
                }
                RenameJavaMemberProcessor.qualifyMember((PsiMember)referee, referent, hidingLocalName);
            }
        }
    }
}

