/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.naming;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;

public class AutomaticParametersRenamer
extends AutomaticRenamer {
    @Deprecated
    public AutomaticParametersRenamer(PsiParameter param, String newParamName) {
        this(param, newParamName, (Language)JavaLanguage.INSTANCE);
    }

    public AutomaticParametersRenamer(PsiParameter param, String newParamName, Language language) {
        PsiElement scope = param.getDeclarationScope();
        if (scope instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)scope;
            int parameterIndex = method.getParameterList().getParameterIndex(param);
            if (parameterIndex < 0) {
                return;
            }
            for (PsiMethod overrider : OverridingMethodsSearch.search((PsiMethod)method).findAll()) {
                PsiParameter inheritedParam;
                PsiParameter[] parameters;
                if (!overrider.getLanguage().isKindOf(language) || parameterIndex >= (parameters = overrider.getParameterList().getParameters()).length || Comparing.strEqual((String)(inheritedParam = parameters[parameterIndex]).getName(), (String)newParamName)) continue;
                this.myElements.add(inheritedParam);
                this.suggestAllNames(inheritedParam.getName(), newParamName);
            }
        }
    }

    public String getDialogTitle() {
        return JavaRefactoringBundle.message((String)"rename.parameters.dialog.title", (Object[])new Object[0]);
    }

    public String getDialogDescription() {
        return JavaRefactoringBundle.message((String)"rename.parameter.in.hierarchy.to.dialog.description", (Object[])new Object[0]);
    }

    public String entityName() {
        return JavaRefactoringBundle.message((String)"automatic.parameter.renamer.entity.name", (Object[])new Object[0]);
    }

    public boolean isSelectedByDefault() {
        return true;
    }
}

