/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename.naming;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.rename.naming.AutomaticRenamer;
import com.intellij.refactoring.rename.naming.AutomaticTestMethodRenamerFactory;
import com.intellij.usageView.UsageInfo;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0005H\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0016J&\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/intellij/refactoring/rename/naming/JavaAutomaticTestMethodRenamerFactory;", "Lcom/intellij/refactoring/rename/naming/AutomaticTestMethodRenamerFactory;", "<init>", "()V", "isApplicable", "", "element", "Lcom/intellij/psi/PsiElement;", "isEnabled", "setEnabled", "", "enabled", "createRenamer", "Lcom/intellij/refactoring/rename/naming/AutomaticRenamer;", "newName", "", "usages", "", "Lcom/intellij/usageView/UsageInfo;", "intellij.java.impl.refactorings"})
public final class JavaAutomaticTestMethodRenamerFactory
extends AutomaticTestMethodRenamerFactory {
    @Override
    public boolean isApplicable(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof PsiMethod)) {
            return false;
        }
        return super.isApplicable(element);
    }

    public boolean isEnabled() {
        return JavaRefactoringSettings.getInstance().isRenameTestMethods();
    }

    public void setEnabled(boolean enabled) {
        JavaRefactoringSettings.getInstance().setRenameTestMethods(enabled);
    }

    @NotNull
    public AutomaticRenamer createRenamer(@NotNull PsiElement element, @NotNull String newName, @NotNull Collection<UsageInfo> usages) {
        PsiClass psiClass;
        PsiMethod psiMethod;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)newName, (String)"newName");
        Intrinsics.checkNotNullParameter(usages, (String)"usages");
        PsiMethod psiMethod2 = psiMethod = element instanceof PsiMethod ? (PsiMethod)element : null;
        PsiClass psiClass2 = psiClass = psiMethod2 != null ? psiMethod2.getContainingClass() : null;
        Module module = psiClass2 != null ? ModuleUtil.findModuleForPsiElement((PsiElement)((PsiElement)psiClass2)) : null;
        PsiMethod psiMethod3 = psiMethod;
        PsiClass psiClass3 = psiClass;
        return new AutomaticTestMethodRenamerFactory.AutomaticTestMethodRenamer(psiMethod3 != null ? psiMethod3.getName() : null, psiClass3 != null ? psiClass3.getName() : null, module, newName);
    }
}

