/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.replaceConstructorWithBuilder;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.icons.AllIcons;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Iconable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.replaceConstructorWithBuilder.ReplaceConstructorWithBuilderDialog;
import com.intellij.ui.ExperimentalUI;
import com.intellij.util.IncorrectOperationException;
import com.siyeh.ig.psiutils.MethodUtils;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReplaceConstructorWithBuilderAction
extends PsiElementBaseIntentionAction
implements Iconable {
    @NotNull
    public String getText() {
        String string = JavaRefactoringBundle.message((String)"replace.constructor.with.builder.text", (Object[])new Object[0]);
        if (string == null) {
            ReplaceConstructorWithBuilderAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            ReplaceConstructorWithBuilderAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            ReplaceConstructorWithBuilderAction.$$$reportNull$$$0(2);
        }
        if (element == null) {
            ReplaceConstructorWithBuilderAction.$$$reportNull$$$0(3);
        }
        return ReplaceConstructorWithBuilderAction.getConstructor(element) != null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiMethod constructor;
        if (project == null) {
            ReplaceConstructorWithBuilderAction.$$$reportNull$$$0(4);
        }
        if (element == null) {
            ReplaceConstructorWithBuilderAction.$$$reportNull$$$0(5);
        }
        if ((constructor = ReplaceConstructorWithBuilderAction.getConstructor(element)) == null) {
            return;
        }
        PsiClass aClass = constructor.getContainingClass();
        new ReplaceConstructorWithBuilderDialog(project, Objects.requireNonNull(aClass).getConstructors()).show();
    }

    public Icon getIcon(int flags) {
        return ExperimentalUI.isNewUI() ? null : AllIcons.Actions.RefactoringBulb;
    }

    @Nullable
    private static PsiMethod getConstructor(@Nullable PsiElement element) {
        PsiClass aClass;
        PsiMethod method = MethodUtils.getJavaMethodFromHeader((PsiElement)element);
        if (method != null && method.isConstructor() && (aClass = method.getContainingClass()) != null && !aClass.isEnum() && method.getName().equals(aClass.getName())) {
            return method;
        }
        return null;
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/replaceConstructorWithBuilder/ReplaceConstructorWithBuilderAction";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/replaceConstructorWithBuilder/ReplaceConstructorWithBuilderAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5 -> new IllegalArgumentException(string);
        };
    }
}

