/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.replaceConstructorWithBuilder;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.util.EditorHelper;
import com.intellij.ide.util.PackageUtil;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.replaceConstructorWithBuilder.ParameterData;
import com.intellij.refactoring.replaceConstructorWithBuilder.ReplaceConstructorWithBuilderViewDescriptor;
import com.intellij.refactoring.replaceConstructorWithBuilder.usageInfo.ReplaceConstructorWithSettersChainInfo;
import com.intellij.refactoring.util.FixableUsageInfo;
import com.intellij.refactoring.util.FixableUsagesRefactoringProcessor;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.intellij.util.CommonJavaRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.VisibilityUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceConstructorWithBuilderProcessor
extends FixableUsagesRefactoringProcessor {
    private final PsiMethod[] myConstructors;
    private final Map<String, ParameterData> myParametersMap;
    @NotNull
    @NlsSafe
    private final String myClassName;
    @NlsSafe
    private final String myPackageName;
    private final boolean myCreateNewBuilderClass;
    private final PsiElementFactory myElementFactory;
    private final MoveDestination myMoveDestination;
    private final boolean myOpenInEditor;

    public ReplaceConstructorWithBuilderProcessor(Project project, PsiMethod[] constructors, Map<String, ParameterData> parametersMap, @NotNull String className, String packageName, MoveDestination moveDestination, boolean createNewBuilderClass, boolean openInEditor) {
        if (className == null) {
            ReplaceConstructorWithBuilderProcessor.$$$reportNull$$$0(0);
        }
        super(project);
        this.myElementFactory = JavaPsiFacade.getElementFactory((Project)this.myProject);
        this.myConstructors = constructors;
        this.myParametersMap = parametersMap;
        this.myClassName = className;
        this.myPackageName = packageName;
        this.myMoveDestination = moveDestination;
        this.myCreateNewBuilderClass = createNewBuilderClass;
        this.myOpenInEditor = openInEditor;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            ReplaceConstructorWithBuilderProcessor.$$$reportNull$$$0(1);
        }
        return new ReplaceConstructorWithBuilderViewDescriptor();
    }

    protected void findUsages(@NotNull List<? super FixableUsageInfo> usages) {
        if (usages == null) {
            ReplaceConstructorWithBuilderProcessor.$$$reportNull$$$0(2);
        }
        String builderQualifiedName = StringUtil.getQualifiedName((String)this.myPackageName, (String)this.myClassName);
        PsiClass builderClass = JavaPsiFacade.getInstance((Project)this.myProject).findClass(builderQualifiedName, GlobalSearchScope.projectScope((Project)this.myProject));
        for (PsiMethod constructor : this.myConstructors) {
            for (PsiReference reference : ReferencesSearch.search((PsiElement)constructor).asIterable()) {
                PsiElement element = reference.getElement();
                PsiNewExpression newExpression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiNewExpression.class);
                if (newExpression == null || PsiTreeUtil.isAncestor((PsiElement)builderClass, (PsiElement)element, (boolean)false) || newExpression.getAnonymousClass() != null) continue;
                usages.add(new ReplaceConstructorWithSettersChainInfo(newExpression, StringUtil.getQualifiedName((String)this.myPackageName, (String)this.myClassName), this.myParametersMap));
            }
        }
    }

    @Nullable
    private PsiClass createBuilderClass() {
        PsiDirectory directory;
        PsiClass psiClass = this.myConstructors[0].getContainingClass();
        assert (psiClass != null);
        PsiTypeParameterList typeParameterList = psiClass.getTypeParameterList();
        String text = "public class " + this.myClassName + "{}";
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)this.myProject);
        PsiJavaFile newFile = (PsiJavaFile)factory.createFileFromText(this.myClassName + ".java", (FileType)JavaFileType.INSTANCE, (CharSequence)text);
        PsiTypeParameterList list = newFile.getClasses()[0].getTypeParameterList();
        if (list != null && typeParameterList != null) {
            list.replace((PsiElement)typeParameterList);
        }
        PsiFile containingFile = this.myConstructors[0].getContainingFile();
        PsiDirectory containingDirectory = containingFile.getContainingDirectory();
        if (this.myMoveDestination != null) {
            directory = this.myMoveDestination.getTargetDirectory(containingDirectory);
        } else {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)containingFile);
            assert (module != null);
            directory = PackageUtil.findOrCreateDirectoryForPackage((Module)module, (String)this.myPackageName, (PsiDirectory)containingDirectory, (boolean)true, (boolean)true);
        }
        if (directory != null) {
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)PsiManager.getInstance((Project)this.myProject).getProject());
            PsiJavaFile reformattedFile = (PsiJavaFile)codeStyleManager.reformat(JavaCodeStyleManager.getInstance((Project)newFile.getProject()).shortenClassReferences((PsiElement)newFile));
            if (directory.findFile(reformattedFile.getName()) != null) {
                return reformattedFile.getClasses()[0];
            }
            return ((PsiJavaFile)directory.add((PsiElement)reformattedFile)).getClasses()[0];
        }
        return null;
    }

    protected void performRefactoring(UsageInfo @NotNull [] usageInfos) {
        PsiClass builderClass;
        if (usageInfos == null) {
            ReplaceConstructorWithBuilderProcessor.$$$reportNull$$$0(3);
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)this.myProject);
        PsiClass psiClass = builderClass = this.myCreateNewBuilderClass ? this.createBuilderClass() : psiFacade.findClass(StringUtil.getQualifiedName((String)this.myPackageName, (String)this.myClassName), GlobalSearchScope.projectScope((Project)this.myProject));
        if (builderClass == null) {
            return;
        }
        for (String propertyName : this.myParametersMap.keySet()) {
            ParameterData parameterData = this.myParametersMap.get(propertyName);
            PsiField field = this.createField(builderClass, parameterData);
            this.createSetter(builderClass, parameterData, field);
        }
        super.performRefactoring(usageInfos);
        PsiMethod method = this.createBuildMethod(this.createMethodName());
        if (builderClass.findMethodBySignature(method, false) == null) {
            builderClass.add((PsiElement)method);
        }
        PsiMethod constructor = this.getWorkingConstructor();
        VisibilityUtil.escalateVisibility((PsiMember)constructor, (PsiElement)builderClass);
        for (PsiClass containingClass = constructor.getContainingClass(); containingClass != null; containingClass = containingClass.getContainingClass()) {
            VisibilityUtil.escalateVisibility((PsiMember)containingClass, (PsiElement)builderClass);
        }
        if (this.myOpenInEditor) {
            EditorHelper.openInEditor((PsiElement)builderClass);
        }
    }

    private void createSetter(PsiClass builderClass, ParameterData parameterData, PsiField field) {
        PsiMethod setter = null;
        for (PsiMethod method : builderClass.getMethods()) {
            if (!Comparing.strEqual((String)method.getName(), (String)parameterData.getSetterName()) || method.getParameterList().getParametersCount() != 1 || !TypeConversionUtil.isAssignable((PsiType)method.getParameterList().getParameters()[0].getType(), (PsiType)parameterData.getType())) continue;
            setter = method;
            this.fixSetterReturnType(builderClass, field, setter);
            break;
        }
        if (setter == null) {
            setter = PropertyUtilBase.generateSetterPrototype((PsiField)field, (PsiClass)builderClass, (boolean)true);
            PsiIdentifier nameIdentifier = setter.getNameIdentifier();
            assert (nameIdentifier != null);
            nameIdentifier.replace((PsiElement)this.myElementFactory.createIdentifier(parameterData.getSetterName()));
            setter.getParameterList().getParameters()[0].getTypeElement().replace((PsiElement)this.myElementFactory.createTypeElement(parameterData.getType()));
            builderClass.add((PsiElement)setter);
        }
    }

    private PsiField createField(PsiClass builderClass, ParameterData parameterData) {
        PsiExpression initializer;
        String defaultValue;
        PsiField field = builderClass.findFieldByName(parameterData.getFieldName(), false);
        if (field == null) {
            PsiType type = parameterData.getType();
            if (type instanceof PsiEllipsisType) {
                type = ((PsiEllipsisType)type).toArrayType();
            }
            field = this.myElementFactory.createField(parameterData.getFieldName(), type);
            field = (PsiField)builderClass.add((PsiElement)field);
        }
        if ((defaultValue = parameterData.getDefaultValue()) != null && (initializer = field.getInitializer()) == null) {
            try {
                field.setInitializer(this.myElementFactory.createExpressionFromText(defaultValue, (PsiElement)field));
            }
            catch (IncorrectOperationException incorrectOperationException) {
                // empty catch block
            }
        }
        return field;
    }

    private void fixSetterReturnType(PsiClass builderClass, PsiField field, PsiMethod method) {
        if (PsiUtil.resolveClassInType((PsiType)method.getReturnType()) != builderClass) {
            PsiCodeBlock body = method.getBody();
            PsiCodeBlock generatedBody = PropertyUtilBase.generateSetterPrototype((PsiField)field, (PsiClass)builderClass, (boolean)true).getBody();
            assert (body != null);
            assert (generatedBody != null);
            body.replace((PsiElement)generatedBody);
            PsiTypeElement typeElement = method.getReturnTypeElement();
            assert (typeElement != null);
            typeElement.replace((PsiElement)this.myElementFactory.createTypeElement((PsiType)this.myElementFactory.createType(builderClass)));
        }
    }

    private PsiMethod createBuildMethod(String createMethodName) {
        boolean comma;
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)this.myProject);
        PsiClass aClass = this.myConstructors[0].getContainingClass();
        assert (aClass != null);
        PsiType[] typeArguments = (PsiType[])Stream.of(aClass.getTypeParameters()).map(arg_0 -> ((PsiElementFactory)this.myElementFactory).createType(arg_0)).toArray(PsiType[]::new);
        PsiMethod method = this.myElementFactory.createMethod(createMethodName, (PsiType)this.myElementFactory.createType(aClass, typeArguments));
        StringBuilder bodyText = new StringBuilder();
        PsiMethod constructor = this.getWorkingConstructor();
        bodyText.append("{\n  return new ").append(constructor.getName());
        if (typeArguments.length > 0) {
            if (PsiUtil.isAvailable((JavaFeature)JavaFeature.DIAMOND_TYPES, (PsiElement)aClass)) {
                bodyText.append("<>");
            } else {
                bodyText.append('<');
                comma = false;
                for (PsiParameter psiParameter : typeArguments) {
                    bodyText.append(comma ? ", " : "").append(psiParameter.getCanonicalText());
                    comma = true;
                }
                bodyText.append('>');
            }
        }
        bodyText.append("(");
        comma = false;
        for (PsiParameter psiParameter : constructor.getParameterList().getParameters()) {
            String pureParamName = styleManager.variableNameToPropertyName(psiParameter.getName(), VariableKind.PARAMETER);
            bodyText.append(comma ? ", " : "").append(this.myParametersMap.get(pureParamName).getFieldName());
            comma = true;
        }
        bodyText.append(");\n}");
        PsiCodeBlock body = this.myElementFactory.createCodeBlockFromText(bodyText.toString(), (PsiElement)method);
        Objects.requireNonNull(method.getBody()).replace((PsiElement)body);
        return method;
    }

    private PsiMethod getWorkingConstructor() {
        PsiMethod constructor = this.getMostCommonConstructor();
        if (constructor == null && (constructor = this.myConstructors[0]).getParameterList().isEmpty()) {
            constructor = this.myConstructors[1];
        }
        return constructor;
    }

    @Nullable
    private PsiMethod getMostCommonConstructor() {
        if (this.myConstructors.length == 1) {
            return this.myConstructors[0];
        }
        PsiMethod commonConstructor = null;
        for (PsiMethod constructor : this.myConstructors) {
            PsiMethod chainedConstructor = CommonJavaRefactoringUtil.getChainedConstructor((PsiMethod)constructor);
            if (chainedConstructor == null) {
                if (commonConstructor != null && !ReplaceConstructorWithBuilderProcessor.isChained(commonConstructor, constructor)) {
                    return null;
                }
                commonConstructor = constructor;
                continue;
            }
            if (commonConstructor == null) {
                commonConstructor = chainedConstructor;
                continue;
            }
            if (ReplaceConstructorWithBuilderProcessor.isChained(commonConstructor, chainedConstructor)) continue;
            return null;
        }
        return commonConstructor;
    }

    private static boolean isChained(PsiMethod first, PsiMethod last) {
        if (first == null) {
            return false;
        }
        if (first == last) {
            return true;
        }
        return ReplaceConstructorWithBuilderProcessor.isChained(CommonJavaRefactoringUtil.getChainedConstructor((PsiMethod)first), last);
    }

    @NlsSafe
    private String createMethodName() {
        return "create" + StringUtil.capitalize((String)this.myConstructors[0].getName());
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected boolean preprocessUsages(@NotNull Ref<UsageInfo[]> refUsages) {
        PsiMethod commonConstructor;
        if (refUsages == null) {
            ReplaceConstructorWithBuilderProcessor.$$$reportNull$$$0(4);
        }
        @NlsContexts.DialogMessage MultiMap conflicts = new MultiMap();
        if (this.myMoveDestination != null && this.myCreateNewBuilderClass) {
            this.myMoveDestination.analyzeModuleConflicts(Collections.emptyList(), conflicts, (UsageInfo[])refUsages.get());
        }
        if ((commonConstructor = this.getMostCommonConstructor()) == null) {
            PsiClass containingClass = this.myConstructors[0].getContainingClass();
            assert (containingClass != null);
            conflicts.putValue((Object)containingClass, (Object)JavaRefactoringBundle.message((String)"replace.constructor.builder.error.no.constructor.chain", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)containingClass, (boolean)false)}));
        }
        return this.showConflicts(conflicts, (UsageInfo[])refUsages.get());
    }

    @NotNull
    protected String getCommandName() {
        String string = JavaRefactoringBundle.message((String)"replace.constructor.with.builder", (Object[])new Object[0]);
        if (string == null) {
            ReplaceConstructorWithBuilderProcessor.$$$reportNull$$$0(5);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfos";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refUsages";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/replaceConstructorWithBuilder/ReplaceConstructorWithBuilderProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/replaceConstructorWithBuilder/ReplaceConstructorWithBuilderProcessor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "performRefactoring";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "preprocessUsages";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

