/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.safeDelete;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedVariableUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.SafeDeleteFix;
import com.intellij.codeInsight.generation.GetterSetterPrototypeProvider;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.ide.util.SuperMethodWarningUtil;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiRecordComponent;
import com.intellij.psi.PsiRecordHeader;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleSettings;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.FindSuperElementsHelper;
import com.intellij.psi.impl.light.LightDefaultConstructor;
import com.intellij.psi.impl.light.LightRecordMethod;
import com.intellij.psi.impl.source.javadoc.PsiDocParamRef;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.JavaPsiRecordUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.ContractConverter;
import com.intellij.refactoring.changeSignature.JavaParameterInfo;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import com.intellij.refactoring.move.moveClassesOrPackages.ModuleInfoUsageDetector;
import com.intellij.refactoring.safeDelete.ImportSearcher;
import com.intellij.refactoring.safeDelete.JavaSafeDeleteDelegate;
import com.intellij.refactoring.safeDelete.NonCodeUsageSearchInfo;
import com.intellij.refactoring.safeDelete.OverridingMethodsDialog;
import com.intellij.refactoring.safeDelete.SafeDeleteHandler;
import com.intellij.refactoring.safeDelete.SafeDeleteJavaCalleeChooser;
import com.intellij.refactoring.safeDelete.SafeDeleteJavaCallerChooser;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessor;
import com.intellij.refactoring.safeDelete.SafeDeleteProcessorDelegateBase;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteAnnotation;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteFieldWriteReference;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteMemberCalleeUsageInfo;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteOverrideAnnotation;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteOverridingMethodUsageInfo;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteParameterCallHierarchyUsageInfo;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceJavaDeleteUsageInfo;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceUsageInfo;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteUsageInfo;
import com.intellij.refactoring.util.ConflictsUtil;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.UsageInfoToUsageConverter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.JavaPsiConstructorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.tree.TreeUtil;
import com.siyeh.ig.style.LambdaCanBeReplacedWithAnonymousInspection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaSafeDeleteProcessor
extends SafeDeleteProcessorDelegateBase {
    private static final Logger LOG = Logger.getInstance(JavaSafeDeleteProcessor.class);

    public boolean handlesElement(PsiElement element) {
        return element instanceof PsiClass || element instanceof PsiMethod || element instanceof PsiRecordComponent || element instanceof PsiField || element instanceof PsiParameter || element instanceof PsiLocalVariable || element instanceof PsiPackage || element instanceof PsiJavaFile;
    }

    @Nullable
    public NonCodeUsageSearchInfo findUsages(@NotNull PsiElement element, PsiElement @NotNull [] allElementsToDelete, @NotNull List<? super UsageInfo> usages) {
        if (element == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(0);
        }
        if (usages == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(1);
        }
        if (allElementsToDelete == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(2);
        }
        Condition<PsiElement> insideDeletedCondition = JavaSafeDeleteProcessor.getUsageInsideDeletedFilter(allElementsToDelete);
        if (element instanceof PsiClass) {
            PsiClass aClass = (PsiClass)element;
            JavaSafeDeleteProcessor.findClassUsages(aClass, allElementsToDelete, usages);
            if (element instanceof PsiTypeParameter) {
                PsiTypeParameter typeParameter = (PsiTypeParameter)element;
                JavaSafeDeleteProcessor.findTypeParameterExternalUsages(typeParameter, usages);
            } else {
                JavaSafeDeleteProcessor.appendCallees((PsiMember)aClass, usages);
            }
            ModuleInfoUsageDetector.createSafeDeleteUsageInstance(element.getProject(), allElementsToDelete).detectModuleStatementsUsed(usages, (MultiMap<PsiElement, String>)MultiMap.create());
        } else if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            insideDeletedCondition = JavaSafeDeleteProcessor.findMethodUsages(method, allElementsToDelete, usages);
        } else if (element instanceof PsiField) {
            PsiField field = (PsiField)element;
            insideDeletedCondition = JavaSafeDeleteProcessor.findFieldUsages(field, usages, allElementsToDelete);
        } else if (element instanceof PsiRecordComponent) {
            PsiRecordComponent component = (PsiRecordComponent)element;
            insideDeletedCondition = JavaSafeDeleteProcessor.findRecordComponentUsages(component, allElementsToDelete, usages);
        } else if (element instanceof PsiParameter) {
            PsiParameter parameter = (PsiParameter)element;
            LOG.assertTrue(parameter.getDeclarationScope() instanceof PsiMethod);
            JavaSafeDeleteProcessor.findParameterUsages(parameter, allElementsToDelete, usages);
        } else if (element instanceof PsiLocalVariable) {
            PsiLocalVariable variable = (PsiLocalVariable)element;
            for (PsiReference reference : ReferencesSearch.search((PsiElement)element).asIterable()) {
                PsiReferenceExpression referencedElement = (PsiReferenceExpression)reference.getElement();
                PsiElement statementOrExprInList = PsiTreeUtil.getParentOfType((PsiElement)referencedElement, PsiStatement.class);
                if (statementOrExprInList instanceof PsiExpressionListStatement) {
                    PsiExpressionListStatement statement = (PsiExpressionListStatement)statementOrExprInList;
                    statementOrExprInList = PsiTreeUtil.findPrevParent((PsiElement)statement.getExpressionList(), (PsiElement)referencedElement);
                }
                boolean isSafeToDelete = PsiUtil.isAccessedForWriting((PsiExpression)referencedElement);
                boolean hasSideEffects = false;
                if (PsiUtil.isOnAssignmentLeftHand((PsiExpression)referencedElement)) {
                    PsiExpression rhs = ((PsiAssignmentExpression)referencedElement.getParent()).getRExpression();
                    hasSideEffects = RemoveUnusedVariableUtil.checkSideEffects((PsiExpression)rhs, (PsiVariable)variable, new ArrayList());
                }
                usages.add((UsageInfo)new SafeDeleteReferenceJavaDeleteUsageInfo(statementOrExprInList, element, isSafeToDelete && !hasSideEffects));
            }
        }
        return new NonCodeUsageSearchInfo(insideDeletedCondition, element);
    }

    @Nullable
    public Collection<? extends PsiElement> getElementsToSearch(@NotNull PsiElement element, @Nullable Module module, @NotNull Collection<? extends PsiElement> allElementsToDelete) {
        PsiTypeParameter typeParameter;
        PsiTypeParameterListOwner owner;
        PsiParameter param;
        PsiElement psiMethods2;
        if (element == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(3);
        }
        if (allElementsToDelete == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(4);
        }
        Project project = element.getProject();
        if (element instanceof SyntheticElement && !(element instanceof LightDefaultConstructor)) {
            return null;
        }
        if (element instanceof PsiPackage) {
            PsiPackage aPackage = (PsiPackage)element;
            if (module != null) {
                PsiDirectory[] directories = aPackage.getDirectories(module.getModuleScope());
                if (directories.length == 0) {
                    return null;
                }
                return Arrays.asList(directories);
            }
        }
        if (element instanceof PsiJavaFile) {
            PsiJavaFile javaFile = (PsiJavaFile)element;
            PsiClass[] classes = javaFile.getClasses();
            if (classes.length == 0) {
                return null;
            }
            return List.of(classes);
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return Collections.singletonList(element);
            }
            if (method.isDefaultConstructor()) {
                return Collections.singletonList(method.getContainingClass());
            }
            PsiMethod[] methods = SuperMethodWarningUtil.checkSuperMethods((PsiMethod)method, allElementsToDelete);
            if (methods.length == 0) {
                return null;
            }
            ArrayList<PsiMethod> psiMethods2 = new ArrayList<PsiMethod>(Arrays.asList(methods));
            psiMethods2.add(method);
            return psiMethods2;
        }
        if (element instanceof PsiParameter && (psiMethods2 = (param = (PsiParameter)element).getDeclarationScope()) instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)psiMethods2;
            HashSet<PsiElement> parametersToDelete = new HashSet<PsiElement>();
            parametersToDelete.add(element);
            int parameterIndex = method.getParameterList().getParameterIndex(param);
            ArrayList<PsiMethod> superMethods = new ArrayList<PsiMethod>(Arrays.asList(method.findDeepestSuperMethods()));
            if (superMethods.isEmpty()) {
                superMethods.add(method);
            }
            if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ReadAction.run(() -> {
                ContainerUtil.addAllNotNull((Collection)superMethods, (Object[])new PsiMethod[]{FindSuperElementsHelper.getSiblingInheritedViaSubClass((PsiMethod)method)});
                for (PsiMethod superMethod : superMethods) {
                    parametersToDelete.add((PsiElement)superMethod.getParameterList().getParameters()[parameterIndex]);
                    OverridingMethodsSearch.search((PsiMethod)superMethod).forEach(overrider -> {
                        parametersToDelete.add(overrider.getParameterList().getParameters()[parameterIndex].getNavigationElement());
                        return true;
                    });
                }
            }), JavaRefactoringBundle.message((String)"progress.title.collect.hierarchy", (Object[])new Object[]{param.getName()}), true, project)) {
                return null;
            }
            if (parametersToDelete.size() > 1 && !ApplicationManager.getApplication().isUnitTestMode()) {
                String message = JavaRefactoringBundle.message((String)"0.is.a.part.of.method.hierarchy.do.you.want.to.delete.multiple.parameters", (Object[])new Object[]{UsageViewUtil.getLongName((PsiElement)method)});
                int result = Messages.showYesNoCancelDialog((Project)project, (String)message, (String)SafeDeleteHandler.getRefactoringName(), (Icon)Messages.getQuestionIcon());
                if (result == 2) {
                    return null;
                }
                if (result == 1) {
                    return Collections.singletonList(element);
                }
            }
            return parametersToDelete;
        }
        if (element instanceof PsiTypeParameter && (owner = (typeParameter = (PsiTypeParameter)element).getOwner()) instanceof PsiMethod) {
            int index;
            PsiTypeParameterList typeParameterList;
            PsiMethod method = (PsiMethod)owner;
            if (!owner.hasModifierProperty("static") && (typeParameterList = owner.getTypeParameterList()) != null && (index = typeParameterList.getTypeParameterIndex(typeParameter)) >= 0) {
                ArrayList<PsiTypeParameter> overriders = new ArrayList<PsiTypeParameter>();
                overriders.add(typeParameter);
                OverridingMethodsSearch.search((PsiMethod)method).forEach(overrider -> {
                    PsiTypeParameter[] typeParameters = overrider.getTypeParameters();
                    if (index < typeParameters.length) {
                        overriders.add(typeParameters[index]);
                    }
                    return true;
                });
                if (overriders.size() > 1 && !ApplicationManager.getApplication().isUnitTestMode()) {
                    int result;
                    String message = JavaRefactoringBundle.message((String)"0.is.a.part.of.method.hierarchy.do.you.want.to.delete.multiple.type.parameters", (Object[])new Object[]{UsageViewUtil.getLongName((PsiElement)owner)});
                    int n = result = ApplicationManager.getApplication().isUnitTestMode() ? 0 : Messages.showYesNoCancelDialog((Project)project, (String)message, (String)SafeDeleteHandler.getRefactoringName(), (Icon)Messages.getQuestionIcon());
                    if (result == 2) {
                        return null;
                    }
                    if (result == 1) {
                        return Collections.singletonList(element);
                    }
                }
                return overriders;
            }
        }
        return Collections.singletonList(element);
    }

    public UsageView showUsages(UsageInfo @NotNull [] usages, @NotNull UsageViewPresentation presentation, @NotNull UsageViewManager manager, PsiElement @NotNull [] elements) {
        if (presentation == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(5);
        }
        if (manager == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(6);
        }
        if (usages == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(7);
        }
        if (elements == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(8);
        }
        ArrayList<PsiElement> overridingMethods = new ArrayList<PsiElement>();
        ArrayList<UsageInfo> others = new ArrayList<UsageInfo>();
        for (UsageInfo usage : usages) {
            if (usage instanceof SafeDeleteOverridingMethodUsageInfo) {
                SafeDeleteOverridingMethodUsageInfo info = (SafeDeleteOverridingMethodUsageInfo)usage;
                overridingMethods.add(info.getOverridingMethod());
                continue;
            }
            others.add(usage);
        }
        UsageTarget[] targets = new UsageTarget[elements.length + overridingMethods.size()];
        for (int i = 0; i < targets.length; ++i) {
            targets[i] = new PsiElement2UsageTargetAdapter(i < elements.length ? elements[i] : (PsiElement)overridingMethods.get(i - elements.length));
        }
        return manager.showUsages(targets, UsageInfoToUsageConverter.convert((PsiElement[])elements, (UsageInfo[])others.toArray(UsageInfo.EMPTY_ARRAY)), presentation);
    }

    public Collection<PsiElement> getAdditionalElementsToDelete(@NotNull PsiElement element, @NotNull Collection<? extends PsiElement> allElementsToDelete, boolean askUser) {
        if (element == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(9);
        }
        if (allElementsToDelete == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(10);
        }
        if (element instanceof PsiRecordComponent) {
            PsiRecordComponent component = (PsiRecordComponent)element;
            PsiMethod method = JavaPsiRecordUtil.getAccessorForRecordComponent((PsiRecordComponent)component);
            ArrayList<PsiElement> additional = new ArrayList<PsiElement>();
            if (method != null && !(method instanceof SyntheticElement) && !allElementsToDelete.contains(method)) {
                additional.add((PsiElement)method);
            }
            PsiClass recordClass = component.getContainingClass();
            assert (recordClass != null);
            PsiMethod constructor = JavaPsiRecordUtil.findCanonicalConstructor((PsiClass)recordClass);
            if (constructor == null || constructor instanceof SyntheticElement) {
                return additional;
            }
            PsiRecordHeader header = recordClass.getRecordHeader();
            assert (header != null);
            int index = ArrayUtil.indexOf((Object[])header.getRecordComponents(), (Object)component);
            if (index < 0) {
                return additional;
            }
            PsiParameter parameter = constructor.getParameterList().getParameter(index);
            if (parameter != null) {
                additional.add((PsiElement)parameter);
            }
            return additional;
        }
        if (element instanceof PsiField) {
            PsiField field = (PsiField)element;
            Project project = element.getProject();
            String propertyName = JavaCodeStyleManager.getInstance((Project)project).variableNameToPropertyName(field.getName(), VariableKind.FIELD);
            PsiClass aClass = field.getContainingClass();
            if (aClass != null) {
                PsiMethod setter;
                boolean isStatic = field.hasModifierProperty("static");
                PsiMethod[] getters = GetterSetterPrototypeProvider.findGetters((PsiClass)aClass, (String)propertyName, (boolean)isStatic);
                if (getters != null) {
                    ArrayList<PsiMethod> validGetters = new ArrayList<PsiMethod>(1);
                    for (PsiMethod getter : getters) {
                        if (getter == null || allElementsToDelete.contains(getter) || !getter.isPhysical()) continue;
                        validGetters.add(getter);
                    }
                    PsiMethod[] psiMethodArray = getters = validGetters.isEmpty() ? null : validGetters.toArray(PsiMethod.EMPTY_ARRAY);
                }
                if ((setter = PropertyUtilBase.findPropertySetter((PsiClass)aClass, (String)propertyName, (boolean)isStatic, (boolean)false)) != null && (allElementsToDelete.contains(setter) || !setter.isPhysical())) {
                    setter = null;
                }
                if (askUser && (getters != null || setter != null)) {
                    String title = RefactoringBundle.message((String)"delete.title");
                    String message = RefactoringMessageUtil.getGetterSetterMessage((String)field.getName(), (String)title, (PsiMethod)(getters != null ? getters[0] : null), (PsiMethod)setter);
                    if (!ApplicationManager.getApplication().isUnitTestMode() && Messages.showYesNoDialog((Project)project, (String)message, (String)RefactoringBundle.message((String)"safe.delete.title"), (Icon)Messages.getQuestionIcon()) != 0) {
                        getters = null;
                        setter = null;
                    }
                }
                ArrayList<PsiElement> elements = new ArrayList<PsiElement>();
                if (setter != null) {
                    elements.add((PsiElement)setter);
                }
                if (getters != null) {
                    Collections.addAll(elements, getters);
                }
                return elements;
            }
        }
        return null;
    }

    public void findConflicts(@NotNull PsiElement element, PsiElement @NotNull [] allElementsToDelete, UsageInfo @NotNull [] usages, @NotNull MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflicts) {
        if (element == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(11);
        }
        if (conflicts == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(12);
        }
        if (allElementsToDelete == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(13);
        }
        if (usages == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(14);
        }
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            PsiClass containingClass = method.getContainingClass();
            if (containingClass != null && !containingClass.hasModifierProperty("abstract")) {
                for (PsiMethod superMethod : method.findSuperMethods()) {
                    if (JavaSafeDeleteProcessor.isInside((PsiElement)superMethod, allElementsToDelete) || !superMethod.hasModifierProperty("abstract")) continue;
                    String message = JavaRefactoringBundle.message((String)"0.implements.1", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)element, (boolean)true), RefactoringUIUtil.getDescription((PsiElement)superMethod, (boolean)true)});
                    conflicts.putValue((Object)superMethod, (Object)StringUtil.capitalize((String)message));
                }
            }
        } else if (element instanceof PsiParameter) {
            PsiParameter parameter = (PsiParameter)element;
            PsiElement scope = parameter.getDeclarationScope();
            if (scope instanceof PsiMethod) {
                PsiMethod method = (PsiMethod)scope;
                for (UsageInfo usage : usages) {
                    PsiMethodReferenceExpression ref;
                    PsiElement psiElement = usage.getElement();
                    if (!(psiElement instanceof PsiMethodReferenceExpression) || !method.equals((Object)(ref = (PsiMethodReferenceExpression)psiElement).resolve())) continue;
                    String message = JavaRefactoringBundle.message((String)"method.reference.will.be.converted.to.lambda.expression.warning", (Object[])new Object[0]);
                    conflicts.putValue((Object)ref, (Object)StringUtil.capitalize((String)message));
                }
                JavaSafeDeleteProcessor.collectMethodConflicts(conflicts, method, parameter);
            }
        } else if (element instanceof PsiRecordComponent) {
            PsiRecordComponent component = (PsiRecordComponent)element;
            PsiClass recordClass = component.getContainingClass();
            assert (recordClass != null);
            PsiMethod constructor = JavaPsiRecordUtil.findCanonicalConstructor((PsiClass)recordClass);
            if (constructor != null) {
                PsiParameter parameter;
                PsiRecordHeader header = recordClass.getRecordHeader();
                assert (header != null);
                int index = ArrayUtil.indexOf((Object[])header.getRecordComponents(), (Object)component);
                if (index >= 0 && (parameter = constructor.getParameterList().getParameter(index)) != null) {
                    this.findConflicts((PsiElement)parameter, allElementsToDelete, UsageInfo.EMPTY_ARRAY, conflicts);
                }
            }
        }
    }

    public UsageInfo @Nullable [] preprocessUsages(@NotNull Project project, UsageInfo @NotNull [] usages) {
        if (project == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(15);
        }
        if (usages == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(16);
        }
        List<Object> result = Collections.synchronizedList(new ArrayList());
        ArrayList<UsageInfo> overridingMethods = new ArrayList<UsageInfo>();
        final ArrayList<SafeDeleteParameterCallHierarchyUsageInfo> delegatingParams = new ArrayList<SafeDeleteParameterCallHierarchyUsageInfo>();
        final ArrayList<SafeDeleteMemberCalleeUsageInfo> calleesSafeToDelete = new ArrayList<SafeDeleteMemberCalleeUsageInfo>();
        for (UsageInfo usage : usages) {
            if (usage.isNonCodeUsage) {
                SafeDeleteUsageInfo info2;
                PsiElement element;
                if (usage instanceof SafeDeleteUsageInfo && (element = (info2 = (SafeDeleteUsageInfo)usage).getReferencedElement()) instanceof PsiModifierListOwner) {
                    PsiModifierListOwner owner = (PsiModifierListOwner)element;
                    ExternalAnnotationsManager annotationsManager = ExternalAnnotationsManager.getInstance((Project)element.getProject());
                    List annotationsFiles = annotationsManager.findExternalAnnotationsFiles(owner);
                    if (annotationsFiles != null && annotationsFiles.contains(usage.getFile())) {
                        result.add((Object)new SafeDeleteExternalAnnotationsUsageInfo(element, usage.getElement()));
                        continue;
                    }
                }
                result.add(usage);
                continue;
            }
            if (usage instanceof SafeDeleteMemberCalleeUsageInfo) {
                SafeDeleteMemberCalleeUsageInfo info3 = (SafeDeleteMemberCalleeUsageInfo)usage;
                calleesSafeToDelete.add(info3);
                continue;
            }
            if (usage instanceof SafeDeleteOverridingMethodUsageInfo) {
                overridingMethods.add(usage);
                continue;
            }
            if (usage instanceof SafeDeleteParameterCallHierarchyUsageInfo) {
                SafeDeleteParameterCallHierarchyUsageInfo info4 = (SafeDeleteParameterCallHierarchyUsageInfo)usage;
                delegatingParams.add(info4);
                continue;
            }
            if (usage instanceof SafeDeleteAnnotation) {
                SafeDeleteAnnotation info5 = (SafeDeleteAnnotation)usage;
                result.add((Object)new SafeDeleteAnnotation((PsiAnnotation)usage.getElement(), info5.getReferencedElement(), true));
                continue;
            }
            result.add(usage);
        }
        if (!overridingMethods.isEmpty()) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                result.addAll(overridingMethods);
            } else {
                OverridingMethodsDialog dialog = new OverridingMethodsDialog(project, overridingMethods);
                if (!dialog.showAndGet()) {
                    return null;
                }
                ArrayList<UsageInfo> selected = dialog.getSelected();
                HashSet unselected = new HashSet(overridingMethods);
                for (UsageInfo usageInfo : selected) {
                    unselected.remove(usageInfo);
                }
                if (!unselected.isEmpty()) {
                    List unselectedMethods = ContainerUtil.map(unselected, info -> ((SafeDeleteOverridingMethodUsageInfo)((Object)info)).getOverridingMethod());
                    result.removeIf(info -> {
                        SafeDeleteOverrideAnnotation anno;
                        return info instanceof SafeDeleteOverrideAnnotation && !JavaSafeDeleteProcessor.allSuperMethodsSelectedToDelete(unselectedMethods, (anno = (SafeDeleteOverrideAnnotation)((Object)info)).getMethod());
                    });
                }
                result.addAll(selected);
            }
        }
        if (!delegatingParams.isEmpty()) {
            SafeDeleteParameterCallHierarchyUsageInfo parameterHierarchyUsageInfo = (SafeDeleteParameterCallHierarchyUsageInfo)((Object)delegatingParams.get(0));
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                result.addAll(delegatingParams);
            } else {
                PsiMethod method = parameterHierarchyUsageInfo.getCalledMethod();
                PsiParameter parameter = parameterHierarchyUsageInfo.getReferencedElement();
                final int parameterIndex = method.getParameterList().getParameterIndex(parameter);
                SafeDeleteJavaCallerChooser chooser = new SafeDeleteJavaCallerChooser(this, method, project, result){

                    @Override
                    @NotNull
                    protected List<SafeDeleteParameterCallHierarchyUsageInfo> getTopLevelItems() {
                        List list = delegatingParams;
                        if (list == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return list;
                    }

                    @Override
                    protected int getParameterIdx() {
                        return parameterIndex;
                    }

                    @Override
                    protected PsiParameter getParameterInCaller(PsiMethod called, int paramIdx, PsiMethod caller) {
                        return delegatingParams.stream().filter(usage -> caller.equals((Object)usage.getCallerMethod())).map(usage -> usage.getParameterInCaller()).findFirst().orElse(super.getParameterInCaller(called, paramIdx, caller));
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/safeDelete/JavaSafeDeleteProcessor$1", "getTopLevelItems"));
                    }
                };
                TreeUtil.expand((JTree)chooser.getTree(), (int)2);
                if (!chooser.showAndGet()) {
                    return null;
                }
            }
        }
        if (!calleesSafeToDelete.isEmpty()) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                result.addAll(calleesSafeToDelete);
            } else {
                PsiMember member = ((SafeDeleteMemberCalleeUsageInfo)((Object)calleesSafeToDelete.get(0))).getCallerMember();
                ArrayList list = new ArrayList();
                SafeDeleteJavaCalleeChooser chooser = new SafeDeleteJavaCalleeChooser(this, member, project, list){

                    @Override
                    @NotNull
                    protected List<SafeDeleteMemberCalleeUsageInfo> getTopLevelItems() {
                        List list = calleesSafeToDelete;
                        if (list == null) {
                            2.$$$reportNull$$$0(0);
                        }
                        return list;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/safeDelete/JavaSafeDeleteProcessor$2", "getTopLevelItems"));
                    }
                };
                TreeUtil.expand((JTree)chooser.getTree(), (int)2);
                if (!chooser.showAndGet()) {
                    return null;
                }
                result.addAll(list);
                ArrayList<Object> methodsToDelete = new ArrayList<Object>();
                for (SafeDeleteParameterCallHierarchyUsageInfo info4 : list) {
                    methodsToDelete.add(info4.getElement());
                }
                methodsToDelete.add(member);
                Condition<PsiElement> insideDeletedCondition = JavaSafeDeleteProcessor.getUsageInsideDeletedFilter(methodsToDelete.toArray(PsiElement.EMPTY_ARRAY));
                for (SafeDeleteAnnotation info5 : list) {
                    PsiElement psi = info5.getElement();
                    JavaRefactoringSettings refactoringSettings = JavaRefactoringSettings.getInstance();
                    boolean searchNonJava = psi instanceof PsiMethod ? refactoringSettings.RENAME_SEARCH_FOR_TEXT_FOR_METHOD : refactoringSettings.RENAME_SEARCH_FOR_TEXT_FOR_FIELD;
                    boolean searchInCommentsAndStrings = psi instanceof PsiMethod ? refactoringSettings.RENAME_SEARCH_IN_COMMENTS_FOR_METHOD : refactoringSettings.RENAME_SEARCH_IN_COMMENTS_FOR_FIELD;
                    SafeDeleteProcessor.addNonCodeUsages((PsiElement)psi, (SearchScope)GlobalSearchScope.projectScope((Project)project), result, insideDeletedCondition, (boolean)searchNonJava, (boolean)searchInCommentsAndStrings);
                }
            }
        }
        return result.toArray(UsageInfo.EMPTY_ARRAY);
    }

    private static boolean allSuperMethodsSelectedToDelete(List<PsiElement> unselectedMethods, PsiMethod method) {
        ArrayList<PsiMethod> superMethods = new ArrayList<PsiMethod>(Arrays.asList(method.findSuperMethods()));
        superMethods.retainAll(unselectedMethods);
        return superMethods.isEmpty();
    }

    public void prepareForDeletion(@NotNull PsiElement element) {
        if (element == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(17);
        }
        if (element instanceof PsiParameter) {
            PsiMethod method;
            PsiAnnotation contract;
            PsiParameterList parameterList;
            PsiParameter parameter = (PsiParameter)element;
            PsiElement psiElement = element.getParent();
            if (psiElement instanceof PsiParameterList && (psiElement = (parameterList = (PsiParameterList)psiElement).getParent()) instanceof PsiMethod && (contract = JavaMethodContractUtil.findContractAnnotation((PsiMethod)(method = (PsiMethod)psiElement))) != null) {
                ParameterInfoImpl[] info = ParameterInfoImpl.fromMethodExceptParameter((PsiMethod)method, (PsiParameter)parameter);
                try {
                    String[] names = (String[])ContainerUtil.map((Object[])parameterList.getParameters(), PsiParameter::getName, (Object[])ArrayUtilRt.EMPTY_STRING_ARRAY);
                    PsiAnnotation newContract = ContractConverter.convertContract((PsiMethod)method, (String[])names, (JavaParameterInfo[])info);
                    if (newContract != null && newContract != contract) {
                        contract.replace((PsiElement)newContract);
                    }
                }
                catch (ContractConverter.ContractConversionException contractConversionException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean isToSearchInComments(PsiElement element) {
        if (element instanceof PsiClass) {
            return JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_CLASS;
        }
        if (element instanceof PsiMethod) {
            return JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_METHOD;
        }
        if (element instanceof PsiVariable) {
            return JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_VARIABLE;
        }
        if (element instanceof PsiPackage) {
            return JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_PACKAGE;
        }
        return false;
    }

    public void setToSearchInComments(PsiElement element, boolean enabled) {
        if (element instanceof PsiClass) {
            JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_CLASS = enabled;
        } else if (element instanceof PsiMethod) {
            JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_METHOD = enabled;
        } else if (element instanceof PsiVariable) {
            JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_VARIABLE = enabled;
        } else if (element instanceof PsiPackage) {
            JavaRefactoringSettings.getInstance().RENAME_SEARCH_IN_COMMENTS_FOR_PACKAGE = enabled;
        }
    }

    public boolean isToSearchForTextOccurrences(PsiElement element) {
        if (element instanceof PsiClass) {
            return JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_CLASS;
        }
        if (element instanceof PsiMethod) {
            return JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_METHOD;
        }
        if (element instanceof PsiVariable) {
            return JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_VARIABLE;
        }
        if (element instanceof PsiPackage) {
            return JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_PACKAGE;
        }
        return false;
    }

    public void setToSearchForTextOccurrences(PsiElement element, boolean enabled) {
        if (element instanceof PsiClass) {
            JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_CLASS = enabled;
        } else if (element instanceof PsiMethod) {
            JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_METHOD = enabled;
        } else if (element instanceof PsiVariable) {
            JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_VARIABLE = enabled;
        } else if (element instanceof PsiPackage) {
            JavaRefactoringSettings.getInstance().RENAME_SEARCH_FOR_TEXT_FOR_PACKAGE = enabled;
        }
    }

    private static Condition<PsiElement> getUsageInsideDeletedFilter(PsiElement[] allElementsToDelete) {
        return usage -> !(usage instanceof PsiFile) && JavaSafeDeleteProcessor.isInside(usage, allElementsToDelete);
    }

    private static void findClassUsages(PsiClass psiClass, PsiElement[] allElementsToDelete, List<? super UsageInfo> usages) {
        String qualifiedName = psiClass.getQualifiedName();
        boolean annotationType = psiClass.isAnnotationType() && qualifiedName != null;
        PsiElement[] topElementsToDelete = (PsiElement[])Arrays.stream(allElementsToDelete).map(element -> {
            PsiClassOwner owner;
            PsiClass[] classes;
            PsiElement parent;
            if (element instanceof PsiClass && (parent = element.getParent()) instanceof PsiClassOwner && (classes = (owner = (PsiClassOwner)parent).getClasses()).length == 1 && classes[0] == element) {
                return element.getContainingFile();
            }
            return element;
        }).toArray(PsiElement[]::new);
        ReferencesSearch.search((PsiElement)psiClass).forEach(reference -> {
            PsiElement element = reference.getElement();
            if (!JavaSafeDeleteProcessor.isInside(element, topElementsToDelete)) {
                boolean safeDelete;
                UsageInfo usageInfo;
                PsiElement parent = element.getParent();
                JavaSafeDeleteDelegate safeDeleteDelegate = (JavaSafeDeleteDelegate)JavaSafeDeleteDelegate.EP.forLanguage(element.getLanguage());
                UsageInfo usageInfo2 = usageInfo = safeDeleteDelegate != null ? safeDeleteDelegate.createExtendsListUsageInfo((PsiElement)psiClass, reference) : null;
                if (usageInfo != null) {
                    usages.add(usageInfo);
                    return true;
                }
                LOG.assertTrue(element.getTextRange() != null);
                PsiFile containingFile = psiClass.getContainingFile();
                boolean sameFileWithSingleClass = false;
                if (containingFile instanceof PsiClassOwner) {
                    PsiClassOwner owner = (PsiClassOwner)containingFile;
                    PsiClass[] classes = owner.getClasses();
                    sameFileWithSingleClass = classes.length == 1 && classes[0] == psiClass && element.getContainingFile() == containingFile;
                }
                boolean bl = safeDelete = sameFileWithSingleClass || JavaSafeDeleteProcessor.isInNonStaticImport(element);
                if (annotationType && parent instanceof PsiAnnotation) {
                    PsiAnnotation annotation = (PsiAnnotation)parent;
                    usages.add((UsageInfo)new SafeDeleteAnnotation(annotation, (PsiElement)psiClass, safeDelete));
                } else {
                    usages.add((UsageInfo)new SafeDeleteReferenceJavaDeleteUsageInfo(element, (PsiElement)psiClass, safeDelete));
                }
            }
            return true;
        });
    }

    private static boolean isInNonStaticImport(PsiElement element) {
        return ImportSearcher.getImport(element, true) != null;
    }

    private static void findTypeParameterExternalUsages(PsiTypeParameter typeParameter, List<? super UsageInfo> usages) {
        PsiTypeParameterList parameterList;
        PsiTypeParameterListOwner owner = typeParameter.getOwner();
        if (owner != null && (parameterList = owner.getTypeParameterList()) != null) {
            int paramsCount = parameterList.getTypeParameters().length;
            int index = parameterList.getTypeParameterIndex(typeParameter);
            ReferencesSearch.search((PsiElement)owner).forEach(reference -> {
                JavaSafeDeleteDelegate safeDeleteDelegate = (JavaSafeDeleteDelegate)JavaSafeDeleteDelegate.EP.forLanguage(reference.getElement().getLanguage());
                if (safeDeleteDelegate != null) {
                    safeDeleteDelegate.createJavaTypeParameterUsageInfo(reference, usages, (PsiElement)typeParameter, paramsCount, index);
                }
                return true;
            });
        }
    }

    @Nullable
    private static Condition<PsiElement> findMethodUsages(PsiMethod psiMethod, PsiElement[] allElementsToDelete, @NotNull List<? super UsageInfo> usages) {
        if (usages == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(18);
        }
        Collection references = ReferencesSearch.search((PsiElement)psiMethod).findAll();
        if (psiMethod.isConstructor()) {
            return JavaSafeDeleteProcessor.findConstructorUsages(psiMethod, references, usages, allElementsToDelete);
        }
        PsiMethod[] methods = (PsiMethod[])OverridingMethodsSearch.search((PsiMethod)psiMethod).filtering(m -> !(m instanceof LightRecordMethod)).toArray((Object[])PsiMethod.EMPTY_ARRAY);
        Object[] overridingMethods = JavaSafeDeleteProcessor.removeDeletedMethods(methods, allElementsToDelete);
        JavaSafeDeleteProcessor.findFunctionalExpressions(usages, (PsiMethod[])ArrayUtil.prepend((Object)psiMethod, (Object[])overridingMethods));
        HashMap<PsiMethod, Collection<PsiReference>> methodToReferences = new HashMap<PsiMethod, Collection<PsiReference>>();
        for (Object overridingMethod : overridingMethods) {
            Collection overridingReferences = ReferencesSearch.search((PsiElement)overridingMethod).findAll();
            methodToReferences.put((PsiMethod)overridingMethod, overridingReferences);
        }
        Set<PsiMethod> validOverriding = JavaSafeDeleteProcessor.validateOverridingMethods(psiMethod, references, Arrays.asList(overridingMethods), methodToReferences, usages, allElementsToDelete);
        for (PsiReference reference : references) {
            PsiElement element = reference.getElement();
            if (JavaSafeDeleteProcessor.isInside(element, allElementsToDelete) || JavaSafeDeleteProcessor.isInside(element, validOverriding)) continue;
            boolean inStaticImport = PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStaticStatement.class) == null;
            usages.add((UsageInfo)new SafeDeleteReferenceJavaDeleteUsageInfo(element, (PsiElement)psiMethod, !inStaticImport));
        }
        JavaSafeDeleteProcessor.appendCallees((PsiMember)psiMethod, usages);
        return usage -> {
            if (usage instanceof PsiFile) {
                return false;
            }
            return JavaSafeDeleteProcessor.isInside(usage, allElementsToDelete) || JavaSafeDeleteProcessor.isInside(usage, validOverriding);
        };
    }

    private static void appendCallees(@NotNull PsiMember method, @NotNull List<? super UsageInfo> usages) {
        if (method == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(19);
        }
        if (usages == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(20);
        }
        for (PsiElement callee : SafeDeleteFix.computeReferencedCodeSafeToDelete((PsiMember)method)) {
            usages.add((UsageInfo)new SafeDeleteMemberCalleeUsageInfo(callee, method));
        }
    }

    private static void findFunctionalExpressions(List<? super UsageInfo> usages, PsiMethod ... methods) {
        for (PsiMethod method : methods) {
            PsiClass containingClass = method.getContainingClass();
            FunctionalExpressionSearch.search((PsiMethod)method).forEach(expression -> {
                usages.add((UsageInfo)new SafeDeleteFunctionalExpressionUsageInfo((PsiElement)expression, (PsiElement)containingClass, false));
                return true;
            });
        }
    }

    private static PsiMethod[] removeDeletedMethods(PsiMethod[] methods, PsiElement[] allElementsToDelete) {
        ArrayList<PsiMethod> list = new ArrayList<PsiMethod>();
        for (PsiMethod method : methods) {
            boolean isDeleted = false;
            for (PsiElement element : allElementsToDelete) {
                if (element != method) continue;
                isDeleted = true;
                break;
            }
            if (isDeleted) continue;
            list.add(method);
        }
        return list.toArray(PsiMethod.EMPTY_ARRAY);
    }

    @Nullable
    private static Condition<PsiElement> findConstructorUsages(PsiMethod constructor, Collection<PsiReference> originalReferences, @NotNull List<? super UsageInfo> usages, PsiElement[] allElementsToDelete) {
        if (usages == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(21);
        }
        if (JavaSafeDeleteProcessor.isTheOnlyEmptyDefaultConstructor(constructor)) {
            return null;
        }
        HashSet<Object> newConstructors = new HashSet<Object>();
        newConstructors.add(constructor);
        HashMap<PsiMethod, Collection<PsiReference>> constructorsToRefs = new HashMap<PsiMethod, Collection<PsiReference>>();
        constructorsToRefs.put(constructor, originalReferences);
        HashSet<PsiMethod> passConstructors = new HashSet<PsiMethod>();
        do {
            passConstructors.clear();
            for (PsiMethod psiMethod : newConstructors) {
                Collection references = (Collection)constructorsToRefs.get(psiMethod);
                for (PsiReference reference : references) {
                    PsiMethod overridingConstructor = JavaSafeDeleteProcessor.getOverridingConstructorOfSuperCall(reference.getElement());
                    if (overridingConstructor == null || constructorsToRefs.containsKey(overridingConstructor)) continue;
                    Collection overridingConstructorReferences = ReferencesSearch.search((PsiElement)overridingConstructor).findAll();
                    constructorsToRefs.put(overridingConstructor, overridingConstructorReferences);
                    passConstructors.add(overridingConstructor);
                }
            }
            newConstructors.clear();
            newConstructors.addAll(passConstructors);
        } while (!newConstructors.isEmpty());
        Set<PsiMethod> validOverriding = JavaSafeDeleteProcessor.validateOverridingMethods(constructor, originalReferences, constructorsToRefs.keySet(), constructorsToRefs, usages, allElementsToDelete);
        return usage -> {
            if (usage instanceof PsiFile) {
                return false;
            }
            return JavaSafeDeleteProcessor.isInside(usage, allElementsToDelete) || JavaSafeDeleteProcessor.isInside(usage, validOverriding);
        };
    }

    private static boolean isTheOnlyEmptyDefaultConstructor(PsiMethod constructor) {
        if (!constructor.getParameterList().isEmpty()) {
            return false;
        }
        PsiCodeBlock body = constructor.getBody();
        if (body != null && !body.isEmpty()) {
            return false;
        }
        PsiClass aClass = constructor.getContainingClass();
        if (aClass == null) {
            return false;
        }
        return aClass.getConstructors().length == 1;
    }

    private static Set<PsiMethod> validateOverridingMethods(PsiMethod originalMethod, @NotNull Collection<? extends PsiReference> originalReferences, @NotNull Collection<? extends PsiMethod> overridingMethods, Map<PsiMethod, Collection<PsiReference>> methodToReferences, @NotNull List<? super UsageInfo> usages, PsiElement @NotNull [] allElementsToDelete) {
        boolean anyNewBadRefs;
        if (originalReferences == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(22);
        }
        if (overridingMethods == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(23);
        }
        if (usages == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(24);
        }
        if (allElementsToDelete == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(25);
        }
        LinkedHashSet<PsiMethod> validOverriding = new LinkedHashSet<PsiMethod>(overridingMethods);
        HashSet<PsiMethod> multipleInterfaceImplementations = new HashSet<PsiMethod>();
        do {
            anyNewBadRefs = false;
            for (PsiMethod psiMethod : overridingMethods) {
                PsiElement element;
                if (!validOverriding.contains(psiMethod)) continue;
                Collection<PsiReference> overridingReferences = methodToReferences.get(psiMethod);
                boolean anyOverridingRefs = false;
                for (PsiReference psiReference : overridingReferences) {
                    element = psiReference.getElement();
                    if (JavaSafeDeleteProcessor.isInside(element, allElementsToDelete) || JavaSafeDeleteProcessor.isInside(element, validOverriding)) continue;
                    anyOverridingRefs = true;
                    break;
                }
                if (!anyOverridingRefs && JavaSafeDeleteProcessor.isMultipleInterfacesImplementation(psiMethod, originalMethod, allElementsToDelete)) {
                    anyOverridingRefs = true;
                    multipleInterfaceImplementations.add(psiMethod);
                }
                if (!anyOverridingRefs) continue;
                validOverriding.remove(psiMethod);
                anyNewBadRefs = true;
                for (PsiReference psiReference : originalReferences) {
                    element = psiReference.getElement();
                    if (JavaSafeDeleteProcessor.isInside(element, allElementsToDelete) || JavaSafeDeleteProcessor.isInside(element, overridingMethods)) continue;
                    usages.add((UsageInfo)new SafeDeleteReferenceJavaDeleteUsageInfo(element, (PsiElement)originalMethod, false));
                    validOverriding.clear();
                }
            }
        } while (anyNewBadRefs && !validOverriding.isEmpty());
        for (PsiMethod psiMethod : validOverriding) {
            if (psiMethod == originalMethod) continue;
            usages.add((UsageInfo)new SafeDeleteOverridingMethodUsageInfo(psiMethod, originalMethod));
        }
        for (PsiMethod psiMethod : overridingMethods) {
            JavaSafeDeleteDelegate safeDeleteDelegate;
            if (multipleInterfaceImplementations.contains(psiMethod) || (safeDeleteDelegate = (JavaSafeDeleteDelegate)JavaSafeDeleteDelegate.EP.forLanguage(psiMethod.getLanguage())) == null) continue;
            safeDeleteDelegate.createCleanupOverriding((PsiElement)psiMethod, allElementsToDelete, usages);
        }
        return validOverriding;
    }

    private static boolean isMultipleInterfacesImplementation(PsiMethod method, PsiMethod originalMethod, PsiElement[] allElementsToDelete) {
        for (PsiMethod superMethod : method.findSuperMethods()) {
            if (ArrayUtil.find((Object[])allElementsToDelete, (Object)superMethod) >= 0 || MethodSignatureUtil.isSuperMethod((PsiMethod)originalMethod, (PsiMethod)superMethod)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static PsiMethod getOverridingConstructorOfSuperCall(PsiElement element) {
        if (element instanceof PsiReferenceExpression) {
            PsiMethod constructor;
            PsiCodeBlock block;
            PsiExpressionStatement st;
            PsiMethodCallExpression call;
            PsiElement psiElement;
            PsiReferenceExpression ref = (PsiReferenceExpression)element;
            if ("super".equals(element.getText()) && (psiElement = ref.getParent()) instanceof PsiMethodCallExpression && (psiElement = (call = (PsiMethodCallExpression)psiElement).getParent()) instanceof PsiExpressionStatement && (psiElement = (st = (PsiExpressionStatement)psiElement).getParent()) instanceof PsiCodeBlock && (psiElement = (block = (PsiCodeBlock)psiElement).getParent()) instanceof PsiMethod && (constructor = (PsiMethod)psiElement).isConstructor()) {
                return constructor;
            }
        }
        return null;
    }

    static boolean canBePrivate(@NotNull PsiMethod method, PsiElement @NotNull [] allElementsToDelete) {
        PsiClass containingClass;
        if (method == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(26);
        }
        if (allElementsToDelete == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(27);
        }
        if ((containingClass = method.getContainingClass()) == null) {
            return false;
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)method.getProject());
        PsiResolveHelper resolveHelper = facade.getResolveHelper();
        PsiElementFactory factory = facade.getElementFactory();
        PsiModifierList privateModifierList = factory.createMethod("x3", (PsiType)PsiTypes.voidType()).getModifierList();
        privateModifierList.setModifierProperty("private", true);
        for (PsiReference reference : ReferencesSearch.search((PsiElement)method).findAll()) {
            PsiElement element = reference.getElement();
            if (JavaSafeDeleteProcessor.isInside(element, allElementsToDelete) || resolveHelper.isAccessible((PsiMember)method, privateModifierList, element, null, null)) continue;
            return false;
        }
        return true;
    }

    private static Condition<PsiElement> findFieldUsages(PsiField psiField, List<? super UsageInfo> usages, PsiElement[] allElementsToDelete) {
        Condition<PsiElement> isInsideDeleted = JavaSafeDeleteProcessor.getUsageInsideDeletedFilter(allElementsToDelete);
        LinkedHashSet parameters = new LinkedHashSet();
        ReferencesSearch.search((PsiElement)psiField).forEach(reference -> {
            PsiElement element = reference.getElement();
            if (!isInsideDeleted.test((Object)element)) {
                PsiAssignmentExpression assignment;
                PsiElement patt0$temp = element.getParent();
                if (patt0$temp instanceof PsiAssignmentExpression && element == (assignment = (PsiAssignmentExpression)patt0$temp).getLExpression()) {
                    PsiMethod method;
                    PsiParameter parameter;
                    PsiElement patt2$temp;
                    PsiReferenceExpression ref;
                    PsiElement patt1$temp;
                    usages.add((UsageInfo)new SafeDeleteFieldWriteReference(assignment, (PsiMember)psiField));
                    PsiExpression rExpression = PsiUtil.skipParenthesizedExprDown((PsiExpression)assignment.getRExpression());
                    if (rExpression instanceof PsiReferenceExpression && (patt1$temp = (ref = (PsiReferenceExpression)rExpression).resolve()) instanceof PsiParameter && (patt2$temp = (parameter = (PsiParameter)patt1$temp).getDeclarationScope()) instanceof PsiMethod && (method = (PsiMethod)patt2$temp).isConstructor()) {
                        parameters.add(parameter);
                    }
                } else {
                    TextRange range = reference.getRangeInElement();
                    boolean inStaticImport = PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportStaticStatement.class) == null;
                    usages.add((UsageInfo)new SafeDeleteReferenceJavaDeleteUsageInfo(reference.getElement(), (PsiElement)psiField, range.getStartOffset(), range.getEndOffset(), false, !inStaticImport));
                }
            }
            return true;
        });
        PsiClass containingClass = psiField.getContainingClass();
        if (containingClass != null) {
            PsiMethod setterPrototype = PropertyUtilBase.generateSetterPrototype((PsiField)psiField, (PsiClass)containingClass);
            PsiParameter setterParameter = setterPrototype.getParameterList().getParameters()[0];
            for (PsiParameter parameter : parameters) {
                PsiElement scope = parameter.getDeclarationScope();
                if (!(scope instanceof PsiMethod)) continue;
                PsiMethod method = (PsiMethod)scope;
                if (!ReferencesSearch.search((PsiElement)parameter, (SearchScope)new LocalSearchScope(scope)).forEach(ref -> {
                    PsiReferenceExpression r;
                    PsiAssignmentExpression assignment;
                    PsiExpression patt1$temp;
                    PsiElement patt0$temp;
                    PsiElement element = ref.getElement();
                    return element instanceof PsiReferenceExpression && (patt0$temp = PsiUtil.skipParenthesizedExprUp((PsiElement)element.getParent())) instanceof PsiAssignmentExpression && (patt1$temp = PsiUtil.skipParenthesizedExprDown((PsiExpression)(assignment = (PsiAssignmentExpression)patt0$temp).getLExpression())) instanceof PsiReferenceExpression && (r = (PsiReferenceExpression)patt1$temp).resolve() == psiField;
                })) continue;
                usages.add((UsageInfo)JavaSafeDeleteProcessor.createParameterCallHierarchyUsageInfo(setterPrototype, setterParameter, method, parameter));
            }
        } else {
            LOG.assertTrue(!psiField.isPhysical(), (Object)("No containing class for field: " + String.valueOf(psiField.getClass())));
        }
        JavaSafeDeleteProcessor.appendCallees((PsiMember)psiField, usages);
        return isInsideDeleted;
    }

    private static SafeDeleteParameterCallHierarchyUsageInfo createParameterCallHierarchyUsageInfo(PsiMethod called, PsiParameter calledParameter, PsiMethod caller, PsiParameter parameterInCaller) {
        return ApplicationManager.getApplication().isUnitTestMode() ? new SafeDeleteParameterCallHierarchyUsageInfo(caller, parameterInCaller, caller, parameterInCaller) : new SafeDeleteParameterCallHierarchyUsageInfo(called, calledParameter, caller, parameterInCaller);
    }

    private static Condition<PsiElement> findRecordComponentUsages(PsiRecordComponent component, PsiElement @NotNull [] allElementsToDelete, List<? super UsageInfo> usages) {
        if (allElementsToDelete == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(28);
        }
        Condition<PsiElement> isInsideDeleted = JavaSafeDeleteProcessor.getUsageInsideDeletedFilter(allElementsToDelete);
        PsiClass recordClass = component.getContainingClass();
        assert (recordClass != null);
        PsiMethod constructor = JavaPsiRecordUtil.findCanonicalConstructor((PsiClass)recordClass);
        if (constructor != null) {
            PsiRecordHeader header = recordClass.getRecordHeader();
            assert (header != null);
            int index = ArrayUtil.indexOf((Object[])header.getRecordComponents(), (Object)component);
            if (index < 0) {
                return isInsideDeleted;
            }
            ReferencesSearch.search((PsiElement)constructor).asIterable().forEach(ref -> {
                JavaSafeDeleteDelegate safeDeleteDelegate;
                PsiElement element = ref.getElement();
                if (!isInsideDeleted.test((Object)element) && (safeDeleteDelegate = (JavaSafeDeleteDelegate)JavaSafeDeleteDelegate.EP.forLanguage(element.getLanguage())) != null) {
                    safeDeleteDelegate.createUsageInfoForParameter(ref, usages, (PsiNamedElement)component, index, component.isVarArgs());
                }
            });
        }
        ReferencesSearch.search((PsiElement)component).asIterable().forEach(ref -> {
            PsiElement element = ref.getElement();
            if (!isInsideDeleted.test((Object)element)) {
                PsiAssignmentExpression assignment;
                boolean javadoc = element instanceof PsiDocParamRef;
                PsiElement parent = element.getParent();
                usages.add((UsageInfo)(parent instanceof PsiAssignmentExpression && element == (assignment = (PsiAssignmentExpression)parent).getLExpression() ? new SafeDeleteFieldWriteReference(assignment, (PsiMember)component) : new SafeDeleteReferenceJavaDeleteUsageInfo(javadoc ? parent : element, (PsiElement)component, javadoc)));
            }
        });
        return isInsideDeleted;
    }

    private static void findParameterUsages(@NotNull PsiParameter parameter, PsiElement @NotNull [] allElementsToDelete, @NotNull List<? super UsageInfo> usages) {
        PsiMethod method;
        int parameterIndex;
        if (parameter == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(29);
        }
        if (usages == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(30);
        }
        if (allElementsToDelete == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(31);
        }
        if ((parameterIndex = (method = (PsiMethod)parameter.getDeclarationScope()).getParameterList().getParameterIndex(parameter)) < 0) {
            return;
        }
        ReferencesSearch.search((PsiElement)method).forEach(reference -> {
            PsiParameter paramInCaller;
            PsiElement element = reference.getElement();
            JavaSafeDeleteDelegate safeDeleteDelegate = (JavaSafeDeleteDelegate)JavaSafeDeleteDelegate.EP.forLanguage(element.getLanguage());
            if (safeDeleteDelegate != null) {
                safeDeleteDelegate.createUsageInfoForParameter(reference, usages, (PsiNamedElement)parameter, parameterIndex, parameter.isVarArgs());
            }
            if (!parameter.isVarArgs() && !JavaPsiConstructorUtil.isSuperConstructorCall((PsiElement)element.getParent()) && (paramInCaller = SafeDeleteJavaCallerChooser.isTheOnlyOneParameterUsage(element.getParent(), parameterIndex, method)) != null) {
                PsiMethod callerMethod = (PsiMethod)paramInCaller.getDeclarationScope();
                usages.add((UsageInfo)JavaSafeDeleteProcessor.createParameterCallHierarchyUsageInfo(method, parameter, callerMethod, paramInCaller));
            }
            return true;
        });
        ReferencesSearch.search((PsiElement)parameter).forEach(reference -> {
            PsiField field;
            PsiRecordComponent component;
            PsiReferenceExpression ref;
            PsiElement patt2$temp;
            PsiExpression patt1$temp;
            PsiAssignmentExpression assignment;
            PsiElement element = reference.getElement();
            PsiDocTag docTag = (PsiDocTag)PsiTreeUtil.getParentOfType((PsiElement)element, PsiDocTag.class);
            if (docTag != null) {
                usages.add((UsageInfo)new SafeDeleteReferenceJavaDeleteUsageInfo((PsiElement)docTag, (PsiElement)parameter, true));
                return true;
            }
            PsiElement patt0$temp = PsiUtil.skipParenthesizedExprUp((PsiElement)element.getParent());
            if (patt0$temp instanceof PsiAssignmentExpression && PsiTreeUtil.isAncestor((PsiElement)(assignment = (PsiAssignmentExpression)patt0$temp).getRExpression(), (PsiElement)element, (boolean)false) && (patt1$temp = assignment.getLExpression()) instanceof PsiReferenceExpression && (patt2$temp = (ref = (PsiReferenceExpression)patt1$temp).resolve()) instanceof PsiField && (component = JavaPsiRecordUtil.getComponentForField((PsiField)(field = (PsiField)patt2$temp))) != null && JavaSafeDeleteProcessor.isInside((PsiElement)component, allElementsToDelete)) {
                return true;
            }
            boolean isSafeDelete = false;
            PsiElement patt3$temp = element.getParent().getParent();
            if (patt3$temp instanceof PsiMethodCallExpression) {
                PsiMethod superMethod;
                PsiMethodCallExpression call = (PsiMethodCallExpression)patt3$temp;
                if (JavaPsiConstructorUtil.isSuperConstructorCall((PsiElement)call)) {
                    isSafeDelete = true;
                } else if (call.getMethodExpression().getQualifierExpression() instanceof PsiSuperExpression && (superMethod = call.resolveMethod()) != null && MethodSignatureUtil.isSuperMethod((PsiMethod)superMethod, (PsiMethod)method)) {
                    isSafeDelete = true;
                }
            }
            usages.add((UsageInfo)new SafeDeleteReferenceJavaDeleteUsageInfo(element, (PsiElement)parameter, isSafeDelete));
            return true;
        });
        JavaSafeDeleteProcessor.findFunctionalExpressions(usages, method);
    }

    private static boolean isInside(@NotNull PsiElement place, PsiElement @NotNull [] ancestors) {
        if (place == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(32);
        }
        if (ancestors == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(33);
        }
        return JavaSafeDeleteProcessor.isInside(place, Arrays.asList(ancestors));
    }

    private static boolean isInside(@NotNull PsiElement place, @NotNull Collection<? extends PsiElement> ancestors) {
        if (place == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(34);
        }
        if (ancestors == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(35);
        }
        return ContainerUtil.exists(ancestors, element -> JavaSafeDeleteProcessor.isInside(place, element));
    }

    public static boolean isInside(@NotNull PsiElement place, PsiElement ancestor) {
        PsiJavaFile file;
        PsiClass aClass;
        PsiElement psiElement;
        if (place == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(36);
        }
        if (SafeDeleteProcessor.isInside((PsiElement)place, (PsiElement)ancestor)) {
            return true;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)place, PsiComment.class, (boolean)false) != null && ancestor instanceof PsiClass && (psiElement = (aClass = (PsiClass)ancestor).getParent()) instanceof PsiJavaFile && PsiTreeUtil.isAncestor((PsiElement)(file = (PsiJavaFile)psiElement), (PsiElement)place, (boolean)false) && file.getClasses().length == 1;
    }

    public static void collectMethodConflicts(MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflicts, @NotNull PsiMethod method, PsiParameter parameter) {
        PsiClass containingClass;
        if (method == null) {
            JavaSafeDeleteProcessor.$$$reportNull$$$0(37);
        }
        if ((containingClass = method.getContainingClass()) != null) {
            int parameterIndex = method.getParameterList().getParameterIndex(parameter);
            PsiMethod methodCopy = (PsiMethod)method.copy();
            methodCopy.getParameterList().getParameters()[parameterIndex].delete();
            ConflictsUtil.checkMethodConflicts(containingClass, method, methodCopy, conflicts);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 7: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 2: 
            case 4: 
            case 10: 
            case 13: 
            case 25: 
            case 27: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allElementsToDelete";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 19: 
            case 26: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalReferences";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overridingMethods";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 32: 
            case 34: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ancestors";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/safeDelete/JavaSafeDeleteProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findUsages";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementsToSearch";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "showUsages";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "getAdditionalElementsToDelete";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "findConflicts";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "preprocessUsages";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareForDeletion";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "findMethodUsages";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "appendCallees";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "findConstructorUsages";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[2] = "validateOverridingMethods";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[2] = "canBePrivate";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[2] = "findRecordComponentUsages";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[2] = "findParameterUsages";
                break;
            }
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[2] = "isInside";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[2] = "collectMethodConflicts";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class SafeDeleteExternalAnnotationsUsageInfo
    extends SafeDeleteReferenceUsageInfo {
        SafeDeleteExternalAnnotationsUsageInfo(PsiElement referenceElement, PsiElement element) {
            super(element, referenceElement, true);
        }

        public void deleteElement() {
            PsiAnnotation[] externalAnnotations;
            PsiElement referencedElement = this.getReferencedElement();
            if (!referencedElement.isValid()) {
                return;
            }
            ExternalAnnotationsManager annotationsManager = ExternalAnnotationsManager.getInstance((Project)referencedElement.getProject());
            for (PsiAnnotation annotation : externalAnnotations = annotationsManager.findExternalAnnotations((PsiModifierListOwner)referencedElement)) {
                String qualifiedName = annotation.getQualifiedName();
                if (qualifiedName == null) continue;
                annotationsManager.deannotate((PsiModifierListOwner)referencedElement, qualifiedName);
            }
        }
    }

    private static class SafeDeleteFunctionalExpressionUsageInfo
    extends SafeDeleteReferenceUsageInfo {
        private final boolean myIsMethodUsage;

        SafeDeleteFunctionalExpressionUsageInfo(@NotNull PsiElement element, PsiElement referencedElement, boolean isMethodUsage) {
            if (element == null) {
                SafeDeleteFunctionalExpressionUsageInfo.$$$reportNull$$$0(0);
            }
            super(element, referencedElement, SafeDeleteFunctionalExpressionUsageInfo.isSafeToDelete(element, isMethodUsage));
            this.myIsMethodUsage = isMethodUsage;
        }

        private static boolean isSafeToDelete(@NotNull PsiElement element, boolean isMethodUsage) {
            if (element == null) {
                SafeDeleteFunctionalExpressionUsageInfo.$$$reportNull$$$0(1);
            }
            if (isMethodUsage) {
                if (element instanceof PsiLambdaExpression) {
                    return LambdaCanBeReplacedWithAnonymousInspection.isConvertibleLambdaExpression((PsiElement)element);
                }
                if (element instanceof PsiMethodReferenceExpression) {
                    // empty if block
                }
            }
            return false;
        }

        public void deleteElement() {
            if (!this.myIsMethodUsage) {
                return;
            }
            PsiElement element = this.getElement();
            if (element instanceof PsiLambdaExpression) {
                PsiLambdaExpression lambda = (PsiLambdaExpression)element;
                PsiAnonymousClass aClass = LambdaCanBeReplacedWithAnonymousInspection.doFix((Project)this.getProject(), (PsiLambdaExpression)lambda);
                if (aClass == null) {
                    return;
                }
                PsiFile file = aClass.getContainingFile();
                if (file == null || !JavaCodeStyleSettings.getInstance((PsiFile)file).INSERT_OVERRIDE_ANNOTATION) {
                    return;
                }
                PsiMethod[] methods = aClass.getMethods();
                if (methods.length != 1) {
                    return;
                }
                PsiAnnotation overrideAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)methods[0], (boolean)true, (String[])new String[]{"java.lang.Override"});
                if (overrideAnnotation != null) {
                    overrideAnnotation.delete();
                }
            } else if (element instanceof PsiMethodReferenceExpression) {
                // empty if block
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "element";
            objectArray2[1] = "com/intellij/refactoring/safeDelete/JavaSafeDeleteProcessor$SafeDeleteFunctionalExpressionUsageInfo";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSafeToDelete";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

