/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.safeDelete;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteOverridingMethodUsageInfo;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TableUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.impl.UsagePreviewPanel;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OverridingMethodsDialog
extends DialogWrapper {
    private final Project myProject;
    private final List<? extends UsageInfo> myOverridingMethods;
    private final String[] myMethodText;
    private final boolean[] myChecked;
    private static final int CHECK_COLUMN = 0;
    private JBTable myTable;
    private final UsagePreviewPanel myUsagePreviewPanel;

    public OverridingMethodsDialog(Project project, List<? extends UsageInfo> overridingMethods) {
        super(project, true);
        this.myProject = project;
        this.myOverridingMethods = overridingMethods;
        this.myChecked = new boolean[this.myOverridingMethods.size()];
        Arrays.fill(this.myChecked, true);
        this.myMethodText = new String[this.myOverridingMethods.size()];
        Arrays.setAll(this.myMethodText, i -> this.getElementDescription(this.myOverridingMethods.get(i)));
        this.myUsagePreviewPanel = new UsagePreviewPanel(project, new UsageViewPresentation());
        this.setTitle(this.getTitleText());
        this.init();
    }

    @NlsContexts.DialogTitle
    @NotNull
    protected String getTitleText() {
        String string = JavaRefactoringBundle.message((String)"unused.overriding.methods.title", (Object[])new Object[0]);
        if (string == null) {
            OverridingMethodsDialog.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NlsContexts.DialogMessage
    @NotNull
    protected String getDescriptionText() {
        String string = JavaRefactoringBundle.message((String)"there.are.unused.methods.that.override.methods.you.delete", (Object[])new Object[0]);
        if (string == null) {
            OverridingMethodsDialog.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NlsContexts.ColumnName
    @NotNull
    protected String getColumnName() {
        String string = JavaRefactoringBundle.message((String)"method.column", (Object[])new Object[0]);
        if (string == null) {
            OverridingMethodsDialog.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected String getElementDescription(UsageInfo info) {
        PsiElement overridingMethod = ((SafeDeleteOverridingMethodUsageInfo)info).getOverridingMethod();
        if (overridingMethod instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)overridingMethod;
            int options2 = 4355;
            return PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)options2, (int)2);
        }
        return SymbolPresentationUtil.getSymbolPresentableText((PsiElement)overridingMethod);
    }

    protected String getDimensionServiceKey() {
        return "#com.intellij.refactoring.safeDelete.OverridingMethodsDialog";
    }

    @Nullable
    public Dimension getInitialSize() {
        return JBUI.DialogSizes.large();
    }

    public ArrayList<UsageInfo> getSelected() {
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        for (int i = 0; i < this.myChecked.length; ++i) {
            if (!this.myChecked[i]) continue;
            result.add(this.myOverridingMethods.get(i));
        }
        return result;
    }

    protected String getHelpId() {
        return "refactoring.safeDelete.overridingMethods";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTable;
    }

    protected void dispose() {
        Disposer.dispose((Disposable)this.myUsagePreviewPanel);
        super.dispose();
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout(0, 4));
        panel.add((Component)new JLabel(this.getDescriptionText()), "North");
        MyTableModel tableModel = new MyTableModel();
        this.myTable = new JBTable((TableModel)tableModel);
        this.myTable.setShowGrid(false);
        TableColumnModel columnModel = this.myTable.getColumnModel();
        TableColumn checkboxColumn = columnModel.getColumn(0);
        TableUtil.setupCheckboxColumn((TableColumn)checkboxColumn, (int)columnModel.getColumnMargin());
        checkboxColumn.setCellRenderer((TableCellRenderer)new BooleanTableCellRenderer());
        @NonNls InputMap inputMap = this.myTable.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(32, 0), "enable_disable");
        @NonNls ActionMap actionMap = this.myTable.getActionMap();
        actionMap.put("enable_disable", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (OverridingMethodsDialog.this.myTable.isEditing()) {
                    return;
                }
                int[] rows = OverridingMethodsDialog.this.myTable.getSelectedRows();
                if (rows.length > 0) {
                    for (int row : rows) {
                        OverridingMethodsDialog.this.myChecked[row] = !OverridingMethodsDialog.this.myChecked[row];
                    }
                    OverridingMethodsDialog.this.myTable.repaint();
                }
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(@NotNull MouseEvent event) {
                int row;
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((row = OverridingMethodsDialog.this.myTable.getSelectedRow()) < 0 || row >= OverridingMethodsDialog.this.myOverridingMethods.size()) {
                    return false;
                }
                OverridingMethodsDialog.this.myChecked[row] = !OverridingMethodsDialog.this.myChecked[row];
                OverridingMethodsDialog.this.myTable.repaint();
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/refactoring/safeDelete/OverridingMethodsDialog$2", "onDoubleClick"));
            }
        }.installOn((Component)this.myTable);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTable);
        ListSelectionListener selectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = OverridingMethodsDialog.this.myTable.getSelectionModel().getLeadSelectionIndex();
                if (index != -1) {
                    UsageInfo usageInfo = OverridingMethodsDialog.this.myOverridingMethods.get(index);
                    OverridingMethodsDialog.this.myUsagePreviewPanel.updateLayout(OverridingMethodsDialog.this.myProject, Collections.singletonList(usageInfo));
                } else {
                    OverridingMethodsDialog.this.myUsagePreviewPanel.updateLayout(OverridingMethodsDialog.this.myProject, null);
                }
            }
        };
        this.myTable.getSelectionModel().addListSelectionListener(selectionListener);
        final Splitter splitter = new Splitter(true, 0.4f);
        splitter.setFirstComponent((JComponent)scrollPane);
        splitter.setSecondComponent((JComponent)this.myUsagePreviewPanel);
        Disposer.register((Disposable)this.myDisposable, (Disposable)new Disposable(){

            public void dispose() {
                splitter.dispose();
            }
        });
        panel.add((Component)splitter, "Center");
        if (tableModel.getRowCount() != 0) {
            SwingUtilities.invokeLater(() -> this.myTable.setRowSelectionInterval(0, 0));
        }
        return panel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/refactoring/safeDelete/OverridingMethodsDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTitleText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptionText";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    class MyTableModel
    extends AbstractTableModel {
        MyTableModel() {
        }

        @Override
        public int getRowCount() {
            return OverridingMethodsDialog.this.myChecked.length;
        }

        @Override
        public String getColumnName(int column) {
            return column == 0 ? " " : OverridingMethodsDialog.this.getColumnName();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return columnIndex == 0 ? Boolean.class : String.class;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return columnIndex == 0 ? Boolean.valueOf(OverridingMethodsDialog.this.myChecked[rowIndex]) : OverridingMethodsDialog.this.myMethodText[rowIndex];
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                OverridingMethodsDialog.this.myChecked[rowIndex] = (Boolean)aValue;
            }
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }
    }
}

