/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.safeDelete;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.changeSignature.MemberNodeBase;
import com.intellij.refactoring.changeSignature.inCallers.JavaCallerChooser;
import com.intellij.refactoring.changeSignature.inCallers.JavaMethodNode;
import com.intellij.refactoring.safeDelete.JavaSafeDeleteDelegate;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteParameterCallHierarchyUsageInfo;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceJavaDeleteUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.EmptyConsumer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

abstract class SafeDeleteJavaCallerChooser
extends JavaCallerChooser {
    private final PsiMethod myMethod;
    private final List<? super UsageInfo> myResult;

    SafeDeleteJavaCallerChooser(@NotNull PsiMethod method, @NotNull Project project, @NotNull List<? super UsageInfo> result) {
        if (method == null) {
            SafeDeleteJavaCallerChooser.$$$reportNull$$$0(0);
        }
        if (project == null) {
            SafeDeleteJavaCallerChooser.$$$reportNull$$$0(1);
        }
        if (result == null) {
            SafeDeleteJavaCallerChooser.$$$reportNull$$$0(2);
        }
        super(method, project, JavaRefactoringBundle.message((String)"safe.delete.select.methods.to.propagate.delete.parameters.dialog.title", (Object[])new Object[0]), null, EmptyConsumer.getInstance());
        this.myMethod = method;
        this.myResult = result;
    }

    @NotNull
    protected abstract List<SafeDeleteParameterCallHierarchyUsageInfo> getTopLevelItems();

    protected abstract int getParameterIdx();

    protected JavaMethodNode createTreeNodeFor(PsiMethod nodeMethod, HashSet<PsiMethod> called, Runnable cancelCallback) {
        SafeDeleteJavaMethodNode node = new SafeDeleteJavaMethodNode(nodeMethod, called, cancelCallback, this.getParameterIdx(), nodeMethod != null ? nodeMethod.getProject() : this.myProject);
        if (((PsiMethod)this.getTopMember()).equals((Object)nodeMethod)) {
            node.setEnabled(false);
            node.setChecked(true);
        }
        return node;
    }

    protected void doOKAction() {
        ArrayList foreignMethodUsages = new ArrayList();
        Runnable runnable = () -> {
            Set nodes = this.getSelectedNodes();
            for (MemberNodeBase node : nodes) {
                SafeDeleteJavaMethodNode methodNode = (SafeDeleteJavaMethodNode)node;
                PsiMethod nodeMethod = (PsiMethod)methodNode.getMember();
                if (nodeMethod.equals((Object)this.myMethod)) continue;
                int parameterIdx = methodNode.myParameterIdx;
                PsiParameter parameter = nodeMethod.getParameterList().getParameters()[parameterIdx];
                foreignMethodUsages.add(new SafeDeleteParameterCallHierarchyUsageInfo(nodeMethod, parameter, nodeMethod, parameter));
                ReferencesSearch.search((PsiElement)nodeMethod).forEach(reference -> {
                    PsiElement element = reference.getElement();
                    JavaSafeDeleteDelegate safeDeleteDelegate = (JavaSafeDeleteDelegate)JavaSafeDeleteDelegate.EP.forLanguage(element.getLanguage());
                    if (safeDeleteDelegate != null) {
                        safeDeleteDelegate.createUsageInfoForParameter(reference, foreignMethodUsages, (PsiNamedElement)parameter, parameterIdx, parameter.isVarArgs());
                    }
                    return true;
                });
                ReferencesSearch.search((PsiElement)parameter).forEach(reference -> {
                    PsiElement element = reference.getElement();
                    PsiDocTag docTag = (PsiDocTag)PsiTreeUtil.getParentOfType((PsiElement)element, PsiDocTag.class);
                    if (docTag != null) {
                        foreignMethodUsages.add(new SafeDeleteReferenceJavaDeleteUsageInfo((PsiElement)docTag, (PsiElement)parameter, true));
                    }
                    return true;
                });
            }
        };
        if (ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ApplicationManager.getApplication().runReadAction(runnable), JavaRefactoringBundle.message((String)"safe.delete.search.for.caller.method.usages.progress", (Object[])new Object[0]), true, this.myProject)) {
            this.myResult.addAll(foreignMethodUsages);
        }
        super.doOKAction();
    }

    static PsiParameter isTheOnlyOneParameterUsage(PsiElement call, final int parameterIndex, final PsiMethod nodeMethod) {
        PsiExpression expression;
        PsiExpression[] expressions;
        PsiExpressionList argumentList;
        if (call instanceof PsiCallExpression && (argumentList = ((PsiCallExpression)call).getArgumentList()) != null && (expressions = argumentList.getExpressions()).length > parameterIndex && (expression = PsiUtil.deparenthesizeExpression((PsiExpression)expressions[parameterIndex])) != null) {
            PsiElement scope;
            final HashSet paramRefs = new HashSet();
            expression.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                    if (expression == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.visitReferenceExpression(expression);
                    PsiElement resolve = expression.resolve();
                    if (resolve instanceof PsiParameter) {
                        paramRefs.add((PsiParameter)resolve);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/refactoring/safeDelete/SafeDeleteJavaCallerChooser$1", "visitReferenceExpression"));
                }
            });
            PsiParameter parameter = (PsiParameter)ContainerUtil.getFirstItem(paramRefs);
            if (parameter != null && !parameter.isVarArgs() && (scope = parameter.getDeclarationScope()) instanceof PsiMethod && ((PsiMethod)scope).findDeepestSuperMethods().length == 0 && OverridingMethodsSearch.search((PsiMethod)((PsiMethod)scope)).findFirst() == null) {
                final int scopeParamIdx = ((PsiMethod)scope).getParameterList().getParameterIndex(parameter);
                final Ref ref = new Ref((Object)false);
                if (ReferencesSearch.search((PsiElement)parameter, (SearchScope)new LocalSearchScope(scope)).forEach((Processor)new Processor<PsiReference>(){

                    public boolean process(PsiReference reference) {
                        PsiElement element = reference.getElement();
                        if (element instanceof PsiReferenceExpression) {
                            PsiCallExpression parent = (PsiCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiCallExpression.class);
                            while (parent != null) {
                                PsiMethod resolved = parent.resolveMethod();
                                if (scope.equals((Object)resolved)) {
                                    return !2.usedInQualifier(element, parent, scopeParamIdx);
                                }
                                if (nodeMethod.equals((Object)resolved)) {
                                    if (2.usedInQualifier(element, parent, parameterIndex)) {
                                        return false;
                                    }
                                    ref.set((Object)true);
                                    return true;
                                }
                                parent = (PsiCallExpression)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiCallExpression.class, (boolean)true);
                            }
                            return false;
                        }
                        return true;
                    }

                    private static boolean usedInQualifier(PsiElement element, PsiCallExpression parent, int parameterIndex2) {
                        PsiReferenceExpression qualifier = null;
                        if (parent instanceof PsiMethodCallExpression) {
                            qualifier = ((PsiMethodCallExpression)parent).getMethodExpression();
                        } else if (parent instanceof PsiNewExpression) {
                            qualifier = ((PsiNewExpression)parent).getQualifier();
                        }
                        if (PsiTreeUtil.isAncestor((PsiElement)qualifier, (PsiElement)element, (boolean)true)) {
                            return true;
                        }
                        PsiExpressionList list = parent.getArgumentList();
                        return list != null && !PsiTreeUtil.isAncestor((PsiElement)list.getExpressions()[parameterIndex2], (PsiElement)element, (boolean)false);
                    }
                }) && ((Boolean)ref.get()).booleanValue()) {
                    return parameter;
                }
            }
        }
        return null;
    }

    protected PsiParameter getParameterInCaller(PsiMethod called, int paramIdx, PsiMethod caller) {
        if (caller.findDeepestSuperMethods().length > 0) {
            return null;
        }
        Ref ref = new Ref();
        ReferencesSearch.search((PsiElement)called, (SearchScope)new LocalSearchScope((PsiElement)caller)).forEach(reference -> {
            PsiElement elementParent;
            PsiElement element = reference.getElement();
            if (element instanceof PsiJavaCodeReferenceElement && (elementParent = element.getParent()) instanceof PsiCallExpression) {
                ref.set((Object)SafeDeleteJavaCallerChooser.isTheOnlyOneParameterUsage(elementParent, paramIdx, called));
                return false;
            }
            return true;
        });
        return (PsiParameter)ref.get();
    }

    private int getCallerParameterIndex(PsiMethod called, int paramIdx, PsiMethod caller) {
        PsiParameter parameter = this.getParameterInCaller(called, paramIdx, caller);
        return parameter != null ? caller.getParameterList().getParameterIndex(parameter) : -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "method";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "result";
                break;
            }
        }
        objectArray[1] = "com/intellij/refactoring/safeDelete/SafeDeleteJavaCallerChooser";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class SafeDeleteJavaMethodNode
    extends JavaMethodNode {
        private final int myParameterIdx;

        SafeDeleteJavaMethodNode(PsiMethod currentMethod, HashSet<PsiMethod> called, Runnable cancelCallback, int idx, Project project) {
            super(currentMethod, called, project, cancelCallback);
            this.myParameterIdx = idx;
        }

        protected MemberNodeBase<PsiMethod> createNode(PsiMethod caller, HashSet<PsiMethod> called) {
            return new SafeDeleteJavaMethodNode(caller, called, this.myCancelCallback, SafeDeleteJavaCallerChooser.this.getCallerParameterIndex((PsiMethod)this.myMethod, this.myParameterIdx, caller), this.myProject);
        }

        protected @Unmodifiable List<PsiMethod> computeCallers() {
            if (((PsiMethod)SafeDeleteJavaCallerChooser.this.getTopMember()).equals((Object)this.getMember())) {
                List<SafeDeleteParameterCallHierarchyUsageInfo> items = SafeDeleteJavaCallerChooser.this.getTopLevelItems();
                return ContainerUtil.map(items, info -> info.getCallerMethod());
            }
            ArrayList<PsiMethod> methods = new ArrayList<PsiMethod>(super.computeCallers());
            methods.remove(SafeDeleteJavaCallerChooser.this.getTopMember());
            return methods;
        }

        protected Condition<PsiMethod> getFilter() {
            return method -> !((PsiMethod)this.myMethod).equals(method) && SafeDeleteJavaCallerChooser.this.getParameterInCaller((PsiMethod)this.myMethod, this.myParameterIdx, (PsiMethod)method) != null;
        }
    }
}

