/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.safeDelete.usageInfo;

import com.intellij.codeInsight.daemon.impl.quickfix.RemoveUnusedVariableUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiStatement;
import com.intellij.refactoring.safeDelete.ImportSearcher;
import com.intellij.refactoring.safeDelete.usageInfo.SafeDeleteReferenceSimpleDeleteUsageInfo;
import com.intellij.util.CommonJavaRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;

public class SafeDeleteReferenceJavaDeleteUsageInfo
extends SafeDeleteReferenceSimpleDeleteUsageInfo {
    private static final Logger LOG = Logger.getInstance(SafeDeleteReferenceJavaDeleteUsageInfo.class);

    public SafeDeleteReferenceJavaDeleteUsageInfo(PsiElement element, PsiElement referencedElement, boolean isSafeDelete) {
        super(element, referencedElement, isSafeDelete);
    }

    public SafeDeleteReferenceJavaDeleteUsageInfo(PsiElement element, PsiElement referencedElement, int startOffset, int endOffset, boolean isNonCodeUsage, boolean isSafeDelete) {
        super(element, referencedElement, startOffset, endOffset, isNonCodeUsage, isSafeDelete);
    }

    public SafeDeleteReferenceJavaDeleteUsageInfo(PsiExpression expression, PsiElement referenceElement) {
        this((PsiElement)expression, referenceElement, !RemoveUnusedVariableUtil.checkSideEffects((PsiExpression)expression, null, new ArrayList()));
    }

    public void deleteElement() throws IncorrectOperationException {
        if (this.isSafeDelete()) {
            PsiElement element = this.getElement();
            LOG.assertTrue(element != null);
            PsiElement importStatement = ImportSearcher.getImport(element, false);
            if (importStatement != null) {
                if (element instanceof PsiImportStaticReferenceElement) {
                    if (((PsiImportStaticReferenceElement)element).multiResolve(false).length < 2) {
                        importStatement.delete();
                    }
                } else {
                    importStatement.delete();
                }
            } else if (element instanceof PsiExpressionStatement && CommonJavaRefactoringUtil.isLoopOrIf((PsiElement)element.getParent()) && !RemoveUnusedVariableUtil.isForLoopUpdate((PsiElement)element)) {
                PsiStatement emptyTest = JavaPsiFacade.getElementFactory((Project)this.getProject()).createStatementFromText(";", null);
                element.replace((PsiElement)emptyTest);
            } else {
                element.delete();
            }
        }
    }
}

