/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration;

import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.typeMigration.ChangeTypeSignatureHandlerBase;
import com.intellij.refactoring.typeMigration.TypeMigrationProcessor;
import com.intellij.refactoring.typeMigration.TypeMigrationRules;
import com.intellij.refactoring.typeMigration.Util;
import com.intellij.refactoring.typeMigration.ui.TypeMigrationDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeTypeSignatureHandler
implements ChangeTypeSignatureHandlerBase {
    private static final Logger LOG = Logger.getInstance(ChangeTypeSignatureHandler.class);

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        PsiMethod method;
        PsiVariable variable;
        PsiElement parent;
        if (project == null) {
            ChangeTypeSignatureHandler.$$$reportNull$$$0(0);
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        int offset = TargetElementUtil.adjustOffset((PsiFile)file, (Document)editor.getDocument(), (int)editor.getCaretModel().getOffset());
        PsiElement element = file.findElementAt(offset);
        if (element instanceof PsiIdentifier && ((parent = element.getParent()) instanceof PsiVariable ? ChangeTypeSignatureHandler.invoke(project, editor, (variable = (PsiVariable)parent).getTypeElement(), (PsiElement)variable) : parent instanceof PsiMethod && !(method = (PsiMethod)parent).isConstructor() && ChangeTypeSignatureHandler.invoke(project, editor, method.getReturnTypeElement(), (PsiElement)method))) {
            return;
        }
        PsiTypeElement typeElement = (PsiTypeElement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiTypeElement.class);
        while (typeElement != null) {
            PsiElement parent2 = typeElement.getParent();
            if (ChangeTypeSignatureHandler.invoke(project, editor, typeElement, parent2)) {
                return;
            }
            typeElement = (PsiTypeElement)PsiTreeUtil.getParentOfType((PsiElement)parent2, PsiTypeElement.class, (boolean)false);
        }
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)JavaRefactoringBundle.message((String)"caret.position.warning.message", (Object[])new Object[0]), (String)JavaRefactoringBundle.message((String)"type.migration.error.hint.title", (Object[])new Object[0]), (String)"refactoring.migrateType");
    }

    private static boolean invoke(@NotNull Project project, Editor editor, PsiTypeElement typeElement, PsiElement parent) {
        if (project == null) {
            ChangeTypeSignatureHandler.$$$reportNull$$$0(1);
        }
        PsiElement[] toMigrate = null;
        if (parent instanceof PsiVariable) {
            toMigrate = ChangeTypeSignatureHandler.extractReferencedVariables(typeElement);
        } else if (parent instanceof PsiMember && !(parent instanceof PsiClass) || ChangeTypeSignatureHandler.isClassArgument(parent)) {
            toMigrate = new PsiElement[]{parent};
        }
        if (toMigrate != null && toMigrate.length > 0) {
            ChangeTypeSignatureHandler.invoke(project, toMigrate, editor);
            return true;
        }
        return false;
    }

    public void invoke(@NotNull Project project, PsiElement @NotNull [] elements, DataContext dataContext) {
        if (project == null) {
            ChangeTypeSignatureHandler.$$$reportNull$$$0(2);
        }
        if (elements == null) {
            ChangeTypeSignatureHandler.$$$reportNull$$$0(3);
        }
        LOG.assertTrue(elements.length == 1);
        PsiElement element = elements[0];
        ChangeTypeSignatureHandler.invokeOnElement(project, element);
    }

    public void runHighlightingTypeMigrationSilently(Project project, Editor editor, SearchScope boundScope, PsiElement root, PsiType migrationType) {
        TypeMigrationRules rules = new TypeMigrationRules(project);
        rules.setBoundScope(boundScope);
        TypeMigrationProcessor.runHighlightingTypeMigration(project, editor, rules, root, migrationType);
    }

    private static void invokeOnElement(Project project, PsiElement element) {
        if (element instanceof PsiVariable || element instanceof PsiMember && !(element instanceof PsiClass) || element instanceof PsiFile || ChangeTypeSignatureHandler.isClassArgument(element)) {
            ChangeTypeSignatureHandler.invoke(project, new PsiElement[]{element}, null);
        }
    }

    private static boolean isClassArgument(PsiElement element) {
        if (element instanceof PsiReferenceParameterList) {
            PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMember.class);
            if (member instanceof PsiAnonymousClass) {
                return ((PsiAnonymousClass)member).getBaseClassReference().getParameterList() == element;
            }
            if (member instanceof PsiClass) {
                PsiReferenceList implementsList = ((PsiClass)member).getImplementsList();
                PsiReferenceList extendsList = ((PsiClass)member).getExtendsList();
                return PsiTreeUtil.isAncestor((PsiElement)implementsList, (PsiElement)element, (boolean)false) || PsiTreeUtil.isAncestor((PsiElement)extendsList, (PsiElement)element, (boolean)false);
            }
        }
        return false;
    }

    private static void invoke(@NotNull Project project, PsiElement @NotNull [] roots, @Nullable Editor editor) {
        if (project == null) {
            ChangeTypeSignatureHandler.$$$reportNull$$$0(4);
        }
        if (roots == null) {
            ChangeTypeSignatureHandler.$$$reportNull$$$0(5);
        }
        if (Util.canBeMigrated(roots)) {
            TypeMigrationDialog.SingleElement dialog = new TypeMigrationDialog.SingleElement(project, roots);
            dialog.show();
            return;
        }
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)JavaRefactoringBundle.message((String)"only.fields.variables.of.methods.of.valid.type.can.be.considered", (Object[])new Object[0]), (String)JavaRefactoringBundle.message((String)"unable.to.start.type.migration", (Object[])new Object[0]), null);
    }

    private static PsiElement @NotNull [] extractReferencedVariables(@NotNull PsiTypeElement typeElement) {
        PsiElement parent;
        if (typeElement == null) {
            ChangeTypeSignatureHandler.$$$reportNull$$$0(6);
        }
        if ((parent = typeElement.getParent()) instanceof PsiVariable) {
            PsiDeclarationStatement declaration;
            if (parent instanceof PsiField) {
                PsiField aField = (PsiField)parent;
                ArrayList<PsiField> fields = new ArrayList<PsiField>();
                do {
                    fields.add(aField);
                } while ((aField = (PsiField)PsiTreeUtil.getNextSiblingOfType((PsiElement)aField, PsiField.class)) != null && aField.getTypeElement() == typeElement);
                PsiElement[] psiElementArray = fields.toArray(PsiElement.EMPTY_ARRAY);
                if (psiElementArray == null) {
                    ChangeTypeSignatureHandler.$$$reportNull$$$0(7);
                }
                return psiElementArray;
            }
            if (parent instanceof PsiLocalVariable && (declaration = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiDeclarationStatement.class)) != null) {
                PsiElement[] psiElementArray = (PsiElement[])Arrays.stream(declaration.getDeclaredElements()).filter(PsiVariable.class::isInstance).toArray(PsiVariable[]::new);
                if (psiElementArray == null) {
                    ChangeTypeSignatureHandler.$$$reportNull$$$0(8);
                }
                return psiElementArray;
            }
            PsiElement[] psiElementArray = new PsiElement[]{parent};
            if (psiElementArray == null) {
                ChangeTypeSignatureHandler.$$$reportNull$$$0(9);
            }
            return psiElementArray;
        }
        if (PsiElement.EMPTY_ARRAY == null) {
            ChangeTypeSignatureHandler.$$$reportNull$$$0(10);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeElement";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/typeMigration/ChangeTypeSignatureHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/typeMigration/ChangeTypeSignatureHandler";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "extractReferencedVariables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "extractReferencedVariables";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9, 10 -> new IllegalStateException(string);
        };
    }
}

