/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.usageInfo.TypeMigrationUsageInfo;
import com.intellij.util.CommonJavaRefactoringUtil;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ClassTypeArgumentMigrationProcessor {
    private static final Logger LOG = Logger.getInstance(ClassTypeArgumentMigrationProcessor.class);
    private final TypeMigrationLabeler myLabeler;

    public ClassTypeArgumentMigrationProcessor(TypeMigrationLabeler labeler) {
        this.myLabeler = labeler;
    }

    public void migrateClassTypeParameter(PsiReferenceParameterList referenceParameterList, PsiClassType migrationType) {
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)referenceParameterList, PsiClass.class);
        LOG.assertTrue(psiClass != null);
        PsiClass superClass = psiClass.getSuperClass();
        LOG.assertTrue(superClass != null);
        this.myLabeler.getTypeEvaluator().setType(new TypeMigrationUsageInfo((PsiElement)superClass), (PsiType)migrationType);
        HashMap<PsiElement, Pair<PsiReference[], PsiType>> roots = new HashMap<PsiElement, Pair<PsiReference[], PsiType>>();
        this.markTypeParameterUsages(psiClass, migrationType, referenceParameterList, roots);
        HashSet processed = new HashSet();
        for (Map.Entry entry : roots.entrySet()) {
            PsiReference[] references;
            PsiElement member = (PsiElement)entry.getKey();
            PsiType type = (PsiType)((Pair)entry.getValue()).second;
            if (member instanceof PsiParameter && ((PsiParameter)member).getDeclarationScope() instanceof PsiMethod) {
                this.myLabeler.migrateMethodCallExpressions(type, (PsiParameter)member, psiClass);
            }
            for (PsiReference usage : references = (PsiReference[])((Pair)entry.getValue()).first) {
                this.myLabeler.migrateRootUsageExpression(usage, processed);
            }
        }
    }

    private void markTypeParameterUsages(final PsiClass psiClass, PsiClassType migrationType, PsiReferenceParameterList referenceParameterList, final Map<PsiElement, Pair<PsiReference[], PsiType>> roots) {
        final PsiSubstitutor[] fullHierarchySubstitutor = new PsiSubstitutor[]{migrationType.resolveGenerics().getSubstitutor()};
        CommonJavaRefactoringUtil.processSuperTypes((PsiType)migrationType, (CommonJavaRefactoringUtil.SuperTypeVisitor)new CommonJavaRefactoringUtil.SuperTypeVisitor(){

            public void visitType(PsiType aType) {
                fullHierarchySubstitutor[0] = fullHierarchySubstitutor[0].putAll(((PsiClassType)aType).resolveGenerics().getSubstitutor());
            }

            public void visitClass(PsiClass aClass) {
            }
        });
        PsiClass resolvedClass = (PsiClass)((PsiJavaCodeReferenceElement)referenceParameterList.getParent()).resolve();
        LOG.assertTrue(resolvedClass != null);
        HashSet<PsiClass> superClasses = new HashSet<PsiClass>();
        superClasses.add(resolvedClass);
        InheritanceUtil.getSuperClasses((PsiClass)resolvedClass, superClasses, (boolean)true);
        for (PsiClass superSuperClass : superClasses) {
            final HashSet typeParameters = ContainerUtil.newHashSet((Iterable)PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)superSuperClass));
            superSuperClass.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

                public void visitMethod(@NotNull PsiMethod method) {
                    if (method == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    super.visitMethod(method);
                    ClassTypeArgumentMigrationProcessor.this.processMemberType((PsiElement)method, typeParameters, psiClass, fullHierarchySubstitutor[0], roots);
                    for (PsiParameter parameter : method.getParameterList().getParameters()) {
                        ClassTypeArgumentMigrationProcessor.this.processMemberType((PsiElement)parameter, typeParameters, psiClass, fullHierarchySubstitutor[0], roots);
                    }
                }

                public void visitField(@NotNull PsiField field) {
                    if (field == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    super.visitField(field);
                    ClassTypeArgumentMigrationProcessor.this.processMemberType((PsiElement)field, typeParameters, psiClass, fullHierarchySubstitutor[0], roots);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "method";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "field";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/refactoring/typeMigration/ClassTypeArgumentMigrationProcessor$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitMethod";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitField";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    private void processMemberType(PsiElement element, Set<PsiTypeParameter> typeParameters, PsiClass psiClass, PsiSubstitutor substitutor, Map<PsiElement, Pair<PsiReference[], PsiType>> roots) {
        PsiType elementType = TypeMigrationLabeler.getElementType(element);
        if (elementType != null && PsiTypesUtil.mentionsTypeParameters((PsiType)elementType, typeParameters)) {
            PsiType memberType = substitutor.substitute(elementType);
            this.prepareMethodsChangeSignature(psiClass, element, memberType);
            List<PsiReference> refs = TypeMigrationLabeler.filterReferences(psiClass, (Query<? extends PsiReference>)ReferencesSearch.search((PsiElement)element, (SearchScope)psiClass.getUseScope()));
            roots.put(element, (Pair<PsiReference[], PsiType>)Pair.create((Object)this.myLabeler.markRootUsages(element, memberType, refs.toArray(PsiReference.EMPTY_ARRAY)), (Object)memberType));
        }
    }

    private void prepareMethodsChangeSignature(PsiClass currentClass, PsiElement memberToChangeSignature, PsiType memberType) {
        PsiParameter superParameter;
        PsiElement method2;
        if (memberToChangeSignature instanceof PsiMethod) {
            PsiMethod superMethod = (PsiMethod)memberToChangeSignature;
            PsiMethod method2 = MethodSignatureUtil.findMethodBySuperMethod((PsiClass)currentClass, (PsiMethod)superMethod, (boolean)true);
            if (method2 != null && method2.getContainingClass() == currentClass) {
                this.myLabeler.addRoot(new TypeMigrationUsageInfo((PsiElement)method2), memberType, (PsiElement)method2, false);
            }
        } else if (memberToChangeSignature instanceof PsiParameter && (method2 = (superParameter = (PsiParameter)memberToChangeSignature).getDeclarationScope()) instanceof PsiMethod) {
            PsiParameter parameter;
            PsiMethod superMethod = (PsiMethod)method2;
            int parameterIndex = superMethod.getParameterList().getParameterIndex(superParameter);
            PsiMethod method3 = MethodSignatureUtil.findMethodBySuperMethod((PsiClass)currentClass, (PsiMethod)superMethod, (boolean)true);
            if (method3 != null && method3.getContainingClass() == currentClass && !(parameter = Objects.requireNonNull(method3.getParameterList().getParameter(parameterIndex))).getType().equals(memberType)) {
                this.myLabeler.addRoot(new TypeMigrationUsageInfo((PsiElement)parameter), memberType, (PsiElement)parameter, false);
            }
        }
    }
}

