/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.TypeMigrationRules;
import com.intellij.refactoring.typeMigration.usageInfo.TypeMigrationUsageInfo;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeEvaluator {
    private final HashMap<TypeMigrationUsageInfo, LinkedList<PsiType>> myTypeMap;
    private final TypeMigrationRules myRules;
    private final TypeMigrationLabeler myLabeler;
    private final SearchScope myScope;

    public TypeEvaluator(@Nullable LinkedList<Pair<TypeMigrationUsageInfo, PsiType>> types, @Nullable TypeMigrationLabeler labeler, @NotNull Project project) {
        if (project == null) {
            TypeEvaluator.$$$reportNull$$$0(0);
        }
        this.myLabeler = labeler;
        this.myRules = labeler == null ? new TypeMigrationRules(project) : labeler.getRules();
        this.myTypeMap = new HashMap();
        if (types != null) {
            for (Pair pair : types) {
                if (((TypeMigrationUsageInfo)((Object)pair.getFirst())).getElement() instanceof PsiExpression) continue;
                LinkedList<PsiType> e = new LinkedList<PsiType>();
                e.addFirst((PsiType)pair.getSecond());
                this.myTypeMap.put((TypeMigrationUsageInfo)((Object)pair.getFirst()), e);
            }
        }
        this.myScope = this.myRules == null ? GlobalSearchScope.projectScope((Project)project) : this.myRules.getSearchScope();
    }

    public boolean setType(TypeMigrationUsageInfo usageInfo, @NotNull PsiType type) {
        if (type == null) {
            TypeEvaluator.$$$reportNull$$$0(1);
        }
        LinkedList<PsiType> t = this.myTypeMap.get((Object)usageInfo);
        PsiElement element = usageInfo.getElement();
        if (!(!(type instanceof PsiEllipsisType) || element instanceof PsiParameter && ((PsiParameter)element).getDeclarationScope() instanceof PsiMethod)) {
            type = ((PsiEllipsisType)type).toArrayType();
        }
        if (t != null) {
            if (!t.getFirst().equals(type)) {
                if (element instanceof PsiVariable || element instanceof PsiMethod) {
                    return false;
                }
                t.addFirst(type);
                return true;
            }
        } else {
            LinkedList<PsiType> e = new LinkedList<PsiType>();
            e.addFirst(type);
            usageInfo.setOwnerRoot(this.myLabeler.getCurrentRoot());
            this.myTypeMap.put(usageInfo, e);
            return true;
        }
        return false;
    }

    @Nullable
    public PsiType getType(PsiElement element) {
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return null;
        }
        VirtualFile file = psiFile.getVirtualFile();
        if (file == null || !this.myScope.contains(file)) {
            return TypeMigrationLabeler.getElementType(element);
        }
        for (Map.Entry<TypeMigrationUsageInfo, LinkedList<PsiType>> entry : this.myTypeMap.entrySet()) {
            if (!Comparing.equal((Object)element, (Object)entry.getKey().getElement())) continue;
            return entry.getValue().getFirst();
        }
        if (element.getTextRange() == null) {
            return null;
        }
        return this.getType(new TypeMigrationUsageInfo(element));
    }

    @Nullable
    public PsiType getType(TypeMigrationUsageInfo usageInfo) {
        LinkedList<PsiType> e = this.myTypeMap.get((Object)usageInfo);
        if (e != null) {
            return e.getFirst();
        }
        return TypeMigrationLabeler.getElementType(usageInfo.getElement());
    }

    @Nullable
    public PsiType evaluateType(PsiExpression expr) {
        if (expr == null) {
            return null;
        }
        LinkedList<PsiType> e = this.myTypeMap.get((Object)new TypeMigrationUsageInfo((PsiElement)expr));
        if (e != null) {
            return e.getFirst();
        }
        if (expr instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression arrayAccess = (PsiArrayAccessExpression)expr;
            PsiType psiType = this.evaluateType(arrayAccess.getArrayExpression());
            if (psiType instanceof PsiArrayType) {
                PsiArrayType arrayType = (PsiArrayType)psiType;
                return arrayType.getComponentType();
            }
        } else {
            if (expr instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression assignment = (PsiAssignmentExpression)expr;
                return this.evaluateType(assignment.getLExpression());
            }
            if (expr instanceof PsiMethodCallExpression) {
                PsiMethodCallExpression call = (PsiMethodCallExpression)expr;
                JavaResolveResult resolveResult = call.resolveMethodGenerics();
                PsiMethod method = (PsiMethod)resolveResult.getElement();
                if (method != null) {
                    PsiParameter[] parameters = method.getParameterList().getParameters();
                    PsiExpression[] actualParms = call.getArgumentList().getExpressions();
                    return PsiUtil.captureToplevelWildcards((PsiType)this.createMethodSubstitution(parameters, actualParms, method, (PsiExpression)call, resolveResult.getSubstitutor(), false).substitute(this.evaluateType((PsiExpression)call.getMethodExpression())), (PsiElement)expr);
                }
            } else {
                PsiClass superClass;
                PsiClass psiClass;
                if (expr instanceof PsiPolyadicExpression) {
                    PsiPolyadicExpression polyadic = (PsiPolyadicExpression)expr;
                    PsiExpression[] operands = polyadic.getOperands();
                    IElementType sign = polyadic.getOperationTokenType();
                    PsiType lType = operands.length > 0 ? this.evaluateType(operands[0]) : null;
                    for (int i = 1; i < operands.length; ++i) {
                        lType = TypeConversionUtil.calcTypeForBinaryExpression((PsiType)lType, (PsiType)this.evaluateType(operands[i]), (IElementType)sign, (boolean)true);
                    }
                    return lType;
                }
                if (expr instanceof PsiUnaryExpression) {
                    PsiUnaryExpression unary = (PsiUnaryExpression)expr;
                    return this.evaluateType(unary.getOperand());
                }
                if (expr instanceof PsiParenthesizedExpression) {
                    PsiParenthesizedExpression paren = (PsiParenthesizedExpression)expr;
                    return this.evaluateType(paren.getExpression());
                }
                if (expr instanceof PsiConditionalExpression) {
                    PsiConditionalExpression conditional = (PsiConditionalExpression)expr;
                    PsiExpression thenExpression = conditional.getThenExpression();
                    PsiExpression elseExpression = conditional.getElseExpression();
                    PsiType thenType = this.evaluateType(thenExpression);
                    PsiType elseType = this.evaluateType(elseExpression);
                    return switch ((thenType == null ? 0 : 1) + (elseType == null ? 0 : 2)) {
                        case 0 -> expr.getType();
                        case 1 -> thenType;
                        case 2 -> elseType;
                        case 3 -> {
                            if (TypeConversionUtil.areTypesConvertible((PsiType)thenType, (PsiType)elseType)) {
                                yield thenType;
                            }
                            if (TypeConversionUtil.areTypesConvertible((PsiType)elseType, (PsiType)thenType)) {
                                yield elseType;
                            }
                            switch ((thenType.equals(thenExpression.getType()) ? 0 : 1) + (elseType.equals(elseExpression.getType()) ? 0 : 2)) {
                                case 0: 
                                case 3: {
                                    yield expr.getType();
                                }
                                case 1: {
                                    yield thenType;
                                }
                                case 2: {
                                    yield elseType;
                                }
                            }
                            throw new AssertionError();
                        }
                        default -> throw new AssertionError();
                    };
                }
                if (expr instanceof PsiNewExpression) {
                    PsiClassType.ClassResolveResult qualifierResult;
                    PsiNewExpression newExpression = (PsiNewExpression)expr;
                    PsiExpression qualifier = newExpression.getQualifier();
                    if (qualifier != null && (qualifierResult = TypeEvaluator.resolveType(this.evaluateType(qualifier))).getElement() != null) {
                        PsiSubstitutor qualifierSubs = qualifierResult.getSubstitutor();
                        PsiClassType.ClassResolveResult result = TypeEvaluator.resolveType(expr.getType());
                        if (result.getElement() != null) {
                            PsiClass aClass = result.getElement();
                            return JavaPsiFacade.getElementFactory((Project)aClass.getProject()).createType(aClass, result.getSubstitutor().putAll(qualifierSubs));
                        }
                    }
                } else if (expr instanceof PsiFunctionalExpression) {
                    PsiFunctionalExpression functionalExpression = (PsiFunctionalExpression)expr;
                    PsiType functionalInterfaceType = functionalExpression.getFunctionalInterfaceType();
                    if (functionalInterfaceType != null) {
                        return functionalInterfaceType;
                    }
                } else if (expr instanceof PsiReferenceExpression) {
                    PsiType type = this.evaluateReferenceExpressionType(expr);
                    if (type != null) {
                        return PsiImplUtil.normalizeWildcardTypeByPosition((PsiType)type, (PsiExpression)expr);
                    }
                } else if (expr instanceof PsiSuperExpression && (psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)expr, PsiClass.class)) != null && (superClass = psiClass.getSuperClass()) != null) {
                    return this.getType(new TypeMigrationUsageInfo((PsiElement)superClass));
                }
            }
        }
        return this.getType((PsiElement)expr);
    }

    @Nullable
    private PsiType evaluateReferenceExpressionType(PsiExpression expr) {
        PsiReferenceExpression ref = (PsiReferenceExpression)expr;
        PsiExpression qualifier = ref.getQualifierExpression();
        if (qualifier == null) {
            PsiElement resolvee = ref.resolve();
            if (resolvee == null) {
                return null;
            }
            return resolvee instanceof PsiClass ? JavaPsiFacade.getElementFactory((Project)resolvee.getProject()).createType((PsiClass)resolvee, PsiSubstitutor.EMPTY) : this.getType(resolvee);
        }
        PsiType qualifierType = this.evaluateType(qualifier);
        if (!(qualifierType instanceof PsiArrayType)) {
            PsiElement element = ref.resolve();
            PsiClassType.ClassResolveResult result = TypeEvaluator.resolveType(qualifierType);
            PsiClass aClass = result.getElement();
            if (aClass != null) {
                PsiSubstitutor aSubst = result.getSubstitutor();
                if (element instanceof PsiField) {
                    PsiField field = (PsiField)element;
                    PsiType aType = field.getType();
                    PsiClass superClass = field.getContainingClass();
                    if (InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)superClass, (boolean)true)) {
                        aType = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY).substitute(aType);
                    }
                    return aSubst.substitute(aType);
                }
                if (element instanceof PsiMethod) {
                    PsiMethod[] methods;
                    PsiMethod method = (PsiMethod)element;
                    PsiType aType = method.getReturnType();
                    PsiClass superClass = method.getContainingClass();
                    if (InheritanceUtil.isInheritorOrSelf((PsiClass)aClass, (PsiClass)superClass, (boolean)true)) {
                        aType = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)superClass, (PsiClass)aClass, (PsiSubstitutor)PsiSubstitutor.EMPTY).substitute(aType);
                    } else if (InheritanceUtil.isInheritorOrSelf((PsiClass)superClass, (PsiClass)aClass, (boolean)true) && (methods = method.findSuperMethods(aClass)).length > 0) {
                        aType = methods[0].getReturnType();
                    }
                    return aSubst.substitute(aType);
                }
            }
        }
        return null;
    }

    public static PsiClassType.ClassResolveResult resolveType(PsiType type) {
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)type);
        PsiClass aClass = resolveResult.getElement();
        if (aClass instanceof PsiAnonymousClass) {
            PsiClassType baseClassType = ((PsiAnonymousClass)aClass).getBaseClassType();
            return TypeEvaluator.resolveType(resolveResult.getSubstitutor().substitute((PsiType)baseClassType));
        }
        return resolveResult;
    }

    public PsiSubstitutor createMethodSubstitution(PsiParameter[] parameters, PsiExpression[] actualParms, PsiMethod method, PsiExpression call) {
        return this.createMethodSubstitution(parameters, actualParms, method, call, PsiSubstitutor.EMPTY, false);
    }

    public PsiSubstitutor createMethodSubstitution(PsiParameter[] parameters, PsiExpression[] actualParms, PsiMethod method, PsiExpression call, PsiSubstitutor subst, boolean preferSubst) {
        SubstitutorBuilder substitutorBuilder = new SubstitutorBuilder(method, call, subst);
        for (int i = 0; i < Math.min(parameters.length, actualParms.length); ++i) {
            substitutorBuilder.bindTypeParameters(this.getType((PsiElement)parameters[i]), this.evaluateType(actualParms[i]));
        }
        return substitutorBuilder.createSubstitutor(preferSubst);
    }

    public String getReport() {
        Object[] t = new String[this.myTypeMap.size()];
        int k = 0;
        for (TypeMigrationUsageInfo info : this.myTypeMap.keySet()) {
            LinkedList<PsiType> types = this.myTypeMap.get((Object)info);
            StringBuilder b = new StringBuilder();
            if (types != null) {
                b.append(info.getElement()).append(" : ");
                b.append(StringUtil.join(types, psiType -> psiType.getCanonicalText(), (String)" "));
                b.append("\n");
            }
            t[k++] = b.toString();
        }
        Arrays.sort(t);
        StringBuilder buffer = new StringBuilder();
        for (Object aT : t) {
            buffer.append((String)aT);
        }
        return buffer.toString();
    }

    public LinkedList<Pair<TypeMigrationUsageInfo, PsiType>> getMigratedDeclarations() {
        LinkedList<Pair<TypeMigrationUsageInfo, PsiType>> list = new LinkedList<Pair<TypeMigrationUsageInfo, PsiType>>();
        for (TypeMigrationUsageInfo usageInfo : this.myTypeMap.keySet()) {
            LinkedList<PsiType> types = this.myTypeMap.get((Object)usageInfo);
            PsiElement element = usageInfo.getElement();
            if (!(element instanceof PsiVariable) && !(element instanceof PsiMethod)) continue;
            list.addLast((Pair<TypeMigrationUsageInfo, PsiType>)Pair.create((Object)((Object)usageInfo), (Object)types.getFirst()));
        }
        return list;
    }

    @Nullable
    static PsiType substituteType(PsiClassType migrationType, PsiClassType originalType, boolean captureWildcard, PsiClass originalClass, PsiType rawTypeToReplace) {
        PsiTypeParameter[] parameters;
        if (originalClass == null) {
            return null;
        }
        if (!originalType.hasParameters() || !migrationType.hasParameters()) {
            return originalType;
        }
        PsiResolveHelper psiResolveHelper = JavaPsiFacade.getInstance((Project)originalClass.getProject()).getResolveHelper();
        PsiClassType rawOriginalType = JavaPsiFacade.getElementFactory((Project)originalClass.getProject()).createType(originalClass, PsiSubstitutor.EMPTY);
        PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
        PsiClass migrationClass = migrationType.resolve();
        if (migrationClass == null) {
            return originalType;
        }
        for (PsiTypeParameter parameter : parameters = originalClass.getTypeParameters()) {
            PsiType psiType;
            PsiType type = psiResolveHelper.getSubstitutionForTypeParameter(parameter, (PsiType)rawOriginalType, (PsiType)migrationType, false, PsiUtil.getLanguageLevel((PsiElement)originalClass));
            if (type != null) {
                if (captureWildcard && type instanceof PsiWildcardType) {
                    PsiWildcardType wildcardType = (PsiWildcardType)type;
                    psiType = wildcardType.getExtendsBound();
                } else {
                    psiType = type;
                }
            } else {
                return null;
            }
            substitutor = substitutor.put(parameter, psiType);
        }
        return substitutor.substitute(rawTypeToReplace);
    }

    public static PsiType substituteType(PsiType migrationType, PsiType originalType, boolean isContraVariantPosition) {
        if (originalType instanceof PsiClassType) {
            PsiClassType originalClassType = (PsiClassType)originalType;
            if (migrationType instanceof PsiClassType) {
                PsiClassType migrationClassType = (PsiClassType)migrationType;
                PsiClass originalClass = originalClassType.resolve();
                if (originalClass != null) {
                    PsiType psiType;
                    if (isContraVariantPosition && TypeConversionUtil.erasure((PsiType)originalType).isAssignableFrom(TypeConversionUtil.erasure((PsiType)migrationType))) {
                        PsiType psiType2;
                        PsiSubstitutor substitutor;
                        PsiClassType.ClassResolveResult resolveResult = migrationClassType.resolveGenerics();
                        PsiClass psiClass = resolveResult.getElement();
                        PsiSubstitutor psiSubstitutor = substitutor = psiClass != null ? TypeConversionUtil.getClassSubstitutor((PsiClass)originalClass, (PsiClass)psiClass, (PsiSubstitutor)resolveResult.getSubstitutor()) : null;
                        if (substitutor != null && (psiType2 = TypeEvaluator.substituteType(migrationClassType, originalClassType, false, psiClass, (PsiType)JavaPsiFacade.getElementFactory((Project)psiClass.getProject()).createType(originalClass, substitutor))) != null) {
                            return psiType2;
                        }
                    } else if (!isContraVariantPosition && TypeConversionUtil.erasure((PsiType)migrationType).isAssignableFrom(TypeConversionUtil.erasure((PsiType)originalType)) && (psiType = TypeEvaluator.substituteType(migrationClassType, originalClassType, false, originalClass, (PsiType)JavaPsiFacade.getElementFactory((Project)originalClass.getProject()).createType(originalClass, PsiSubstitutor.EMPTY))) != null) {
                        return psiType;
                    }
                }
            }
        }
        return migrationType;
    }

    @Nullable
    public <T> T getSettings(Class<T> aClass) {
        return this.myRules.getConversionSettings(aClass);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/typeMigration/TypeEvaluator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "setType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class SubstitutorBuilder {
        private final Map<PsiTypeParameter, PsiType> myMapping;
        private final PsiMethod myMethod;
        private final PsiExpression myCall;
        private final PsiSubstitutor mySubst;

        SubstitutorBuilder(PsiMethod method, PsiExpression call, PsiSubstitutor subst) {
            this.mySubst = subst;
            this.myMapping = new HashMap<PsiTypeParameter, PsiType>();
            this.myMethod = method;
            this.myCall = call;
        }

        private void update(PsiTypeParameter p, PsiType t) {
            PsiType binding;
            if (t instanceof PsiPrimitiveType) {
                t = ((PsiPrimitiveType)t).getBoxedType((PsiElement)this.myMethod);
            }
            if ((binding = this.myMapping.get(p)) == null) {
                this.myMapping.put(p, t);
            } else if (t != null) {
                this.myMapping.put(p, PsiIntersectionType.createIntersection((PsiType[])new PsiType[]{binding, t}));
            }
        }

        void bindTypeParameters(PsiType formal, PsiType actual) {
            if (formal instanceof PsiWildcardType) {
                if (actual instanceof PsiCapturedWildcardType && ((PsiWildcardType)formal).isExtends() == ((PsiCapturedWildcardType)actual).getWildcard().isExtends()) {
                    this.bindTypeParameters(((PsiWildcardType)formal).getBound(), ((PsiCapturedWildcardType)actual).getWildcard().getBound());
                    return;
                }
                formal = ((PsiWildcardType)formal).getBound();
            }
            if (formal instanceof PsiArrayType && actual instanceof PsiArrayType) {
                this.bindTypeParameters(((PsiArrayType)formal).getComponentType(), ((PsiArrayType)actual).getComponentType());
                return;
            }
            Pair<PsiType, PsiType> typePair = TypeEvaluator.this.myRules.bindTypeParameters(formal, actual, this.myMethod, this.myCall, TypeEvaluator.this.myLabeler);
            if (typePair != null) {
                this.bindTypeParameters((PsiType)typePair.getFirst(), (PsiType)typePair.getSecond());
                return;
            }
            PsiClassType.ClassResolveResult resultF = TypeEvaluator.resolveType(formal);
            PsiClass classF = resultF.getElement();
            if (classF != null) {
                PsiSubstitutor superClassSubstitutor;
                if (classF instanceof PsiTypeParameter) {
                    this.update((PsiTypeParameter)classF, actual);
                    return;
                }
                PsiClassType.ClassResolveResult resultA = TypeEvaluator.resolveType(actual);
                PsiClass classA = resultA.getElement();
                if (classA == null) {
                    return;
                }
                if (!classA.equals((Object)classF) && (superClassSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)classF, (PsiClass)classA, (PsiSubstitutor)resultA.getSubstitutor())) != null) {
                    PsiClassType aligned = JavaPsiFacade.getElementFactory((Project)classF.getProject()).createType(classF, superClassSubstitutor);
                    this.bindTypeParameters(formal, (PsiType)aligned);
                }
                PsiTypeParameter[] typeParms = classA.getTypeParameters();
                PsiSubstitutor substA = resultA.getSubstitutor();
                PsiSubstitutor substF = resultF.getSubstitutor();
                for (PsiTypeParameter typeParm : typeParms) {
                    this.bindTypeParameters(substF.substitute(typeParm), substA.substitute(typeParm));
                }
            }
        }

        public PsiSubstitutor createSubstitutor(boolean preferSubst) {
            PsiSubstitutor theSubst = this.mySubst;
            if (preferSubst) {
                this.myMapping.keySet().removeAll(this.mySubst.getSubstitutionMap().keySet());
            }
            for (PsiTypeParameter parm : this.myMapping.keySet()) {
                theSubst = theSubst.put(parm, this.myMapping.get(parm));
            }
            return theSubst;
        }
    }
}

