/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration;

import com.intellij.codeInsight.generation.GetterSetterPrototypeProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.controlFlow.DefUseUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.Util;
import com.intellij.refactoring.typeMigration.usageInfo.TypeMigrationUsageInfo;
import com.intellij.util.CommonProcessors;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Processor;
import com.siyeh.ig.psiutils.ExpressionUtils;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

class TypeMigrationStatementProcessor
extends JavaRecursiveElementVisitor {
    private final PsiElement myStatement;
    private final TypeMigrationLabeler myLabeler;
    private static final Logger LOG = Logger.getInstance(TypeMigrationStatementProcessor.class);
    private final TypeEvaluator myTypeEvaluator;

    TypeMigrationStatementProcessor(PsiElement expression, TypeMigrationLabeler labeler) {
        this.myStatement = expression;
        this.myLabeler = labeler;
        this.myTypeEvaluator = this.myLabeler.getTypeEvaluator();
    }

    public void visitAssignmentExpression(@NotNull PsiAssignmentExpression expression) {
        if (expression == null) {
            TypeMigrationStatementProcessor.$$$reportNull$$$0(0);
        }
        super.visitAssignmentExpression(expression);
        PsiExpression lExpression = expression.getLExpression();
        TypeView left = new TypeView(this, lExpression);
        PsiExpression rExpression = expression.getRExpression();
        if (rExpression == null) {
            return;
        }
        TypeView right = new TypeView(this, rExpression);
        IElementType sign = expression.getOperationTokenType();
        PsiType ltype = left.getType();
        PsiType rtype = right.getType();
        if (ltype == null || rtype == null) {
            return;
        }
        if (sign != JavaTokenType.EQ) {
            IElementType binaryOperator = TypeConversionUtil.convertEQtoOperation((IElementType)sign);
            if (!TypeConversionUtil.isBinaryOperatorApplicable((IElementType)binaryOperator, (PsiType)ltype, (PsiType)rtype, (boolean)false)) {
                if (left.isChanged()) {
                    this.findConversionOrFail((PsiExpression)expression, lExpression, left.getTypePair());
                }
                if (right.isChanged()) {
                    this.findConversionOrFail((PsiExpression)expression, rExpression, right.getTypePair());
                }
                return;
            }
            if (binaryOperator == JavaTokenType.PLUS && !left.isChanged() && right.isChanged() && ltype.equalsToText("java.lang.String")) {
                return;
            }
        }
        switch (TypeInfection.getInfection(left, right).ordinal()) {
            case 0: {
                break;
            }
            case 1: {
                this.myLabeler.migrateExpressionType(rExpression, ltype, this.myStatement, TypeConversionUtil.isAssignable((PsiType)ltype, (PsiType)rtype) && !TypeMigrationStatementProcessor.isSetter(expression), true);
                break;
            }
            case 2: {
                if (lExpression instanceof PsiReferenceExpression && ((PsiReferenceExpression)lExpression).resolve() instanceof PsiLocalVariable && !TypeMigrationStatementProcessor.canBeVariableType(rtype)) {
                    this.tryToRemoveLocalVariableAssignment((PsiLocalVariable)Objects.requireNonNull(((PsiReferenceExpression)lExpression).resolve()), rExpression, rtype);
                    break;
                }
                this.myLabeler.migrateExpressionType(lExpression, rtype, this.myStatement, TypeConversionUtil.isAssignable((PsiType)ltype, (PsiType)rtype), false);
                break;
            }
            case 3: {
                this.addTypeUsage((PsiElement)lExpression);
                this.addTypeUsage((PsiElement)rExpression);
            }
        }
    }

    public void visitArrayAccessExpression(@NotNull PsiArrayAccessExpression expression) {
        TypeView typeView;
        if (expression == null) {
            TypeMigrationStatementProcessor.$$$reportNull$$$0(1);
        }
        super.visitArrayAccessExpression(expression);
        PsiExpression indexExpression = expression.getIndexExpression();
        if (indexExpression != null) {
            this.checkIndexExpression(indexExpression);
        }
        if ((typeView = new TypeView(this, expression.getArrayExpression())).isChanged() && typeView.getType() instanceof PsiClassType) {
            TypeConversionDescriptorBase conversion = this.myLabeler.getRules().findConversion((PsiType)typeView.getTypePair().first, typeView.getType(), null, (PsiExpression)expression, false, this.myLabeler);
            if (conversion == null) {
                this.myLabeler.markFailedConversion(typeView.getType(), (PsiElement)expression);
            } else {
                this.myLabeler.setConversionMapping((PsiExpression)expression, conversion);
                PsiType type = this.myTypeEvaluator.evaluateType((PsiExpression)expression);
                if (type != null) {
                    this.myTypeEvaluator.setType(new TypeMigrationUsageInfo((PsiElement)expression), type);
                }
            }
        }
    }

    public void visitSwitchLabelStatement(@NotNull PsiSwitchLabelStatement statement) {
        PsiExpression expression;
        PsiSwitchStatement switchStatement;
        TypeView typeView;
        if (statement == null) {
            TypeMigrationStatementProcessor.$$$reportNull$$$0(2);
        }
        super.visitSwitchLabelStatement(statement);
        PsiExpression caseValue = statement.getCaseValue();
        if (caseValue != null && (typeView = new TypeView(this, caseValue)).isChanged() && (switchStatement = statement.getEnclosingSwitchStatement()) != null && (expression = switchStatement.getExpression()) != null) {
            this.myLabeler.migrateExpressionType(expression, typeView.getType(), this.myStatement, false, false);
        }
    }

    public void visitInstanceOfExpression(@NotNull PsiInstanceOfExpression expression) {
        if (expression == null) {
            TypeMigrationStatementProcessor.$$$reportNull$$$0(3);
        }
        super.visitInstanceOfExpression(expression);
        PsiTypeElement typeElement = expression.getCheckType();
        if (typeElement != null) {
            PsiExpression consideredExpression = expression.getOperand();
            PsiType migrationType = this.myTypeEvaluator.evaluateType(consideredExpression);
            PsiType fixedType = typeElement.getType();
            if (migrationType != null && !TypeConversionUtil.isAssignable((PsiType)migrationType, (PsiType)fixedType)) {
                this.myLabeler.markFailedConversion(migrationType, (PsiElement)consideredExpression);
            }
        }
    }

    public void visitTypeCastExpression(@NotNull PsiTypeCastExpression expression) {
        if (expression == null) {
            TypeMigrationStatementProcessor.$$$reportNull$$$0(4);
        }
        super.visitTypeCastExpression(expression);
        PsiTypeElement typeElement = expression.getCastType();
        if (typeElement != null) {
            PsiType fixedType = typeElement.getType();
            PsiType migrationType = this.myTypeEvaluator.evaluateType(expression.getOperand());
            if (migrationType != null && !TypeConversionUtil.areTypesConvertible((PsiType)migrationType, (PsiType)fixedType)) {
                this.myLabeler.markFailedConversion(migrationType, (PsiElement)expression);
            }
        }
    }

    public void visitVariable(@NotNull PsiVariable variable) {
        if (variable == null) {
            TypeMigrationStatementProcessor.$$$reportNull$$$0(5);
        }
        super.visitVariable(variable);
        PsiExpression initializer = variable.getInitializer();
        if (initializer != null && initializer.getType() != null) {
            this.processVariable(variable, initializer, null, null, null, false);
        }
    }

    public void visitReturnStatement(@NotNull PsiReturnStatement statement) {
        if (statement == null) {
            TypeMigrationStatementProcessor.$$$reportNull$$$0(6);
        }
        super.visitReturnStatement(statement);
        PsiElement method = PsiTreeUtil.getParentOfType((PsiElement)statement, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
        PsiExpression value = statement.getReturnValue();
        if (method != null && value != null) {
            if (method instanceof PsiLambdaExpression) {
                return;
            }
            PsiType returnType = ((PsiMethod)method).getReturnType();
            PsiType valueType = this.myTypeEvaluator.evaluateType(value);
            if (returnType != null && valueType != null && (TypeMigrationStatementProcessor.isGetter(value, method) || !TypeConversionUtil.isAssignable((PsiType)returnType, (PsiType)valueType)) && returnType.equals(this.myTypeEvaluator.getType(method)) && !this.myLabeler.addMigrationRoot(method, valueType, this.myStatement, false, true)) {
                this.myLabeler.convertExpression(value, valueType, returnType, false);
            }
        }
    }

    public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
        TypeView view;
        PsiExpression qualifierExpression;
        if (expression == null) {
            TypeMigrationStatementProcessor.$$$reportNull$$$0(7);
        }
        if ((qualifierExpression = expression.getQualifierExpression()) != null && qualifierExpression.isPhysical()) {
            qualifierExpression.accept((PsiElementVisitor)this);
            TypeView qualifierView = new TypeView(this, qualifierExpression);
            if (qualifierView.isChanged()) {
                PsiMember member = (PsiMember)expression.advancedResolve(false).getElement();
                if (member == null) {
                    return;
                }
                Pair<PsiType, PsiType> typePair = qualifierView.getTypePair();
                TypeConversionDescriptorBase conversion = this.myLabeler.getRules().findConversion((PsiType)typePair.getFirst(), (PsiType)typePair.getSecond(), member, (PsiExpression)expression, false, this.myLabeler);
                if (conversion == null) {
                    this.myLabeler.markFailedConversion((PsiType)typePair.getSecond(), (PsiElement)qualifierExpression);
                } else {
                    PsiElement parent = Util.getEssentialParent((PsiElement)expression);
                    PsiType type = conversion.conversionType();
                    if (parent instanceof PsiMethodCallExpression) {
                        PsiType targetType;
                        this.myLabeler.setConversionMapping((PsiExpression)((PsiMethodCallExpression)parent), conversion);
                        PsiType psiType = targetType = type != null ? type : this.myTypeEvaluator.evaluateType((PsiExpression)parent);
                        if (targetType != null) {
                            this.myTypeEvaluator.setType(new TypeMigrationUsageInfo(parent), targetType);
                        }
                    } else {
                        PsiType targetType;
                        this.myLabeler.setConversionMapping((PsiExpression)expression, conversion);
                        PsiType psiType = targetType = type != null ? type : this.myTypeEvaluator.evaluateType((PsiExpression)expression);
                        if (targetType != null) {
                            this.myTypeEvaluator.setType(new TypeMigrationUsageInfo((PsiElement)expression), targetType);
                        }
                    }
                }
            }
        } else if (PsiUtil.isCondition((PsiElement)expression, (PsiElement)expression.getParent()) && (view = new TypeView(this, (PsiExpression)expression)).isChanged()) {
            this.findConversionOrFail((PsiExpression)expression, (PsiExpression)expression, view.getTypePair());
        }
    }

    public void visitIfStatement(@NotNull PsiIfStatement statement) {
        TypeView view;
        if (statement == null) {
            TypeMigrationStatementProcessor.$$$reportNull$$$0(8);
        }
        super.visitIfStatement(statement);
        PsiExpression condition = statement.getCondition();
        if (condition != null && (view = new TypeView(this, condition)).isChanged()) {
            this.findConversionOrFail(condition, condition, view.getTypePair());
        }
    }

    public void visitForeachStatement(@NotNull PsiForeachStatement statement) {
        if (statement == null) {
            TypeMigrationStatementProcessor.$$$reportNull$$$0(9);
        }
        super.visitForeachStatement(statement);
        PsiExpression value = statement.getIteratedValue();
        PsiParameter psiParameter = statement.getIterationParameter();
        if (value != null) {
            TypeView typeView = new TypeView(this, value);
            PsiType psiType = typeView.getType();
            if (psiType instanceof PsiArrayType) {
                psiType = ((PsiArrayType)psiType).getComponentType();
            } else if (psiType instanceof PsiClassType) {
                PsiClassType.ClassResolveResult resolveResult = ((PsiClassType)psiType).resolveGenerics();
                PsiClass psiClass = resolveResult.getElement();
                if (psiClass == null) {
                    return;
                }
                PsiType targetTypeParameter = this.getTargetTypeParameter(psiClass, value, typeView);
                if (targetTypeParameter == null) {
                    return;
                }
                psiType = resolveResult.getSubstitutor().substitute(targetTypeParameter);
                if (psiType instanceof PsiWildcardType) {
                    psiType = ((PsiWildcardType)psiType).getExtendsBound();
                }
            } else {
                this.myLabeler.markFailedConversion(typeView.getType(), (PsiElement)value);
                return;
            }
            TypeView left = new TypeView(this, (PsiVariable)psiParameter, null, null);
            if (TypeInfection.getInfection(left, typeView) == TypeInfection.LEFT_INFECTED) {
                PsiArrayType iterableType;
                PsiType typeViewType = typeView.getType();
                if (typeViewType instanceof PsiArrayType) {
                    iterableType = left.getType().createArrayType();
                } else {
                    PsiClass iterableClass = PsiUtil.resolveClassInType((PsiType)typeViewType);
                    LOG.assertTrue(iterableClass != null);
                    PsiType targetType = this.getTargetTypeParameter(iterableClass, value, typeView);
                    PsiClass typeParam = PsiUtil.resolveClassInClassTypeOnly((PsiType)targetType);
                    if (!(typeParam instanceof PsiTypeParameter)) {
                        return;
                    }
                    Map<PsiTypeParameter, PsiType> substMap = Collections.singletonMap((PsiTypeParameter)typeParam, left.getType());
                    PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)iterableClass.getProject());
                    iterableType = factory.createType(iterableClass, factory.createSubstitutor(substMap));
                }
                this.myLabeler.migrateExpressionType(value, (PsiType)iterableType, this.myStatement, TypeConversionUtil.isAssignable((PsiType)iterableType, (PsiType)typeViewType), true);
            } else {
                this.processVariable((PsiVariable)psiParameter, value, psiType, null, null, false);
            }
        }
    }

    private PsiType getTargetTypeParameter(PsiClass iterableClass, PsiExpression value, TypeView typeView) {
        Project project = iterableClass.getProject();
        PsiClass itClass = JavaPsiFacade.getInstance((Project)project).findClass("java.lang.Iterable", GlobalSearchScope.allScope((Project)project));
        if (itClass == null) {
            return null;
        }
        if (!InheritanceUtil.isInheritorOrSelf((PsiClass)iterableClass, (PsiClass)itClass, (boolean)true)) {
            this.findConversionOrFail(value, value, typeView.getTypePair());
            return null;
        }
        PsiSubstitutor aSubstitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)itClass, (PsiClass)iterableClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
        return aSubstitutor.substitute(itClass.getTypeParameters()[0]);
    }

    public void visitNewExpression(@NotNull PsiNewExpression expression) {
        PsiExpression[] dimensions;
        if (expression == null) {
            TypeMigrationStatementProcessor.$$$reportNull$$$0(10);
        }
        super.visitNewExpression(expression);
        for (PsiExpression dimension : dimensions = expression.getArrayDimensions()) {
            this.checkIndexExpression(dimension);
        }
        PsiArrayInitializerExpression arrayInitializer = expression.getArrayInitializer();
        if (arrayInitializer != null) {
            this.processArrayInitializer(arrayInitializer, (PsiExpression)expression);
        }
    }

    public void visitArrayInitializerExpression(@NotNull PsiArrayInitializerExpression expression) {
        if (expression == null) {
            TypeMigrationStatementProcessor.$$$reportNull$$$0(11);
        }
        super.visitArrayInitializerExpression(expression);
        this.processArrayInitializer(expression, (PsiExpression)expression);
    }

    public void visitUnaryExpression(@NotNull PsiUnaryExpression expression) {
        if (expression == null) {
            TypeMigrationStatementProcessor.$$$reportNull$$$0(12);
        }
        super.visitUnaryExpression(expression);
        TypeView typeView = new TypeView(this, (PsiExpression)expression);
        if (typeView.isChanged() && !TypeConversionUtil.isUnaryOperatorApplicable((PsiJavaToken)expression.getOperationSign(), (PsiType)typeView.getType())) {
            this.findConversionOrFail((PsiExpression)expression, (PsiExpression)expression, typeView.getTypePair());
        }
    }

    private void findConversionOrFail(PsiExpression expression, PsiExpression toFail, Pair<PsiType, PsiType> typePair) {
        TypeConversionDescriptorBase conversion = this.myLabeler.getRules().findConversion((PsiType)typePair.getFirst(), (PsiType)typePair.getSecond(), null, expression, this.myLabeler);
        if (conversion == null) {
            this.myLabeler.markFailedConversion((PsiType)typePair.getSecond(), (PsiElement)toFail);
        } else {
            this.myLabeler.setConversionMapping(expression, conversion);
            PsiType psiType = this.myTypeEvaluator.evaluateType(expression);
            LOG.assertTrue(psiType != null, (Object)expression);
            this.myTypeEvaluator.setType(new TypeMigrationUsageInfo((PsiElement)expression), psiType);
        }
    }

    public void visitPolyadicExpression(@NotNull PsiPolyadicExpression expression) {
        if (expression == null) {
            TypeMigrationStatementProcessor.$$$reportNull$$$0(13);
        }
        super.visitPolyadicExpression(expression);
        PsiExpression[] operands = expression.getOperands();
        if (operands.length == 0) {
            return;
        }
        IElementType operationTokenType = expression.getOperationTokenType();
        PsiExpression lOperand = operands[0];
        TypeView left = new TypeView(this, lOperand);
        for (int i = 1; i < operands.length; ++i) {
            PsiExpression rOperand = operands[i];
            if (rOperand == null) {
                return;
            }
            TypeView right = new TypeView(this, rOperand);
            if (this.tryFindConversionIfOperandIsNull(left, right, rOperand) || this.tryFindConversionIfOperandIsNull(right, left, lOperand)) continue;
            if (!TypeConversionUtil.isBinaryOperatorApplicable((IElementType)operationTokenType, (PsiType)left.getType(), (PsiType)right.getType(), (boolean)false)) {
                if (left.isChanged()) {
                    this.findConversionOrFail(lOperand, lOperand, left.getTypePair());
                }
                if (right.isChanged()) {
                    this.findConversionOrFail(rOperand, rOperand, right.getTypePair());
                }
            }
            lOperand = rOperand;
            left = right;
        }
    }

    protected boolean tryFindConversionIfOperandIsNull(TypeView nullCandidate, TypeView comparingType, PsiExpression comparingExpr) {
        if (nullCandidate.getType() == PsiTypes.nullType() && comparingType.isChanged()) {
            Pair<PsiType, PsiType> typePair = comparingType.getTypePair();
            TypeConversionDescriptorBase conversion = this.myLabeler.getRules().findConversion((PsiType)typePair.getFirst(), (PsiType)typePair.getSecond(), null, comparingExpr, false, this.myLabeler);
            if (conversion != null) {
                this.myLabeler.setConversionMapping(comparingExpr, conversion);
            }
            return true;
        }
        return false;
    }

    private void processArrayInitializer(PsiArrayInitializerExpression expression, PsiExpression parentExpression) {
        PsiExpression[] initializers = expression.getInitializers();
        PsiType migrationType = null;
        for (PsiExpression initializer : initializers) {
            TypeView typeView = new TypeView(this, initializer);
            if (!typeView.isChanged()) continue;
            PsiType type = typeView.getType();
            if (migrationType != null && TypeConversionUtil.isAssignable(migrationType, (PsiType)type)) continue;
            if (migrationType != null && !TypeConversionUtil.isAssignable((PsiType)type, (PsiType)migrationType)) {
                this.myLabeler.markFailedConversion(type, (PsiElement)parentExpression);
                return;
            }
            migrationType = type;
        }
        PsiType exprType = expression.getType();
        if (migrationType != null && exprType instanceof PsiArrayType) {
            boolean alreadyProcessed = TypeConversionUtil.isAssignable((PsiType)((PsiArrayType)exprType).getComponentType(), migrationType);
            this.myLabeler.migrateExpressionType(parentExpression, (PsiType)(alreadyProcessed ? exprType : migrationType.createArrayType()), (PsiElement)expression, alreadyProcessed, true);
        }
    }

    private void checkIndexExpression(PsiExpression indexExpression) {
        PsiType indexType = this.myTypeEvaluator.evaluateType(indexExpression);
        if (indexType != null && !TypeConversionUtil.isAssignable((PsiType)PsiTypes.intType(), (PsiType)indexType)) {
            this.myLabeler.markFailedConversion(indexType, (PsiElement)indexExpression);
        }
    }

    public void visitCallExpression(@NotNull PsiCallExpression callExpression) {
        if (callExpression == null) {
            TypeMigrationStatementProcessor.$$$reportNull$$$0(14);
        }
        super.visitCallExpression(callExpression);
        JavaResolveResult resolveResult = callExpression.resolveMethodGenerics();
        PsiElement method = resolveResult.getElement();
        if (method instanceof PsiMethod) {
            PsiType qualifierType;
            PsiExpression qualifier;
            if (callExpression instanceof PsiMethodCallExpression && this.migrateEqualsMethod((PsiMethodCallExpression)callExpression, (PsiMethod)method)) {
                return;
            }
            PsiExpressionList argumentList = callExpression.getArgumentList();
            if (argumentList == null) {
                return;
            }
            PsiExpression[] psiExpressions = argumentList.getExpressions();
            PsiParameter[] originalParams = ((PsiMethod)method).getParameterList().getParameters();
            PsiSubstitutor evalSubstitutor = this.myTypeEvaluator.createMethodSubstitution(originalParams, psiExpressions, (PsiMethod)method, (PsiExpression)callExpression);
            for (int i = 0; i < psiExpressions.length; ++i) {
                PsiParameter originalParameter;
                if (originalParams.length <= i) {
                    if (originalParams.length <= 0 || !originalParams[originalParams.length - 1].isVarArgs()) continue;
                    originalParameter = originalParams[originalParams.length - 1];
                } else {
                    originalParameter = originalParams[i];
                }
                this.processVariable((PsiVariable)originalParameter, psiExpressions[i], null, resolveResult.getSubstitutor(), evalSubstitutor, true);
            }
            PsiExpression psiExpression = qualifier = callExpression instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)callExpression).getMethodExpression().getQualifierExpression() : null;
            if (qualifier != null && qualifier.isPhysical() && !new TypeView(this, qualifier).isChanged() && (qualifierType = qualifier.getType()) instanceof PsiClassType) {
                PsiClassType.ClassResolveResult classResolveResult = ((PsiClassType)qualifierType).resolveGenerics();
                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)this.myStatement.getProject());
                PsiClass psiClass = classResolveResult.getElement();
                if (psiClass == null) {
                    return;
                }
                PsiClassType migrationType = elementFactory.createType(psiClass, TypeMigrationStatementProcessor.composeIfNotAssignable(classResolveResult.getSubstitutor(), evalSubstitutor));
                this.myLabeler.migrateExpressionType(qualifier, (PsiType)migrationType, this.myStatement, migrationType.equals(qualifierType), true);
            }
        }
    }

    private boolean migrateEqualsMethod(PsiMethodCallExpression methodCallExpression, PsiMethod method) {
        PsiParameter parameter;
        PsiExpression qualifier = methodCallExpression.getMethodExpression().getQualifierExpression();
        if (qualifier == null) {
            return false;
        }
        TypeView qualifierTypeView = new TypeView(this, qualifier);
        if (!qualifierTypeView.isChanged()) {
            return false;
        }
        if (method.getName().equals("equals") && method.getParameterList().getParametersCount() == 1 && (parameter = method.getParameterList().getParameters()[0]).getType().equals(PsiType.getJavaLangObject((PsiManager)methodCallExpression.getManager(), (GlobalSearchScope)methodCallExpression.getResolveScope()))) {
            PsiExpression[] expressions = methodCallExpression.getArgumentList().getExpressions();
            if (expressions.length != 1) {
                return false;
            }
            TypeView argumentTypeView = new TypeView(this, expressions[0]);
            PsiType argumentType = argumentTypeView.getType();
            if (!argumentTypeView.isChanged() && ((PsiType)qualifierTypeView.getTypePair().getFirst()).equals(argumentType)) {
                PsiType migrationType = qualifierTypeView.getType();
                this.myLabeler.migrateExpressionType(expressions[0], migrationType, (PsiElement)methodCallExpression, TypeConversionUtil.isAssignable((PsiType)migrationType, (PsiType)argumentType), true);
                return true;
            }
        }
        return false;
    }

    private void processVariable(PsiVariable variable, PsiExpression value, PsiType migrationType, PsiSubstitutor varSubstitutor, PsiSubstitutor evalSubstitutor, boolean isCovariantPosition) {
        TypeView right = new TypeView(this, value);
        TypeView left = new TypeView(this, variable, varSubstitutor, evalSubstitutor);
        PsiType declarationType = left.getType();
        switch (TypeInfection.getInfection(left, right).ordinal()) {
            case 0: {
                break;
            }
            case 1: {
                PsiType valueType = right.getType();
                if (valueType == null || declarationType == null) break;
                this.myLabeler.migrateExpressionType(value, TypeMigrationStatementProcessor.adjustMigrationTypeIfGenericArrayCreation(declarationType, value), this.myStatement, left.isVarArgs() ? TypeMigrationStatementProcessor.isVarargAssignable(left, right) : TypeConversionUtil.isAssignable((PsiType)declarationType, (PsiType)valueType), true);
                break;
            }
            case 2: {
                PsiDeclarationStatement decl;
                PsiType psiType;
                PsiType psiType2 = psiType = migrationType != null ? migrationType : right.getType();
                if (psiType == null) break;
                if (TypeMigrationStatementProcessor.canBeVariableType(psiType)) {
                    PsiType newType;
                    if (declarationType == null) break;
                    boolean assignable = left.isVarArgs() ? TypeMigrationStatementProcessor.isVarargAssignable(left, right) : TypeConversionUtil.isAssignable((PsiType)declarationType, (PsiType)psiType);
                    Object object = newType = left.isVarArgs() && !right.isVarArgs() ? new PsiEllipsisType(psiType) : psiType;
                    if (this.myLabeler.addMigrationRoot((PsiElement)variable, newType, this.myStatement, assignable, true) || assignable) break;
                    if (declarationType instanceof PsiEllipsisType) {
                        declarationType = ((PsiEllipsisType)declarationType).getComponentType();
                    }
                    this.myLabeler.convertExpression(value, psiType, declarationType, isCovariantPosition);
                    break;
                }
                if (!(variable instanceof PsiLocalVariable) || (decl = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiDeclarationStatement.class)) == null || decl.getDeclaredElements().length != 1) break;
                this.tryToRemoveLocalVariableAssignment((PsiLocalVariable)variable, value, psiType);
                break;
            }
            case 3: {
                this.addTypeUsage((PsiElement)variable);
            }
        }
    }

    private void tryToRemoveLocalVariableAssignment(@NotNull PsiLocalVariable variable, @NotNull PsiExpression valueExpression, @NotNull PsiType migrationType) {
        PsiCodeBlock codeBlock;
        PsiElement[] refs;
        if (variable == null) {
            TypeMigrationStatementProcessor.$$$reportNull$$$0(15);
        }
        if (valueExpression == null) {
            TypeMigrationStatementProcessor.$$$reportNull$$$0(16);
        }
        if (migrationType == null) {
            TypeMigrationStatementProcessor.$$$reportNull$$$0(17);
        }
        if ((refs = DefUseUtil.getRefs((PsiCodeBlock)Objects.requireNonNull(codeBlock = (PsiCodeBlock)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiCodeBlock.class)), (PsiVariable)variable, (PsiElement)valueExpression)).length == 0) {
            this.myLabeler.setConversionMapping(valueExpression, new TypeConversionDescriptorBase(this){

                @Override
                public PsiExpression replace(PsiExpression expression, @NotNull TypeEvaluator evaluator) throws IncorrectOperationException {
                    PsiElement parent;
                    if (evaluator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((parent = expression.getParent()) instanceof PsiLocalVariable) {
                        PsiLocalVariable var = (PsiLocalVariable)parent;
                        PsiDeclarationStatement decl = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)var, PsiDeclarationStatement.class);
                        if (decl == null) {
                            return null;
                        }
                        Project project = var.getProject();
                        PsiAssignmentExpression assignment = ExpressionUtils.splitDeclaration((PsiDeclarationStatement)decl, (Project)project);
                        if (assignment == null) {
                            return null;
                        }
                        PsiExpression rExpression = assignment.getRExpression();
                        if (rExpression == null) {
                            return null;
                        }
                        assignment.replace((PsiElement)rExpression);
                        if (ReferencesSearch.search((PsiElement)var).forEach((Processor)new CommonProcessors.FindFirstProcessor())) {
                            var.delete();
                        }
                    } else if (parent instanceof PsiAssignmentExpression) {
                        PsiAssignmentExpression assignment = (PsiAssignmentExpression)parent;
                        PsiExpression rExpression = assignment.getRExpression();
                        return rExpression == null ? null : (PsiExpression)parent.replace((PsiElement)rExpression);
                    }
                    return null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "com/intellij/refactoring/typeMigration/TypeMigrationStatementProcessor$1", "replace"));
                }
            });
        } else {
            this.myLabeler.markFailedConversion(migrationType, (PsiElement)valueExpression);
        }
    }

    private static boolean canBeVariableType(@NotNull PsiType type) {
        if (type == null) {
            TypeMigrationStatementProcessor.$$$reportNull$$$0(18);
        }
        return !type.getDeepComponentType().equals(PsiTypes.voidType());
    }

    private static PsiType adjustMigrationTypeIfGenericArrayCreation(PsiType migrationType, PsiExpression expression) {
        PsiClassType rawType;
        PsiType componentType;
        if (expression instanceof PsiNewExpression && migrationType instanceof PsiArrayType && (componentType = migrationType.getDeepComponentType()) instanceof PsiClassType && !(rawType = ((PsiClassType)componentType).rawType()).equals((Object)componentType)) {
            return PsiTypesUtil.createArrayType((PsiType)rawType, (int)migrationType.getArrayDimensions());
        }
        return migrationType;
    }

    private void addTypeUsage(PsiElement typedElement) {
        if (typedElement instanceof PsiReferenceExpression) {
            this.myLabeler.setTypeUsage(((PsiReferenceExpression)typedElement).resolve(), this.myStatement);
        } else if (typedElement instanceof PsiMethodCallExpression) {
            this.myLabeler.setTypeUsage((PsiElement)((PsiMethodCallExpression)typedElement).resolveMethod(), this.myStatement);
        } else {
            this.myLabeler.setTypeUsage(typedElement, this.myStatement);
        }
    }

    private static boolean isSetter(PsiAssignmentExpression expression) {
        PsiElement resolved;
        PsiExpression lExpression = expression.getLExpression();
        if (lExpression instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)lExpression).resolve()) instanceof PsiField) {
            PsiMethod setter;
            PsiField field = (PsiField)resolved;
            NavigatablePsiElement containingMethod = (NavigatablePsiElement)PsiTreeUtil.getParentOfType((PsiElement)expression, (Class[])new Class[]{PsiMethod.class, PsiLambdaExpression.class});
            if (containingMethod instanceof PsiMethod && containingMethod.isEquivalentTo((PsiElement)(setter = PropertyUtilBase.findPropertySetter((PsiClass)field.getContainingClass(), (String)field.getName(), (boolean)field.hasModifierProperty("static"), (boolean)false)))) {
                return true;
            }
        }
        return false;
    }

    private static boolean isGetter(PsiExpression returnValue, PsiElement containingMethod) {
        PsiElement resolved;
        if (returnValue instanceof PsiReferenceExpression && (resolved = ((PsiReferenceExpression)returnValue).resolve()) instanceof PsiField) {
            PsiField field = (PsiField)resolved;
            boolean isStatic = field.hasModifierProperty("static");
            PsiMethod[] getters = GetterSetterPrototypeProvider.findGetters((PsiClass)field.getContainingClass(), (String)field.getName(), (boolean)isStatic);
            if (getters != null) {
                for (PsiMethod getter : getters) {
                    if (!containingMethod.isEquivalentTo((PsiElement)getter)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static PsiSubstitutor composeIfNotAssignable(PsiSubstitutor actual, PsiSubstitutor required) {
        if (actual == PsiSubstitutor.EMPTY) {
            return required;
        }
        if (required == PsiSubstitutor.EMPTY) {
            return actual;
        }
        PsiSubstitutor result = PsiSubstitutor.createSubstitutor((Map)actual.getSubstitutionMap());
        for (Map.Entry e : required.getSubstitutionMap().entrySet()) {
            PsiTypeParameter typeParameter = (PsiTypeParameter)e.getKey();
            PsiType requiredType = (PsiType)e.getValue();
            PsiType actualType = (PsiType)result.getSubstitutionMap().get(typeParameter);
            if (requiredType == null || actualType != null && TypeConversionUtil.isAssignable((PsiType)actualType, (PsiType)requiredType)) continue;
            result = result.put(typeParameter, requiredType);
        }
        return result;
    }

    private static boolean isVarargAssignable(TypeView left, TypeView right) {
        PsiType rightOrigin;
        Pair<PsiType, PsiType> leftPair = left.getTypePair();
        Pair<PsiType, PsiType> rightPair = right.getTypePair();
        PsiType leftOrigin = (PsiType)leftPair.getFirst();
        boolean isDirectlyAssignable = TypeConversionUtil.isAssignable((PsiType)leftOrigin, (PsiType)(rightOrigin = (PsiType)rightPair.getFirst()));
        return TypeConversionUtil.isAssignable((PsiType)(isDirectlyAssignable ? (PsiType)leftPair.getSecond() : ((PsiEllipsisType)leftPair.getSecond()).getComponentType()), (PsiType)((PsiType)rightPair.getSecond()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 5: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueExpression";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "migrationType";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/typeMigration/TypeMigrationStatementProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "visitAssignmentExpression";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "visitArrayAccessExpression";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "visitSwitchLabelStatement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "visitInstanceOfExpression";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visitTypeCastExpression";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "visitVariable";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "visitReturnStatement";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "visitReferenceExpression";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "visitIfStatement";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "visitForeachStatement";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "visitNewExpression";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "visitArrayInitializerExpression";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "visitUnaryExpression";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "visitPolyadicExpression";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "visitCallExpression";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "tryToRemoveLocalVariableAssignment";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[2] = "canBeVariableType";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class TypeView {
        final PsiType myOriginType;
        final PsiType myType;
        final boolean myChanged;

        TypeView(@NotNull TypeMigrationStatementProcessor typeMigrationStatementProcessor, PsiExpression expr) {
            if (expr == null) {
                TypeView.$$$reportNull$$$0(0);
            }
            PsiType exprType = expr.getType();
            this.myOriginType = GenericsUtil.getVariableTypeByExpressionType((PsiType)exprType);
            PsiType type = typeMigrationStatementProcessor.myTypeEvaluator.evaluateType(expr);
            this.myType = GenericsUtil.getVariableTypeByExpressionType((PsiType)type);
            this.myChanged = this.myOriginType != null && this.myType != null && !this.myType.equals(this.myOriginType);
        }

        TypeView(TypeMigrationStatementProcessor typeMigrationStatementProcessor, PsiVariable var, PsiSubstitutor varSubstitutor, PsiSubstitutor evalSubstitutor) {
            this.myOriginType = varSubstitutor != null ? varSubstitutor.substitute(var.getType()) : var.getType();
            PsiSubstitutor substitutor = PsiSubstitutor.EMPTY;
            if (varSubstitutor != null) {
                substitutor = substitutor.putAll(varSubstitutor);
            }
            if (evalSubstitutor != null) {
                substitutor = substitutor.putAll(evalSubstitutor);
            }
            this.myType = substitutor.substitute(typeMigrationStatementProcessor.myTypeEvaluator.getType((PsiElement)var));
            this.myChanged = this.myOriginType != null && this.myType != null && !this.myType.equals(this.myOriginType);
        }

        public PsiType getType() {
            return this.myType;
        }

        public boolean isChanged() {
            return this.myChanged;
        }

        public Pair<PsiType, PsiType> getTypePair() {
            return Pair.create((Object)this.myOriginType, (Object)this.myType);
        }

        public boolean isVarArgs() {
            return this.myType instanceof PsiEllipsisType && this.myOriginType instanceof PsiEllipsisType;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expr", "com/intellij/refactoring/typeMigration/TypeMigrationStatementProcessor$TypeView", "<init>"));
        }
    }

    private static enum TypeInfection {
        NONE_INFECTED,
        LEFT_INFECTED,
        RIGHT_INFECTED,
        BOTH_INFECTED;


        static TypeInfection getInfection(TypeView left, TypeView right) {
            if (left.isChanged()) {
                return right.isChanged() ? BOTH_INFECTED : LEFT_INFECTED;
            }
            return right.isChanged() ? RIGHT_INFECTED : NONE_INFECTED;
        }
    }
}

