/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.ui;

import com.intellij.CommonBundle;
import com.intellij.core.JavaPsiBundle;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.AlphaComparator;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.TypeMigrationProcessor;
import com.intellij.refactoring.typeMigration.ui.MigrationConflictsPanel;
import com.intellij.refactoring.typeMigration.ui.MigrationNode;
import com.intellij.refactoring.typeMigration.ui.MigrationRootNode;
import com.intellij.refactoring.typeMigration.ui.MigrationUsagesPanel;
import com.intellij.refactoring.typeMigration.ui.TypeMigrationDialog;
import com.intellij.refactoring.typeMigration.ui.TypeMigrationTreeStructure;
import com.intellij.refactoring.typeMigration.usageInfo.TypeMigrationUsageInfo;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.DuplicateNodeRenderer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SmartExpander;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.content.Content;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewContentManager;
import com.intellij.usages.TextChunk;
import com.intellij.usages.UsageInfoToUsageConverter;
import com.intellij.usages.UsagePresentation;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MigrationPanel
extends JPanel
implements Disposable {
    private static final DataKey<TypeMigrationUsageInfo[]> MIGRATION_USAGES_KEY = DataKey.create((String)"migration.usages");
    private final PsiElement[] myInitialRoots;
    private final TypeMigrationLabeler myLabeler;
    private final MyTree myRootsTree;
    private final Project myProject;
    private Content myContent;
    private final MigrationUsagesPanel myUsagesPanel;
    private final MigrationConflictsPanel myConflictsPanel;

    public MigrationPanel(PsiElement[] roots, @NotNull TypeMigrationLabeler labeler, Project project, boolean previewUsages) {
        if (labeler == null) {
            MigrationPanel.$$$reportNull$$$0(0);
        }
        super(new BorderLayout());
        this.myInitialRoots = roots;
        this.myLabeler = labeler;
        this.myProject = project;
        MigrationRootNode currentRoot = new MigrationRootNode(project, this.myLabeler, roots, previewUsages);
        this.myRootsTree = new MyTree();
        TypeMigrationTreeStructure structure = new TypeMigrationTreeStructure(project);
        structure.setRoots(currentRoot);
        StructureTreeModel model = new StructureTreeModel((AbstractTreeStructure)structure, (Comparator)AlphaComparator.getInstance(), (Disposable)this);
        this.myRootsTree.setModel((TreeModel)new AsyncTreeModel((TreeModel)model, (Disposable)this));
        this.initTree(this.myRootsTree);
        this.myRootsTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                MigrationPanel.this.selectionChanged();
            }
        });
        final Splitter treeSplitter = new Splitter();
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                treeSplitter.dispose();
            }
        });
        treeSplitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)((Object)this.myRootsTree)));
        this.myUsagesPanel = new MigrationUsagesPanel(this.myProject);
        treeSplitter.setSecondComponent((JComponent)((Object)this.myUsagesPanel));
        Disposer.register((Disposable)this, (Disposable)this.myUsagesPanel);
        this.add((Component)this.createToolbar(), "South");
        final Splitter conflictsSplitter = new Splitter(true, 0.8f);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                conflictsSplitter.dispose();
            }
        });
        conflictsSplitter.setFirstComponent((JComponent)treeSplitter);
        this.myConflictsPanel = new MigrationConflictsPanel(this.myProject);
        conflictsSplitter.setSecondComponent((JComponent)((Object)this.myConflictsPanel));
        this.add((Component)conflictsSplitter, "Center");
        Disposer.register((Disposable)this, (Disposable)this.myConflictsPanel);
        model.invalidateAsync();
    }

    private void selectionChanged() {
        this.myConflictsPanel.setToInitialPosition();
        this.myUsagesPanel.setToInitialPosition();
        DefaultMutableTreeNode[] migrationNodes = (DefaultMutableTreeNode[])this.myRootsTree.getSelectedNodes(DefaultMutableTreeNode.class, null);
        if (migrationNodes.length == 0) {
            return;
        }
        Object userObject = migrationNodes[0].getUserObject();
        if (userObject instanceof MigrationNode) {
            AbstractTreeNode rootNode;
            MigrationNode migrationNode = (MigrationNode)((Object)userObject);
            UsageInfo[] failedUsages = this.myLabeler.getFailedUsages(migrationNode.getInfo());
            if (failedUsages.length > 0) {
                this.myConflictsPanel.showUsages(PsiElement.EMPTY_ARRAY, failedUsages);
            }
            if ((rootNode = migrationNode.getParent()) instanceof MigrationNode) {
                this.myUsagesPanel.showRootUsages(((MigrationNode)rootNode).getInfo(), migrationNode.getInfo(), this.myLabeler);
            }
        }
    }

    private JComponent createToolbar() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints(-1, 0, 1, 1, 0.0, 1.0, 18, 0, (Insets)JBUI.insets((int)5, (int)10, (int)5, (int)0), 0, 0);
        JButton performButton = new JButton(JavaRefactoringBundle.message((String)"type.migration.migrate.button.text", (Object[])new Object[0]));
        performButton.addActionListener(new ActionListener(){

            private static void expandTree(MigrationNode migrationNode) {
                if (!migrationNode.getInfo().isExcluded() || migrationNode.areChildrenInitialized()) {
                    Collection<AbstractTreeNode<?>> nodes = migrationNode.getChildren();
                    for (AbstractTreeNode<?> node : nodes) {
                        ApplicationManager.getApplication().runReadAction(() -> 4.expandTree((MigrationNode)node));
                    }
                }
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Object userObject;
                Object root = MigrationPanel.this.myRootsTree.getModel().getRoot();
                if (root instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)root).getUserObject()) instanceof MigrationRootNode) {
                    ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
                        HashSet files = new HashSet();
                        TypeMigrationUsageInfo[] usages = (TypeMigrationUsageInfo[])ReadAction.compute(() -> {
                            TypeMigrationUsageInfo[] usages1;
                            Collection<AbstractTreeNode<?>> children = ((MigrationRootNode)((Object)((Object)((Object)userObject)))).getChildren();
                            for (AbstractTreeNode<?> child : children) {
                                4.expandTree((MigrationNode)child);
                            }
                            for (TypeMigrationUsageInfo usage : usages1 = MigrationPanel.this.myLabeler.getMigratedUsages()) {
                                PsiElement element;
                                if (usage.isExcluded() || (element = usage.getElement()) == null) continue;
                                files.add(element.getContainingFile().getVirtualFile());
                            }
                            return usages1;
                        });
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (ReadonlyStatusHandler.getInstance((Project)MigrationPanel.this.myProject).ensureFilesWritable((Collection)files).hasReadonlyFiles()) {
                                return;
                            }
                            WriteCommandAction.writeCommandAction((Project)MigrationPanel.this.myProject).run(() -> TypeMigrationProcessor.change(usages, MigrationPanel.this.myLabeler, MigrationPanel.this.myProject));
                        }, MigrationPanel.this.myProject.getDisposed());
                    }, JavaRefactoringBundle.message((String)"type.migration.action.name", (Object[])new Object[0]), false, MigrationPanel.this.myProject);
                }
                UsageViewContentManager.getInstance((Project)MigrationPanel.this.myProject).closeContent(MigrationPanel.this.myContent);
            }
        });
        panel.add((Component)performButton, gc);
        JButton closeButton = new JButton(CommonBundle.getCancelButtonText());
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UsageViewContentManager.getInstance((Project)MigrationPanel.this.myProject).closeContent(MigrationPanel.this.myContent);
            }
        });
        panel.add((Component)closeButton, gc);
        JButton rerunButton = new JButton(JavaRefactoringBundle.message((String)"type.migration.rerun.button.text", (Object[])new Object[0]));
        rerunButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                UsageViewContentManager.getInstance((Project)MigrationPanel.this.myProject).closeContent(MigrationPanel.this.myContent);
                TypeMigrationDialog.MultipleElements dialog = new TypeMigrationDialog.MultipleElements(MigrationPanel.this.myProject, MigrationPanel.this.myInitialRoots, MigrationPanel.this.myLabeler.getMigrationRootTypeFunction(), MigrationPanel.this.myLabeler.getRules());
                dialog.show();
            }
        });
        panel.add((Component)rerunButton, gc);
        JButton helpButton = new JButton(CommonBundle.getHelpButtonText());
        helpButton.addActionListener(new ActionListener(this){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpManager.getInstance().invokeHelp("reference.typeMigrationPreview");
            }
        });
        gc.weightx = 1.0;
        panel.add((Component)helpButton, gc);
        return panel;
    }

    private void initTree(Tree tree) {
        MigrationRootsTreeCellRenderer rootsTreeCellRenderer = new MigrationRootsTreeCellRenderer();
        tree.setCellRenderer((TreeCellRenderer)((Object)rootsTreeCellRenderer));
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        TreeUtil.installActions((JTree)tree);
        TreeUtil.expandAll((JTree)tree);
        SmartExpander.installOn((JTree)tree);
        EditSourceOnDoubleClickHandler.install((JTree)tree);
        TreeUIHelper.getInstance().installTreeSpeedSearch((JTree)tree);
        PopupHandler.installPopupMenu((JComponent)tree, (ActionGroup)this.createTreePopupActions(), (String)"MigrationPanelPopup");
    }

    private ActionGroup createTreePopupActions() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new ExcludeAction(this));
        group.add((AnAction)new IncludeAction());
        group.addSeparator();
        ActionManager actionManager = ActionManager.getInstance();
        group.add(actionManager.getAction("EditSource"));
        group.add(actionManager.getAction("VersionControlsGroup"));
        return group;
    }

    public void dispose() {
    }

    public void setContent(Content content) {
        this.myContent = content;
        Disposer.register((Disposable)content, (Disposable)this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labeler", "com/intellij/refactoring/typeMigration/ui/MigrationPanel", "<init>"));
    }

    private static final class MyTree
    extends Tree
    implements UiDataProvider {
        private MyTree() {
        }

        protected void paintComponent(Graphics g) {
            DuplicateNodeRenderer.paintDuplicateNodesBackground((Graphics)g, (JTree)((Object)this));
            super.paintComponent(g);
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            DefaultMutableTreeNode[] defaultMutableTreeNodeArray;
            DefaultMutableTreeNode[] selectedNodes;
            if (sink == null) {
                MyTree.$$$reportNull$$$0(0);
            }
            if ((selectedNodes = (DefaultMutableTreeNode[])this.getSelectedNodes(DefaultMutableTreeNode.class, null)).length == 1 && (defaultMutableTreeNodeArray = selectedNodes[0].getUserObject()) instanceof MigrationNode) {
                MigrationNode node = (MigrationNode)defaultMutableTreeNodeArray;
                sink.lazy(CommonDataKeys.PSI_ELEMENT, () -> node.getInfo().getElement());
            }
            HashSet usageInfos = new HashSet();
            for (DefaultMutableTreeNode selectedNode : selectedNodes) {
                Object object = selectedNode.getUserObject();
                if (!(object instanceof MigrationNode)) continue;
                MigrationNode node = (MigrationNode)((Object)object);
                MyTree.collectInfos(usageInfos, node);
            }
            sink.set(MIGRATION_USAGES_KEY, (Object)usageInfos.toArray(new TypeMigrationUsageInfo[0]));
        }

        private static void collectInfos(Set<? super TypeMigrationUsageInfo> usageInfos, MigrationNode currentNode) {
            usageInfos.add(currentNode.getInfo());
            if (!currentNode.areChildrenInitialized()) {
                return;
            }
            Collection<AbstractTreeNode<?>> nodes = currentNode.getChildren();
            for (AbstractTreeNode<?> node : nodes) {
                MyTree.collectInfos(usageInfos, (MigrationNode)node);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/refactoring/typeMigration/ui/MigrationPanel$MyTree", "uiDataSnapshot"));
        }
    }

    private static class MigrationRootsTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private MigrationRootsTreeCellRenderer() {
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                MigrationRootsTreeCellRenderer.$$$reportNull$$$0(0);
            }
            ReadAction.run(() -> this.doCustomize((DefaultMutableTreeNode)value));
        }

        private void doCustomize(DefaultMutableTreeNode value) {
            Object userObject = value.getUserObject();
            if (!(userObject instanceof MigrationNode)) {
                return;
            }
            MigrationNode migrationNode = (MigrationNode)((Object)userObject);
            TypeMigrationUsageInfo usageInfo = migrationNode.getInfo();
            if (usageInfo != null) {
                PsiElement element = usageInfo.getElement();
                if (element != null) {
                    String location;
                    PsiTypeElement typeElement = null;
                    if (element instanceof PsiVariable) {
                        PsiVariable var = (PsiVariable)element;
                        typeElement = var.getTypeElement();
                    } else if (element instanceof PsiMethod) {
                        PsiMethod method = (PsiMethod)element;
                        typeElement = method.getReturnTypeElement();
                    }
                    if (typeElement == null) {
                        typeElement = element;
                    }
                    UsagePresentation presentation = UsageInfoToUsageConverter.convert((PsiElement[])new PsiElement[]{typeElement}, (UsageInfo)new UsageInfo((PsiElement)typeElement)).getPresentation();
                    boolean isPrefix = true;
                    for (TextChunk chunk : presentation.getText()) {
                        if (!isPrefix) {
                            this.append(chunk.getText(), MigrationRootsTreeCellRenderer.patchAttrs(usageInfo, chunk.getSimpleAttributesIgnoreBackground()));
                        }
                        isPrefix = false;
                    }
                    this.setIcon(presentation.getIcon());
                    if (element instanceof PsiMember) {
                        location = SymbolPresentationUtil.getSymbolContainerText((PsiElement)element);
                    } else {
                        PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMember.class);
                        if (member instanceof PsiField) {
                            PsiField field = (PsiField)member;
                            location = PsiFormatUtil.formatVariable((PsiVariable)field, (int)6145, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                        } else if (member instanceof PsiMethod) {
                            PsiMethod method = (PsiMethod)member;
                            location = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)6145, (int)2);
                        } else if (member instanceof PsiClass) {
                            PsiClass psiClass = (PsiClass)member;
                            location = PsiFormatUtil.formatClass((PsiClass)psiClass, (int)2049);
                        } else {
                            location = null;
                        }
                        if (location != null) {
                            location = JavaPsiBundle.message((String)"aux.context.display", (Object[])new Object[]{location});
                        }
                    }
                    if (location != null) {
                        this.append(location, SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    }
                } else {
                    this.append(UsageViewBundle.message((String)"node.invalid", (Object[])new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
                }
            }
        }

        private static SimpleTextAttributes patchAttrs(TypeMigrationUsageInfo usageInfo, SimpleTextAttributes original) {
            if (usageInfo.isExcluded()) {
                original = new SimpleTextAttributes(original.getStyle() | 4, original.getFgColor(), original.getWaveColor());
            }
            return original;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/refactoring/typeMigration/ui/MigrationPanel$MigrationRootsTreeCellRenderer", "customizeCellRenderer"));
        }
    }

    private class ExcludeAction
    extends ExcludeIncludeActionBase {
        ExcludeAction(MigrationPanel migrationPanel) {
            super(JavaRefactoringBundle.message((String)"type.migration.exclude.action.text", (Object[])new Object[0]));
            this.registerCustomShortcutSet(CommonShortcuts.getDelete(), (JComponent)((Object)migrationPanel.myRootsTree));
        }

        @Override
        protected void processUsage(TypeMigrationUsageInfo usageInfo) {
            usageInfo.setExcluded(true);
        }
    }

    private class IncludeAction
    extends ExcludeIncludeActionBase {
        IncludeAction() {
            super(JavaRefactoringBundle.message((String)"type.migration.include.action.text", (Object[])new Object[0]));
            this.registerCustomShortcutSet(CommonShortcuts.getInsert(), (JComponent)((Object)MigrationPanel.this.myRootsTree));
        }

        @Override
        protected void processUsage(TypeMigrationUsageInfo usageInfo) {
            usageInfo.setExcluded(false);
        }

        @Override
        public void update(@NotNull AnActionEvent e) {
            DefaultMutableTreeNode[] selectedNodes;
            if (e == null) {
                IncludeAction.$$$reportNull$$$0(0);
            }
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(false);
            for (DefaultMutableTreeNode node : selectedNodes = (DefaultMutableTreeNode[])MigrationPanel.this.myRootsTree.getSelectedNodes(DefaultMutableTreeNode.class, null)) {
                MigrationNode parentNode;
                Object userObject = node.getUserObject();
                if (!(userObject instanceof MigrationNode)) {
                    return;
                }
                MigrationNode migrationNode = (MigrationNode)((Object)userObject);
                AbstractTreeNode abstractTreeNode = migrationNode.getParent();
                if (!(abstractTreeNode instanceof MigrationNode) || !(parentNode = (MigrationNode)abstractTreeNode).getInfo().isExcluded()) continue;
                return;
            }
            presentation.setEnabled(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/refactoring/typeMigration/ui/MigrationPanel$IncludeAction", "update"));
        }
    }

    private abstract class ExcludeIncludeActionBase
    extends AnAction {
        protected abstract void processUsage(TypeMigrationUsageInfo var1);

        ExcludeIncludeActionBase(String text) {
            super(text);
        }

        private static TypeMigrationUsageInfo @Nullable [] getUsages(AnActionEvent context) {
            return (TypeMigrationUsageInfo[])context.getData(MIGRATION_USAGES_KEY);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ExcludeIncludeActionBase.$$$reportNull$$$0(0);
            }
            TreePath[] selectionPaths = MigrationPanel.this.myRootsTree.getSelectionPaths();
            e.getPresentation().setEnabled(selectionPaths != null && selectionPaths.length > 0);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ExcludeIncludeActionBase.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ExcludeIncludeActionBase.$$$reportNull$$$0(2);
            }
            TypeMigrationUsageInfo[] usages = ExcludeIncludeActionBase.getUsages(e);
            assert (usages != null);
            for (TypeMigrationUsageInfo usageInfo : usages) {
                this.processUsage(usageInfo);
            }
            MigrationPanel.this.myRootsTree.repaint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/refactoring/typeMigration/ui/MigrationPanel$ExcludeIncludeActionBase";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/refactoring/typeMigration/ui/MigrationPanel$ExcludeIncludeActionBase";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

