/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.java.JavaBundle;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.light.LightRecordCanonicalConstructor;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.util.RefactoringUIUtil;
import com.intellij.util.containers.MultiMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConflictsUtil {
    private ConflictsUtil() {
    }

    @NotNull
    public static PsiElement getContainer(PsiElement place) {
        PsiElement parent = place;
        while (true) {
            if (parent instanceof PsiMember && !(parent instanceof PsiTypeParameter)) {
                PsiElement psiElement = parent;
                if (psiElement == null) {
                    ConflictsUtil.$$$reportNull$$$0(0);
                }
                return psiElement;
            }
            if (parent instanceof PsiFile) {
                PsiFile file = (PsiFile)parent;
                PsiElement host = FileContextUtil.getFileContext((PsiFile)file);
                if (host == null) {
                    PsiElement psiElement = parent;
                    if (psiElement == null) {
                        ConflictsUtil.$$$reportNull$$$0(1);
                    }
                    return psiElement;
                }
                parent = host;
            }
            parent = parent.getParent();
        }
    }

    public static void checkMethodConflicts(@Nullable PsiClass aClass, @Nullable PsiMethod refactoredMethod, PsiMethod prototype, MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflicts) {
        PsiMethod method;
        if (prototype == null) {
            return;
        }
        String protoMethodInfo = RefactoringUIUtil.getDescription((PsiElement)prototype, (boolean)false);
        PsiMethod psiMethod = method = aClass != null ? aClass.findMethodBySignature(prototype, true) : null;
        if (method == null && aClass != null) {
            MethodSignature signature = prototype.getSignature(PsiSubstitutor.EMPTY);
            for (PsiMethod classMethod : aClass.getMethods()) {
                if (!MethodSignatureUtil.areSignaturesErasureEqual((MethodSignature)signature, (MethodSignature)classMethod.getSignature(PsiSubstitutor.EMPTY))) continue;
                method = classMethod;
                protoMethodInfo = JavaRefactoringBundle.message((String)"method.with.the.same.erasure", (Object[])new Object[0]);
                break;
            }
        }
        if (!(method == null || method == refactoredMethod || ConflictsUtil.isStaticInterfaceMethods(aClass, refactoredMethod, method) || method instanceof LightRecordCanonicalConstructor && refactoredMethod instanceof LightRecordCanonicalConstructor)) {
            if (aClass.equals((Object)method.getContainingClass())) {
                conflicts.putValue((Object)method, (Object)RefactoringBundle.message((String)"0.is.already.defined.in.1", (Object[])new Object[]{StringUtil.capitalize((String)protoMethodInfo), RefactoringUIUtil.getDescription((PsiElement)aClass, (boolean)false)}));
            } else if (JavaPsiFacade.getInstance((Project)method.getProject()).getResolveHelper().isAccessible((PsiMember)method, (PsiElement)aClass, null)) {
                String classDescription = RefactoringUIUtil.getDescription((PsiElement)method.getContainingClass(), (boolean)false);
                if (method.hasModifierProperty("final")) {
                    conflicts.putValue((Object)method, (Object)JavaRefactoringBundle.message((String)"renaming.method.will.override.final.0", (Object[])new Object[]{protoMethodInfo, classDescription}));
                } else if (PsiUtil.getAccessLevel((PsiModifierList)prototype.getModifierList()) >= PsiUtil.getAccessLevel((PsiModifierList)method.getModifierList())) {
                    boolean isMethodAbstract = method.hasModifierProperty("abstract");
                    boolean isMyMethodAbstract = refactoredMethod != null && refactoredMethod.hasModifierProperty("abstract");
                    String conflict = isMethodAbstract != isMyMethodAbstract ? JavaRefactoringBundle.message((String)"method.0.will.implement.method.of.the.base.class", (Object[])new Object[]{protoMethodInfo, classDescription}) : JavaRefactoringBundle.message((String)"method.0.will.override.a.method.of.the.base.class", (Object[])new Object[]{protoMethodInfo, classDescription});
                    conflicts.putValue((Object)method, (Object)conflict);
                } else {
                    conflicts.putValue((Object)method, (Object)JavaRefactoringBundle.message((String)"method.0.will.hide.method.of.the.base.class", (Object[])new Object[]{protoMethodInfo, classDescription}));
                }
            }
        }
        if (aClass != null && prototype.hasModifierProperty("private")) {
            ClassInheritorsSearch.search((PsiClass)aClass).forEach(aClass1 -> {
                PsiMethod[] methods;
                for (PsiMethod method1 : methods = aClass1.findMethodsBySignature(prototype, false)) {
                    conflicts.putValue((Object)method1, (Object)JavaBundle.message((String)"conflict.message.method.will.override.method.base.class", (Object[])new Object[]{RefactoringUIUtil.getDescription((PsiElement)method1, (boolean)true), RefactoringUIUtil.getDescription((PsiElement)aClass, (boolean)false)}));
                }
                return true;
            });
        }
    }

    private static boolean isStaticInterfaceMethods(PsiClass aClass, PsiMethod refactoredMethod, PsiMethod method) {
        return aClass.isInterface() && method.hasModifierProperty("static") && refactoredMethod != null && refactoredMethod.hasModifierProperty("static");
    }

    public static void checkFieldConflicts(@Nullable PsiClass aClass, String newName, MultiMap<PsiElement, @NlsContexts.DialogMessage String> conflicts) {
        PsiField existingField;
        PsiField psiField = existingField = aClass != null ? aClass.findFieldByName(newName, true) : null;
        if (existingField != null) {
            if (aClass.equals((Object)existingField.getContainingClass())) {
                String className = aClass instanceof PsiAnonymousClass ? JavaRefactoringBundle.message((String)"current.class", (Object[])new Object[0]) : RefactoringUIUtil.getDescription((PsiElement)aClass, (boolean)false);
                String conflict = JavaRefactoringBundle.message((String)"field.0.is.already.defined.in.the.1", (Object[])new Object[]{existingField.getName(), className});
                conflicts.putValue((Object)existingField, (Object)conflict);
            } else if (!existingField.hasModifierProperty("private")) {
                String fieldInfo = PsiFormatUtil.formatVariable((PsiVariable)existingField, (int)7, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                String className = RefactoringUIUtil.getDescription((PsiElement)existingField.getContainingClass(), (boolean)false);
                String descr = JavaRefactoringBundle.message((String)"field.0.will.hide.field.1.of.the.base.class", (Object[])new Object[]{newName, fieldInfo, className});
                conflicts.putValue((Object)existingField, (Object)descr);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/util/ConflictsUtil", "getContainer"));
    }
}

