/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util;

import com.intellij.codeInsight.BlockUtils;
import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.codeInsight.daemon.impl.quickfix.SimplifyBooleanExpressionFix;
import com.intellij.codeInspection.dataFlow.JavaMethodContractUtil;
import com.intellij.codeInspection.redundantCast.RemoveRedundantCastUtil;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModCommand;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.GenericsUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDiamondType;
import com.intellij.psi.PsiDiamondTypeImpl;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiResourceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchExpression;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiUnaryExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiPrecedenceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.refactoring.inline.InlineLocalHandler;
import com.intellij.refactoring.inline.InlineTransformer;
import com.intellij.refactoring.util.CommonJavaInlineUtil;
import com.intellij.refactoring.util.RefactoringChangeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonJavaRefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.text.UniqueNameGenerator;
import com.siyeh.ig.psiutils.BoolUtils;
import com.siyeh.ig.psiutils.CommentTracker;
import com.siyeh.ig.psiutils.ControlFlowUtils;
import com.siyeh.ig.psiutils.ExpressionUtils;
import com.siyeh.ig.psiutils.SideEffectChecker;
import com.siyeh.ig.psiutils.StatementExtractor;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InlineUtil
implements CommonJavaInlineUtil {
    private static final Logger LOG = Logger.getInstance(InlineUtil.class);

    private InlineUtil() {
    }

    @NotNull
    public static PsiExpression inlineVariable(PsiVariable variable, PsiExpression initializer, PsiJavaCodeReferenceElement ref) {
        PsiExpression psiExpression = CommonJavaInlineUtil.getInstance().inlineVariable(variable, initializer, ref, null);
        if (psiExpression == null) {
            InlineUtil.$$$reportNull$$$0(0);
        }
        return psiExpression;
    }

    @NotNull
    public PsiExpression inlineVariable(@NotNull PsiVariable variable, @NotNull PsiExpression initializer, @NotNull PsiJavaCodeReferenceElement ref, @Nullable PsiExpression thisAccessExpr) {
        PsiType exprType;
        PsiElement parent;
        if (variable == null) {
            InlineUtil.$$$reportNull$$$0(1);
        }
        if (initializer == null) {
            InlineUtil.$$$reportNull$$$0(2);
        }
        if (ref == null) {
            InlineUtil.$$$reportNull$$$0(3);
        }
        if ((parent = ref.getParent()) instanceof PsiResourceExpression) {
            LOG.error("Unable to inline resource reference");
            PsiExpression psiExpression = (PsiExpression)ref;
            if (psiExpression == null) {
                InlineUtil.$$$reportNull$$$0(4);
            }
            return psiExpression;
        }
        PsiManager manager = initializer.getManager();
        PsiClass thisClass = RefactoringChangeUtil.getThisClass((PsiElement)initializer);
        PsiClass refParent = RefactoringChangeUtil.getThisClass((PsiElement)ref);
        PsiType varType = variable.getType();
        if ((initializer = CommonJavaRefactoringUtil.convertInitializerToNormalExpression((PsiExpression)initializer, (PsiType)varType)) instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression concatenation = (PsiPolyadicExpression)initializer;
            if (parent instanceof PsiPolyadicExpression) {
                PsiType type;
                PsiPolyadicExpression parentConcatenation = (PsiPolyadicExpression)parent;
                IElementType operationTokenType = concatenation.getOperationTokenType();
                if (!(operationTokenType != JavaTokenType.PLUS && operationTokenType != JavaTokenType.MINUS || parentConcatenation.getOperationTokenType() != JavaTokenType.PLUS || (type = parentConcatenation.getType()) == null || !type.equalsToText("java.lang.String") || varType.equalsToText("java.lang.String") && !PsiPrecedenceUtil.areStringParenthesesNeeded((PsiPolyadicExpression)concatenation, (PsiPolyadicExpression)parentConcatenation, (PsiElement)ref))) {
                    PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)initializer.getProject());
                    initializer = factory.createExpressionFromText("(" + initializer.getText() + ")", (PsiElement)initializer);
                }
            }
        }
        InlineUtil.solveLocalNameConflicts((PsiElement)initializer, (PsiElement)ref, (PsiElement)initializer);
        ChangeContextUtil.encodeContextInfo((PsiElement)initializer, (boolean)false);
        PsiExpression expr = (PsiExpression)InlineUtil.replaceDiamondWithInferredTypesIfNeeded(initializer, (PsiElement)ref);
        if (thisAccessExpr == null) {
            thisAccessExpr = InlineUtil.createThisExpression(manager, thisClass, refParent);
        }
        if ((exprType = GenericsUtil.getVariableTypeByExpressionType((PsiType)(expr = (PsiExpression)ChangeContextUtil.decodeContextInfo((PsiElement)expr, (PsiClass)thisClass, (PsiExpression)thisAccessExpr)).getType())) != null && !(exprType = PsiTypesUtil.removeExternalAnnotations((PsiType)exprType)).equals(varType)) {
            PsiEllipsisType type;
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)manager.getProject());
            PsiMethod method = InlineUtil.qualifyWithExplicitTypeArguments(initializer, expr, varType);
            if (method != null) {
                PsiMethodCallExpression call;
                PsiReferenceExpression methodExpression;
                PsiExpression qualifierExpression;
                if (expr instanceof PsiMethodCallExpression && (qualifierExpression = (methodExpression = (call = (PsiMethodCallExpression)expr).getMethodExpression()).getQualifierExpression()) == null) {
                    PsiClass containingClass = method.getContainingClass();
                    LOG.assertTrue(containingClass != null);
                    if (method.getModifierList().hasModifierProperty("static")) {
                        methodExpression.setQualifierExpression((PsiExpression)elementFactory.createReferenceExpression(containingClass));
                    } else {
                        methodExpression.setQualifierExpression((PsiExpression)InlineUtil.createThisExpression(method.getManager(), thisClass, refParent));
                    }
                }
            } else if (varType instanceof PsiEllipsisType && (type = (PsiEllipsisType)varType).getComponentType().equals(exprType)) {
                String varargsWrapper = "new " + exprType.getCanonicalText() + "[]{" + expr.getText() + "}";
                expr.replace((PsiElement)elementFactory.createExpressionFromText(varargsWrapper, (PsiElement)expr));
            } else {
                PsiClassType type2;
                boolean insertCastWhenUnchecked;
                boolean bl = insertCastWhenUnchecked = !(exprType instanceof PsiClassType && (type2 = (PsiClassType)exprType).isRaw() && parent instanceof PsiExpressionList);
                if (expr instanceof PsiFunctionalExpression || !PsiPolyExpressionUtil.isPolyExpression((PsiExpression)expr) && insertCastWhenUnchecked) {
                    expr = InlineUtil.surroundWithCast(variable, expr);
                }
            }
        }
        ChangeContextUtil.clearContextInfo((PsiElement)initializer);
        PsiExpression psiExpression = expr;
        if (psiExpression == null) {
            InlineUtil.$$$reportNull$$$0(5);
        }
        return psiExpression;
    }

    private static PsiMethod qualifyWithExplicitTypeArguments(PsiExpression initializer, PsiExpression expr, PsiType varType) {
        PsiMethod method;
        PsiTypeParameter[] typeParameters;
        JavaResolveResult resolveResult;
        PsiElement resolved;
        PsiCallExpression call;
        PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)initializer.getProject());
        if (expr instanceof PsiCallExpression && (call = (PsiCallExpression)expr).getTypeArguments().length == 0 && (resolved = (resolveResult = ((PsiCallExpression)initializer).resolveMethodGenerics()).getElement()) instanceof PsiMethod && (typeParameters = (method = (PsiMethod)resolved).getTypeParameters()).length > 0) {
            PsiCallExpression copy = (PsiCallExpression)expr.copy();
            for (PsiTypeParameter typeParameter : typeParameters) {
                PsiType substituted = resolveResult.getSubstitutor().substitute(typeParameter);
                if (substituted == null) break;
                copy.getTypeArgumentList().add((PsiElement)elementFactory.createTypeElement(substituted));
            }
            if (varType.equals(copy.getType()) && copy.resolveMethodGenerics().isValidResult()) {
                call.getTypeArgumentList().replace((PsiElement)copy.getTypeArgumentList());
                return method;
            }
        }
        return null;
    }

    private static PsiExpression surroundWithCast(PsiVariable variable, PsiExpression expr) {
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)expr.getProject());
        PsiTypeCastExpression cast = (PsiTypeCastExpression)factory.createExpressionFromText("(t)a", null);
        PsiTypeElement castTypeElement = cast.getCastType();
        assert (castTypeElement != null);
        PsiTypeElement typeElement = variable.getTypeElement();
        if (typeElement == null) {
            typeElement = factory.createTypeElement(variable.getType());
        } else if (typeElement.isInferredType()) {
            return expr;
        }
        PsiType psiType = typeElement.getType();
        if (psiType instanceof PsiEllipsisType) {
            PsiEllipsisType type = (PsiEllipsisType)psiType;
            typeElement = factory.createTypeElement(type.toArrayType());
        }
        castTypeElement.replace((PsiElement)typeElement);
        PsiExpression operand = cast.getOperand();
        assert (operand != null);
        operand.replace((PsiElement)expr);
        expr = (PsiTypeCastExpression)expr.replace((PsiElement)cast);
        if (RedundantCastUtil.isCastRedundant((PsiTypeCastExpression)((PsiTypeCastExpression)expr))) {
            return RemoveRedundantCastUtil.removeCast((PsiTypeCastExpression)((PsiTypeCastExpression)expr));
        }
        return expr;
    }

    private static PsiThisExpression createThisExpression(PsiManager manager, PsiClass thisClass, PsiClass refParent) {
        PsiThisExpression thisAccessExpr = null;
        if (Comparing.equal((Object)thisClass, (Object)refParent)) {
            thisAccessExpr = RefactoringChangeUtil.createThisExpression((PsiManager)manager, null);
        } else if (!(thisClass instanceof PsiAnonymousClass)) {
            thisAccessExpr = RefactoringChangeUtil.createThisExpression((PsiManager)manager, (PsiClass)thisClass);
        }
        return thisAccessExpr;
    }

    public static boolean allUsagesAreTailCalls(PsiMethod method) {
        List nonTailCallUsages = Collections.synchronizedList(new ArrayList());
        boolean result = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ReferencesSearch.search((PsiElement)method).forEach(psiReference -> {
            ProgressManager.checkCanceled();
            if (InlineUtil.getTailCallType(psiReference) == TailCallType.None) {
                nonTailCallUsages.add(psiReference);
                return false;
            }
            return true;
        }), JavaRefactoringBundle.message((String)"inline.method.checking.tail.calls.progress", (Object[])new Object[0]), true, method.getProject());
        return result && nonTailCallUsages.isEmpty();
    }

    public static TailCallType getTailCallType(@NotNull PsiReference psiReference) {
        PsiExpression expression;
        PsiElement element;
        if (psiReference == null) {
            InlineUtil.$$$reportNull$$$0(6);
        }
        if ((element = psiReference.getElement()) instanceof PsiMethodReferenceExpression) {
            return TailCallType.Return;
        }
        PsiExpression methodCall = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class);
        if (methodCall == null) {
            return TailCallType.None;
        }
        PsiElement callParent = PsiUtil.skipParenthesizedExprUp((PsiElement)methodCall.getParent());
        if (callParent instanceof PsiReturnStatement || callParent instanceof PsiLambdaExpression) {
            return TailCallType.Return;
        }
        if (callParent instanceof PsiExpression && BoolUtils.isNegation((PsiExpression)(expression = (PsiExpression)callParent))) {
            PsiPolyadicExpression polyOp;
            PsiElement negationParent = PsiUtil.skipParenthesizedExprUp((PsiElement)callParent.getParent());
            if (negationParent instanceof PsiPolyadicExpression && ((polyOp = (PsiPolyadicExpression)negationParent).getOperationTokenType().equals(JavaTokenType.ANDAND) || polyOp.getOperationTokenType().equals(JavaTokenType.OROR)) && PsiTreeUtil.isAncestor((PsiElement)((PsiElement)ArrayUtil.getLastElement((Object[])polyOp.getOperands())), (PsiElement)callParent, (boolean)false)) {
                negationParent = PsiUtil.skipParenthesizedExprUp((PsiElement)negationParent.getParent());
            }
            if (negationParent instanceof PsiReturnStatement || negationParent instanceof PsiYieldStatement || negationParent instanceof PsiLambdaExpression) {
                return TailCallType.Invert;
            }
        }
        if (callParent instanceof PsiExpressionStatement) {
            PsiStatement curElement = (PsiStatement)callParent;
            while (true) {
                if (PsiTreeUtil.getNextSiblingOfType((PsiElement)curElement, PsiStatement.class) != null) {
                    return TailCallType.None;
                }
                PsiElement parent = curElement.getParent();
                if (parent instanceof PsiCodeBlock) {
                    PsiElement blockParent = parent.getParent();
                    if (blockParent instanceof PsiMethod || blockParent instanceof PsiLambdaExpression) {
                        return TailCallType.Simple;
                    }
                    if (!(blockParent instanceof PsiBlockStatement)) {
                        return TailCallType.None;
                    }
                    parent = blockParent.getParent();
                    if (parent instanceof PsiLoopStatement) {
                        return TailCallType.Continue;
                    }
                }
                if (!(parent instanceof PsiLabeledStatement) && !(parent instanceof PsiIfStatement)) {
                    return TailCallType.None;
                }
                curElement = (PsiStatement)parent;
            }
        }
        return TailCallType.None;
    }

    public static void substituteTypeParams(PsiElement scope, final PsiSubstitutor substitutor, final PsiElementFactory factory) {
        final HashMap replacement2 = new HashMap();
        scope.accept((PsiElementVisitor)new JavaRecursiveElementVisitor(){

            public void visitTypeElement(@NotNull PsiTypeElement typeElement) {
                PsiClassType classType;
                PsiClassType.ClassResolveResult resolveResult;
                PsiElement resolved;
                if (typeElement == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitTypeElement(typeElement);
                PsiType type = typeElement.getType();
                if (type instanceof PsiClassType && (resolved = (resolveResult = (classType = (PsiClassType)type).resolveGenerics()).getElement()) instanceof PsiTypeParameter) {
                    PsiCapturedWildcardType wildcardType;
                    PsiTypeParameter parameter = (PsiTypeParameter)resolved;
                    PsiType newType = resolveResult.getSubstitutor().putAll(substitutor).substitute(parameter);
                    if (newType instanceof PsiCapturedWildcardType) {
                        wildcardType = (PsiCapturedWildcardType)newType;
                        newType = wildcardType.getUpperBound();
                    }
                    if (newType instanceof PsiWildcardType) {
                        wildcardType = (PsiWildcardType)newType;
                        newType = wildcardType.getBound();
                    }
                    if (newType == null) {
                        newType = PsiType.getJavaLangObject((PsiManager)resolved.getManager(), (GlobalSearchScope)resolved.getResolveScope());
                    }
                    try {
                        replacement2.put(typeElement, factory.createTypeElement(newType));
                    }
                    catch (IncorrectOperationException e) {
                        LOG.error((Throwable)e);
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeElement", "com/intellij/refactoring/util/InlineUtil$1", "visitTypeElement"));
            }
        });
        for (PsiElement element : replacement2.keySet()) {
            if (!element.isValid()) continue;
            element.replace((PsiElement)replacement2.get(element));
        }
    }

    private static PsiElement replaceDiamondWithInferredTypesIfNeeded(PsiExpression initializer, PsiElement ref) {
        PsiDiamondType.DiamondInferenceResult inferenceResult;
        PsiNewExpression expression;
        PsiDiamondType diamondType;
        if (initializer instanceof PsiNewExpression && (diamondType = PsiDiamondType.getDiamondType((PsiNewExpression)(expression = (PsiNewExpression)initializer))) != null && (inferenceResult = diamondType.resolveInferredTypes()).getErrorMessage() == null) {
            PsiElement copy = ref.copy();
            PsiElement parent = ref.replace((PsiElement)initializer);
            PsiDiamondType.DiamondInferenceResult result = PsiDiamondTypeImpl.resolveInferredTypes((PsiNewExpression)expression, (PsiElement)parent);
            ref = parent.replace(copy);
            if (!result.equals((Object)inferenceResult)) {
                String inferredTypeText = StringUtil.join((Object[])inferenceResult.getTypes(), psiType -> psiType.getCanonicalText(), (String)", ");
                PsiJavaCodeReferenceElement classReference = expression.getClassOrAnonymousClassReference();
                PsiNewExpression expandedDiamond = (PsiNewExpression)JavaPsiFacade.getElementFactory((Project)initializer.getProject()).createExpressionFromText("new " + Objects.requireNonNull(classReference).getReferenceName() + "<" + inferredTypeText + ">()", (PsiElement)initializer);
                PsiNewExpression newExpression = (PsiNewExpression)initializer.copy();
                Objects.requireNonNull(newExpression.getClassOrAnonymousClassReference()).replace((PsiElement)Objects.requireNonNull(expandedDiamond.getClassReference()));
                return ref.replace((PsiElement)newExpression);
            }
        }
        return ref != initializer ? ref.replace((PsiElement)initializer) : initializer;
    }

    public static void solveLocalNameConflicts(PsiElement scope, PsiElement placeToInsert, PsiElement renameScope) {
        PsiElement[] children;
        if (scope instanceof PsiVariable || scope instanceof PsiClass) {
            PsiNameIdentifierOwner named = (PsiNameIdentifierOwner)scope;
            String name = named.getName();
            PsiElement identifier = named.getNameIdentifier();
            if (name != null && identifier != null) {
                Object newName;
                BiFunction<PsiElement, String, String> suggester;
                String oldName = name;
                Project project = scope.getProject();
                JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
                BiFunction<PsiElement, String, String> biFunction = suggester = scope instanceof PsiVariable ? (place, curName) -> codeStyleManager.suggestUniqueVariableName(curName, place, true) : (place, curName) -> InlineUtil.suggestClassName(place, curName);
                while (!((String)(newName = suggester.apply(placeToInsert, name))).equals(name) && !((String)(newName = suggester.apply((PsiElement)named, name = newName))).equals(name)) {
                    name = newName;
                }
                if (!name.equals(oldName)) {
                    for (PsiReference reference : ReferencesSearch.search((PsiElement)named, (SearchScope)new LocalSearchScope(renameScope), (boolean)true).asIterable()) {
                        reference.handleElementRename(name);
                    }
                    PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)scope.getProject());
                    if (named instanceof PsiClass) {
                        PsiClass cls = (PsiClass)named;
                        for (PsiMethod constructor : cls.getConstructors()) {
                            if (constructor instanceof SyntheticElement || !constructor.getName().equals(oldName)) continue;
                            Objects.requireNonNull(constructor.getNameIdentifier()).replace((PsiElement)factory.createIdentifier(name));
                        }
                    }
                    Objects.requireNonNull(named.getNameIdentifier()).replace((PsiElement)factory.createIdentifier(name));
                }
            }
        }
        for (PsiElement child : children = scope.getChildren()) {
            InlineUtil.solveLocalNameConflicts(child, placeToInsert, renameScope);
        }
    }

    @NotNull
    private static String suggestClassName(@NotNull PsiElement place, @NotNull String name) {
        if (place == null) {
            InlineUtil.$$$reportNull$$$0(7);
        }
        if (name == null) {
            InlineUtil.$$$reportNull$$$0(8);
        }
        PsiResolveHelper helper = PsiResolveHelper.getInstance((Project)place.getProject());
        String string = UniqueNameGenerator.generateUniqueNameOneBased((String)name, n -> {
            PsiCodeBlock block;
            PsiDeclarationStatement decl;
            PsiElement patt1$temp;
            PsiElement patt0$temp;
            return helper.resolveReferencedClass(n, place) == null && (!(place instanceof PsiClass) || !((patt0$temp = place.getParent()) instanceof PsiDeclarationStatement) || !((patt1$temp = (decl = (PsiDeclarationStatement)patt0$temp).getParent()) instanceof PsiCodeBlock) || SyntaxTraverser.psiTraverser((PsiElement)(block = (PsiCodeBlock)patt1$temp)).filter(PsiClass.class).find(cls -> n.equals(cls.getName())) == null);
        });
        if (string == null) {
            InlineUtil.$$$reportNull$$$0(9);
        }
        return string;
    }

    public static boolean isChainingConstructor(PsiMethod constructor) {
        return CommonJavaRefactoringUtil.getChainedConstructor((PsiMethod)constructor) != null;
    }

    public static void checkChangedBeforeLastAccessConflicts(@NotNull MultiMap<PsiElement, String> conflicts, @NotNull PsiExpression initializer, @NotNull PsiVariable variable) {
        if (conflicts == null) {
            InlineUtil.$$$reportNull$$$0(10);
        }
        if (initializer == null) {
            InlineUtil.$$$reportNull$$$0(11);
        }
        if (variable == null) {
            InlineUtil.$$$reportNull$$$0(12);
        }
        Map<PsiElement, PsiVariable> writePlaces = InlineUtil.getChangedBeforeLastAccessMap(initializer, variable);
        String readVarName = variable.getName();
        for (Map.Entry<PsiElement, PsiVariable> writePlaceEntry : writePlaces.entrySet()) {
            String message = JavaRefactoringBundle.message((String)"variable.0.is.changed.before.last.access", (Object[])new Object[]{writePlaceEntry.getValue().getName(), readVarName});
            conflicts.putValue((Object)writePlaceEntry.getKey(), (Object)message);
        }
    }

    @NotNull
    public static Map<PsiElement, PsiVariable> getChangedBeforeLastAccessMap(@NotNull PsiExpression initializer, @NotNull PsiVariable variable) {
        Set referencedVars;
        if (initializer == null) {
            InlineUtil.$$$reportNull$$$0(13);
        }
        if (variable == null) {
            InlineUtil.$$$reportNull$$$0(14);
        }
        if ((referencedVars = VariableAccessUtils.collectUsedVariables((PsiElement)initializer)).isEmpty()) {
            Map<PsiElement, PsiVariable> map = Map.of();
            if (map == null) {
                InlineUtil.$$$reportNull$$$0(15);
            }
            return map;
        }
        PsiElement scope = PsiUtil.getTopLevelEnclosingCodeBlock((PsiElement)initializer, null);
        if (scope == null) {
            Map<PsiElement, PsiVariable> map = Map.of();
            if (map == null) {
                InlineUtil.$$$reportNull$$$0(16);
            }
            return map;
        }
        ControlFlow flow = InlineUtil.createControlFlow(scope);
        if (flow == null) {
            Map<PsiElement, PsiVariable> map = Map.of();
            if (map == null) {
                InlineUtil.$$$reportNull$$$0(17);
            }
            return map;
        }
        int start = flow.getEndOffset((PsiElement)initializer);
        if (start < 0) {
            Map<PsiElement, PsiVariable> map = Map.of();
            if (map == null) {
                InlineUtil.$$$reportNull$$$0(18);
            }
            return map;
        }
        Map map = ControlFlowUtil.getWritesBeforeReads((ControlFlow)flow, (Set)referencedVars, Collections.singleton(variable), (int)start);
        if (map == null) {
            InlineUtil.$$$reportNull$$$0(19);
        }
        return map;
    }

    @Nullable
    private static ControlFlow createControlFlow(@NotNull PsiElement scope) {
        if (scope == null) {
            InlineUtil.$$$reportNull$$$0(20);
        }
        ControlFlowFactory factory = ControlFlowFactory.getInstance((Project)scope.getProject());
        LocalsOrMyInstanceFieldsControlFlowPolicy policy = LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance();
        try {
            return factory.getControlFlow(scope, (ControlFlowPolicy)policy);
        }
        catch (AnalysisCanceledException e) {
            return null;
        }
    }

    public static void extractReturnValues(PsiMethod method, boolean replaceWithContinue) {
        PsiReturnStatement[] returnStatements;
        PsiCodeBlock block = Objects.requireNonNull(method.getBody());
        for (PsiReturnStatement returnStatement : returnStatements = PsiUtil.findReturnStatements((PsiMethod)method)) {
            PsiExpression returnValue = returnStatement.getReturnValue();
            if (returnValue != null) {
                List<PsiExpression> sideEffects = !InlineUtil.singleReturnMethod(method) || !PsiUtil.isStatement((PsiElement)returnValue) ? SideEffectChecker.extractSideEffectExpressions((PsiExpression)returnValue) : Collections.singletonList(returnValue);
                CommentTracker ct = new CommentTracker();
                sideEffects.forEach(arg_0 -> ((CommentTracker)ct).markUnchanged(arg_0));
                PsiStatement[] statements = StatementExtractor.generateStatements(sideEffects, (PsiExpression)returnValue);
                ct.delete((PsiElement)returnValue);
                if (statements.length > 0) {
                    PsiStatement lastAdded = BlockUtils.addBefore((PsiStatement)returnStatement, (PsiStatement[])statements);
                    returnStatement = Objects.requireNonNull((PsiReturnStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)lastAdded, PsiReturnStatement.class));
                }
                ct.insertCommentsBefore((PsiElement)returnStatement);
            }
            if (ControlFlowUtils.blockCompletesWithStatement((PsiCodeBlock)block, (PsiStatement)returnStatement)) {
                new CommentTracker().deleteAndRestoreComments((PsiElement)returnStatement);
                continue;
            }
            if (!replaceWithContinue) continue;
            new CommentTracker().replaceAndRestoreComments((PsiElement)returnStatement, "continue;");
        }
    }

    private static boolean singleReturnMethod(PsiMethod method) {
        int statementCount = Objects.requireNonNull(method.getBody()).getStatementCount();
        if (!method.hasModifierProperty("static") && PsiTreeUtil.getContextOfType((PsiElement)method, (Class[])new Class[]{PsiClass.class}) != null) {
            --statementCount;
        }
        return statementCount <= 1;
    }

    public static PsiExpression inlineInitializer(PsiVariable variable, PsiExpression initializer, PsiJavaCodeReferenceElement ref) {
        PsiElement psiElement;
        PsiClass varThisClass;
        PsiThisExpression expression;
        Project project = variable.getProject();
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project);
        if (initializer instanceof PsiThisExpression && (expression = (PsiThisExpression)initializer).getQualifier() == null && (varThisClass = RefactoringChangeUtil.getThisClass((PsiElement)variable)) != null && varThisClass != RefactoringChangeUtil.getThisClass((PsiElement)ref)) {
            initializer = factory.createExpressionFromText(varThisClass.getName() + ".this", (PsiElement)variable);
        }
        PsiExpression expr = InlineUtil.inlineVariable(variable, initializer, ref);
        CommonJavaRefactoringUtil.tryToInlineArrayCreationForVarargs((PsiExpression)expr);
        if (expr instanceof PsiThisExpression && (psiElement = expr.getParent()) instanceof PsiReferenceExpression) {
            PsiElement newRefElement;
            PsiReferenceExpression refExpr = (PsiReferenceExpression)psiElement;
            PsiElement refElement = refExpr.resolve();
            PsiExpression exprCopy = (PsiExpression)refExpr.copy();
            refExpr = (PsiReferenceExpression)refExpr.replace((PsiElement)factory.createExpressionFromText(Objects.requireNonNull(refExpr.getReferenceName()), null));
            if (refElement != null && !refElement.equals((Object)(newRefElement = refExpr.resolve()))) {
                refExpr.replace((PsiElement)exprCopy);
            }
        }
        if (expr instanceof PsiLiteralExpression) {
            Object object;
            PsiLiteralExpression literalExpression = (PsiLiteralExpression)expr;
            if (PsiTypes.booleanType().equals((Object)expr.getType()) && (object = literalExpression.getValue()) instanceof Boolean) {
                Boolean value = (Boolean)object;
                SimplifyBooleanExpressionFix.trySimplify((PsiExpression)expr, (boolean)value);
            }
        }
        return initializer;
    }

    public static boolean canInlineParameterOrThisVariable(PsiLocalVariable variable) {
        List refs = VariableAccessUtils.getVariableReferencesNoCache((PsiVariable)variable);
        boolean isAccessedForWriting = false;
        for (PsiReferenceExpression refElement : refs) {
            if (!PsiUtil.isAccessedForWriting((PsiExpression)refElement)) continue;
            isAccessedForWriting = true;
        }
        if (refs.size() == 1 && !isAccessedForWriting && InlineUtil.isFirstUse(variable, (PsiReferenceExpression)refs.get(0))) {
            return true;
        }
        PsiExpression initializer = variable.getInitializer();
        return InlineUtil.canInlineParameterOrThisVariable(variable.getProject(), initializer, false, false, refs.size(), isAccessedForWriting);
    }

    private static boolean isFirstUse(PsiLocalVariable variable, PsiReferenceExpression expression) {
        PsiElement parent;
        PsiElement psiElement = variable.getParent();
        if (!(psiElement instanceof PsiDeclarationStatement)) {
            return false;
        }
        PsiDeclarationStatement decl = (PsiDeclarationStatement)psiElement;
        PsiStatement statement = (PsiStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)decl, PsiStatement.class);
        if (statement == null) {
            return false;
        }
        PsiReferenceExpression cur = expression;
        while (true) {
            PsiAssignmentExpression assign;
            PsiMethodCallExpression call;
            if ((parent = cur.getParent()) instanceof PsiPolyadicExpression) {
                PsiPolyadicExpression poly = (PsiPolyadicExpression)parent;
                if (poly.getOperands()[0] != cur) {
                    return false;
                }
                cur = poly;
                continue;
            }
            if (parent instanceof PsiParenthesizedExpression || parent instanceof PsiTypeCastExpression || parent instanceof PsiUnaryExpression || parent instanceof PsiInstanceOfExpression || parent instanceof PsiSwitchExpression) {
                cur = (PsiExpression)parent;
                continue;
            }
            if (parent instanceof PsiConditionalExpression) {
                PsiConditionalExpression cond = (PsiConditionalExpression)parent;
                if (cond.getCondition() != cur) {
                    return false;
                }
                cur = cond;
                continue;
            }
            if (parent instanceof PsiExpressionList) {
                PsiReferenceExpression qualifierRef;
                PsiExpression qualifier;
                PsiExpressionList list = (PsiExpressionList)parent;
                for (PsiExpression expr : list.getExpressions()) {
                    if (expr == cur) break;
                    if (ExpressionUtils.isSafelyRecomputableExpression((PsiExpression)expr)) continue;
                    return false;
                }
                PsiElement psiElement2 = list.getParent();
                if (!(psiElement2 instanceof PsiCallExpression)) {
                    return false;
                }
                call = (PsiCallExpression)psiElement2;
                if (call instanceof PsiMethodCallExpression) {
                    PsiMethodCallExpression methodCall = call;
                    v0 = methodCall.getMethodExpression().getQualifierExpression();
                } else if (call instanceof PsiNewExpression) {
                    PsiNewExpression newExpression = (PsiNewExpression)call;
                    v0 = newExpression.getQualifier();
                } else {
                    v0 = qualifier = null;
                }
                if (!(qualifier == null || ExpressionUtils.isSafelyRecomputableExpression((PsiExpression)qualifier) || qualifier instanceof PsiReferenceExpression && (qualifierRef = (PsiReferenceExpression)qualifier).resolve() instanceof PsiClass)) {
                    return false;
                }
                cur = call;
                continue;
            }
            if (parent instanceof PsiAssignmentExpression && (assign = (PsiAssignmentExpression)parent).getRExpression() == cur) {
                PsiReferenceExpression lRef;
                PsiExpression lExpression = assign.getLExpression();
                if (lExpression instanceof PsiReferenceExpression && ((lRef = (PsiReferenceExpression)lExpression).getQualifierExpression() == null || lRef.getQualifierExpression() instanceof PsiQualifiedExpression)) {
                    cur = assign;
                    continue;
                }
                return false;
            }
            if (parent instanceof PsiReferenceExpression) {
                PsiReferenceExpression ref = (PsiReferenceExpression)parent;
                PsiElement psiElement3 = parent.getParent();
                if (psiElement3 instanceof PsiMethodCallExpression) {
                    call = (PsiMethodCallExpression)psiElement3;
                    cur = call;
                    continue;
                }
                cur = ref;
                continue;
            }
            if (parent instanceof PsiArrayAccessExpression) {
                PsiArrayAccessExpression arr = (PsiArrayAccessExpression)parent;
                if (arr.getIndexExpression() == cur && !ExpressionUtils.isSafelyRecomputableExpression((PsiExpression)arr)) {
                    return false;
                }
                cur = arr;
                continue;
            }
            if (parent instanceof PsiArrayInitializerExpression) {
                PsiArrayInitializerExpression init = (PsiArrayInitializerExpression)parent;
                for (PsiExpression initializer : init.getInitializers()) {
                    if (initializer == cur) break;
                    if (ExpressionUtils.isSafelyRecomputableExpression((PsiExpression)initializer)) continue;
                    return false;
                }
                cur = init;
                continue;
            }
            if (!(parent instanceof PsiNewExpression)) break;
            PsiNewExpression newExpression = (PsiNewExpression)parent;
            cur = newExpression;
        }
        if (parent instanceof PsiLocalVariable) {
            PsiLocalVariable var = (PsiLocalVariable)parent;
            return var.getParent() == statement;
        }
        if (parent instanceof PsiStatement) {
            if (parent != statement) {
                return false;
            }
            return parent instanceof PsiAssertStatement || parent instanceof PsiReturnStatement || parent instanceof PsiIfStatement || parent instanceof PsiExpressionStatement || parent instanceof PsiSynchronizedStatement || parent instanceof PsiSwitchStatement || parent instanceof PsiWhileStatement || parent instanceof PsiForeachStatement;
        }
        return false;
    }

    private static boolean canInlineParameterOrThisVariable(Project project, PsiExpression initializer, boolean shouldBeFinal, boolean strictlyFinal, int accessCount, boolean isAccessedForWriting) {
        PsiPrefixExpression prefix;
        if (strictlyFinal) {
            class CanAllLocalsBeDeclaredFinal
            extends JavaRecursiveElementWalkingVisitor {
                private boolean success = true;

                CanAllLocalsBeDeclaredFinal() {
                }

                public void visitReferenceExpression(@NotNull PsiReferenceExpression expression) {
                    PsiElement psiElement;
                    if (expression == null) {
                        CanAllLocalsBeDeclaredFinal.$$$reportNull$$$0(0);
                    }
                    if (((psiElement = expression.resolve()) instanceof PsiLocalVariable || psiElement instanceof PsiParameter) && !CommonJavaRefactoringUtil.canBeDeclaredFinal((PsiVariable)((PsiVariable)psiElement))) {
                        this.success = false;
                    }
                }

                public void visitElement(@NotNull PsiElement element) {
                    if (element == null) {
                        CanAllLocalsBeDeclaredFinal.$$$reportNull$$$0(1);
                    }
                    if (this.success) {
                        super.visitElement(element);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "expression";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "element";
                            break;
                        }
                    }
                    objectArray2[1] = "com/intellij/refactoring/util/InlineUtil$1CanAllLocalsBeDeclaredFinal";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitReferenceExpression";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "visitElement";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }
            CanAllLocalsBeDeclaredFinal canAllLocalsBeDeclaredFinal = new CanAllLocalsBeDeclaredFinal();
            initializer.accept((PsiElementVisitor)canAllLocalsBeDeclaredFinal);
            if (!canAllLocalsBeDeclaredFinal.success) {
                return false;
            }
        }
        if (initializer instanceof PsiFunctionalExpression) {
            return accessCount <= 1;
        }
        if (initializer instanceof PsiReferenceExpression) {
            PsiReferenceExpression ref = (PsiReferenceExpression)initializer;
            PsiVariable refVar = (PsiVariable)ref.resolve();
            if (refVar == null) {
                return !isAccessedForWriting;
            }
            if (refVar instanceof PsiField) {
                if (isAccessedForWriting) {
                    return false;
                }
                if (refVar.hasModifierProperty("volatile")) {
                    return accessCount <= 1;
                }
                return true;
            }
            if (isAccessedForWriting) {
                if (refVar.hasModifierProperty("final") || shouldBeFinal) {
                    return false;
                }
                PsiReference[] refs = (PsiReference[])ReferencesSearch.search((PsiElement)refVar, (SearchScope)GlobalSearchScope.projectScope((Project)project), (boolean)false).toArray((Object[])PsiReference.EMPTY_ARRAY);
                return refs.length == 1;
            }
            if (shouldBeFinal) {
                return refVar.hasModifierProperty("final") || CommonJavaRefactoringUtil.canBeDeclaredFinal((PsiVariable)refVar);
            }
            return true;
        }
        if (isAccessedForWriting) {
            return false;
        }
        if (initializer instanceof PsiCallExpression) {
            PsiExpression[] expressions;
            PsiNewExpression newExpression;
            PsiArrayInitializerExpression arrayInitializer;
            PsiCallExpression callExpression = (PsiCallExpression)initializer;
            if (accessCount != 1) {
                return false;
            }
            if (initializer instanceof PsiNewExpression && (arrayInitializer = (newExpression = (PsiNewExpression)initializer).getArrayInitializer()) != null) {
                for (PsiExpression expression : arrayInitializer.getInitializers()) {
                    if (InlineUtil.canInlineParameterOrThisVariable(project, expression, shouldBeFinal, strictlyFinal, accessCount, false)) continue;
                    return false;
                }
                return true;
            }
            PsiExpressionList argumentList = callExpression.getArgumentList();
            if (argumentList == null) {
                return false;
            }
            for (PsiExpression expression : expressions = argumentList.getExpressions()) {
                if (InlineUtil.canInlineParameterOrThisVariable(project, expression, shouldBeFinal, strictlyFinal, accessCount, false)) continue;
                return false;
            }
            PsiMethod method = callExpression.resolveMethod();
            return method == null || JavaMethodContractUtil.isPure((PsiMethod)method);
        }
        if (initializer instanceof PsiLiteralExpression) {
            return true;
        }
        if (initializer instanceof PsiPrefixExpression && (prefix = (PsiPrefixExpression)initializer).getOperand() instanceof PsiLiteralExpression) {
            return true;
        }
        if (initializer instanceof PsiArrayAccessExpression) {
            PsiArrayAccessExpression expression = (PsiArrayAccessExpression)initializer;
            PsiExpression arrayExpression = expression.getArrayExpression();
            PsiExpression indexExpression = expression.getIndexExpression();
            return InlineUtil.canInlineParameterOrThisVariable(project, arrayExpression, shouldBeFinal, strictlyFinal, accessCount, false) && InlineUtil.canInlineParameterOrThisVariable(project, indexExpression, shouldBeFinal, strictlyFinal, accessCount, false);
        }
        if (initializer instanceof PsiParenthesizedExpression) {
            PsiParenthesizedExpression expression = (PsiParenthesizedExpression)initializer;
            PsiExpression expr = expression.getExpression();
            return expr == null || InlineUtil.canInlineParameterOrThisVariable(project, expr, shouldBeFinal, strictlyFinal, accessCount, false);
        }
        if (initializer instanceof PsiTypeCastExpression) {
            PsiTypeCastExpression expression = (PsiTypeCastExpression)initializer;
            PsiExpression operand = expression.getOperand();
            return operand != null && InlineUtil.canInlineParameterOrThisVariable(project, operand, shouldBeFinal, strictlyFinal, accessCount, false);
        }
        if (initializer instanceof PsiPolyadicExpression) {
            PsiPolyadicExpression binExpr = (PsiPolyadicExpression)initializer;
            for (PsiExpression op : binExpr.getOperands()) {
                if (InlineUtil.canInlineParameterOrThisVariable(project, op, shouldBeFinal, strictlyFinal, accessCount, false)) continue;
                return false;
            }
            return true;
        }
        if (initializer instanceof PsiClassObjectAccessExpression) {
            return true;
        }
        if (initializer instanceof PsiThisExpression) {
            return true;
        }
        return initializer instanceof PsiSuperExpression;
    }

    public static void tryInlineGeneratedLocal(PsiLocalVariable variable, boolean strictlyFinal) {
        List refs = VariableAccessUtils.getVariableReferencesNoCache((PsiVariable)variable);
        PsiReferenceExpression firstRef = (PsiReferenceExpression)ContainerUtil.getFirstItem((List)refs);
        PsiExpression initializer = variable.getInitializer();
        if (firstRef == null) {
            PsiDeclarationStatement declaration = (PsiDeclarationStatement)variable.getParent();
            if (initializer != null) {
                List sideEffects = SideEffectChecker.extractSideEffectExpressions((PsiExpression)initializer);
                for (PsiStatement statement : StatementExtractor.generateStatements((List)sideEffects, (PsiExpression)initializer)) {
                    declaration.getParent().addBefore((PsiElement)statement, (PsiElement)declaration);
                }
            }
            declaration.delete();
            return;
        }
        boolean isAccessedForWriting = false;
        boolean usedAsResource = false;
        for (PsiReferenceExpression refElement : refs) {
            if (PsiUtil.isAccessedForWriting((PsiExpression)refElement)) {
                isAccessedForWriting = true;
            }
            if (!(refElement.getParent() instanceof PsiResourceExpression)) continue;
            usedAsResource = true;
        }
        boolean shouldBeFinal = variable.hasModifierProperty("final") && strictlyFinal;
        Project project = variable.getProject();
        boolean canInline = refs.size() == 1 && !isAccessedForWriting && InlineUtil.isFirstUse(variable, (PsiReferenceExpression)refs.get(0)) || InlineUtil.canInlineParameterOrThisVariable(project, initializer, shouldBeFinal, strictlyFinal, refs.size(), isAccessedForWriting);
        if (canInline &= !usedAsResource) {
            if (shouldBeFinal) {
                InlineUtil.declareUsedLocalsFinal((PsiElement)initializer, true);
            }
            for (PsiJavaCodeReferenceElement ref : refs) {
                initializer = InlineUtil.inlineInitializer((PsiVariable)variable, initializer, ref);
            }
            variable.getParent().delete();
        }
    }

    private static void declareUsedLocalsFinal(PsiElement expr, boolean strictlyFinal) {
        PsiElement[] children;
        PsiReferenceExpression ref;
        PsiElement refElement;
        if (expr instanceof PsiReferenceExpression && ((refElement = (ref = (PsiReferenceExpression)expr).resolve()) instanceof PsiLocalVariable || refElement instanceof PsiParameter) && (strictlyFinal || CommonJavaRefactoringUtil.canBeDeclaredFinal((PsiVariable)((PsiVariable)refElement)))) {
            PsiUtil.setModifierProperty((PsiModifierListOwner)((PsiVariable)refElement), (String)"final", (boolean)true);
        }
        for (PsiElement child : children = expr.getChildren()) {
            InlineUtil.declareUsedLocalsFinal(child, strictlyFinal);
        }
    }

    public static void tryInlineResultVariable(@NotNull PsiLocalVariable resultVar, @NotNull PsiReferenceExpression resultUsage) {
        PsiElement context;
        if (resultVar == null) {
            InlineUtil.$$$reportNull$$$0(21);
        }
        if (resultUsage == null) {
            InlineUtil.$$$reportNull$$$0(22);
        }
        if ((context = PsiUtil.getVariableCodeBlock((PsiVariable)resultVar, null)) == null) {
            return;
        }
        List references = VariableAccessUtils.getVariableReferencesNoCache((PsiVariable)resultVar);
        if (resultVar.getInitializer() == null) {
            PsiAssignmentExpression assignment = null;
            for (PsiReferenceExpression ref : references) {
                if (!(ref.getParent() instanceof PsiAssignmentExpression) || !((PsiAssignmentExpression)ref.getParent()).getLExpression().equals((Object)ref)) continue;
                if (assignment != null) {
                    assignment = null;
                    break;
                }
                assignment = (PsiAssignmentExpression)ref.getParent();
            }
            if (assignment != null) {
                InlineUtil.inlineSingleAssignment((PsiVariable)resultVar, assignment, resultUsage);
                return;
            }
        }
        InlineUtil.tryReplaceWithTarget(resultVar, resultUsage, context, references);
    }

    private static void tryReplaceWithTarget(@NotNull PsiLocalVariable variable, @NotNull PsiReferenceExpression usage, PsiElement context, List<? extends PsiReferenceExpression> references) {
        PsiModifierList modifierList;
        PsiDeclarationStatement declaration;
        PsiElement psiElement;
        if (variable == null) {
            InlineUtil.$$$reportNull$$$0(23);
        }
        if (usage == null) {
            InlineUtil.$$$reportNull$$$0(24);
        }
        if (!((psiElement = PsiUtil.skipParenthesizedExprUp((PsiElement)usage.getParent())) instanceof PsiLocalVariable)) {
            return;
        }
        PsiLocalVariable target = (PsiLocalVariable)psiElement;
        String name = target.getName();
        if (!target.getType().equals(variable.getType())) {
            return;
        }
        PsiElement psiElement2 = target.getParent();
        if (!(psiElement2 instanceof PsiDeclarationStatement) || (declaration = (PsiDeclarationStatement)psiElement2).getDeclaredElements().length != 1) {
            return;
        }
        PsiModifierList modifiers = target.getModifierList();
        if (modifiers != null && modifiers.hasAnnotations()) {
            return;
        }
        boolean effectivelyFinal = ControlFlowUtil.isEffectivelyFinal((PsiVariable)variable, (PsiElement)context);
        if (!effectivelyFinal && !VariableAccessUtils.canUseAsNonFinal((PsiLocalVariable)target)) {
            return;
        }
        for (PsiReferenceExpression psiReferenceExpression : references) {
            ExpressionUtils.bindReferenceTo((PsiReferenceExpression)psiReferenceExpression, (String)name);
        }
        if (effectivelyFinal && target.hasModifierProperty("final") && (modifierList = variable.getModifierList()) != null) {
            modifierList.setModifierProperty("final", true);
        }
        variable.setName(name);
        new CommentTracker().deleteAndRestoreComments((PsiElement)declaration);
    }

    private static void inlineSingleAssignment(@NotNull PsiVariable resultVar, @NotNull PsiAssignmentExpression assignment, @NotNull PsiReferenceExpression resultUsage) {
        if (resultVar == null) {
            InlineUtil.$$$reportNull$$$0(25);
        }
        if (assignment == null) {
            InlineUtil.$$$reportNull$$$0(26);
        }
        if (resultUsage == null) {
            InlineUtil.$$$reportNull$$$0(27);
        }
        LOG.assertTrue(assignment.getParent() instanceof PsiExpressionStatement);
        if (assignment.getParent().getParent() != resultVar.getParent().getParent()) {
            return;
        }
        String name = Objects.requireNonNull(resultVar.getName());
        PsiDeclarationStatement declaration = JavaPsiFacade.getElementFactory((Project)resultVar.getProject()).createVariableDeclarationStatement(name, resultVar.getType(), assignment.getRExpression());
        declaration = (PsiDeclarationStatement)assignment.getParent().replace((PsiElement)declaration);
        resultVar.getParent().delete();
        resultVar = (PsiVariable)declaration.getDeclaredElements()[0];
        PsiElement parentStatement = CommonJavaRefactoringUtil.getParentStatement((PsiElement)resultUsage, (boolean)true);
        boolean canInline = false;
        for (PsiElement next = declaration.getNextSibling(); next != null; next = next.getNextSibling()) {
            if (next.equals((Object)parentStatement)) {
                canInline = true;
                break;
            }
            if (next instanceof PsiStatement) break;
        }
        if (canInline) {
            InlineUtil.inlineVariable(resultVar, resultVar.getInitializer(), (PsiJavaCodeReferenceElement)resultUsage);
            declaration.delete();
        }
    }

    @NotNull
    public ModCommand inline(@NotNull PsiVariable var) {
        if (var == null) {
            InlineUtil.$$$reportNull$$$0(28);
        }
        ModCommand modCommand = InlineLocalHandler.doInline(ActionContext.from(null, (PsiFile)var.getContainingFile()), var, null, InlineLocalHandler.InlineMode.CHECK_CONFLICTS);
        if (modCommand == null) {
            InlineUtil.$$$reportNull$$$0(29);
        }
        return modCommand;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 6, 7, 8, 10, 11, 12, 13, 14, 20, 21, 22, 23, 24, 25, 26, 27, 28 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/refactoring/util/InlineUtil";
                break;
            }
            case 1: 
            case 12: 
            case 14: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 2: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initializer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiReference";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultVar";
                break;
            }
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultUsage";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignment";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "var";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "inlineVariable";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/refactoring/util/InlineUtil";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestClassName";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangedBeforeLastAccessMap";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "inline";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "inlineVariable";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTailCallType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "suggestClassName";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "checkChangedBeforeLastAccessConflicts";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getChangedBeforeLastAccessMap";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createControlFlow";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "tryInlineResultVariable";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "tryReplaceWithTarget";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "inlineSingleAssignment";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "inline";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 6, 7, 8, 10, 11, 12, 13, 14, 20, 21, 22, 23, 24, 25, 26, 27, 28 -> new IllegalArgumentException(string);
        };
    }

    public static enum TailCallType {
        None(null),
        Simple((methodCopy, callSite, returnType) -> {
            InlineUtil.extractReturnValues(methodCopy, false);
            return null;
        }),
        Continue((methodCopy, callSite, returnType) -> {
            InlineUtil.extractReturnValues(methodCopy, true);
            return null;
        }),
        Invert((methodCopy, callSite, returnType) -> {
            for (PsiReturnStatement statement : PsiUtil.findReturnStatements((PsiMethod)methodCopy)) {
                PsiExpression value = statement.getReturnValue();
                if (value == null) continue;
                CommentTracker ct = new CommentTracker();
                ct.replaceAndRestoreComments((PsiElement)value, BoolUtils.getNegatedExpressionText((PsiExpression)value, (CommentTracker)ct));
            }
            return null;
        }),
        Return((methodCopy, callSite, returnType) -> null);

        @Nullable
        private final InlineTransformer myTransformer;

        private TailCallType(InlineTransformer transformer) {
            this.myTransformer = transformer;
        }

        @Nullable
        public InlineTransformer getTransformer() {
            return this.myTransformer;
        }
    }
}

