/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.classMembers;

import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.refactoring.classMembers.AbstractMemberInfoStorage;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class MemberInfoStorage
extends AbstractMemberInfoStorage<PsiMember, PsiClass, MemberInfo> {
    public MemberInfoStorage(PsiClass aClass, MemberInfoBase.Filter<PsiMember> memberInfoFilter) {
        super((PsiElement)aClass, memberInfoFilter);
    }

    protected boolean isInheritor(PsiClass baseClass, PsiClass aClass) {
        return aClass.isInheritor(baseClass, true);
    }

    protected void extractClassMembers(PsiClass aClass, ArrayList<MemberInfo> temp) {
        MemberInfo.extractClassMembers((PsiClass)aClass, temp, (MemberInfoBase.Filter)this.myFilter, (boolean)false);
    }

    protected boolean memberConflict(PsiMember member1, PsiMember member) {
        if (member instanceof PsiMethod && member1 instanceof PsiMethod) {
            return MethodSignatureUtil.areSignaturesEqual((PsiMethod)((PsiMethod)member), (PsiMethod)((PsiMethod)member1));
        }
        if (member instanceof PsiField && member1 instanceof PsiField || member instanceof PsiClass && member1 instanceof PsiClass) {
            return member.getName().equals(member1.getName());
        }
        return false;
    }

    protected void buildSubClassesMap(PsiClass aClass) {
        this.buildSubClassesMap(aClass, new HashSet<PsiClass>());
    }

    private void buildSubClassesMap(PsiClass aClass, Set<PsiClass> visited) {
        PsiReferenceList implementsList;
        PsiReferenceList extendsList = aClass.getExtendsList();
        if (extendsList != null) {
            this.buildSubClassesMapForList(aClass, visited, extendsList.getReferencedTypes());
        }
        if ((implementsList = aClass.getImplementsList()) != null) {
            this.buildSubClassesMapForList(aClass, visited, implementsList.getReferencedTypes());
        }
        if (aClass instanceof PsiAnonymousClass) {
            this.buildSubClassesMapForList(aClass, visited, ((PsiAnonymousClass)aClass).getBaseClassType());
        }
    }

    private void buildSubClassesMapForList(PsiClass aClass, Set<PsiClass> processed, PsiClassType ... classesList) {
        for (PsiClassType element : classesList) {
            PsiClass resolved = element.resolve();
            if (resolved == null || !processed.add(resolved)) continue;
            this.getSubclasses((PsiElement)resolved).add(aClass);
            this.buildSubClassesMap(resolved, processed);
        }
    }
}

