/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.util.occurrences;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.FindResult;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.IntroduceVariableUtil;
import com.intellij.refactoring.util.occurrences.BaseOccurrenceManager;
import com.intellij.refactoring.util.occurrences.OccurrenceFilter;
import com.intellij.util.CommonJavaRefactoringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class ExpressionOccurrenceManager
extends BaseOccurrenceManager {
    private final PsiExpression myMainOccurence;
    private final PsiElement myScope;
    private final boolean myMaintainStaticContext;

    public ExpressionOccurrenceManager(PsiExpression mainOccurence, PsiElement scope, OccurrenceFilter filter) {
        this(mainOccurence, scope, filter, false);
    }

    public ExpressionOccurrenceManager(PsiExpression mainOccurence, PsiElement scope, OccurrenceFilter filter, boolean maintainStaticContext) {
        super(filter);
        this.myMainOccurence = mainOccurence;
        this.myScope = scope;
        this.myMaintainStaticContext = maintainStaticContext;
    }

    @Override
    protected PsiExpression @NotNull [] defaultOccurrences() {
        PsiExpression[] psiExpressionArray = new PsiExpression[]{this.myMainOccurence};
        if (psiExpressionArray == null) {
            ExpressionOccurrenceManager.$$$reportNull$$$0(0);
        }
        return psiExpressionArray;
    }

    public PsiExpression getMainOccurence() {
        return this.myMainOccurence;
    }

    @Override
    protected PsiExpression @NotNull [] findOccurrences() {
        if ("null".equals(this.myMainOccurence.getText())) {
            PsiExpression[] psiExpressionArray = this.defaultOccurrences();
            if (psiExpressionArray == null) {
                ExpressionOccurrenceManager.$$$reportNull$$$0(1);
            }
            return psiExpressionArray;
        }
        if (this.myFilter != null && !this.myFilter.isOK(this.myMainOccurence)) {
            PsiExpression[] psiExpressionArray = this.defaultOccurrences();
            if (psiExpressionArray == null) {
                ExpressionOccurrenceManager.$$$reportNull$$$0(2);
            }
            return psiExpressionArray;
        }
        PsiExpression[] expressionOccurrences = this.findExpressionOccurrences();
        PsiClass scopeClass = (PsiClass)PsiTreeUtil.getNonStrictParentOfType((PsiElement)this.myScope, (Class[])new Class[]{PsiClass.class});
        if (this.myMaintainStaticContext && expressionOccurrences.length > 1 && !CommonJavaRefactoringUtil.isInStaticContext((PsiElement)this.myMainOccurence, (PsiClass)scopeClass)) {
            ArrayList<PsiExpression> expressions = new ArrayList<PsiExpression>(Arrays.asList(expressionOccurrences));
            expressions.removeIf(expression -> CommonJavaRefactoringUtil.isInStaticContext((PsiElement)expression, (PsiClass)scopeClass));
            PsiExpression[] psiExpressionArray = expressions.toArray(PsiExpression.EMPTY_ARRAY);
            if (psiExpressionArray == null) {
                ExpressionOccurrenceManager.$$$reportNull$$$0(3);
            }
            return psiExpressionArray;
        }
        if (expressionOccurrences == null) {
            ExpressionOccurrenceManager.$$$reportNull$$$0(4);
        }
        return expressionOccurrences;
    }

    public PsiElement getScope() {
        return this.myScope;
    }

    public PsiExpression @NotNull [] findExpressionOccurrences() {
        if (this.myMainOccurence instanceof PsiLiteralExpression && !this.myMainOccurence.isPhysical()) {
            FindManager findManager = FindManager.getInstance((Project)this.getScope().getProject());
            FindModel findModel = findManager.getFindInFileModel().clone();
            findModel.setCaseSensitive(true);
            findModel.setRegularExpressions(false);
            String value = StringUtil.unquoteString((String)this.myMainOccurence.getText());
            if (!value.isEmpty()) {
                findModel.setStringToFind(value);
                ArrayList<PsiExpression> results = new ArrayList<PsiExpression>();
                PsiFile file = this.getScope().getContainingFile();
                String text = this.getScope().getText();
                int offset = this.getScope().getTextRange().getStartOffset();
                FindResult result = findManager.findString((CharSequence)text, 0, findModel);
                HashSet<PsiLiteralExpression> literals = new HashSet<PsiLiteralExpression>();
                while (result.isStringFound()) {
                    PsiExpression expression;
                    int startOffset = offset + result.getStartOffset();
                    int endOffset = result.getEndOffset();
                    PsiLiteralExpression literalExpression = (PsiLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(startOffset), PsiLiteralExpression.class);
                    if (literalExpression != null && !literals.contains(literalExpression) && (expression = IntroduceVariableUtil.getSelectedExpression((Project)file.getProject(), (PsiFile)file, (int)startOffset, (int)(offset + endOffset))) != null && IntroduceVariableUtil.getErrorMessage((PsiExpression)expression) == null) {
                        results.add(expression);
                        literals.add(literalExpression);
                    }
                    result = findManager.findString((CharSequence)text, endOffset, findModel);
                }
                PsiExpression[] psiExpressionArray = results.toArray(PsiExpression.EMPTY_ARRAY);
                if (psiExpressionArray == null) {
                    ExpressionOccurrenceManager.$$$reportNull$$$0(5);
                }
                return psiExpressionArray;
            }
        }
        PsiExpression[] psiExpressionArray = CodeInsightUtil.findExpressionOccurrences((PsiElement)this.myScope, (PsiExpression)this.myMainOccurence);
        if (psiExpressionArray == null) {
            ExpressionOccurrenceManager.$$$reportNull$$$0(6);
        }
        return psiExpressionArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/refactoring/util/occurrences/ExpressionOccurrenceManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultOccurrences";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findOccurrences";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findExpressionOccurrences";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

