/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.serialization.compiler.fir.checkers;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirAnonymousFunctionExpression;
import org.jetbrains.kotlin.fir.expressions.FirArgumentList;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.impl.FirResolvedArgumentList;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlinx.serialization.compiler.fir.checkers.FirSerializationErrors;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0002H\u0016R\u00020\u000fR\u00020\u0011j\u0006\u0010\u0010\u001a\u00020\u000fj\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0002H\u0002J\u0010\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u001dH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/kotlinx/serialization/compiler/fir/checkers/FirSerializationPluginCallChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "<init>", "()V", "jsonCallableId", "Lorg/jetbrains/kotlin/name/CallableId;", "jsonDefaultClassId", "Lorg/jetbrains/kotlin/name/ClassId;", "parameterNameFrom", "Lorg/jetbrains/kotlin/name/Name;", "parameterNameBuilderAction", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)V", "isJsonFormatCreation", "", "function", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "isDefaultFormat", "functionCall", "isDefaultFormatArgument", "argumentExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "isEmptyFunctionArgument", "argument", "kotlinx-serialization-compiler-plugin.k2"})
@SourceDebugExtension(value={"SMAP\nFirSerializationPluginCallChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirSerializationPluginCallChecker.kt\norg/jetbrains/kotlinx/serialization/compiler/fir/checkers/FirSerializationPluginCallChecker\n+ 2 FirExpressionUtil.kt\norg/jetbrains/kotlin/fir/expressions/FirExpressionUtilKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,89:1\n72#2,4:90\n221#3,2:94\n*S KotlinDebug\n*F\n+ 1 FirSerializationPluginCallChecker.kt\norg/jetbrains/kotlinx/serialization/compiler/fir/checkers/FirSerializationPluginCallChecker\n*L\n63#1:90,4\n63#1:94,2\n*E\n"})
public final class FirSerializationPluginCallChecker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final FirSerializationPluginCallChecker INSTANCE = new FirSerializationPluginCallChecker();
    @NotNull
    private static final CallableId jsonCallableId;
    @NotNull
    private static final ClassId jsonDefaultClassId;
    @NotNull
    private static final Name parameterNameFrom;
    @NotNull
    private static final Name parameterNameBuilderAction;

    private FirSerializationPluginCallChecker() {
        super(MppCheckerKind.Common);
    }

    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirFunctionCall expression) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        FirBasedSymbol firBasedSymbol = FirReferenceUtilsKt.getSymbol((FirReference)((FirReference)expression.getCalleeReference()));
        FirNamedFunctionSymbol firNamedFunctionSymbol = firBasedSymbol instanceof FirNamedFunctionSymbol ? (FirNamedFunctionSymbol)firBasedSymbol : null;
        if (firNamedFunctionSymbol == null) {
            return;
        }
        FirNamedFunctionSymbol function = firNamedFunctionSymbol;
        if (!this.isJsonFormatCreation(function)) {
            return;
        }
        if (this.isDefaultFormat(expression)) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)((DiagnosticContext)context), (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)expression.getSource()), (KtDiagnosticFactory0)FirSerializationErrors.INSTANCE.getJSON_FORMAT_REDUNDANT_DEFAULT(), null, (int)8, null);
        } else {
            Object object = CollectionsKt.getOrNull((List)context.getCallsOrAssignments(), (int)(context.getCallsOrAssignments().size() - 2));
            FirFunctionCall firFunctionCall = object instanceof FirFunctionCall ? (FirFunctionCall)object : null;
            if (firFunctionCall == null) {
                return;
            }
            FirFunctionCall parentCall = firFunctionCall;
            if (parentCall.getExplicitReceiver() != expression) {
                return;
            }
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)((DiagnosticContext)context), (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)expression.getSource()), (KtDiagnosticFactory0)FirSerializationErrors.INSTANCE.getJSON_FORMAT_REDUNDANT(), null, (int)8, null);
        }
    }

    private final boolean isJsonFormatCreation(FirNamedFunctionSymbol function) {
        return Intrinsics.areEqual((Object)function.getCallableId(), (Object)jsonCallableId);
    }

    private final boolean isDefaultFormat(FirFunctionCall functionCall) {
        boolean emptyBuilder;
        boolean defaultFrom;
        block2: {
            defaultFrom = false;
            defaultFrom = true;
            emptyBuilder = false;
            FirCall $this$resolvedArgumentMapping$iv = (FirCall)functionCall;
            boolean $i$f$getResolvedArgumentMapping = false;
            FirArgumentList argumentList$iv = $this$resolvedArgumentMapping$iv.getArgumentList();
            LinkedHashMap linkedHashMap = argumentList$iv instanceof FirResolvedArgumentList ? ((FirResolvedArgumentList)argumentList$iv).getMapping() : null;
            if (linkedHashMap == null) break block2;
            Map $this$forEach$iv = linkedHashMap;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv;
                Map.Entry entry = element$iv = iterator.next();
                boolean bl = false;
                FirExpression argumentExpression = (FirExpression)entry.getKey();
                FirValueParameter parameter = (FirValueParameter)entry.getValue();
                Name name = parameter.getName();
                if (Intrinsics.areEqual((Object)name, (Object)parameterNameFrom)) {
                    defaultFrom = INSTANCE.isDefaultFormatArgument(argumentExpression);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)name, (Object)parameterNameBuilderAction)) continue;
                emptyBuilder = INSTANCE.isEmptyFunctionArgument(argumentExpression);
            }
        }
        return defaultFrom && emptyBuilder;
    }

    private final boolean isDefaultFormatArgument(FirExpression argumentExpression) {
        ConeKotlinType coneKotlinType = FirTypeUtilsKt.getResolvedType((FirExpression)argumentExpression);
        ConeClassLikeType coneClassLikeType = coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
        if (coneClassLikeType == null) {
            return false;
        }
        ConeClassLikeType typeRef = coneClassLikeType;
        return Intrinsics.areEqual((Object)typeRef.getLookupTag().getClassId(), (Object)jsonDefaultClassId);
    }

    private final boolean isEmptyFunctionArgument(FirExpression argument) {
        FirStatement firStatement;
        FirAnonymousFunctionExpression firAnonymousFunctionExpression = argument instanceof FirAnonymousFunctionExpression ? (FirAnonymousFunctionExpression)argument : null;
        if (firAnonymousFunctionExpression == null || (firAnonymousFunctionExpression = firAnonymousFunctionExpression.getAnonymousFunction()) == null || (firAnonymousFunctionExpression = firAnonymousFunctionExpression.getBody()) == null) {
            return false;
        }
        FirAnonymousFunctionExpression lambdaArgument = firAnonymousFunctionExpression;
        return lambdaArgument.getStatements().isEmpty() || Intrinsics.areEqual((Object)((firStatement = (FirStatement)CollectionsKt.singleOrNull((List)lambdaArgument.getStatements())) != null && (firStatement = firStatement.getSource()) != null ? firStatement.getKind() : null), (Object)KtFakeSourceElementKind.ImplicitReturn.FromExpressionBody.INSTANCE);
    }

    static {
        FqName fqName = new FqName("kotlinx.serialization.json");
        Name name = Name.identifier((String)"Json");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
        jsonCallableId = new CallableId(fqName, name);
        jsonDefaultClassId = ClassId.Companion.fromString$default((ClassId.Companion)ClassId.Companion, (String)"kotlinx/serialization/json/Json.Default", (boolean)false, (int)2, null);
        Name name2 = Name.identifier((String)"from");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        parameterNameFrom = name2;
        Name name3 = Name.identifier((String)"builderAction");
        Intrinsics.checkNotNullExpressionValue((Object)name3, (String)"identifier(...)");
        parameterNameBuilderAction = name3;
    }
}

