/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.util;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.LocalPtyOptions;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.sudo.SudoCommandProvider;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.platform.eel.EelExecApi;
import com.intellij.platform.eel.EelExecApiHelpers;
import com.intellij.platform.eel.EelExecApiHelpersKt;
import com.intellij.platform.eel.EelProcess;
import com.intellij.platform.eel.path.EelPath;
import com.intellij.platform.eel.provider.EelNioBridgeServiceKt;
import com.intellij.platform.eel.provider.LocalEelDescriptor;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.io.IdeUtilIoBundle;
import com.intellij.util.io.SuperUserStatus;
import com.intellij.util.system.OS;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\n2\u0014\u0010\u0016\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0017H\u0007J/\u0010\u0018\u001a\u00020\u00192\u000b\u0010\u001a\u001a\u00070\n\u00a2\u0006\u0002\b\u000b2\u000b\u0010\u001b\u001a\u00070\n\u00a2\u0006\u0002\b\u000b2\u000b\u0010\u001c\u001a\u00070\n\u00a2\u0006\u0002\b\u000bH\u0007J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0007J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0007J\u0018\u0010\u001d\u001a\u00020\n2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010#\u001a\u00020\nH\u0007J\u0012\u0010$\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001f\u001a\u00020 H\u0007J\u001d\u0010%\u001a\u00020&2\u0006\u0010\u001f\u001a\u00020 2\u000b\u0010'\u001a\u00070\n\u00a2\u0006\u0002\b(H\u0007J\u001d\u0010)\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020 2\u000b\u0010'\u001a\u00070\n\u00a2\u0006\u0002\b(H\u0007J\u001d\u0010*\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u000b\u0010'\u001a\u00070\n\u00a2\u0006\u0002\b(H\u0007J\u001a\u0010+\u001a\u00070\n\u00a2\u0006\u0002\b\u000b2\u0006\u0010,\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b-J\b\u0010.\u001a\u00020\bH\u0007J'\u0010/\u001a\r\u0012\t\u0012\u00070\n\u00a2\u0006\u0002\b\u000b002\n\b\u0001\u00101\u001a\u0004\u0018\u00010\n2\u0006\u00102\u001a\u00020\nH\u0007J&\u00103\u001a\u00020&*\u0002042\u0006\u00105\u001a\u0002062\b\u00107\u001a\u0004\u0018\u0001082\u0006\u00109\u001a\u00020\bH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\f\u0010\u0003\u001a\u0004\b\r\u0010\u000eR\u001f\u0010\u000f\u001a\u00070\n\u00a2\u0006\u0002\b\u000b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0010\u0010\u0003\u001a\u0004\b\u0011\u0010\u000e\u00a8\u0006:"}, d2={"Lcom/intellij/execution/util/ExecUtil;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "hasSupportedTerminals", "Lkotlin/Lazy;", "", "osascriptPath", "", "Lcom/intellij/openapi/util/NlsSafe;", "getOsascriptPath$annotations", "getOsascriptPath", "()Ljava/lang/String;", "openCommandPath", "getOpenCommandPath$annotations", "getOpenCommandPath", "loadTemplate", "loader", "Ljava/lang/ClassLoader;", "templateName", "variables", "", "createTempExecutableScript", "Ljava/io/File;", "prefix", "suffix", "content", "execAndGetOutput", "Lcom/intellij/execution/process/ProcessOutput;", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "timeoutInMilliseconds", "", "stdin", "execAndReadLine", "sudo", "Ljava/lang/Process;", "prompt", "Lorg/jetbrains/annotations/Nls;", "sudoCommand", "sudoAndGetOutput", "escapeAppleScriptArgument", "arg", "escapeAppleScriptArgument$intellij_platform_ide_util_io", "hasTerminalApp", "getTerminalCommand", "", "title", "command", "startProcessBlockingUsingEel", "Lcom/intellij/platform/eel/EelExecApi;", "builder", "Ljava/lang/ProcessBuilder;", "pty", "Lcom/intellij/execution/process/LocalPtyOptions;", "isPassParentEnvironment", "intellij.platform.ide.util.io"})
@SourceDebugExtension(value={"SMAP\nExecUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExecUtil.kt\ncom/intellij/execution/util/ExecUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,239:1\n1#2:240\n13#3:241\n13#3:242\n*S KotlinDebug\n*F\n+ 1 ExecUtil.kt\ncom/intellij/execution/util/ExecUtil\n*L\n116#1:241\n33#1:242\n*E\n"})
public final class ExecUtil {
    @NotNull
    public static final ExecUtil INSTANCE = new ExecUtil();
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Lazy<Boolean> hasSupportedTerminals;

    private ExecUtil() {
    }

    @NotNull
    public static final String getOsascriptPath() {
        return "/usr/bin/osascript";
    }

    @JvmStatic
    public static /* synthetic */ void getOsascriptPath$annotations() {
    }

    @NotNull
    public static final String getOpenCommandPath() {
        return "/usr/bin/open";
    }

    @JvmStatic
    public static /* synthetic */ void getOpenCommandPath$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final String loadTemplate(@NotNull ClassLoader loader, @NotNull String templateName, @Nullable Map<String, String> variables) throws IOException {
        String string;
        Intrinsics.checkNotNullParameter((Object)loader, (String)"loader");
        Intrinsics.checkNotNullParameter((Object)templateName, (String)"templateName");
        InputStream inputStream = loader.getResourceAsStream(templateName);
        if (inputStream == null) {
            throw new IOException("Template '" + templateName + "' not found by " + loader);
        }
        InputStream stream = inputStream;
        Object object2 = stream;
        Object object3 = null;
        try {
            InputStream object4 = (InputStream)object2;
            boolean bl = false;
            byte[] byArray = object4.readAllBytes();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"readAllBytes(...)");
            string = StringsKt.decodeToString((byte[])byArray);
        }
        catch (Throwable bl) {
            object3 = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
        }
        String template = string;
        object2 = variables;
        if (object2 == null || object2.isEmpty()) {
            return template;
        }
        StringBuilder buffer = new StringBuilder(template);
        for (Map.Entry entry : variables.entrySet()) {
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            int pos = buffer.indexOf(name);
            if (pos < 0) continue;
            buffer.replace(pos, pos + name.length(), value);
        }
        String string2 = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    @JvmStatic
    @NotNull
    public static final File createTempExecutableScript(@NotNull String prefix, @NotNull String suffix, @NotNull String content) throws IOException, ExecutionException {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        File tempDir = new File(PathManager.getTempPath());
        File file = FileUtil.createTempFile((File)tempDir, (String)prefix, (String)suffix, (boolean)true, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(...)");
        File tempFile = file;
        byte[] byArray = content.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        FileUtil.writeToFile((File)tempFile, (byte[])byArray);
        if (!tempFile.setExecutable(true, true)) {
            Object[] objectArray = new Object[]{tempFile};
            throw new ExecutionException(IdeUtilIoBundle.message("dialog.message.failed.to.make.temp.file.executable", objectArray));
        }
        return tempFile;
    }

    @JvmStatic
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static final ProcessOutput execAndGetOutput(@NotNull GeneralCommandLine commandLine) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        ProcessOutput processOutput = new CapturingProcessHandler(commandLine).runProcess();
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"runProcess(...)");
        return processOutput;
    }

    @JvmStatic
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static final ProcessOutput execAndGetOutput(@NotNull GeneralCommandLine commandLine, int timeoutInMilliseconds) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        ProcessOutput processOutput = new CapturingProcessHandler(commandLine).runProcess(timeoutInMilliseconds);
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"runProcess(...)");
        return processOutput;
    }

    @JvmStatic
    @RequiresBackgroundThread(generateAssertion=false)
    @NotNull
    public static final String execAndGetOutput(@NotNull GeneralCommandLine commandLine, @NotNull String stdin) {
        CapturingProcessHandler capturingProcessHandler;
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)stdin, (String)"stdin");
        CapturingProcessHandler $this$execAndGetOutput_u24lambda_u240 = capturingProcessHandler = new CapturingProcessHandler(commandLine);
        boolean bl = false;
        $this$execAndGetOutput_u24lambda_u240.addProcessListener(new ProcessListener($this$execAndGetOutput_u24lambda_u240, commandLine, stdin){
            final /* synthetic */ CapturingProcessHandler $this_apply;
            final /* synthetic */ GeneralCommandLine $commandLine;
            final /* synthetic */ String $stdin;
            {
                this.$this_apply = $this_apply;
                this.$commandLine = $commandLine;
                this.$stdin = $stdin;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void startNotified(ProcessEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                OutputStream outputStream = this.$this_apply.getProcessInput();
                Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"getProcessInput(...)");
                Closeable closeable = outputStream;
                Charset charset = this.$commandLine.getCharset();
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"getCharset(...)");
                Object object = charset;
                closeable = new OutputStreamWriter((OutputStream)closeable, (Charset)object);
                object = this.$stdin;
                Throwable throwable = null;
                try {
                    OutputStreamWriter it = (OutputStreamWriter)closeable;
                    boolean bl = false;
                    it.write((String)object);
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        });
        String string = capturingProcessHandler.runProcess().getStdout();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStdout(...)");
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    @RequiresBackgroundThread(generateAssertion=false)
    @Nullable
    public static final String execAndReadLine(@NotNull GeneralCommandLine commandLine) {
        String string;
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        try {
            String string2;
            Process process = commandLine.createProcess();
            Intrinsics.checkNotNullExpressionValue((Object)process, (String)"createProcess(...)");
            Process process2 = process;
            Closeable closeable = new BufferedReader(new InputStreamReader(process2.getInputStream(), commandLine.getCharset()));
            Throwable throwable = null;
            try {
                BufferedReader it = (BufferedReader)closeable;
                boolean bl = false;
                string2 = it.readLine();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            string = string2;
        }
        catch (ExecutionException e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(ExecUtil.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.debug((Throwable)e);
            string = null;
        }
        return string;
    }

    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final Process sudo(@NotNull GeneralCommandLine commandLine, @NotNull String prompt) throws ExecutionException, IOException {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        Process process = ExecUtil.sudoCommand(commandLine, prompt).createProcess();
        Intrinsics.checkNotNullExpressionValue((Object)process, (String)"createProcess(...)");
        return process;
    }

    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final GeneralCommandLine sudoCommand(@NotNull GeneralCommandLine commandLine, @NotNull String prompt) throws ExecutionException, IOException {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        if (SuperUserStatus.isSuperUser()) {
            return commandLine;
        }
        GeneralCommandLine generalCommandLine = SudoCommandProvider.Companion.getInstance().sudoCommand(commandLine, prompt);
        if (generalCommandLine == null) {
            throw new UnsupportedOperationException("Cannot `sudo` on this system - no suitable utils found");
        }
        GeneralCommandLine sudoCommandLine = generalCommandLine;
        GeneralCommandLine generalCommandLine2 = sudoCommandLine.withWorkingDirectory(commandLine.getWorkingDirectory()).withEnvironment(commandLine.getEnvironment()).withParentEnvironmentType(commandLine.getParentEnvironmentType()).withRedirectErrorStream(commandLine.isRedirectErrorStream());
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine2, (String)"withRedirectErrorStream(...)");
        return generalCommandLine2;
    }

    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final ProcessOutput sudoAndGetOutput(@NotNull GeneralCommandLine commandLine, @NotNull String prompt) throws IOException, ExecutionException {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        return ExecUtil.execAndGetOutput(ExecUtil.sudoCommand(commandLine, prompt));
    }

    @NotNull
    public final String escapeAppleScriptArgument$intellij_platform_ide_util_io(@NotNull String arg) {
        Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
        return Intrinsics.areEqual((Object)arg, (Object)"&&") ? "\"" + arg + "\"" : "quoted form of \"" + StringsKt.replace$default((String)StringsKt.replace$default((String)arg, (String)"\"", (String)"\\\"", (boolean)false, (int)4, null), (String)"\\", (String)"\\\\", (boolean)false, (int)4, null) + "\"";
    }

    @JvmStatic
    @ApiStatus.Internal
    public static final boolean hasTerminalApp() {
        return OS.CURRENT == OS.Windows || OS.CURRENT == OS.macOS || (Boolean)hasSupportedTerminals.getValue() != false;
    }

    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final List<String> getTerminalCommand(@Nls(capitalization=Nls.Capitalization.Title) @Nullable String title, @NotNull String command) {
        List list;
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        if (OS.CURRENT == OS.Windows) {
            Object[] objectArray = new String[5];
            Intrinsics.checkNotNullExpressionValue((Object)CommandLineUtil.getWinShellName(), (String)"getWinShellName(...)");
            objectArray[1] = "/c";
            objectArray[2] = "start";
            String string = title;
            if (string == null || (string = StringsKt.replace$default((String)string, (char)'\"', (char)'\'', (boolean)false, (int)4, null)) == null) {
                string = "";
            }
            Intrinsics.checkNotNullExpressionValue((Object)GeneralCommandLine.inescapableQuote(string), (String)"inescapableQuote(...)");
            objectArray[4] = command;
            list = CollectionsKt.listOf((Object[])objectArray);
        } else if (OS.CURRENT == OS.macOS) {
            String string = title;
            String prefix = string != null ? "\"echo -n \" & " + INSTANCE.escapeAppleScriptArgument$intellij_platform_ide_util_io("\\0033]0;" + string + "\\007") + " & \" ; \" & " : "";
            String script = prefix + "\"clear ; exec \" & " + INSTANCE.escapeAppleScriptArgument$intellij_platform_ide_util_io(command);
            Object[] objectArray = new String[]{ExecUtil.getOsascriptPath(), "-e", StringsKt.trimMargin$default((String)("\n          |tell application \"Terminal\"\n          |  activate\n          |  do script " + script + "\n          |end tell\n          "), null, (int)1, null)};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else if (PathEnvironmentVariableUtil.isOnPath("konsole")) {
            if (title != null) {
                Object[] objectArray = new String[]{"konsole", "-p", "tabtitle=\"" + StringsKt.replace$default((String)title, (char)'\"', (char)'\'', (boolean)false, (int)4, null) + "\"", "-e", command};
                list = CollectionsKt.listOf((Object[])objectArray);
            } else {
                Object[] objectArray = new String[]{"konsole", "-e", command};
                list = CollectionsKt.listOf((Object[])objectArray);
            }
        } else if (PathEnvironmentVariableUtil.isOnPath("gnome-terminal")) {
            if (title != null) {
                Object[] objectArray = new String[]{"gnome-terminal", "-t", title, "-x", command};
                list = CollectionsKt.listOf((Object[])objectArray);
            } else {
                Object[] objectArray = new String[]{"gnome-terminal", "-x", command};
                list = CollectionsKt.listOf((Object[])objectArray);
            }
        } else if (PathEnvironmentVariableUtil.isOnPath("urxvt")) {
            if (title != null) {
                Object[] objectArray = new String[]{"urxvt", "-title", title, "-e", command};
                list = CollectionsKt.listOf((Object[])objectArray);
            } else {
                Object[] objectArray = new String[]{"urxvt", "-e", command};
                list = CollectionsKt.listOf((Object[])objectArray);
            }
        } else if (PathEnvironmentVariableUtil.isOnPath("xterm")) {
            if (title != null) {
                Object[] objectArray = new String[]{"xterm", "-T", title, "-e", command};
                list = CollectionsKt.listOf((Object[])objectArray);
            } else {
                Object[] objectArray = new String[]{"xterm", "-e", command};
                list = CollectionsKt.listOf((Object[])objectArray);
            }
        } else {
            throw new UnsupportedOperationException("Unsupported OS/desktop: " + OS.CURRENT.name() + "/" + System.getenv("XDG_CURRENT_DESKTOP"));
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final Process startProcessBlockingUsingEel(@NotNull EelExecApi $this$startProcessBlockingUsingEel, @NotNull ProcessBuilder builder, @Nullable LocalPtyOptions pty, boolean isPassParentEnvironment) {
        EelExecApi.Pty pty2;
        EelPath workingDir;
        Object $this$startProcessBlockingUsingEel_u24lambda_u240_u240;
        Intrinsics.checkNotNullParameter((Object)$this$startProcessBlockingUsingEel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        List<String> args = builder.command();
        Intrinsics.checkNotNull(args);
        String exe = (String)CollectionsKt.first(args);
        boolean bl = false;
        Object object = $this$startProcessBlockingUsingEel;
        try {
            $this$startProcessBlockingUsingEel_u24lambda_u240_u240 = object;
            boolean bl2 = false;
            Path path = Path.of(exe, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"of(...)");
            $this$startProcessBlockingUsingEel_u24lambda_u240_u240 = Result.constructor-impl((Object)EelNioBridgeServiceKt.asEelPath((Path)path).toString());
        }
        catch (Throwable bl2) {
            $this$startProcessBlockingUsingEel_u24lambda_u240_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl2));
        }
        object = $this$startProcessBlockingUsingEel_u24lambda_u240_u240;
        String string = (String)(Result.isFailure-impl((Object)object) ? null : object);
        if (string == null) {
            string = exe;
        }
        String exe2 = string;
        List<String> rest = args.subList(1, args.size());
        Map map = isPassParentEnvironment ? (Map)CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Map<String, ? extends String>>, Object>($this$startProcessBlockingUsingEel, null){
            int label;
            final /* synthetic */ EelExecApi $this_startProcessBlockingUsingEel;
            {
                this.$this_startProcessBlockingUsingEel = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = EelExecApiHelpersKt.environmentVariables((EelExecApi)this.$this_startProcessBlockingUsingEel).eelIt((Continuation)this);
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        this.label = 2;
                        v1 = ((EelExecApi.EnvironmentVariablesDeferred)v0).await((Continuation)this);
                        if (v1 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl21
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl21:
                        // 2 sources

                        return v1;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Map<String, String>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        })) : MapsKt.emptyMap();
        Map<String, String> map2 = builder.environment();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"environment(...)");
        Map env2 = MapsKt.plus((Map)map, map2);
        Comparable<File> comparable = builder.directory();
        EelPath eelPath = comparable != null && (comparable = comparable.toPath()) != null ? EelNioBridgeServiceKt.asEelPath((Path)comparable) : (workingDir = null);
        if ($this$startProcessBlockingUsingEel.getDescriptor() != LocalEelDescriptor.INSTANCE) {
            for (String arg : rest) {
                String eelPath2;
                Object object2;
                Path path;
                Object object3;
                Object object4 = $this$startProcessBlockingUsingEel;
                try {
                    EelExecApi $this$startProcessBlockingUsingEel_u24lambda_u241 = object4;
                    boolean bl3 = false;
                    object3 = Result.constructor-impl((Object)Path.of(arg, new String[0]));
                }
                catch (Throwable bl3) {
                    object3 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl3));
                }
                if ((Path)(Result.isFailure-impl((Object)(object4 = object3)) ? null : object4) == null || !path.isAbsolute()) continue;
                object3 = $this$startProcessBlockingUsingEel;
                try {
                    Object $this$startProcessBlockingUsingEel_u24lambda_u242 = object3;
                    boolean bl4 = false;
                    object2 = Result.constructor-impl((Object)EelNioBridgeServiceKt.asEelPath((Path)path).toString());
                }
                catch (Throwable throwable) {
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                if ((String)(Result.isFailure-impl((Object)(object3 = object2)) ? null : object3) == null || Intrinsics.areEqual((Object)arg, (Object)eelPath2)) continue;
                logger.warn("Argument '" + arg + "' is not normalized for remote EEL execution, expected '" + eelPath2 + "'");
            }
        }
        Intrinsics.checkNotNull((Object)exe2);
        EelExecApiHelpers.SpawnProcess spawnProcess = EelExecApiHelpersKt.spawnProcess((EelExecApi)$this$startProcessBlockingUsingEel, (String)exe2).args(rest).workingDirectory(workingDir).env(env2);
        LocalPtyOptions localPtyOptions = pty;
        if (localPtyOptions != null) {
            void $this$startProcessBlockingUsingEel_u24lambda_u243;
            LocalPtyOptions path = localPtyOptions;
            EelExecApiHelpers.SpawnProcess spawnProcess2 = spawnProcess;
            boolean bl5 = false;
            pty2 = new EelExecApi.Pty($this$startProcessBlockingUsingEel_u24lambda_u243.getInitialColumns(), $this$startProcessBlockingUsingEel_u24lambda_u243.getInitialRows(), !$this$startProcessBlockingUsingEel_u24lambda_u243.getConsoleMode());
            spawnProcess = spawnProcess2;
        } else {
            pty2 = null;
        }
        EelExecApiHelpers.SpawnProcess options = spawnProcess.interactionOptions((EelExecApi.InteractionOptions)pty2);
        return (Process)CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Process>, Object>(options, null){
            int label;
            final /* synthetic */ EelExecApiHelpers.SpawnProcess $options;
            {
                this.$options = $options;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = this.$options.eelIt((Continuation)this);
                        if (object2 != object) return ((EelProcess)object2).convertToJavaProcess();
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return ((EelProcess)object2).convertToJavaProcess();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Process> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    private static final boolean hasSupportedTerminals$lambda$0() {
        return PathEnvironmentVariableUtil.isOnPath("konsole") || PathEnvironmentVariableUtil.isOnPath("gnome-terminal") || PathEnvironmentVariableUtil.isOnPath("urxvt") || PathEnvironmentVariableUtil.isOnPath("xterm");
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ExecUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        ExecUtil.logger = logger;
        hasSupportedTerminals = LazyKt.lazy(ExecUtil::hasSupportedTerminals$lambda$0);
    }
}

