/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LocalFileUrl;
import com.intellij.util.Url;
import com.intellij.util.UrlImpl;
import com.intellij.util.UrlsKt;
import com.intellij.util.io.URLUtil;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\b\u0007\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0007J0\u0010\t\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\n\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\u000b\u001a\u0004\u0018\u00010\u0007H\u0007J6\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\rH\u0007J*\u0010\u000e\u001a\u00020\u000f2\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\r2\n\u0010\u0010\u001a\u00060\u0011j\u0002`\u0012H\u0007J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007H\u0007J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0007H\u0007J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0017\u001a\u00020\u0007H\u0007J\u001a\u0010\u0019\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0007J$\u0010\u0019\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\f\u001a\u0004\u0018\u00010\u0007H\u0007J\"\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0007J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u001bH\u0007J\u0012\u0010\u001c\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0017\u001a\u00020\u001bH\u0007J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0007J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0017\u001a\u00020\u0007H\u0007J\u0012\u0010\"\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0017\u001a\u00020\u001bH\u0002J\u0010\u0010#\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0010\u0010$\u001a\u00020\u00052\u0006\u0010%\u001a\u00020\u0007H\u0007J(\u0010&\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u00052\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00050(2\b\b\u0002\u0010)\u001a\u00020\u001fH\u0007J\u0016\u0010&\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015J*\u0010*\u001a\u00020\u001f2\b\u0010+\u001a\u0004\u0018\u00010\u00052\b\u0010,\u001a\u0004\u0018\u00010\u00052\u0006\u0010)\u001a\u00020\u001f2\u0006\u0010-\u001a\u00020\u001fJ\u0010\u0010.\u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u0005H\u0007\u00a8\u0006/"}, d2={"Lcom/intellij/util/Urls;", "", "<init>", "()V", "newUri", "Lcom/intellij/util/Url;", "scheme", "", "path", "newUrl", "authority", "rawParameters", "parameters", "", "encodeParameters", "", "result", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "newLocalFileUrl", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "newFromEncoded", "url", "parseEncoded", "newHttpUrl", "newFromIdea", "", "parseFromIdea", "parse", "asLocalIfNoScheme", "", "parseAsJavaUriWithoutParameters", "Ljava/net/URI;", "parseUrl", "newFromVirtualFile", "newUnparsable", "string", "equalsIgnoreParameters", "urls", "", "caseSensitive", "equals", "url1", "url2", "ignoreParameters", "toUriWithoutParameters", "intellij.platform.ide.util.io"})
@NonNls
@SourceDebugExtension(value={"SMAP\nUrls.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Urls.kt\ncom/intellij/util/Urls\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,196:1\n13#2:197\n1#3:198\n1807#4,3:199\n*S KotlinDebug\n*F\n+ 1 Urls.kt\ncom/intellij/util/Urls\n*L\n116#1:197\n162#1:199,3\n*E\n"})
public final class Urls {
    @NotNull
    public static final Urls INSTANCE = new Urls();

    private Urls() {
    }

    @JvmStatic
    @NotNull
    public static final Url newUri(@Nullable String scheme, @NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new UrlImpl(scheme, null, path);
    }

    @JvmStatic
    @NotNull
    public static final Url newUrl(@Nullable String scheme, @Nullable String authority, @Nullable String path, @Nullable String rawParameters) {
        return new UrlImpl(scheme, authority, path, rawParameters);
    }

    @JvmStatic
    @NotNull
    public static final Url newUrl(@NotNull String scheme, @NotNull String authority, @NotNull String path, @NotNull Map<String, String> parameters) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        if (!parameters.isEmpty()) {
            StringBuilder result = new StringBuilder().append('?');
            Intrinsics.checkNotNull((Object)result);
            Urls.encodeParameters(parameters, result);
            return new UrlImpl(scheme, authority, path, result.toString());
        }
        return new UrlImpl(scheme, authority, path);
    }

    @JvmStatic
    public static final void encodeParameters(@NotNull Map<String, String> parameters, @NotNull StringBuilder result) {
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        int initialSize = result.length();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (result.length() != initialSize) {
                result.append('&');
            }
            result.append(URLUtil.encodeURIComponent((String)name));
            CharSequence charSequence = value;
            if (charSequence == null || charSequence.length() == 0) continue;
            result.append('=').append(URLUtil.encodeURIComponent((String)value));
        }
    }

    @JvmStatic
    @NotNull
    public static final Url newLocalFileUrl(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return new LocalFileUrl(FileUtilRt.toSystemIndependentName((String)path));
    }

    @JvmStatic
    @NotNull
    public static final Url newLocalFileUrl(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return new LocalFileUrl(file.getPath());
    }

    @JvmStatic
    @NotNull
    public static final Url newFromEncoded(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Url url2 = Urls.parse(url, false);
        if (url2 == null) {
            throw new MalformedURLException("Malformed URL: " + url);
        }
        return url2;
    }

    @JvmStatic
    @Nullable
    public static final Url parseEncoded(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return Urls.parse(url, false);
    }

    @JvmStatic
    @NotNull
    public static final Url newHttpUrl(@NotNull String authority, @Nullable String path) {
        Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
        return Urls.newUrl("http", authority, path);
    }

    @JvmStatic
    @NotNull
    public static final Url newHttpUrl(@NotNull String authority, @Nullable String path, @Nullable String parameters) {
        Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
        return new UrlImpl("http", authority, path, parameters);
    }

    @JvmStatic
    @NotNull
    public static final Url newUrl(@NotNull String scheme, @NotNull String authority, @Nullable String path) {
        Intrinsics.checkNotNullParameter((Object)scheme, (String)"scheme");
        Intrinsics.checkNotNullParameter((Object)authority, (String)"authority");
        return new UrlImpl(scheme, authority, path);
    }

    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final Url newFromIdea(@NotNull CharSequence url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Url url2 = Urls.parseFromIdea(url);
        if (url2 == null) {
            throw new MalformedURLException("Malformed URL: " + url);
        }
        return url2;
    }

    @JvmStatic
    @ApiStatus.Internal
    @Nullable
    public static final Url parseFromIdea(@NotNull CharSequence url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        for (int i = 0; i < url.length(); ++i) {
            char element = url.charAt(i);
            switch (element) {
                case ':': {
                    return INSTANCE.parseUrl(url);
                }
                case '/': 
                case '\\': {
                    return Urls.newLocalFileUrl(((Object)url).toString());
                }
            }
        }
        return Urls.newLocalFileUrl(((Object)url).toString());
    }

    @JvmStatic
    @Nullable
    public static final Url parse(@NotNull String url, boolean asLocalIfNoScheme) {
        Url url2;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (((CharSequence)url).length() == 0) {
            url2 = null;
        } else if (asLocalIfNoScheme && !URLUtil.containsScheme((String)url)) {
            url2 = Urls.newLocalFileUrl(url);
        } else {
            String string = VfsUtilCore.toIdeaUrl((String)url, (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toIdeaUrl(...)");
            url2 = INSTANCE.parseUrl(string);
        }
        return url2;
    }

    @JvmStatic
    @ApiStatus.Internal
    @Nullable
    public static final URI parseAsJavaUriWithoutParameters(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Url url2 = INSTANCE.parseUrl(url);
        if (url2 == null) {
            return null;
        }
        Url asUrl = url2;
        try {
            return Urls.toUriWithoutParameters(asUrl);
        }
        catch (Exception e) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(Urls.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("Cannot parse: " + url, (Throwable)e);
            return null;
        }
    }

    private final Url parseUrl(CharSequence url) {
        boolean hasUrlSeparator;
        CharSequence charSequence;
        CharSequence charSequence2;
        String string;
        CharSequence urlToParse = StringsKt.startsWith$default((CharSequence)url, (CharSequence)"jar:file://", (boolean)false, (int)2, null) ? url.subSequence(4, url.length()) : url;
        Matcher matcher = UrlsKt.access$getURI_PATTERN$p().matcher(urlToParse);
        if (!matcher.matches()) {
            return null;
        }
        Object scheme = matcher.group(1);
        if (urlToParse != url) {
            scheme = "jar:" + (String)scheme;
        }
        String string2 = matcher.group(3);
        if (string2 != null) {
            String string3;
            String it = string3 = string2;
            boolean bl = false;
            string = !(((CharSequence)it).length() == 0) ? string3 : null;
        } else {
            string = null;
        }
        String authority = string;
        String string4 = matcher.group(4);
        if (string4 != null) {
            charSequence2 = string4;
            String it = charSequence2;
            boolean bl = false;
            charSequence = !(((CharSequence)it).length() == 0) ? charSequence2 : null;
        } else {
            charSequence = null;
        }
        Object path = charSequence;
        charSequence2 = matcher.group(2);
        boolean bl = hasUrlSeparator = !(charSequence2 == null || charSequence2.length() == 0);
        if (authority == null) {
            if (hasUrlSeparator) {
                authority = "";
            }
        } else if (Intrinsics.areEqual((Object)"file", (Object)scheme) || !hasUrlSeparator) {
            CharSequence charSequence3 = path;
            path = charSequence3 == null ? authority : authority + (String)charSequence3;
            authority = hasUrlSeparator ? "" : null;
        }
        return new UrlImpl((String)scheme, authority, (String)path, matcher.group(5));
    }

    @JvmStatic
    @NotNull
    public static final Url newFromVirtualFile(@NotNull VirtualFile file) {
        Url url;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file.isInLocalFileSystem()) {
            String string = file.getFileSystem().getProtocol();
            String string2 = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            url = Urls.newUri(string, string2);
        } else {
            String string = file.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            url = INSTANCE.parseUrl(string);
            if (url == null) {
                String string3 = file.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getPath(...)");
                url = Urls.newUnparsable(string3);
            }
        }
        return url;
    }

    @JvmStatic
    @NotNull
    public static final Url newUnparsable(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return new UrlImpl(null, null, string, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean equalsIgnoreParameters(@NotNull Url url, @NotNull Collection<? extends Url> urls, boolean caseSensitive) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter(urls, (String)"urls");
            Iterable $this$any$iv = urls;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Url it = (Url)element$iv;
                    boolean bl2 = false;
                    if (!INSTANCE.equals(url, it, caseSensitive, true)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public static /* synthetic */ boolean equalsIgnoreParameters$default(Url url, Collection collection, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return Urls.equalsIgnoreParameters(url, collection, bl);
    }

    public final boolean equalsIgnoreParameters(@NotNull Url url, @NotNull VirtualFile file) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file.isInLocalFileSystem()) {
            bl = url.isInLocalFileSystem() && StringsKt.equals((String)url.getPath(), (String)file.getPath(), (!file.isCaseSensitive() ? 1 : 0) != 0);
        } else if (url.isInLocalFileSystem()) {
            bl = false;
        } else {
            String string = file.getUrl();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
            Url url2 = this.parseUrl(string);
            bl = url2 != null ? url2.equalsIgnoreParameters(url) : false;
        }
        return bl;
    }

    public final boolean equals(@Nullable Url url1, @Nullable Url url2, boolean caseSensitive, boolean ignoreParameters) {
        if (url1 == null || url2 == null) {
            return url1 == url2;
        }
        Url url = ignoreParameters ? url1.trimParameters() : url1;
        Intrinsics.checkNotNull((Object)url);
        Url o1 = url;
        Url url3 = ignoreParameters ? url2.trimParameters() : url2;
        Intrinsics.checkNotNull((Object)url3);
        Url o2 = url3;
        return caseSensitive ? Intrinsics.areEqual((Object)o1, (Object)o2) : o1.equalsIgnoreCase(o2);
    }

    @JvmStatic
    @NotNull
    public static final URI toUriWithoutParameters(@NotNull Url url) {
        URI uRI;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            Object object;
            String authority;
            boolean inLocalFileSystem = url.isInLocalFileSystem();
            String scheme = inLocalFileSystem ? "file" : url.getScheme();
            String string = authority = inLocalFileSystem ? "" : url.getAuthority();
            if (inLocalFileSystem && SystemInfoRt.isWindows && url.getPath().charAt(0) != '/') {
                object = "/" + url.getPath();
            } else {
                String string2 = url.getPath();
                object = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getPath(...)");
            }
            String externalPath = object;
            uRI = new URI(scheme, authority, externalPath, null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        return uRI;
    }

    @JvmStatic
    @JvmOverloads
    public static final boolean equalsIgnoreParameters(@NotNull Url url, @NotNull Collection<? extends Url> urls) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(urls, (String)"urls");
        return Urls.equalsIgnoreParameters$default(url, urls, false, 4, null);
    }
}

