/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.dataframe.plugin.extensions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.SessionHolder;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.FirExpressionChecker;
import org.jetbrains.kotlin.fir.declarations.FirAnnotationUtilsKt;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.extensions.FirPredicateBasedProviderKt;
import org.jetbrains.kotlin.fir.extensions.predicate.AbstractPredicate;
import org.jetbrains.kotlin.fir.extensions.predicate.LookupPredicate;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeProjectionWithVariance;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlinx.dataframe.plugin.InterpretKt;
import org.jetbrains.kotlinx.dataframe.plugin.extensions.FirDataFrameErrors;
import org.jetbrains.kotlinx.dataframe.plugin.extensions.KotlinTypeFacadeImpl;
import org.jetbrains.kotlinx.dataframe.plugin.impl.PluginDataFrameSchema;
import org.jetbrains.kotlinx.dataframe.plugin.impl.SimpleCol;
import org.jetbrains.kotlinx.dataframe.plugin.impl.SimpleDataColumn;
import org.jetbrains.kotlinx.dataframe.plugin.impl.api.FlattenPluginSchemaKt;
import org.jetbrains.kotlinx.dataframe.plugin.impl.data.ColumnWithPathApproximation;
import org.jetbrains.kotlinx.dataframe.plugin.utils.Names;

@Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00132\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003:\u0001\u0013B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J-\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0002H\u0016R\u00020\u000bR\u00020\rj\u0006\u0010\f\u001a\u00020\u000bj\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0010J$\u0010\u0011\u001a\u00020\n*\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u000bH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\b\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlinx/dataframe/plugin/extensions/Checker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirExpressionChecker;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/FirFunctionCallChecker;", "isTest", "", "<init>", "(Z)V", "()Z", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "expression", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;)V", "analyzeCast", "Lorg/jetbrains/kotlinx/dataframe/plugin/extensions/KotlinTypeFacadeImpl;", "Companion", "kotlin-dataframe-compiler-plugin.k2"})
@SourceDebugExtension(value={"SMAP\nExpressionAnalysisAdditionalChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExpressionAnalysisAdditionalChecker.kt\norg/jetbrains/kotlinx/dataframe/plugin/extensions/Checker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 LookupPredicate.kt\norg/jetbrains/kotlin/fir/extensions/predicate/LookupPredicate$Companion\n*L\n1#1,285:1\n1205#2,2:286\n1282#2,4:288\n105#3:292\n*S KotlinDebug\n*F\n+ 1 ExpressionAnalysisAdditionalChecker.kt\norg/jetbrains/kotlinx/dataframe/plugin/extensions/Checker\n*L\n172#1:286,2\n172#1:288,4\n120#1:292\n*E\n"})
final class Checker
extends FirExpressionChecker<FirFunctionCall> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isTest;
    @NotNull
    private static final CallableId CAST_ID;
    @NotNull
    private static final ClassId CHECK;
    @NotNull
    private static final LookupPredicate VALID_CAST_TARGET_PREDICATE;

    public Checker(boolean isTest) {
        super(MppCheckerKind.Common);
        this.isTest = isTest;
    }

    public final boolean isTest() {
        return this.isTest;
    }

    public void check(@NotNull CheckerContext context, @NotNull DiagnosticReporter reporter, @NotNull FirFunctionCall expression) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        KotlinTypeFacadeImpl $this$check_u24lambda_u240 = new KotlinTypeFacadeImpl(context.getSession(), this.isTest);
        boolean bl = false;
        this.analyzeCast($this$check_u24lambda_u240, expression, reporter, context);
    }

    /*
     * WARNING - void declaration
     */
    private final void analyzeCast(KotlinTypeFacadeImpl $this$analyzeCast, FirFunctionCall expression, DiagnosticReporter reporter, CheckerContext context) {
        ConeKotlinType coneType;
        block17: {
            block16: {
                FirNamedReference calleeReference = expression.getCalleeReference();
                if (!(calleeReference instanceof FirResolvedNamedReference)) break block16;
                FirCallableSymbol firCallableSymbol = FirReferenceUtilsKt.toResolvedCallableSymbol$default((FirReference)((FirReference)calleeReference), (boolean)false, (int)1, null);
                if (Intrinsics.areEqual((Object)(firCallableSymbol != null ? firCallableSymbol.getCallableId() : null), (Object)CAST_ID) && FirAnnotationUtilsKt.hasAnnotation((FirBasedSymbol)((FirResolvedNamedReference)calleeReference).getResolvedSymbol(), (ClassId)CHECK, (FirSession)$this$analyzeCast.getSession())) break block17;
            }
            return;
        }
        Object object = CollectionsKt.getOrNull((List)expression.getTypeArguments(), (int)0);
        FirTypeProjectionWithVariance firTypeProjectionWithVariance = object instanceof FirTypeProjectionWithVariance ? (FirTypeProjectionWithVariance)object : null;
        if (firTypeProjectionWithVariance == null) {
            return;
        }
        FirTypeProjectionWithVariance targetProjection = firTypeProjectionWithVariance;
        ConeKotlinType coneKotlinType = FirTypeUtilsKt.getConeType((FirTypeRef)targetProjection.getTypeRef());
        ConeClassLikeType coneClassLikeType = coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null;
        if (coneClassLikeType == null) {
            return;
        }
        ConeClassLikeType targetType = coneClassLikeType;
        FirClassLikeSymbol targetSymbol = ToSymbolUtilsKt.toSymbol((SessionHolder)$this$analyzeCast, (ConeClassLikeType)targetType);
        if (targetSymbol != null && !FirPredicateBasedProviderKt.getPredicateBasedProvider((FirSession)$this$analyzeCast.getSession()).matches((AbstractPredicate)VALID_CAST_TARGET_PREDICATE, (FirBasedSymbol)targetSymbol)) {
            String text = "Annotate " + ConeTypeUtilsKt.renderReadable((ConeKotlinType)((ConeKotlinType)targetType)) + " with @DataSchema to use generated properties";
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)expression.getSource()), FirDataFrameErrors.INSTANCE.getCAST_TARGET_WARNING(), (Object)text, (DiagnosticContext)((DiagnosticContext)context), null, (int)16, null);
        }
        FirExpression firExpression = expression.getExplicitReceiver();
        Object object2 = coneType = firExpression != null ? FirTypeUtilsKt.getResolvedType((FirExpression)firExpression) : null;
        if (coneType != null) {
            void $this$associateTo$iv$iv;
            ConeTypeProjection coneTypeProjection = (ConeTypeProjection)ArraysKt.getOrNull((Object[])TypeExpansionUtilsKt.fullyExpandedType((SessionHolder)$this$analyzeCast, (ConeKotlinType)coneType).getTypeArguments(), (int)0);
            ConeKotlinType coneKotlinType2 = coneTypeProjection != null ? ConeTypeProjectionKt.getType((ConeTypeProjection)coneTypeProjection) : null;
            ConeClassLikeType coneClassLikeType2 = coneKotlinType2 instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType2 : null;
            if (coneClassLikeType2 == null) {
                return;
            }
            ConeClassLikeType sourceType = coneClassLikeType2;
            PluginDataFrameSchema source = InterpretKt.pluginDataFrameSchema((SessionHolder)$this$analyzeCast, sourceType);
            if (PluginDataFrameSchema.columns$default(source, null, 1, null).isEmpty()) {
                return;
            }
            PluginDataFrameSchema target = InterpretKt.pluginDataFrameSchema((SessionHolder)$this$analyzeCast, targetType);
            List<ColumnWithPathApproximation> sourceColumns = FlattenPluginSchemaKt.flatten(source, true);
            List<ColumnWithPathApproximation> targetColumns = FlattenPluginSchemaKt.flatten(target, true);
            Iterable $this$associate$iv = sourceColumns;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv;
                ColumnWithPathApproximation it = (ColumnWithPathApproximation)element$iv$iv;
                boolean bl = false;
                Pair pair = TuplesKt.to(it.getPath().getPath(), (Object)it.getColumn());
                map2.put(pair.getFirst(), pair.getSecond());
            }
            Map sourceMap = destination$iv$iv;
            List missingColumns = new ArrayList();
            boolean valid = true;
            for (ColumnWithPathApproximation target2 : targetColumns) {
                boolean bl;
                SimpleCol source2 = (SimpleCol)sourceMap.get(target2.getPath().getPath());
                if (source2 != null) {
                    if (!(source2 instanceof SimpleDataColumn) || !(target2.getColumn() instanceof SimpleDataColumn)) continue;
                    if (TypeUtilsKt.isSubtypeOf$default((ConeKotlinType)((SimpleDataColumn)source2).getType().getConeType$kotlin_dataframe_compiler_plugin_k2(), (ConeKotlinType)((SimpleDataColumn)target2.getColumn()).getType().getConeType$kotlin_dataframe_compiler_plugin_k2(), (FirSession)$this$analyzeCast.getSession(), (boolean)false, (int)4, null)) {
                        bl = true;
                    } else {
                        ((Collection)missingColumns).add(target2.getPath().getPath() + ' ' + ((SimpleDataColumn)target2.getColumn()).getName() + ": " + ConeTypeUtilsKt.renderReadable((ConeKotlinType)((SimpleDataColumn)source2).getType().getConeType$kotlin_dataframe_compiler_plugin_k2()) + " is not subtype of " + ((SimpleDataColumn)target2.getColumn()).getType().getConeType$kotlin_dataframe_compiler_plugin_k2());
                        bl = false;
                    }
                } else {
                    ((Collection)missingColumns).add(target2.getPath().getPath() + ' ' + target2.getColumn().getName() + " is missing");
                    bl = false;
                }
                boolean present = bl;
                valid = valid && present;
            }
            if (!valid) {
                KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)expression.getSource()), FirDataFrameErrors.INSTANCE.getCAST_ERROR(), (Object)("Cast cannot succeed \n " + CollectionsKt.joinToString$default((Iterable)missingColumns, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)), (DiagnosticContext)((DiagnosticContext)context), null, (int)16, null);
            }
        }
    }

    static {
        Object[] objectArray = new String[]{"org", "jetbrains", "kotlinx", "dataframe", "api"};
        FqName fqName = FqName.Companion.fromSegments(CollectionsKt.listOf((Object[])objectArray));
        Name name = Name.identifier((String)"cast");
        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
        CAST_ID = new CallableId(fqName, name);
        FqName fqName2 = new FqName("org.jetbrains.kotlinx.dataframe.annotations");
        Name name2 = Name.identifier((String)"Check");
        Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"identifier(...)");
        CHECK = new ClassId(fqName2, name2);
        LookupPredicate.Companion this_$iv = LookupPredicate.Companion;
        boolean $i$f$create = false;
        LookupPredicate.BuilderContext $this$VALID_CAST_TARGET_PREDICATE_u24lambda_u240 = LookupPredicate.BuilderContext.INSTANCE;
        boolean bl = false;
        FqName[] fqNameArray = new FqName[]{Names.INSTANCE.getDATA_SCHEMA_CLASS_ID().asSingleFqName()};
        LookupPredicate lookupPredicate = $this$VALID_CAST_TARGET_PREDICATE_u24lambda_u240.annotated(fqNameArray);
        fqNameArray = new FqName[]{Names.INSTANCE.getDATA_SCHEMA_SOURCE_CLASS_ID().asSingleFqName()};
        VALID_CAST_TARGET_PREDICATE = $this$VALID_CAST_TARGET_PREDICATE_u24lambda_u240.or(lookupPredicate, $this$VALID_CAST_TARGET_PREDICATE_u24lambda_u240.annotated(fqNameArray));
    }

    @Metadata(mv={2, 4, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlinx/dataframe/plugin/extensions/Checker$Companion;", "", "<init>", "()V", "CAST_ID", "Lorg/jetbrains/kotlin/name/CallableId;", "getCAST_ID", "()Lorg/jetbrains/kotlin/name/CallableId;", "CHECK", "Lorg/jetbrains/kotlin/name/ClassId;", "getCHECK", "()Lorg/jetbrains/kotlin/name/ClassId;", "VALID_CAST_TARGET_PREDICATE", "Lorg/jetbrains/kotlin/fir/extensions/predicate/LookupPredicate;", "getVALID_CAST_TARGET_PREDICATE", "()Lorg/jetbrains/kotlin/fir/extensions/predicate/LookupPredicate;", "kotlin-dataframe-compiler-plugin.k2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final CallableId getCAST_ID() {
            return CAST_ID;
        }

        @NotNull
        public final ClassId getCHECK() {
            return CHECK;
        }

        @NotNull
        public final LookupPredicate getVALID_CAST_TARGET_PREDICATE() {
            return VALID_CAST_TARGET_PREDICATE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

