/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.console;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.OpenFileHyperlinkInfo;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.ide.browsers.OpenUrlHyperlinkInfo;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.javascript.debugger.JSDebuggerBundle;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.JsFileUtil;
import com.intellij.javascript.debugger.console.ConsoleMessageBuilder;
import com.intellij.javascript.debugger.console.DOMNode;
import com.intellij.javascript.debugger.console.DeferredEntity;
import com.intellij.javascript.debugger.console.HyperLink;
import com.intellij.javascript.debugger.console.JavaScriptConsoleViewContentTypes;
import com.intellij.javascript.debugger.console.LinkType;
import com.intellij.javascript.debugger.console.MessagePrinter;
import com.intellij.javascript.debugger.console.MessageType;
import com.intellij.javascript.debugger.console.PrintableEntity;
import com.intellij.javascript.debugger.console.Text;
import com.intellij.javascript.debugger.console.TreeRoot;
import com.intellij.javascript.debugger.console.UrlsAndAnsiParser;
import com.intellij.javascript.debugger.console.WebConsoleView;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.SimpleColoredText;
import com.intellij.util.Url;
import com.intellij.xdebugger.frame.XValue;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.DebuggerViewSupport;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.ScriptDebuggerUrls;
import org.jetbrains.debugger.SourceInfo;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.VariableImpl;
import org.jetbrains.debugger.VariableView;
import org.jetbrains.debugger.VariableViewKt;
import org.jetbrains.debugger.Vm;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueType;
import org.jetbrains.wip.protocol.runtime.CallFrameValue;
import org.jetbrains.wip.protocol.runtime.StackTraceValue;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B5\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u000fH\u0016J\u0018\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u000fH\u0016J\"\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u001e\u001a\u0004\u0018\u00010\u0015H\u0016J\b\u0010\u001f\u001a\u00020\u000fH\u0016J\b\u0010 \u001a\u00020\u000fH\u0016J\u001a\u0010!\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J\b\u0010$\u001a\u00020\u000fH\u0002J\b\u0010%\u001a\u00020\u000fH\u0002J\u0018\u0010&\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u001aH\u0016J\u001a\u0010*\u001a\u0004\u0018\u00010+2\u0006\u0010,\u001a\u00020(2\u0006\u0010)\u001a\u00020\u001aH\u0002J*\u0010-\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020.2\b\u0010/\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010)\u001a\u00020\u001aH\u0016J<\u00100\u001a\u00020\u000f2\u0006\u00101\u001a\u00020\u00152\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002032\b\u00105\u001a\u0004\u0018\u00010\u00152\u0006\u00106\u001a\u00020\u001a2\b\u00107\u001a\u0004\u0018\u00010\u0015H\u0016J<\u00108\u001a\u00020\u000f2\u0006\u00101\u001a\u00020\u00152\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002032\b\u00105\u001a\u0004\u0018\u00010\u00152\u0006\u00106\u001a\u00020\u001a2\b\u00107\u001a\u0004\u0018\u00010\u0015H\u0016J\u001a\u00108\u001a\u00020\u000f2\u0006\u00109\u001a\u00020\u00152\b\u0010:\u001a\u0004\u0018\u00010;H\u0016J\u0010\u0010<\u001a\u00020\u000f2\u0006\u00101\u001a\u00020\u0015H\u0016J\"\u0010=\u001a\u00020\u000f2\u0006\u00109\u001a\u00020\u00152\b\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010>\u001a\u00020?H\u0002JJ\u0010@\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010;\u0012\u0004\u0012\u00020\u00150A2\u0006\u00101\u001a\u00020\u00152\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u0002032\b\u00105\u001a\u0004\u0018\u00010\u00152\u0006\u00106\u001a\u00020\u001a2\b\u00107\u001a\u0004\u0018\u00010\u0015H\u0002J,\u0010B\u001a\u00020\u00152\b\u0010C\u001a\u0004\u0018\u00010D2\b\u0010E\u001a\u0004\u0018\u00010F2\u0006\u0010G\u001a\u00020\u00152\u0006\u0010H\u001a\u000203H\u0002J\b\u0010I\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006J"}, d2={"Lcom/intellij/javascript/debugger/console/WebConsoleMessageBuilder;", "Lcom/intellij/javascript/debugger/console/ConsoleMessageBuilder;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "messageVm", "Lorg/jetbrains/debugger/Vm;", "printer", "Lcom/intellij/javascript/debugger/console/MessagePrinter;", "domPresentationProvider", "Lcom/intellij/javascript/debugger/console/WebConsoleView$DOMPresentationProvider;", "disposableRoot", "Lcom/intellij/openapi/Disposable;", "<init>", "(Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;Lorg/jetbrains/debugger/Vm;Lcom/intellij/javascript/debugger/console/MessagePrinter;Lcom/intellij/javascript/debugger/console/WebConsoleView$DOMPresentationProvider;Lcom/intellij/openapi/Disposable;)V", "startMessage", "", "contentType", "Lcom/intellij/execution/ui/ConsoleViewContentType;", "type", "Lcom/intellij/javascript/debugger/console/MessageType;", "source", "", "endMessage", "groupStart", "groupName", "collapsed", "", "groupEnd", "append", "text", "style", "increaseLastMessageRepeatCount", "clear", "printStackTrace", "stackTrace", "Lorg/jetbrains/wip/protocol/runtime/StackTraceValue;", "startTrace", "endTrace", "printValue", "value", "Lcom/intellij/xdebugger/frame/XValue;", "xmlView", "prepareValueEntity", "Lcom/intellij/javascript/debugger/console/PrintableEntity;", "xValue", "printAndStoreValueToInspect", "Lorg/jetbrains/debugger/values/Value;", "expression", "addMessageLink", "url", "suggestedLine", "", "suggestedColumn", "functionName", "resolveToScript", "scriptId", "addHyperLink", "hyperlinkText", "info", "Lcom/intellij/execution/filters/HyperlinkInfo;", "printBrowserLink", "printMessageHyperlink", "linkType", "Lcom/intellij/javascript/debugger/console/LinkType;", "createLinkInfo", "Lkotlin/Pair;", "getLinkText", "parsedUrl", "Lcom/intellij/util/Url;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "rawUrl", "line", "flush", "intellij.javascript.debugger.backend"})
@SourceDebugExtension(value={"SMAP\nWebConsoleMessageBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebConsoleMessageBuilder.kt\ncom/intellij/javascript/debugger/console/WebConsoleMessageBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,287:1\n1#2:288\n1915#3,2:289\n*S KotlinDebug\n*F\n+ 1 WebConsoleMessageBuilder.kt\ncom/intellij/javascript/debugger/console/WebConsoleMessageBuilder\n*L\n285#1:289,2\n*E\n"})
public final class WebConsoleMessageBuilder
extends ConsoleMessageBuilder {
    @NotNull
    private final Vm messageVm;
    @NotNull
    private final MessagePrinter printer;
    @Nullable
    private final WebConsoleView.DOMPresentationProvider domPresentationProvider;
    @NotNull
    private final Disposable disposableRoot;

    public WebConsoleMessageBuilder(@NotNull JavaScriptDebugProcess<?> debugProcess, @NotNull Vm messageVm, @NotNull MessagePrinter printer, @Nullable WebConsoleView.DOMPresentationProvider domPresentationProvider, @NotNull Disposable disposableRoot) {
        Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)messageVm, (String)"messageVm");
        Intrinsics.checkNotNullParameter((Object)printer, (String)"printer");
        Intrinsics.checkNotNullParameter((Object)disposableRoot, (String)"disposableRoot");
        super(debugProcess);
        this.messageVm = messageVm;
        this.printer = printer;
        this.domPresentationProvider = domPresentationProvider;
        this.disposableRoot = disposableRoot;
    }

    @Override
    public void startMessage(@NotNull ConsoleViewContentType contentType, @NotNull MessageType type, @Nullable String source) {
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        this.getTasks().add((Function0<Unit>)((Function0)() -> WebConsoleMessageBuilder.startMessage$lambda$0(contentType, source, this, type)));
    }

    @Override
    public void endMessage() {
    }

    @Override
    public void groupStart(@NotNull String groupName, boolean collapsed) {
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        this.getTasks().add((Function0<Unit>)((Function0)() -> WebConsoleMessageBuilder.groupStart$lambda$0(this, groupName, collapsed)));
    }

    @Override
    public void groupEnd() {
        this.getTasks().add((Function0<Unit>)((Function0)() -> WebConsoleMessageBuilder.groupEnd$lambda$0(this)));
    }

    @Override
    public void append(@NotNull String text, @NotNull ConsoleViewContentType contentType, @Nullable String style) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        this.getTasks().add((Function0<Unit>)((Function0)() -> WebConsoleMessageBuilder.append$lambda$0(text, contentType, this, style)));
    }

    @Override
    public void increaseLastMessageRepeatCount() {
        this.getTasks().add((Function0<Unit>)((Function0)() -> WebConsoleMessageBuilder.increaseLastMessageRepeatCount$lambda$0(this)));
    }

    @Override
    public void clear() {
        this.getTasks().add((Function0<Unit>)((Function0)() -> WebConsoleMessageBuilder.clear$lambda$0(this)));
    }

    @Override
    public void printStackTrace(@NotNull ConsoleViewContentType contentType, @Nullable StackTraceValue stackTrace) {
        StackTraceValue currentStackTrace;
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        if (stackTrace == null) {
            return;
        }
        if (stackTrace.callFrames().isEmpty() || Intrinsics.areEqual((Object)"undefined", (Object)((CallFrameValue)CollectionsKt.first((List)stackTrace.callFrames())).url())) {
            return;
        }
        int max = -1;
        for (currentStackTrace = stackTrace; currentStackTrace != null; currentStackTrace = currentStackTrace.getParent()) {
            Comparable comparable;
            Iterator iterator = ((Iterable)currentStackTrace.callFrames()).iterator();
            if (!iterator.hasNext()) {
                comparable = null;
            } else {
                CallFrameValue frame = (CallFrameValue)iterator.next();
                boolean bl = false;
                Comparable comparable2 = Integer.valueOf(WebConsoleMessageBuilder.printStackTrace$frameName(frame).length());
                while (iterator.hasNext()) {
                    CallFrameValue frame2 = (CallFrameValue)iterator.next();
                    $i$a$-maxOfOrNull-WebConsoleMessageBuilder$printStackTrace$1 = false;
                    Comparable comparable3 = Integer.valueOf(WebConsoleMessageBuilder.printStackTrace$frameName(frame2).length());
                    if (comparable2.compareTo(comparable3) >= 0) continue;
                    comparable2 = comparable3;
                }
                comparable = comparable2;
            }
            Integer n = (Integer)comparable;
            int n2 = n != null ? n : 0;
            max = Math.max(max, n2);
        }
        this.startTrace();
        for (currentStackTrace = stackTrace; currentStackTrace != null; currentStackTrace = currentStackTrace.getParent()) {
            if (!Intrinsics.areEqual((Object)currentStackTrace, (Object)stackTrace)) {
                ConsoleMessageBuilder consoleMessageBuilder = this;
                Object[] objectArray = new Object[]{currentStackTrace.getDescription()};
                String string = JSDebuggerBundle.message("js.frame.async", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                ConsoleMessageBuilder.append$default(consoleMessageBuilder, string, contentType, null, 4, null);
                this.newLine();
            }
            for (CallFrameValue frame : currentStackTrace.callFrames()) {
                String functionName = WebConsoleMessageBuilder.printStackTrace$frameName(frame);
                ConsoleMessageBuilder.append$default(this, functionName, contentType, null, 4, null);
                ConsoleMessageBuilder consoleMessageBuilder = this;
                String string = StringUtil.repeatSymbol((char)' ', (int)(max - functionName.length()));
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"repeatSymbol(...)");
                ConsoleMessageBuilder.append$default(consoleMessageBuilder, string, null, null, 6, null);
                ConsoleMessageBuilder.append$default(this, "\t", contentType, null, 4, null);
                this.addHyperLink(frame.url(), frame.getLineNumber(), frame.getColumnNumber(), frame.functionName(), true, frame.scriptId());
                this.newLine();
            }
        }
        this.endTrace();
    }

    private final void startTrace() {
        this.getTasks().add((Function0<Unit>)((Function0)() -> WebConsoleMessageBuilder.startTrace$lambda$0(this)));
    }

    private final void endTrace() {
        this.getTasks().add((Function0<Unit>)((Function0)() -> WebConsoleMessageBuilder.endTrace$lambda$0(this)));
    }

    @Override
    public void printValue(@NotNull XValue value, boolean xmlView) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        PrintableEntity printableEntity = this.prepareValueEntity(value, xmlView);
        if (printableEntity == null) {
            return;
        }
        PrintableEntity printableEntity2 = printableEntity;
        this.getTasks().add((Function0<Unit>)((Function0)() -> WebConsoleMessageBuilder.printValue$lambda$0(this, printableEntity2)));
    }

    private final PrintableEntity prepareValueEntity(XValue xValue, boolean xmlView) {
        if (!(xValue instanceof VariableView)) {
            return null;
        }
        Value value = ((VariableView)xValue).getValue();
        if (value == null) {
            return null;
        }
        Value value2 = value;
        Ref.ObjectRef contentType = new Ref.ObjectRef();
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.getConsoleViewType(JavaScriptConsoleViewContentTypes.INSTANCE.getValueKey(value2));
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"getConsoleViewType(...)");
        contentType.element = consoleViewContentType;
        PrintableEntity printableEntity = null;
        if (value2 instanceof ObjectValue) {
            TreeRoot tree = new TreeRoot(((VariableView)xValue).getVariableName(), (ConsoleViewContentType)contentType.element, (VariableView)xValue, this.getDebugProcess(), this.disposableRoot, null, 32, null);
            Promise promise = (Promise)tree.getLoadPromise();
            if (value2.getType() == ValueType.NODE && this.domPresentationProvider != null && xmlView) {
                Promise promise2 = this.domPresentationProvider.getNodePresentation(value2).then(arg_0 -> WebConsoleMessageBuilder.prepareValueEntity$lambda$1(arg_0 -> WebConsoleMessageBuilder.prepareValueEntity$lambda$0(this, contentType, arg_0), arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"then(...)");
                promise = promise2;
            }
            printableEntity = new DeferredEntity((Promise<PrintableEntity>)promise, tree);
        } else {
            String text;
            String string = value2.getValueString();
            if (string == null) {
                string = "undefined";
            }
            if (Intrinsics.areEqual((Object)(text = string), (Object)"undefined")) {
                ConsoleViewContentType consoleViewContentType2 = ConsoleViewContentType.getConsoleViewType(ConsoleMessageBuilder.Companion.getCONSOLE_INFO_KEY());
                Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType2, (String)"getConsoleViewType(...)");
                contentType.element = consoleViewContentType2;
            }
            printableEntity = new Text(text, (ConsoleViewContentType)contentType.element, null, null, 12, null);
        }
        return printableEntity;
    }

    @Override
    public void printAndStoreValueToInspect(@NotNull Value value, @Nullable String expression, @NotNull ConsoleViewContentType contentType, boolean xmlView) {
        String string;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        if (value instanceof ObjectValue) {
            string = VariableViewKt.getObjectValueDescription((ObjectValue)((ObjectValue)value));
        } else {
            String string2 = value.getValueString();
            string = string2;
            Intrinsics.checkNotNull((Object)string2);
        }
        String valueString = string;
        String string3 = expression;
        if (string3 == null) {
            string3 = valueString;
        }
        this.printValue((XValue)new VariableView((Variable)new VariableImpl(string3, value), new VariableContext(this){
            final /* synthetic */ WebConsoleMessageBuilder this$0;
            {
                this.this$0 = $receiver;
            }

            public EvaluateContext getEvaluateContext() {
                EvaluateContext evaluateContext = WebConsoleMessageBuilder.access$getMessageVm$p(this.this$0).getEvaluateContext();
                if (evaluateContext == null) {
                    throw new IllegalStateException("global evaluation context is null, vm " + WebConsoleMessageBuilder.access$getMessageVm$p(this.this$0) + ", vm class " + WebConsoleMessageBuilder.access$getMessageVm$p(this.this$0).getClass().getName());
                }
                return evaluateContext;
            }

            public boolean watchableAsEvaluationExpression() {
                return false;
            }

            public DebuggerViewSupport getViewSupport() {
                return (DebuggerViewSupport)this.this$0.getDebugProcess().getDebuggerViewSupport();
            }

            public Vm getVm() {
                return WebConsoleMessageBuilder.access$getMessageVm$p(this.this$0);
            }
        }), xmlView);
    }

    @Override
    public void addMessageLink(@NotNull String url, int suggestedLine, int suggestedColumn, @Nullable String functionName, boolean resolveToScript, @Nullable String scriptId) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Pair<HyperlinkInfo, String> pair = this.createLinkInfo(url, suggestedLine, suggestedColumn, functionName, resolveToScript, scriptId);
        HyperlinkInfo hyperlinkInfo = (HyperlinkInfo)pair.component1();
        String linkText = (String)pair.component2();
        this.getTasks().add((Function0<Unit>)((Function0)() -> WebConsoleMessageBuilder.addMessageLink$lambda$0(this, linkText, hyperlinkInfo)));
    }

    @Override
    public void addHyperLink(@NotNull String url, int suggestedLine, int suggestedColumn, @Nullable String functionName, boolean resolveToScript, @Nullable String scriptId) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Pair<HyperlinkInfo, String> pair = this.createLinkInfo(url, suggestedLine, suggestedColumn, functionName, resolveToScript, scriptId);
        HyperlinkInfo hyperlinkInfo = (HyperlinkInfo)pair.component1();
        String linkText = (String)pair.component2();
        this.getTasks().add((Function0<Unit>)((Function0)() -> WebConsoleMessageBuilder.addHyperLink$lambda$0(this, linkText, hyperlinkInfo)));
    }

    @Override
    public void addHyperLink(@NotNull String hyperlinkText, @Nullable HyperlinkInfo info) {
        Intrinsics.checkNotNullParameter((Object)hyperlinkText, (String)"hyperlinkText");
        this.getTasks().add((Function0<Unit>)((Function0)() -> WebConsoleMessageBuilder.addHyperLink$lambda$1(this, hyperlinkText, info)));
    }

    @Override
    public void printBrowserLink(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.getTasks().add((Function0<Unit>)((Function0)() -> WebConsoleMessageBuilder.printBrowserLink$lambda$0(this, url)));
    }

    private final void printMessageHyperlink(String hyperlinkText, HyperlinkInfo info, LinkType linkType) {
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"NORMAL_OUTPUT");
        this.printer.print(new HyperLink(hyperlinkText, consoleViewContentType, info, linkType, null, 16, null));
    }

    private final Pair<HyperlinkInfo, String> createLinkInfo(String url, int suggestedLine, int suggestedColumn, String functionName, boolean resolveToScript, String scriptId) {
        int line = suggestedLine;
        int column = suggestedColumn;
        SourceInfo sourceInfo = resolveToScript ? this.getDebugProcess().getSourceInfo(this.messageVm, scriptId, url, functionName, line, column) : null;
        VirtualFile file = null;
        Url parsedUrl = null;
        OpenFileHyperlinkInfo hyperlinkInfo = null;
        if (sourceInfo == null) {
            parsedUrl = ScriptDebuggerUrls.parse((String)url, (boolean)true);
            VirtualFile virtualFile = file = parsedUrl == null ? null : JavaScriptDebugProcess.findFile$default(this.getDebugProcess(), parsedUrl, false, null, 6, null);
            if (virtualFile != null) {
                VirtualFile it = virtualFile;
                boolean bl = false;
                Navigatable navigatable = PsiNavigationSupport.getInstance().createNavigatable(this.getDebugProcess().getSession().getProject(), file, 0);
                Intrinsics.checkNotNullExpressionValue((Object)navigatable, (String)"createNavigatable(...)");
                Navigatable navigatable2 = navigatable;
                hyperlinkInfo = arg_0 -> WebConsoleMessageBuilder.createLinkInfo$lambda$0$0(navigatable2, arg_0);
            }
        } else {
            file = sourceInfo.getFile();
            line = sourceInfo.getLine();
            parsedUrl = null;
            Project project = this.getDebugProcess().getSession().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            hyperlinkInfo = new OpenFileHyperlinkInfo(sourceInfo.createNavigatable(project));
        }
        String linkText = this.getLinkText(parsedUrl, file, url, line);
        return new Pair((Object)hyperlinkInfo, (Object)linkText);
    }

    private final String getLinkText(Url parsedUrl, VirtualFile file, String rawUrl, int line) {
        Url url;
        Object object = file;
        if ((object == null || (object = object.getName()) == null) && ((url = parsedUrl) != null && (url = url.trimParameters()) != null ? url.toDecodedForm() : (object = null)) == null) {
            object = rawUrl;
        }
        Object name = object;
        String string = StringUtil.shortenPathWithEllipsis((String)name, (int)25, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortenPathWithEllipsis(...)");
        name = string;
        return line < 0 ? name : (String)name + ":" + (line + 1);
    }

    @Override
    public void flush() {
        Iterable $this$forEach$iv = this.getTasks();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Function0 it = (Function0)element$iv;
            boolean bl = false;
            it.invoke();
        }
    }

    private static final Unit startMessage$lambda$0(ConsoleViewContentType $contentType, String $source, WebConsoleMessageBuilder this$0, MessageType $type) {
        String string;
        String level;
        block3: {
            block2: {
                ConsoleViewContentType consoleViewContentType = $contentType;
                level = "level-" + (Intrinsics.areEqual((Object)consoleViewContentType, (Object)ConsoleViewContentType.LOG_ERROR_OUTPUT) || Intrinsics.areEqual((Object)consoleViewContentType, (Object)ConsoleViewContentType.ERROR_OUTPUT) ? "error" : (Intrinsics.areEqual((Object)consoleViewContentType, (Object)ConsoleViewContentType.LOG_WARNING_OUTPUT) ? "warning" : (Intrinsics.areEqual((Object)consoleViewContentType, (Object)ConsoleViewContentType.LOG_INFO_OUTPUT) ? "info" : (Intrinsics.areEqual((Object)consoleViewContentType, (Object)ConsoleViewContentType.LOG_DEBUG_OUTPUT) ? "debug" : "log"))));
                string = $source;
                if (string == null) break block2;
                String string2 = string;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
                String string3 = string2.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
                string = string3;
                if (string3 != null) break block3;
            }
            string = "default";
        }
        String src = "source-" + string;
        this$0.printer.startMessage($type, level, src);
        return Unit.INSTANCE;
    }

    private static final Unit groupStart$lambda$0(WebConsoleMessageBuilder this$0, String $groupName, boolean $collapsed) {
        this$0.printer.startGroup($groupName, $collapsed);
        return Unit.INSTANCE;
    }

    private static final Unit groupEnd$lambda$0(WebConsoleMessageBuilder this$0) {
        this$0.printer.endGroup();
        return Unit.INSTANCE;
    }

    private static final Unit append$lambda$0$0(WebConsoleMessageBuilder this$0, String $style, String txt, ConsoleViewContentType cType, SimpleColoredText coloredText) {
        Intrinsics.checkNotNullParameter((Object)txt, (String)"txt");
        Intrinsics.checkNotNullParameter((Object)cType, (String)"cType");
        this$0.printer.print(new Text(txt, cType, coloredText, $style));
        return Unit.INSTANCE;
    }

    private static final Unit append$lambda$0$1(WebConsoleMessageBuilder this$0, String txt, HyperlinkInfo hyperlinkInfo, SimpleColoredText simpleColoredText) {
        Intrinsics.checkNotNullParameter((Object)txt, (String)"txt");
        Intrinsics.checkNotNullParameter((Object)hyperlinkInfo, (String)"hyperlinkInfo");
        MessagePrinter messagePrinter = this$0.printer;
        ConsoleViewContentType consoleViewContentType = ConsoleViewContentType.NORMAL_OUTPUT;
        Intrinsics.checkNotNullExpressionValue((Object)consoleViewContentType, (String)"NORMAL_OUTPUT");
        messagePrinter.print(new HyperLink(txt, consoleViewContentType, hyperlinkInfo, LinkType.BROWSER, simpleColoredText));
        return Unit.INSTANCE;
    }

    private static final Unit append$lambda$0(String $text, ConsoleViewContentType $contentType, WebConsoleMessageBuilder this$0, String $style) {
        UrlsAndAnsiParser.INSTANCE.parseAndPrint($text, $contentType, (Function3<? super String, ? super ConsoleViewContentType, ? super SimpleColoredText, Unit>)((Function3)(arg_0, arg_1, arg_2) -> WebConsoleMessageBuilder.append$lambda$0$0(this$0, $style, arg_0, arg_1, arg_2)), (Function3<? super String, ? super HyperlinkInfo, ? super SimpleColoredText, Unit>)((Function3)(arg_0, arg_1, arg_2) -> WebConsoleMessageBuilder.append$lambda$0$1(this$0, arg_0, arg_1, arg_2)));
        return Unit.INSTANCE;
    }

    private static final Unit increaseLastMessageRepeatCount$lambda$0(WebConsoleMessageBuilder this$0) {
        this$0.printer.increaseLastMessageRepeatCount();
        return Unit.INSTANCE;
    }

    private static final Unit clear$lambda$0(WebConsoleMessageBuilder this$0) {
        this$0.printer.clear();
        return Unit.INSTANCE;
    }

    private static final String printStackTrace$frameName(CallFrameValue frame) {
        CharSequence charSequence;
        CharSequence charSequence2 = frame.functionName();
        if (charSequence2.length() == 0) {
            boolean bl = false;
            charSequence = "(anonymous function)";
        } else {
            charSequence = charSequence2;
        }
        return (String)charSequence;
    }

    private static final Unit startTrace$lambda$0(WebConsoleMessageBuilder this$0) {
        this$0.printer.startTrace();
        return Unit.INSTANCE;
    }

    private static final Unit endTrace$lambda$0(WebConsoleMessageBuilder this$0) {
        this$0.printer.endTrace();
        return Unit.INSTANCE;
    }

    private static final Unit printValue$lambda$0(WebConsoleMessageBuilder this$0, PrintableEntity $printableEntity) {
        this$0.printer.print($printableEntity);
        return Unit.INSTANCE;
    }

    private static final PrintableEntity prepareValueEntity$lambda$0(WebConsoleMessageBuilder this$0, Ref.ObjectRef $contentType, ItemPresentation itemPresentation) {
        DOMNode dOMNode;
        ItemPresentation itemPresentation2 = itemPresentation;
        if (itemPresentation2 != null) {
            ItemPresentation it = itemPresentation2;
            boolean bl = false;
            dOMNode = DOMNode.Companion.createDOMNode(itemPresentation, this$0.domPresentationProvider, (ConsoleViewContentType)$contentType.element);
        } else {
            dOMNode = null;
        }
        return dOMNode;
    }

    private static final PrintableEntity prepareValueEntity$lambda$1(Function1 $tmp0, Object p0) {
        return (PrintableEntity)$tmp0.invoke(p0);
    }

    private static final Unit addMessageLink$lambda$0(WebConsoleMessageBuilder this$0, String $linkText, HyperlinkInfo $hyperlinkInfo) {
        this$0.printMessageHyperlink($linkText, $hyperlinkInfo, LinkType.MESSAGE);
        return Unit.INSTANCE;
    }

    private static final Unit addHyperLink$lambda$0(WebConsoleMessageBuilder this$0, String $linkText, HyperlinkInfo $hyperlinkInfo) {
        this$0.printMessageHyperlink($linkText, $hyperlinkInfo, LinkType.SOURCE);
        return Unit.INSTANCE;
    }

    private static final Unit addHyperLink$lambda$1(WebConsoleMessageBuilder this$0, String $hyperlinkText, HyperlinkInfo $info) {
        this$0.printMessageHyperlink($hyperlinkText, $info, LinkType.SOURCE);
        return Unit.INSTANCE;
    }

    private static final Unit printBrowserLink$lambda$0(WebConsoleMessageBuilder this$0, String $url) {
        String string = JsFileUtil.trimTitle($url);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trimTitle(...)");
        this$0.printMessageHyperlink(string, (HyperlinkInfo)new OpenUrlHyperlinkInfo($url, this$0.getDebugProcess().getConnection().getBrowser()), LinkType.SOURCE);
        return Unit.INSTANCE;
    }

    private static final void createLinkInfo$lambda$0$0(Navigatable $navigatable, Project it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $navigatable.navigate(true);
    }

    public static final /* synthetic */ Vm access$getMessageVm$p(WebConsoleMessageBuilder $this) {
        return $this.messageVm;
    }
}

