/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.console.jcef;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.intellij.javascript.debugger.console.ConsoleHtmlPanel;
import com.intellij.javascript.debugger.console.JSBridge;
import com.intellij.javascript.debugger.console.ResourcesStaticServer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.jcef.JBCefBrowserBase;
import com.intellij.ui.jcef.JBCefJSQuery;
import com.intellij.ui.jcef.JCEFHtmlPanel;
import java.awt.Color;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.handler.CefLoadHandler;
import org.cef.handler.CefLoadHandlerAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 K2\u00020\u00012\u00020\u0002:\u0001KB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010$\u001a\u00020\u00102\u0006\u0010%\u001a\u00020\nH\u0016J\u0012\u0010&\u001a\u0004\u0018\u00010'2\u0006\u0010(\u001a\u00020\nH\u0016J\u0016\u0010)\u001a\u00020\u00102\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J)\u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\n2\u0012\u0010-\u001a\n\u0012\u0006\b\u0001\u0012\u00020'0.\"\u00020'H\u0016\u00a2\u0006\u0002\u0010/J7\u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\n2\f\u0010-\u001a\b\u0012\u0004\u0012\u00020'0.2\u0012\u00100\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00100 H\u0016\u00a2\u0006\u0002\u00101J*\u00102\u001a\u00020\u00102 \u00103\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\n\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020'0.0504H\u0016J\u0010\u00106\u001a\u00020\u00102\u0006\u00107\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020\u00102\u0006\u00107\u001a\u000208H\u0016J\u0016\u0010:\u001a\u00020\u00102\f\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\b\u0010<\u001a\u00020\u0010H\u0002J\u0010\u0010=\u001a\u00020\u00102\u0006\u0010>\u001a\u00020?H\u0016J>\u0010@\u001a\u00020\u00102\u0006\u0010A\u001a\u00020\n2\n\u0010B\u001a\u00060Cj\u0002`D2\u0006\u0010E\u001a\u00020\u00122\u0018\u0010F\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0.\u0012\u0004\u0012\u00020\u00100 H\u0002J\u0010\u0010G\u001a\u00020\u00102\u0006\u0010H\u001a\u00020IH\u0016J\b\u0010J\u001a\u00020\u0010H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0014\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0015\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0016\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0017\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0018\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0019\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001a\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001b\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001c\u001a\u00070\u0012\u00a2\u0006\u0002\b\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000RB\u0010\u001d\u001a6\u0012\u0004\u0012\u00020\u001f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00100 0\u001ej\u001a\u0012\u0004\u0012\u00020\u001f\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00100 `!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\"\u001a\u00020#X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006L"}, d2={"Lcom/intellij/javascript/debugger/console/jcef/JCEFConsoleHtmlPanel;", "Lcom/intellij/ui/jcef/JCEFHtmlPanel;", "Lcom/intellij/javascript/debugger/console/ConsoleHtmlPanel;", "<init>", "()V", "cefLoadHandler", "Lorg/cef/handler/CefLoadHandler;", "pageLoaded", "", "pageUrl", "", "tasks", "", "Ljava/lang/Runnable;", "initHandler", "Lkotlin/Function0;", "", "navigateQuery", "Lcom/intellij/ui/jcef/JBCefJSQuery;", "Lorg/jetbrains/annotations/NotNull;", "expandQuery", "highlightQuery", "hideHighlightQuery", "updateStickToEndQuery", "nodeLinkClickQuery", "logQuery", "messageNodeQuery", "collapseQuery", "executeQuery", "executeCallbackMap", "Ljava/util/HashMap;", "", "Lkotlin/Function1;", "Lkotlin/collections/HashMap;", "executeQueryId", "Ljava/util/concurrent/atomic/AtomicInteger;", "load", "mainUrl", "executeScript", "", "s", "runWhenPageReady", "runnable", "callJS", "method", "args", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "callback", "(Ljava/lang/String;[Ljava/lang/Object;Lkotlin/jvm/functions/Function1;)V", "runRequestsBatch", "batch", "", "Lkotlin/Pair;", "addKeyListener", "keyListener", "Ljava/awt/event/KeyListener;", "removeKeyListener", "onInit", "function", "pageInit", "setBridge", "jsBridge", "Lcom/intellij/javascript/debugger/console/JSBridge;", "bindMethod", "name", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "query", "invoke", "setBackground", "background", "Ljava/awt/Color;", "dispose", "Companion", "intellij.javascript.debugger.backend"})
public final class JCEFConsoleHtmlPanel
extends JCEFHtmlPanel
implements ConsoleHtmlPanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CefLoadHandler cefLoadHandler;
    private boolean pageLoaded;
    @Nullable
    private String pageUrl;
    @NotNull
    private final List<Runnable> tasks = new ArrayList();
    @Nullable
    private Function0<Unit> initHandler;
    @NotNull
    private final JBCefJSQuery navigateQuery;
    @NotNull
    private final JBCefJSQuery expandQuery;
    @NotNull
    private final JBCefJSQuery highlightQuery;
    @NotNull
    private final JBCefJSQuery hideHighlightQuery;
    @NotNull
    private final JBCefJSQuery updateStickToEndQuery;
    @NotNull
    private final JBCefJSQuery nodeLinkClickQuery;
    @NotNull
    private final JBCefJSQuery logQuery;
    @NotNull
    private final JBCefJSQuery messageNodeQuery;
    @NotNull
    private final JBCefJSQuery collapseQuery;
    @NotNull
    private final JBCefJSQuery executeQuery;
    @NotNull
    private final HashMap<Integer, Function1<String, Unit>> executeCallbackMap;
    @NotNull
    private final AtomicInteger executeQueryId;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Gson gson;

    public JCEFConsoleHtmlPanel() {
        super(true, null, ResourcesStaticServer.Companion.getMainUrl());
        Intrinsics.checkNotNull((Object)this, (String)"null cannot be cast to non-null type com.intellij.ui.jcef.JBCefBrowserBase");
        JBCefJSQuery jBCefJSQuery = JBCefJSQuery.create((JBCefBrowserBase)((JBCefBrowserBase)this));
        Intrinsics.checkNotNullExpressionValue((Object)jBCefJSQuery, (String)"create(...)");
        this.navigateQuery = jBCefJSQuery;
        JBCefJSQuery jBCefJSQuery2 = JBCefJSQuery.create((JBCefBrowserBase)((JBCefBrowserBase)this));
        Intrinsics.checkNotNullExpressionValue((Object)jBCefJSQuery2, (String)"create(...)");
        this.expandQuery = jBCefJSQuery2;
        JBCefJSQuery jBCefJSQuery3 = JBCefJSQuery.create((JBCefBrowserBase)((JBCefBrowserBase)this));
        Intrinsics.checkNotNullExpressionValue((Object)jBCefJSQuery3, (String)"create(...)");
        this.highlightQuery = jBCefJSQuery3;
        JBCefJSQuery jBCefJSQuery4 = JBCefJSQuery.create((JBCefBrowserBase)((JBCefBrowserBase)this));
        Intrinsics.checkNotNullExpressionValue((Object)jBCefJSQuery4, (String)"create(...)");
        this.hideHighlightQuery = jBCefJSQuery4;
        JBCefJSQuery jBCefJSQuery5 = JBCefJSQuery.create((JBCefBrowserBase)((JBCefBrowserBase)this));
        Intrinsics.checkNotNullExpressionValue((Object)jBCefJSQuery5, (String)"create(...)");
        this.updateStickToEndQuery = jBCefJSQuery5;
        JBCefJSQuery jBCefJSQuery6 = JBCefJSQuery.create((JBCefBrowserBase)((JBCefBrowserBase)this));
        Intrinsics.checkNotNullExpressionValue((Object)jBCefJSQuery6, (String)"create(...)");
        this.nodeLinkClickQuery = jBCefJSQuery6;
        JBCefJSQuery jBCefJSQuery7 = JBCefJSQuery.create((JBCefBrowserBase)((JBCefBrowserBase)this));
        Intrinsics.checkNotNullExpressionValue((Object)jBCefJSQuery7, (String)"create(...)");
        this.logQuery = jBCefJSQuery7;
        JBCefJSQuery jBCefJSQuery8 = JBCefJSQuery.create((JBCefBrowserBase)((JBCefBrowserBase)this));
        Intrinsics.checkNotNullExpressionValue((Object)jBCefJSQuery8, (String)"create(...)");
        this.messageNodeQuery = jBCefJSQuery8;
        JBCefJSQuery jBCefJSQuery9 = JBCefJSQuery.create((JBCefBrowserBase)((JBCefBrowserBase)this));
        Intrinsics.checkNotNullExpressionValue((Object)jBCefJSQuery9, (String)"create(...)");
        this.collapseQuery = jBCefJSQuery9;
        JBCefJSQuery jBCefJSQuery10 = JBCefJSQuery.create((JBCefBrowserBase)((JBCefBrowserBase)this));
        Intrinsics.checkNotNullExpressionValue((Object)jBCefJSQuery10, (String)"create(...)");
        this.executeQuery = jBCefJSQuery10;
        this.executeCallbackMap = new HashMap();
        this.executeQueryId = new AtomicInteger(0);
        this.cefLoadHandler = (CefLoadHandler)new CefLoadHandlerAdapter(){

            public void onLoadError(CefBrowser browser, CefFrame frame, CefLoadHandler.ErrorCode errorCode, String errorText, String failedUrl) {
                LOG.warn("Failed to load " + failedUrl + "\nErr " + errorCode + ": " + errorText);
            }

            public void onLoadingStateChange(CefBrowser browser, boolean isLoading, boolean canGoBack, boolean canGoForward) {
                if (!isLoading) {
                    CefBrowser cefBrowser = browser;
                    if (Intrinsics.areEqual((Object)(cefBrowser != null ? cefBrowser.getURL() : null), (Object)pageUrl)) {
                        this.pageInit();
                    }
                }
            }
        };
        this.executeQuery.addHandler(arg_0 -> JCEFConsoleHtmlPanel._init_$lambda$1(arg_0 -> JCEFConsoleHtmlPanel._init_$lambda$0(this, arg_0), arg_0));
        this.getJBCefClient().addLoadHandler(this.cefLoadHandler, this.getCefBrowser());
    }

    @Override
    public void load(@NotNull String mainUrl) {
        Intrinsics.checkNotNullParameter((Object)mainUrl, (String)"mainUrl");
        this.pageLoaded = false;
        this.pageUrl = mainUrl;
        this.loadURL(mainUrl);
    }

    @Override
    @Nullable
    public Object executeScript(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.getCefBrowser().executeJavaScript(s, this.getCefBrowser().getURL(), 0);
        return null;
    }

    @Override
    public void runWhenPageReady(@NotNull Function0<Unit> runnable) {
        Intrinsics.checkNotNullParameter(runnable, (String)"runnable");
        if (this.pageLoaded) {
            runnable.invoke();
        } else {
            this.tasks.add(() -> JCEFConsoleHtmlPanel.runWhenPageReady$lambda$0(runnable));
        }
    }

    @Override
    public void callJS(@NotNull String method, Object ... args) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        String jsArgs = !(args.length == 0) ? "..." + gson.toJson((Object)args) : "";
        this.executeScript("WebConsole.instance()." + method + "(" + jsArgs + ");");
    }

    @Override
    public void callJS(@NotNull String method, @NotNull Object[] args, @NotNull Function1<? super String, Unit> callback2) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        String jsArgs = !(args.length == 0) ? "..." + gson.toJson((Object)args) : "";
        int id = this.executeQueryId.incrementAndGet();
        ((Map)this.executeCallbackMap).put(id, callback2);
        this.executeScript("(function () { let _res = WebConsole.instance()." + method + "(" + jsArgs + ");" + this.executeQuery.inject("JSON.stringify([" + id + ", _res]) ") + "})()");
    }

    @Override
    public void runRequestsBatch(@NotNull List<? extends Pair<String, ? extends Object[]>> batch) {
        Intrinsics.checkNotNullParameter(batch, (String)"batch");
        try {
            this.executeScript("window.processRequests(" + gson.toJson(batch) + ")");
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public void addKeyListener(@NotNull KeyListener keyListener2) {
        Intrinsics.checkNotNullParameter((Object)keyListener2, (String)"keyListener");
        this.getCefBrowser().getUIComponent().addKeyListener(keyListener2);
    }

    @Override
    public void removeKeyListener(@NotNull KeyListener keyListener2) {
        Intrinsics.checkNotNullParameter((Object)keyListener2, (String)"keyListener");
        this.getCefBrowser().getUIComponent().removeKeyListener(keyListener2);
    }

    @Override
    public void onInit(@NotNull Function0<Unit> function) {
        Intrinsics.checkNotNullParameter(function, (String)"function");
        this.initHandler = function;
    }

    private final void pageInit() {
        if (!this.pageLoaded) {
            this.pageLoaded = true;
            LOG.info("WebConsole page loaded");
            Function0<Unit> function0 = this.initHandler;
            if (function0 != null) {
                function0.invoke();
            }
            for (Runnable task : this.tasks) {
                task.run();
            }
            this.tasks.clear();
            LOG.info("initialization complete");
        }
    }

    @Override
    public void setBridge(@NotNull JSBridge jsBridge) {
        Intrinsics.checkNotNullParameter((Object)jsBridge, (String)"jsBridge");
        StringBuilder sb = new StringBuilder();
        sb.append("window.JSBridge = {");
        this.bindMethod("navigate", sb, this.navigateQuery, (Function1<? super String[], Unit>)((Function1)arg_0 -> JCEFConsoleHtmlPanel.setBridge$lambda$0(jsBridge, arg_0)));
        this.bindMethod("expand", sb, this.expandQuery, (Function1<? super String[], Unit>)((Function1)arg_0 -> JCEFConsoleHtmlPanel.setBridge$lambda$1(jsBridge, arg_0)));
        this.bindMethod("highlight", sb, this.highlightQuery, (Function1<? super String[], Unit>)((Function1)arg_0 -> JCEFConsoleHtmlPanel.setBridge$lambda$2(jsBridge, arg_0)));
        this.bindMethod("hideHighlight", sb, this.hideHighlightQuery, (Function1<? super String[], Unit>)((Function1)arg_0 -> JCEFConsoleHtmlPanel.setBridge$lambda$3(jsBridge, arg_0)));
        this.bindMethod("collapse", sb, this.collapseQuery, (Function1<? super String[], Unit>)((Function1)arg_0 -> JCEFConsoleHtmlPanel.setBridge$lambda$4(jsBridge, arg_0)));
        this.bindMethod("messageNodeCallback", sb, this.messageNodeQuery, (Function1<? super String[], Unit>)((Function1)arg_0 -> JCEFConsoleHtmlPanel.setBridge$lambda$5(jsBridge, arg_0)));
        this.bindMethod("updateStickToEnd", sb, this.updateStickToEndQuery, (Function1<? super String[], Unit>)((Function1)arg_0 -> JCEFConsoleHtmlPanel.setBridge$lambda$6(jsBridge, arg_0)));
        this.bindMethod("nodeLinkClick", sb, this.nodeLinkClickQuery, (Function1<? super String[], Unit>)((Function1)arg_0 -> JCEFConsoleHtmlPanel.setBridge$lambda$7(jsBridge, arg_0)));
        this.bindMethod("log", sb, this.logQuery, (Function1<? super String[], Unit>)((Function1)arg_0 -> JCEFConsoleHtmlPanel.setBridge$lambda$8(jsBridge, arg_0)));
        sb.append("};");
        this.getCefBrowser().executeJavaScript(sb.toString(), this.getCefBrowser().getURL(), 0);
    }

    private final void bindMethod(String name, StringBuilder sb, JBCefJSQuery query, Function1<? super String[], Unit> invoke) {
        String jsFun = name + " : function() {" + query.inject("JSON.stringify([...arguments])") + "},";
        sb.append(jsFun);
        query.addHandler(arg_0 -> JCEFConsoleHtmlPanel.bindMethod$lambda$1(arg_0 -> JCEFConsoleHtmlPanel.bindMethod$lambda$0(invoke, arg_0), arg_0));
        Disposer.register((Disposable)this, (Disposable)((Disposable)query));
    }

    @Override
    public void setBackground(@NotNull Color background) {
        Intrinsics.checkNotNullParameter((Object)background, (String)"background");
    }

    public void dispose() {
        super.dispose();
        this.getJBCefClient().removeLoadHandler(this.cefLoadHandler, this.getCefBrowser());
        this.initHandler = null;
        this.tasks.clear();
    }

    private static final void lambda$0$0$0(Function1 $callback, String[] $args) {
        $callback.invoke((Object)$args[1]);
    }

    private static final JBCefJSQuery.Response _init_$lambda$0(JCEFConsoleHtmlPanel this$0, String it) {
        block0: {
            String[] args = (String[])gson.fromJson(it, String[].class);
            Function1<String, Unit> function1 = this$0.executeCallbackMap.remove(Integer.parseInt(args[0]));
            if (function1 == null) break block0;
            Function1<String, Unit> callback2 = function1;
            boolean bl = false;
            AppUIUtil.invokeOnEdt(() -> JCEFConsoleHtmlPanel.lambda$0$0$0(callback2, args));
        }
        return null;
    }

    private static final JBCefJSQuery.Response _init_$lambda$1(Function1 $tmp0, Object p0) {
        return (JBCefJSQuery.Response)$tmp0.invoke(p0);
    }

    private static final void runWhenPageReady$lambda$0(Function0 $runnable) {
        $runnable.invoke();
    }

    private static final Unit setBridge$lambda$0(JSBridge $jsBridge, String[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $jsBridge.navigate(Integer.parseInt(it[0]));
        return Unit.INSTANCE;
    }

    private static final Unit setBridge$lambda$1(JSBridge $jsBridge, String[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $jsBridge.expand(Integer.parseInt(it[0]), Integer.parseInt(it[1]));
        return Unit.INSTANCE;
    }

    private static final Unit setBridge$lambda$2(JSBridge $jsBridge, String[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $jsBridge.highlight(Integer.parseInt(it[0]));
        return Unit.INSTANCE;
    }

    private static final Unit setBridge$lambda$3(JSBridge $jsBridge, String[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $jsBridge.hideHighlight(Integer.parseInt(it[0]));
        return Unit.INSTANCE;
    }

    private static final Unit setBridge$lambda$4(JSBridge $jsBridge, String[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $jsBridge.collapse(Integer.parseInt(it[0]));
        return Unit.INSTANCE;
    }

    private static final Unit setBridge$lambda$5(JSBridge $jsBridge, String[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $jsBridge.messageNodeCallback(Integer.parseInt(it[0]));
        return Unit.INSTANCE;
    }

    private static final Unit setBridge$lambda$6(JSBridge $jsBridge, String[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $jsBridge.updateStickToEnd(Boolean.parseBoolean(it[0]));
        return Unit.INSTANCE;
    }

    private static final Unit setBridge$lambda$7(JSBridge $jsBridge, String[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $jsBridge.nodeLinkClick(Integer.parseInt(it[0]));
        return Unit.INSTANCE;
    }

    private static final Unit setBridge$lambda$8(JSBridge $jsBridge, String[] it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $jsBridge.log(it[0]);
        return Unit.INSTANCE;
    }

    private static final JBCefJSQuery.Response bindMethod$lambda$0(Function1 $invoke, String it) {
        String[] args = (String[])gson.fromJson(it, String[].class);
        Intrinsics.checkNotNull((Object)args);
        $invoke.invoke((Object)args);
        return null;
    }

    private static final JBCefJSQuery.Response bindMethod$lambda$1(Function1 $tmp0, Object p0) {
        return (JBCefJSQuery.Response)$tmp0.invoke(p0);
    }

    static {
        Logger logger = Logger.getInstance(JCEFConsoleHtmlPanel.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Gson gson = new GsonBuilder().create();
        Intrinsics.checkNotNullExpressionValue((Object)gson, (String)"create(...)");
        JCEFConsoleHtmlPanel.gson = gson;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/intellij/javascript/debugger/console/jcef/JCEFConsoleHtmlPanel$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "intellij.javascript.debugger.backend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Gson getGson() {
            return gson;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

