/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.execution;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.BrowserSelector;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.javascript.debugger.execution.RemoteBrowserSelector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\bw\u0018\u0000 \f2\u00020\u0001:\u0003\f\r\u000eR\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u00a6\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u0082\u0001\u0002\u000f\u0010\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0011\u00c0\u0006\u0001"}, d2={"Lcom/intellij/javascript/debugger/execution/BrowserSelectorProxy;", "", "mainComponent", "Ljavax/swing/JComponent;", "getMainComponent", "()Ljavax/swing/JComponent;", "selectedBrowserId", "", "getSelectedBrowserId", "()Ljava/lang/String;", "setSelectedBrowserId", "(Ljava/lang/String;)V", "Companion", "Monolith", "Split", "Lcom/intellij/javascript/debugger/execution/BrowserSelectorProxy$Monolith;", "Lcom/intellij/javascript/debugger/execution/BrowserSelectorProxy$Split;", "intellij.javascript.debugger.backend"})
@ApiStatus.Internal
public sealed interface BrowserSelectorProxy {
    @NotNull
    public static final Companion Companion = com.intellij.javascript.debugger.execution.BrowserSelectorProxy$Companion.$$INSTANCE;

    @NotNull
    public JComponent getMainComponent();

    @Nullable
    public String getSelectedBrowserId();

    public void setSelectedBrowserId(@Nullable String var1);

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/javascript/debugger/execution/BrowserSelectorProxy$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/javascript/debugger/execution/BrowserSelectorProxy;", "project", "Lcom/intellij/openapi/project/Project;", "browserFamily", "Lcom/intellij/ide/browsers/BrowserFamily;", "clientId", "Lcom/intellij/codeWithMe/ClientId;", "intellij.javascript.debugger.backend"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @NotNull
        public final BrowserSelectorProxy create(@NotNull Project project, @Nullable BrowserFamily browserFamily, @NotNull ClientId clientId) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            return Registry.Companion.is("js.debugger.browser.split") ? (BrowserSelectorProxy)new Split(project, browserFamily, clientId) : (BrowserSelectorProxy)new Monolith(browserFamily);
        }

        public static /* synthetic */ BrowserSelectorProxy create$default(Companion companion, Project project, BrowserFamily browserFamily, ClientId clientId, int n, Object object) {
            if ((n & 2) != 0) {
                browserFamily = BrowserFamily.CHROME;
            }
            if ((n & 4) != 0) {
                clientId = ClientId.Companion.getCurrent();
            }
            return companion.create(project, browserFamily, clientId);
        }

        static {
            $$INSTANCE = new Companion();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR(\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/intellij/javascript/debugger/execution/BrowserSelectorProxy$Monolith;", "Lcom/intellij/javascript/debugger/execution/BrowserSelectorProxy;", "browserFamily", "Lcom/intellij/ide/browsers/BrowserFamily;", "<init>", "(Lcom/intellij/ide/browsers/BrowserFamily;)V", "selector", "Lcom/intellij/ide/browsers/BrowserSelector;", "mainComponent", "Ljavax/swing/JComponent;", "getMainComponent", "()Ljavax/swing/JComponent;", "value", "", "selectedBrowserId", "getSelectedBrowserId", "()Ljava/lang/String;", "setSelectedBrowserId", "(Ljava/lang/String;)V", "intellij.javascript.debugger.backend"})
    @SourceDebugExtension(value={"SMAP\nBrowserSelectorProxy.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BrowserSelectorProxy.kt\ncom/intellij/javascript/debugger/execution/BrowserSelectorProxy$Monolith\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n1#2:62\n*E\n"})
    public static final class Monolith
    implements BrowserSelectorProxy {
        @Nullable
        private final BrowserFamily browserFamily;
        @NotNull
        private final BrowserSelector selector;

        public Monolith(@Nullable BrowserFamily browserFamily) {
            this.browserFamily = browserFamily;
            this.selector = new BrowserSelector(arg_0 -> Monolith.selector$lambda$1(arg_0 -> Monolith.selector$lambda$0(this, arg_0), arg_0));
        }

        @Override
        @NotNull
        public JComponent getMainComponent() {
            JComponent jComponent = this.selector.getMainComponent();
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getMainComponent(...)");
            return jComponent;
        }

        @Override
        @Nullable
        public String getSelectedBrowserId() {
            return this.selector.getSelectedBrowserId();
        }

        @Override
        public void setSelectedBrowserId(@Nullable String value) {
            WebBrowserManager browserManager = WebBrowserManager.getInstance();
            WebBrowser webBrowser = browserManager.findBrowserById(value);
            if (webBrowser == null) {
                BrowserFamily browserFamily = this.browserFamily;
                if (browserFamily != null) {
                    BrowserFamily it = browserFamily;
                    boolean bl = false;
                    webBrowser = browserManager.getFirstBrowserOrNull(it);
                } else {
                    webBrowser = null;
                }
            }
            WebBrowser browser = webBrowser;
            this.selector.setSelected(browser);
        }

        private static final boolean selector$lambda$0(Monolith this$0, WebBrowser it) {
            return this$0.browserFamily == null || it != null && it.getFamily() == this$0.browserFamily;
        }

        private static final boolean selector$lambda$1(Function1 $tmp0, Object p0) {
            return (Boolean)$tmp0.invoke(p0);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR(\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u00118V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/intellij/javascript/debugger/execution/BrowserSelectorProxy$Split;", "Lcom/intellij/javascript/debugger/execution/BrowserSelectorProxy;", "project", "Lcom/intellij/openapi/project/Project;", "browserFamily", "Lcom/intellij/ide/browsers/BrowserFamily;", "clientId", "Lcom/intellij/codeWithMe/ClientId;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/ide/browsers/BrowserFamily;Lcom/intellij/codeWithMe/ClientId;)V", "selector", "Lcom/intellij/javascript/debugger/execution/RemoteBrowserSelector;", "mainComponent", "Ljavax/swing/JComponent;", "getMainComponent", "()Ljavax/swing/JComponent;", "value", "", "selectedBrowserId", "getSelectedBrowserId", "()Ljava/lang/String;", "setSelectedBrowserId", "(Ljava/lang/String;)V", "intellij.javascript.debugger.backend"})
    public static final class Split
    implements BrowserSelectorProxy {
        @NotNull
        private final RemoteBrowserSelector selector;

        public Split(@NotNull Project project, @Nullable BrowserFamily browserFamily, @NotNull ClientId clientId) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            this.selector = new RemoteBrowserSelector(project, browserFamily, clientId);
        }

        @Override
        @NotNull
        public JComponent getMainComponent() {
            return this.selector.getMainComponent();
        }

        @Override
        @Nullable
        public String getSelectedBrowserId() {
            return this.selector.getSelectedBrowserId();
        }

        @Override
        public void setSelectedBrowserId(@Nullable String value) {
            this.selector.setSelectedBrowserId(value);
        }
    }
}

