/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.locationResolving;

import com.intellij.execution.configurations.RunProfile;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.locationResolving.JSFileUrlMappings;
import com.intellij.javascript.debugger.sourcemap.PreloadedSourceMapList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.xdebugger.XDebugSession;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u00020\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0011"}, d2={"Lcom/intellij/javascript/debugger/locationResolving/JSLocationResolver;", "", "<init>", "()V", "getPreloadedSourceMapList", "Lcom/intellij/javascript/debugger/sourcemap/PreloadedSourceMapList;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "getFileMappings", "Lcom/intellij/javascript/debugger/locationResolving/JSFileUrlMappings;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "dropCache", "", "runProfile", "Lcom/intellij/execution/configurations/RunProfile;", "Companion", "intellij.javascript.debugger.backend"})
public final class JSLocationResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Key<CachedValue<PreloadedSourceMapList>> PRELOADED_SOURCE_MAP_LIST_KEY;
    @NotNull
    private static final Key<CachedValue<JSFileUrlMappings>> FILE_URL_MAPPINGS_KEY;

    @NotNull
    public final PreloadedSourceMapList getPreloadedSourceMapList(@NotNull JavaScriptDebugProcess<?> debugProcess) {
        Intrinsics.checkNotNullParameter(debugProcess, (String)"debugProcess");
        RunProfile runProfile = debugProcess.getSession().getRunProfile();
        if (!(runProfile instanceof UserDataHolder)) {
            return new PreloadedSourceMapList();
        }
        Object object = CachedValuesManager.getManager((Project)debugProcess.getSession().getProject()).getCachedValue((UserDataHolder)runProfile, PRELOADED_SOURCE_MAP_LIST_KEY, JSLocationResolver::getPreloadedSourceMapList$lambda$0, false);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (PreloadedSourceMapList)object;
    }

    @NotNull
    public final JSFileUrlMappings getFileMappings(@NotNull XDebugSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        RunProfile runProfile = session.getRunProfile();
        if (!(runProfile instanceof UserDataHolder)) {
            return new JSFileUrlMappings();
        }
        Object object = CachedValuesManager.getManager((Project)session.getProject()).getCachedValue((UserDataHolder)runProfile, FILE_URL_MAPPINGS_KEY, JSLocationResolver::getFileMappings$lambda$0, false);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (JSFileUrlMappings)object;
    }

    public final void dropCache(@NotNull RunProfile runProfile) {
        Intrinsics.checkNotNullParameter((Object)runProfile, (String)"runProfile");
        if (runProfile instanceof UserDataHolder) {
            ((UserDataHolder)runProfile).putUserData(PRELOADED_SOURCE_MAP_LIST_KEY, null);
            ((UserDataHolder)runProfile).putUserData(FILE_URL_MAPPINGS_KEY, null);
        }
    }

    private static final CachedValueProvider.Result getPreloadedSourceMapList$lambda$0() {
        Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
        return new CachedValueProvider.Result((Object)new PreloadedSourceMapList(), objectArray);
    }

    private static final CachedValueProvider.Result getFileMappings$lambda$0() {
        Object[] objectArray = new Object[]{PsiModificationTracker.MODIFICATION_COUNT};
        return new CachedValueProvider.Result((Object)new JSFileUrlMappings(), objectArray);
    }

    static {
        Key key = Key.create((String)"js.preloaded.source.map.list");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        PRELOADED_SOURCE_MAP_LIST_KEY = key;
        Key key2 = Key.create((String)"js.file.url.mappings");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        FILE_URL_MAPPINGS_KEY = key2;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/javascript/debugger/locationResolving/JSLocationResolver$Companion;", "", "<init>", "()V", "instance", "Lcom/intellij/javascript/debugger/locationResolving/JSLocationResolver;", "getInstance", "()Lcom/intellij/javascript/debugger/locationResolving/JSLocationResolver;", "PRELOADED_SOURCE_MAP_LIST_KEY", "Lcom/intellij/openapi/util/Key;", "Lcom/intellij/psi/util/CachedValue;", "Lcom/intellij/javascript/debugger/sourcemap/PreloadedSourceMapList;", "FILE_URL_MAPPINGS_KEY", "Lcom/intellij/javascript/debugger/locationResolving/JSFileUrlMappings;", "intellij.javascript.debugger.backend"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final JSLocationResolver getInstance() {
            Object object = ApplicationManager.getApplication().getService(JSLocationResolver.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (JSLocationResolver)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

