/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.debugger.scripts;

import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.javascript.debugger.JSDebuggerCoroutineScopeHolder;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.execution.JavaScriptDebugConfiguration;
import com.intellij.javascript.debugger.scripts.FileNode;
import com.intellij.javascript.debugger.scripts.OpenActualScriptSourceAction;
import com.intellij.javascript.debugger.scripts.OpenScriptSourceAction;
import com.intellij.javascript.debugger.scripts.SetLocalPathForScriptAction;
import com.intellij.javascript.debugger.scripts.SourceTabManager;
import com.intellij.javascript.debugger.scripts.SourcesTreeStructure;
import com.intellij.javascript.debugger.scripts.VisualizeScriptSourcemap;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.platform.util.coroutines.flow.FlowKt;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.WeightBasedComparator;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.util.Comparator;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.tree.TreeModel;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineName;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020 J\b\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020\u001eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0014X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0019\u001a\u0004\u0018\u00010\u001a8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006$"}, d2={"Lcom/intellij/javascript/debugger/scripts/SourcesTreeComponent;", "Lcom/intellij/openapi/Disposable;", "sourceTabManager", "Lcom/intellij/javascript/debugger/scripts/SourceTabManager;", "<init>", "(Lcom/intellij/javascript/debugger/scripts/SourceTabManager;)V", "tree", "Lcom/intellij/ui/treeStructure/SimpleTree;", "mainComponent", "Ljavax/swing/JScrollPane;", "Lorg/jetbrains/annotations/NotNull;", "getMainComponent", "()Ljavax/swing/JScrollPane;", "debugProcess", "Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "getDebugProcess", "()Lcom/intellij/javascript/debugger/JavaScriptDebugProcess;", "treeStructure", "Lcom/intellij/javascript/debugger/scripts/SourcesTreeStructure;", "structureTreeModel", "Lcom/intellij/ui/tree/StructureTreeModel;", "getStructureTreeModel$intellij_javascript_debugger_backend", "()Lcom/intellij/ui/tree/StructureTreeModel;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "selectedNode", "Lcom/intellij/javascript/debugger/scripts/FileNode;", "getSelectedNode", "()Lcom/intellij/javascript/debugger/scripts/FileNode;", "subscribeForScriptUpdates", "", "getDefaultFocusedComponent", "Ljavax/swing/JComponent;", "createPopupGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "dispose", "intellij.javascript.debugger.backend"})
public final class SourcesTreeComponent
implements Disposable {
    @NotNull
    private final SourceTabManager sourceTabManager;
    @NotNull
    private final SimpleTree tree;
    @NotNull
    private final JScrollPane mainComponent;
    @NotNull
    private final JavaScriptDebugProcess<?> debugProcess;
    @NotNull
    private final SourcesTreeStructure treeStructure;
    @NotNull
    private final StructureTreeModel<SourcesTreeStructure> structureTreeModel;
    @NotNull
    private final CoroutineScope cs;

    public SourcesTreeComponent(@NotNull SourceTabManager sourceTabManager) {
        Intrinsics.checkNotNullParameter((Object)sourceTabManager, (String)"sourceTabManager");
        this.sourceTabManager = sourceTabManager;
        this.tree = new SimpleTree();
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)((Component)this.tree));
        Intrinsics.checkNotNullExpressionValue((Object)jScrollPane, (String)"createScrollPane(...)");
        this.mainComponent = jScrollPane;
        this.debugProcess = this.sourceTabManager.getDebugProcess();
        this.treeStructure = new SourcesTreeStructure(this.sourceTabManager);
        this.structureTreeModel = new StructureTreeModel((AbstractTreeStructure)this.treeStructure, (Comparator)new WeightBasedComparator(true), (Disposable)this.debugProcess);
        Project project = this.debugProcess.getSession().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.cs = JSDebuggerCoroutineScopeHolder.Companion.createChildScope$default(JSDebuggerCoroutineScopeHolder.Companion, project, "SourceTab", null, false, 12, null);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setModel((TreeModel)new AsyncTreeModel((TreeModel)this.structureTreeModel, (Disposable)this));
        SetLocalPathForScriptAction setLocalPathForScriptAction = this.debugProcess.getSession().getRunProfile() instanceof JavaScriptDebugConfiguration ? new SetLocalPathForScriptAction(this) : null;
        final DefaultActionGroup fileGroup = this.createPopupGroup();
        final DefaultActionGroup dirGroup = null;
        if (setLocalPathForScriptAction != null) {
            dirGroup = new DefaultActionGroup();
            dirGroup.add((AnAction)setLocalPathForScriptAction);
            fileGroup.add((AnAction)setLocalPathForScriptAction);
        } else {
            dirGroup = null;
        }
        this.tree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                block1: {
                    DefaultActionGroup group;
                    Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
                    FileNode fileNode = this.getSelectedNode();
                    if (fileNode == null) break block1;
                    FileNode fileNode2 = fileNode;
                    DefaultActionGroup defaultActionGroup = fileGroup;
                    DefaultActionGroup defaultActionGroup2 = dirGroup;
                    FileNode it = fileNode2;
                    boolean bl = false;
                    DefaultActionGroup defaultActionGroup3 = group = it.getFileInfo().isFile() ? defaultActionGroup : defaultActionGroup2;
                    if (group != null) {
                        ActionManager.getInstance().createActionPopupMenu("SourcesTreeComponent", (ActionGroup)group).getComponent().show(comp, x, y);
                    }
                }
            }
        });
    }

    @NotNull
    public final JScrollPane getMainComponent() {
        return this.mainComponent;
    }

    @NotNull
    public final JavaScriptDebugProcess<?> getDebugProcess() {
        return this.debugProcess;
    }

    @NotNull
    public final StructureTreeModel<SourcesTreeStructure> getStructureTreeModel$intellij_javascript_debugger_backend() {
        return this.structureTreeModel;
    }

    @Nullable
    public final FileNode getSelectedNode() {
        SimpleNode simpleNode = this.tree.getSelectedNode();
        return simpleNode instanceof FileNode ? (FileNode)simpleNode : null;
    }

    public final void subscribeForScriptUpdates() {
        BuildersKt.launch$default((CoroutineScope)this.cs, (CoroutineContext)((CoroutineContext)new CoroutineName("SourceTabManagerScriptUpdater")), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SourcesTreeComponent this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = FlowKt.throttle((Flow)((Flow)SourcesTreeComponent.access$getSourceTabManager$p(this.this$0).getUpdateScriptsFlow()), (long)300L).collect(new FlowCollector(this.this$0){
                            final /* synthetic */ SourcesTreeComponent this$0;
                            {
                                this.this$0 = $receiver;
                            }

                            public final Object emit(Unit it, Continuation<? super Unit> $completion) {
                                SourcesTreeComponent.access$getTreeStructure$p(this.this$0).clearCaches();
                                this.this$0.getStructureTreeModel$intellij_javascript_debugger_backend().invalidateAsync();
                                return Unit.INSTANCE;
                            }
                        }, (Continuation)this);
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        SourcesTreeComponent.access$getSourceTabManager$p(this.this$0).updateScripts();
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    @NotNull
    public final JComponent getDefaultFocusedComponent() {
        return (JComponent)this.tree;
    }

    private final DefaultActionGroup createPopupGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new OpenScriptSourceAction(this));
        WebBrowser browser = this.debugProcess.getConnection().getBrowser();
        if (browser == null || browser.getFamily() == BrowserFamily.CHROME) {
            group.add((AnAction)new OpenActualScriptSourceAction(this));
            group.add((AnAction)new VisualizeScriptSourcemap(this));
        }
        return group;
    }

    public void dispose() {
        Disposer.dispose((Disposable)((Disposable)this.structureTreeModel));
        CoroutineScopeKt.cancel$default((CoroutineScope)this.cs, null, (int)1, null);
    }

    public static final /* synthetic */ SourceTabManager access$getSourceTabManager$p(SourcesTreeComponent $this) {
        return $this.sourceTabManager;
    }

    public static final /* synthetic */ SourcesTreeStructure access$getTreeStructure$p(SourcesTreeComponent $this) {
        return $this.treeStructure;
    }
}

