/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.javascript.debugger.FileResolverByContentKt;
import com.intellij.javascript.debugger.sourcemap.SourceMapLoaderKt;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.PathUtilRt;
import com.intellij.util.SmartList;
import com.intellij.util.Url;
import com.intellij.util.io.AsarFileSystem;
import com.intellij.util.io.FileItem;
import java.nio.file.Path;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.ScriptDebuggerUrls;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/util/io/AsarFileFinder;", "", "<init>", "()V", "pathToAsarFs", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/intellij/util/io/AsarFileSystem;", "findFileIfAsar", "Lcom/intellij/openapi/vfs/VirtualFile;", "url", "Lcom/intellij/util/Url;", "project", "Lcom/intellij/openapi/project/Project;", "getAsarFs", "path", "intellij.javascript.debugger.backend"})
@SourceDebugExtension(value={"SMAP\nasar.kt\nKotlin\n*S Kotlin\n*F\n+ 1 asar.kt\ncom/intellij/util/io/AsarFileFinder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,230:1\n1#2:231\n873#3,2:232\n*S KotlinDebug\n*F\n+ 1 asar.kt\ncom/intellij/util/io/AsarFileFinder\n*L\n202#1:232,2\n*E\n"})
public final class AsarFileFinder {
    @NotNull
    private final ConcurrentHashMap<String, AsarFileSystem> pathToAsarFs = new ConcurrentHashMap();

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final VirtualFile findFileIfAsar(@NotNull Url url, @NotNull Project project) {
        Object it;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (!url.isInLocalFileSystem()) {
            return null;
        }
        String string = ScriptDebuggerUrls.INSTANCE.toFilePath(url);
        if (string == null) {
            return null;
        }
        String scriptPath = string;
        int index = StringsKt.indexOf$default((CharSequence)scriptPath, (String)".asar/", (int)0, (boolean)false, (int)6, null);
        if (index <= 0) {
            return null;
        }
        String string2 = scriptPath.substring(0, index + 5);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
        AsarFileSystem asarFileSystem = this.getAsarFs(string2, project);
        if (asarFileSystem == null) {
            return null;
        }
        AsarFileSystem fs = asarFileSystem;
        String string3 = scriptPath.substring(index + 6);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        String scriptRelativePath = string3;
        FileItem fileItem = fs.getFile(scriptRelativePath);
        if (fileItem == null) {
            return null;
        }
        FileItem fileItem2 = fileItem;
        VirtualFile virtualFile = fs.getVfsRoot();
        if (virtualFile != null) {
            it = virtualFile;
            boolean bl = false;
            VirtualFile virtualFile2 = it.findFileByRelativePath(scriptRelativePath);
            if (virtualFile2 != null) {
                VirtualFile it2 = virtualFile2;
                boolean bl2 = false;
                return it2;
            }
        }
        GlobalSearchScope globalSearchScope = ProjectScope.getContentScope((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getContentScope(...)");
        GlobalSearchScope scope = globalSearchScope;
        Object object = ActionsKt.runReadAction(() -> AsarFileFinder.findFileIfAsar$lambda$1(scriptRelativePath, scope));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
        Collection files2 = (Collection)object;
        if (!files2.isEmpty()) {
            void $this$filterTo$iv;
            it = files2;
            Collection destination$iv = (Collection)new SmartList();
            boolean $i$f$filterTo = false;
            for (Object element$iv : $this$filterTo$iv) {
                VirtualFile it3 = (VirtualFile)element$iv;
                boolean bl = false;
                String string4 = it3.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getPath(...)");
                if (!FileUtilKt.endsWithName((String)string4, (String)scriptRelativePath)) continue;
                destination$iv.add(element$iv);
            }
            files2 = destination$iv;
            if (!files2.isEmpty()) {
                return FileResolverByContentKt.selectMostSimilarFile$default(files2, fs.loadText(fileItem2), null, 4, null);
            }
        }
        return null;
    }

    @Nullable
    public final AsarFileSystem getAsarFs(@NotNull String path, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        AsarFileSystem fs = null;
        fs = this.pathToAsarFs.get(path);
        if (fs == null) {
            Path path2 = SourceMapLoaderKt.regularFile(path);
            if (path2 == null) {
                return null;
            }
            Object it = path2;
            boolean bl = false;
            fs = new AsarFileSystem((Path)it);
            String packageJson = "package.json";
            FileItem fileItem = fs.getFile(packageJson);
            if (fileItem != null) {
                FileItem fileItem2 = fileItem;
                boolean bl2 = false;
                GlobalSearchScope globalSearchScope = ProjectScope.getContentScope((Project)project);
                Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"getContentScope(...)");
                GlobalSearchScope scope = globalSearchScope;
                Object object = ActionsKt.runReadAction(() -> AsarFileFinder.getAsarFs$lambda$1$0(packageJson, scope));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runReadAction(...)");
                Collection files2 = (Collection)object;
                if (!files2.isEmpty()) {
                    VirtualFile virtualFile = FileResolverByContentKt.selectMostSimilarFile$default(files2, fs.loadText(fileItem2), null, 4, null);
                    if (virtualFile != null) {
                        VirtualFile it2 = virtualFile;
                        boolean bl3 = false;
                        fs.setVfsRoot(it2.getParent());
                    }
                }
            }
            AsarFileSystem asarFileSystem = this.pathToAsarFs.putIfAbsent(path, fs);
            if (asarFileSystem != null) {
                it = asarFileSystem;
                boolean bl4 = false;
                return it;
            }
        }
        return fs;
    }

    private static final Collection findFileIfAsar$lambda$1(String $scriptRelativePath, GlobalSearchScope $scope) {
        return FilenameIndex.getVirtualFilesByName((String)PathUtilRt.getFileName((String)$scriptRelativePath), (GlobalSearchScope)$scope);
    }

    private static final Collection getAsarFs$lambda$1$0(String $packageJson, GlobalSearchScope $scope) {
        return FilenameIndex.getVirtualFilesByName((String)$packageJson, (GlobalSearchScope)$scope);
    }
}

