/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.application.options.editor.WebEditorOptions;
import com.intellij.codeInsight.editorActions.ExternallyTagSynchronizedLanguage;
import com.intellij.codeInsight.editorActions.XmlTagNameSynchronizer;
import com.intellij.codeInsight.editorActions.XmlTagNameSynchronizerImpl;
import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.xhtml.XHTMLLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.impl.TestOnlyThreading;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.XmlTypedHandlersAdditionalSupport;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.templateLanguages.TemplateLanguage;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import kotlinx.coroutines.sync.Semaphore;
import kotlinx.coroutines.sync.SemaphoreKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u001a2\u00020\u0001:\u0004\u001a\u001b\u001c\u001dB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0007J\u0016\u0010\u000e\u001a\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0002J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0011H\u0002J\u0016\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0011H\u0082@\u00a2\u0006\u0002\u0010\u0015J\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/codeInsight/editorActions/XmlTagNameSynchronizer;", "", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "getCs", "()Lkotlinx/coroutines/CoroutineScope;", "waitForSynchronizersCreation", "", "writeLock", "Lkotlinx/coroutines/sync/Semaphore;", "recreateSynchronizersFor", "editors", "", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "scheduleEnsureSynchronizerCreated", "editor", "ensureSynchronizerCreated", "(Lcom/intellij/openapi/editor/impl/EditorImpl;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "findXmlLikeLanguage", "Lcom/intellij/lang/Language;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "Companion", "MyEditorFactoryListener", "MyCommandListener", "MyDynamicPluginListener", "intellij.xml.impl"})
@SourceDebugExtension(value={"SMAP\nXmlTagNameSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XmlTagNameSynchronizer.kt\ncom/intellij/codeInsight/editorActions/XmlTagNameSynchronizer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,223:1\n23#2:224\n1#3:225\n*S KotlinDebug\n*F\n+ 1 XmlTagNameSynchronizer.kt\ncom/intellij/codeInsight/editorActions/XmlTagNameSynchronizer\n*L\n101#1:224\n*E\n"})
public final class XmlTagNameSynchronizer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final Semaphore writeLock;
    @NotNull
    private static final Key<Boolean> SKIP_COMMAND;
    @NotNull
    private static final Key<XmlTagNameSynchronizerImpl> SYNCHRONIZER_KEY;
    @NotNull
    private static final Set<XMLLanguage> SUPPORTED_LANGUAGES;

    public XmlTagNameSynchronizer(@NotNull Project project, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.project = project;
        this.cs = cs;
        this.writeLock = SemaphoreKt.Semaphore$default((int)1, (int)0, (int)2, null);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            MessageBusConnection messageBus = this.project.getMessageBus().connect();
            Topic topic = AnActionListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            messageBus.subscribe(topic, (Object)new AnActionListener(){

                public void beforeShortcutTriggered(Shortcut shortcut, List<? extends AnAction> actions, DataContext dataContext) {
                    Intrinsics.checkNotNullParameter((Object)shortcut, (String)"shortcut");
                    Intrinsics.checkNotNullParameter(actions, (String)"actions");
                    Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
                    this.waitForSynchronizersCreation();
                }

                public void beforeEditorTyping(char c, DataContext dataContext) {
                    Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
                    this.waitForSynchronizersCreation();
                }
            });
            Topic topic2 = CommandListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
            messageBus.subscribe(topic2, (Object)new CommandListener(){

                public void commandStarted(CommandEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    this.waitForSynchronizersCreation();
                }

                public void undoTransparentActionStarted() {
                    this.waitForSynchronizersCreation();
                }
            });
        }
    }

    @NotNull
    public final CoroutineScope getCs() {
        return this.cs;
    }

    @TestOnly
    @RequiresEdt
    public final void waitForSynchronizersCreation() {
        if (this.writeLock.getAvailablePermits() > 0) {
            return;
        }
        Application application = ApplicationManager.getApplication();
        if (application.isWriteAccessAllowed()) {
            return;
        }
        long start = System.currentTimeMillis();
        Job job = JobKt.getJob((CoroutineContext)this.cs.getCoroutineContext());
        while (!((Collection)SequencesKt.toList((Sequence)job.getChildren())).isEmpty() && JobKt.isActive((CoroutineContext)this.cs.getCoroutineContext())) {
            TestOnlyThreading.releaseTheAcquiredWriteIntentLockThenExecuteActionAndTakeWriteIntentLockBack(XmlTagNameSynchronizer::waitForSynchronizersCreation$lambda$0);
            UIUtil.dispatchAllInvocationEvents();
            Thread.sleep(1L);
            if (application.isWriteIntentLockAcquired()) {
                return;
            }
            if (System.currentTimeMillis() - start <= 2000L) continue;
            XmlTagNameSynchronizer $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(XmlTagNameSynchronizer.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Timed out waiting for synchronizers to be created.", (Throwable)new TimeoutException());
            return;
        }
    }

    private final void recreateSynchronizersFor(List<EditorImpl> editors) {
        BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, editors, null){
            Object L$0;
            Object L$1;
            Object L$2;
            Object L$3;
            Object L$4;
            Object L$5;
            int I$0;
            int I$1;
            int I$2;
            int I$3;
            int label;
            final /* synthetic */ XmlTagNameSynchronizer this$0;
            final /* synthetic */ List<EditorImpl> $editors;
            {
                this.this$0 = $receiver;
                this.$editors = $editors;
                super(2, $completion);
            }

            /*
             * Exception decompiling
             */
            public final Object invokeSuspend(Object $result) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 8[WHILELOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredExpressionStatement.dump(StructuredExpressionStatement.java:29)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                 *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void scheduleEnsureSynchronizerCreated(EditorImpl editor) {
        BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, editor, null){
            Object L$0;
            Object L$1;
            Object L$2;
            int I$0;
            int I$1;
            int label;
            final /* synthetic */ XmlTagNameSynchronizer this$0;
            final /* synthetic */ EditorImpl $editor;
            {
                this.this$0 = $receiver;
                this.$editor = $editor;
                super(2, $completion);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var9_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var2_3 = XmlTagNameSynchronizer.access$getWriteLock$p(this.this$0);
                        var3_4 = this.this$0;
                        var4_5 = this.$editor;
                        $i$f$withPermit = 0;
                        this.L$0 = $this$withPermit$iv;
                        this.L$1 = var3_4;
                        this.L$2 = var4_5;
                        this.I$0 = $i$f$withPermit;
                        this.label = 1;
                        v0 = $this$withPermit$iv.acquire((Continuation)this);
                        if (v0 == var9_2) {
                            return var9_2;
                        }
                        ** GOTO lbl26
                    }
                    case 1: {
                        $i$f$withPermit = this.I$0;
                        var4_5 = (EditorImpl)this.L$2;
                        var3_4 = (XmlTagNameSynchronizer)this.L$1;
                        $this$withPermit$iv = (Semaphore)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl26:
                        // 3 sources

                        $i$a$-withPermit-XmlTagNameSynchronizer$scheduleEnsureSynchronizerCreated$1$1 = 0;
                        this.L$0 = $this$withPermit$iv;
                        this.L$1 = null;
                        this.L$2 = null;
                        this.I$0 = $i$f$withPermit;
                        this.I$1 = $i$a$-withPermit-XmlTagNameSynchronizer$scheduleEnsureSynchronizerCreated$1$1;
                        this.label = 2;
                        v1 = XmlTagNameSynchronizer.access$ensureSynchronizerCreated(var3_4, var4_5, (Continuation)this);
                        ** if (v1 != var9_2) goto lbl37
lbl36:
                        // 1 sources

                        return var9_2;
lbl37:
                        // 1 sources

                        ** GOTO lbl46
                    }
                    case 2: {
                        $i$a$-withPermit-XmlTagNameSynchronizer$scheduleEnsureSynchronizerCreated$1$1 = this.I$1;
                        $i$f$withPermit = this.I$0;
                        $this$withPermit$iv = (Semaphore)this.L$0;
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl46:
                            // 2 sources

                            var7_10 = Unit.INSTANCE;
                        }
                        catch (Throwable var8_11) {
                            throw var8_11;
                        }
                        finally {
                            $this$withPermit$iv.release();
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * Unable to fully structure code
     */
    private final Object ensureSynchronizerCreated(EditorImpl editor, Continuation<? super Unit> $completion) {
        if (!($completion instanceof ensureSynchronizerCreated.1)) ** GOTO lbl-1000
        var7_3 = $completion;
        if ((var7_3.label & -2147483648) != 0) {
            var7_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ XmlTagNameSynchronizer this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return XmlTagNameSynchronizer.access$ensureSynchronizerCreated(this.this$0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (editor.getUserData(XmlTagNameSynchronizer.SYNCHRONIZER_KEY) != null) {
                    return Unit.INSTANCE;
                }
                $continuation.L$0 = editor;
                $continuation.label = 1;
                v0 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, ensureSynchronizerCreated$lambda$0(com.intellij.openapi.editor.impl.EditorImpl com.intellij.codeInsight.editorActions.XmlTagNameSynchronizer ), ()Lcom/intellij/lang/Language;)((EditorImpl)editor, (XmlTagNameSynchronizer)this), (Continuation)$continuation);
                if (v0 == var8_5) {
                    return var8_5;
                }
                ** GOTO lbl24
            }
            case 1: {
                editor = (EditorImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                if ((var3_6 = (Language)v0) == null) break;
                language = var3_6;
                $i$a$-let-XmlTagNameSynchronizer$ensureSynchronizerCreated$3 = 0;
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)editor);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)language);
                $continuation.I$0 = $i$a$-let-XmlTagNameSynchronizer$ensureSynchronizerCreated$3;
                $continuation.label = 2;
                v1 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(editor, this, language, null){
                    int label;
                    final /* synthetic */ EditorImpl $editor;
                    final /* synthetic */ XmlTagNameSynchronizer this$0;
                    final /* synthetic */ Language $language;
                    {
                        this.$editor = $editor;
                        this.this$0 = $receiver;
                        this.$language = $language;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                if (this.$editor.isDisposed() || XmlTagNameSynchronizer.access$getProject$p(this.this$0).isDisposed()) {
                                    return Unit.INSTANCE;
                                }
                                new XmlTagNameSynchronizerImpl(this.$editor, XmlTagNameSynchronizer.access$getProject$p(this.this$0), this.$language).listenForDocumentChanges();
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v1 == var8_5) {
                    return var8_5;
                }
                break;
            }
            case 2: {
                $i$a$-let-XmlTagNameSynchronizer$ensureSynchronizerCreated$3 = $continuation.I$0;
                language = (Language)$continuation.L$1;
                editor = (EditorImpl)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
                break;
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Language findXmlLikeLanguage(Project project, VirtualFile file) {
        Object object;
        block6: {
            block5: {
                VirtualFile virtualFile;
                object = file;
                if (object == null) break block5;
                VirtualFile it = virtualFile = object;
                boolean bl = false;
                object = it.isValid() ? virtualFile : null;
                if (object == null) break block5;
                VirtualFile it2 = object;
                boolean bl2 = false;
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(it2);
                object = psiFile;
                if (psiFile != null) break block6;
            }
            return null;
        }
        VirtualFile psiFile = object;
        for (Language language : psiFile.getViewProvider().getLanguages()) {
            Object v2;
            block4: {
                Iterable iterable = SUPPORTED_LANGUAGES;
                for (Object t : iterable) {
                    XMLLanguage it = (XMLLanguage)t;
                    boolean bl = false;
                    if (!language.isKindOf((Language)it)) continue;
                    v2 = t;
                    break block4;
                }
                v2 = null;
            }
            if ((v2 == null || language instanceof TemplateLanguage || language instanceof ExternallyTagSynchronizedLanguage) && !XmlTypedHandlersAdditionalSupport.supportsTypedHandlers((PsiFile)psiFile, (Language)language)) continue;
            return language;
        }
        return null;
    }

    private static final void waitForSynchronizersCreation$lambda$0() {
    }

    private static final Language ensureSynchronizerCreated$lambda$0(EditorImpl $editor, XmlTagNameSynchronizer this$0) {
        if ($editor.isDisposed() || this$0.project.isDisposed()) {
            return null;
        }
        DocumentEx documentEx = $editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"getDocument(...)");
        DocumentEx document = documentEx;
        VirtualFile file = FileDocumentManager.getInstance().getFile((Document)document);
        return this$0.findXmlLikeLanguage(this$0.project, file);
    }

    @JvmStatic
    public static final void runWithoutCancellingSyncTagsEditing(@NotNull Document document, @NotNull Runnable runnable) {
        Companion.runWithoutCancellingSyncTagsEditing(document, runnable);
    }

    @JvmStatic
    @TestOnly
    @NotNull
    public static final XmlTagNameSynchronizer getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    public static final /* synthetic */ Semaphore access$getWriteLock$p(XmlTagNameSynchronizer $this) {
        return $this.writeLock;
    }

    public static final /* synthetic */ Object access$ensureSynchronizerCreated(XmlTagNameSynchronizer $this, EditorImpl editor, Continuation $completion) {
        return $this.ensureSynchronizerCreated(editor, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Project access$getProject$p(XmlTagNameSynchronizer $this) {
        return $this.project;
    }

    static {
        Key key = Key.create((String)"tag.name.synchronizer.skip.command");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        SKIP_COMMAND = key;
        Key key2 = Key.create((String)"tag_name_synchronizer");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        SYNCHRONIZER_KEY = key2;
        Object[] objectArray = new XMLLanguage[]{HTMLLanguage.INSTANCE, XMLLanguage.INSTANCE, XHTMLLanguage.INSTANCE};
        SUPPORTED_LANGUAGES = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0012R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/codeInsight/editorActions/XmlTagNameSynchronizer$Companion;", "", "<init>", "()V", "runWithoutCancellingSyncTagsEditing", "", "document", "Lcom/intellij/openapi/editor/Document;", "runnable", "Ljava/lang/Runnable;", "getInstance", "Lcom/intellij/codeInsight/editorActions/XmlTagNameSynchronizer;", "project", "Lcom/intellij/openapi/project/Project;", "SKIP_COMMAND", "Lcom/intellij/openapi/util/Key;", "", "getSKIP_COMMAND$intellij_xml_impl", "()Lcom/intellij/openapi/util/Key;", "SYNCHRONIZER_KEY", "Lcom/intellij/codeInsight/editorActions/XmlTagNameSynchronizerImpl;", "getSYNCHRONIZER_KEY$intellij_xml_impl", "SUPPORTED_LANGUAGES", "", "Lcom/intellij/lang/xml/XMLLanguage;", "intellij.xml.impl"})
    @SourceDebugExtension(value={"SMAP\nXmlTagNameSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XmlTagNameSynchronizer.kt\ncom/intellij/codeInsight/editorActions/XmlTagNameSynchronizer$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,223:1\n30#2,2:224\n*S KotlinDebug\n*F\n+ 1 XmlTagNameSynchronizer.kt\ncom/intellij/codeInsight/editorActions/XmlTagNameSynchronizer$Companion\n*L\n70#1:224,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        public final void runWithoutCancellingSyncTagsEditing(@NotNull Document document, @NotNull Runnable runnable) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
            document.putUserData(this.getSKIP_COMMAND$intellij_xml_impl(), (Object)true);
            try {
                runnable.run();
            }
            finally {
                document.putUserData(this.getSKIP_COMMAND$intellij_xml_impl(), null);
            }
        }

        @JvmStatic
        @TestOnly
        @NotNull
        public final XmlTagNameSynchronizer getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<XmlTagNameSynchronizer> serviceClass$iv = XmlTagNameSynchronizer.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (XmlTagNameSynchronizer)object;
        }

        @NotNull
        public final Key<Boolean> getSKIP_COMMAND$intellij_xml_impl() {
            return SKIP_COMMAND;
        }

        @NotNull
        public final Key<XmlTagNameSynchronizerImpl> getSYNCHRONIZER_KEY$intellij_xml_impl() {
            return SYNCHRONIZER_KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/codeInsight/editorActions/XmlTagNameSynchronizer$MyCommandListener;", "Lcom/intellij/openapi/command/CommandListener;", "<init>", "()V", "beforeCommandFinished", "", "event", "Lcom/intellij/openapi/command/CommandEvent;", "findSynchronizers", "Lkotlin/sequences/Sequence;", "Lcom/intellij/codeInsight/editorActions/XmlTagNameSynchronizerImpl;", "document", "Lcom/intellij/openapi/editor/Document;", "intellij.xml.impl"})
    @SourceDebugExtension(value={"SMAP\nXmlTagNameSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XmlTagNameSynchronizer.kt\ncom/intellij/codeInsight/editorActions/XmlTagNameSynchronizer$MyCommandListener\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,223:1\n1342#2,2:224\n*S KotlinDebug\n*F\n+ 1 XmlTagNameSynchronizer.kt\ncom/intellij/codeInsight/editorActions/XmlTagNameSynchronizer$MyCommandListener\n*L\n196#1:224,2\n*E\n"})
    public static final class MyCommandListener
    implements CommandListener {
        public void beforeCommandFinished(@NotNull CommandEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Sequence<XmlTagNameSynchronizerImpl> $this$forEach$iv = this.findSynchronizers(event.getDocument());
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                XmlTagNameSynchronizerImpl it = (XmlTagNameSynchronizerImpl)element$iv;
                boolean bl = false;
                it.beforeCommandFinished();
            }
        }

        private final Sequence<XmlTagNameSynchronizerImpl> findSynchronizers(Document document) {
            Sequence sequence;
            if (document == null || !WebEditorOptions.getInstance().isSyncTagEditing()) {
                sequence = SequencesKt.emptySequence();
            } else {
                Stream stream = EditorFactory.getInstance().editors(document, null);
                Intrinsics.checkNotNullExpressionValue((Object)stream, (String)"editors(...)");
                sequence = SequencesKt.mapNotNull((Sequence)StreamsKt.asSequence((Stream)stream), MyCommandListener::findSynchronizers$lambda$0);
            }
            return sequence;
        }

        private static final XmlTagNameSynchronizerImpl findSynchronizers$lambda$0(Editor editor) {
            return (XmlTagNameSynchronizerImpl)editor.getUserData(Companion.getSYNCHRONIZER_KEY$intellij_xml_impl());
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0005H\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/codeInsight/editorActions/XmlTagNameSynchronizer$MyDynamicPluginListener;", "Lcom/intellij/ide/plugins/DynamicPluginListener;", "<init>", "()V", "pluginLoaded", "", "pluginDescriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "pluginUnloaded", "isUpdate", "", "recreateSynchronizers", "intellij.xml.impl"})
    @SourceDebugExtension(value={"SMAP\nXmlTagNameSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XmlTagNameSynchronizer.kt\ncom/intellij/codeInsight/editorActions/XmlTagNameSynchronizer$MyDynamicPluginListener\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,223:1\n11135#2:224\n11361#2,3:225\n11364#2,3:235\n383#3,7:228\n221#4:238\n222#4:253\n30#5,2:239\n812#6,12:241\n*S KotlinDebug\n*F\n+ 1 XmlTagNameSynchronizer.kt\ncom/intellij/codeInsight/editorActions/XmlTagNameSynchronizer$MyDynamicPluginListener\n*L\n218#1:224\n218#1:225,3\n218#1:235,3\n218#1:228,7\n218#1:238\n218#1:253\n219#1:239,2\n219#1:241,12\n*E\n"})
    public static final class MyDynamicPluginListener
    implements DynamicPluginListener {
        public void pluginLoaded(@NotNull IdeaPluginDescriptor pluginDescriptor) {
            Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
            this.recreateSynchronizers();
        }

        public void pluginUnloaded(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
            Intrinsics.checkNotNullParameter((Object)pluginDescriptor, (String)"pluginDescriptor");
            this.recreateSynchronizers();
        }

        /*
         * WARNING - void declaration
         */
        private final void recreateSynchronizers() {
            Map map;
            void $this$groupByTo$iv$iv;
            Editor[] editorArray = EditorFactory.getInstance().getAllEditors();
            Intrinsics.checkNotNullExpressionValue((Object)editorArray, (String)"getAllEditors(...)");
            Object[] $this$groupBy$iv = editorArray;
            boolean $i$f$groupBy = false;
            Object object = $this$groupBy$iv;
            Map destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (void element$iv$iv : $this$groupByTo$iv$iv) {
                Object object2;
                void $this$getOrPut$iv$iv$iv;
                Editor it = (Editor)element$iv$iv;
                boolean bl = false;
                Project key$iv$iv = it.getProject();
                map = destination$iv$iv;
                Project key$iv$iv$iv = key$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl2 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv$iv, answer$iv$iv$iv);
                    object2 = answer$iv$iv$iv;
                } else {
                    object2 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object2;
                list$iv$iv.add(element$iv$iv);
            }
            Map $this$forEach$iv = destination$iv$iv;
            boolean $i$f$forEach = false;
            object = $this$forEach$iv.entrySet().iterator();
            while (object.hasNext()) {
                void $this$filterIsInstanceTo$iv$iv;
                void $this$filterIsInstance$iv;
                Map.Entry element$iv;
                Map.Entry entry = element$iv = (Map.Entry)object.next();
                boolean bl = false;
                Project project = (Project)entry.getKey();
                List editors = (List)entry.getValue();
                Object object3 = project;
                if (object3 == null) continue;
                Object $this$service$iv = (ComponentManager)object3;
                boolean $i$f$service = false;
                Class<XmlTagNameSynchronizer> serviceClass$iv = XmlTagNameSynchronizer.class;
                Object object4 = $this$service$iv.getService(serviceClass$iv);
                if (object4 == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                object3 = (XmlTagNameSynchronizer)object4;
                if (object3 == null) continue;
                $this$service$iv = editors;
                map = object3;
                boolean $i$f$filterIsInstance = false;
                serviceClass$iv = $this$filterIsInstance$iv;
                Collection destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof EditorImpl)) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                ((XmlTagNameSynchronizer)((Object)map)).recreateSynchronizersFor((List)destination$iv$iv2);
            }
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\f\u0010\b\u001a\u00020\u0005*\u00020\tH\u0002\u00a8\u0006\n"}, d2={"Lcom/intellij/codeInsight/editorActions/XmlTagNameSynchronizer$MyEditorFactoryListener;", "Lcom/intellij/openapi/editor/event/EditorFactoryListener;", "<init>", "()V", "editorCreated", "", "event", "Lcom/intellij/openapi/editor/event/EditorFactoryEvent;", "scheduleEnsureSynchronizerCreated", "Lcom/intellij/openapi/editor/Editor;", "intellij.xml.impl"})
    @SourceDebugExtension(value={"SMAP\nXmlTagNameSynchronizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XmlTagNameSynchronizer.kt\ncom/intellij/codeInsight/editorActions/XmlTagNameSynchronizer$MyEditorFactoryListener\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,223:1\n30#2,2:224\n*S KotlinDebug\n*F\n+ 1 XmlTagNameSynchronizer.kt\ncom/intellij/codeInsight/editorActions/XmlTagNameSynchronizer$MyEditorFactoryListener\n*L\n190#1:224,2\n*E\n"})
    public static final class MyEditorFactoryListener
    implements EditorFactoryListener {
        public void editorCreated(@NotNull EditorFactoryEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Editor editor = event.getEditor();
            Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
            this.scheduleEnsureSynchronizerCreated(editor);
        }

        private final void scheduleEnsureSynchronizerCreated(Editor $this$scheduleEnsureSynchronizerCreated) {
            block3: {
                Object object = $this$scheduleEnsureSynchronizerCreated.getProject();
                if (object == null) break block3;
                ComponentManager $this$service$iv = (ComponentManager)object;
                boolean $i$f$service = false;
                Class<XmlTagNameSynchronizer> serviceClass$iv = XmlTagNameSynchronizer.class;
                Object object2 = $this$service$iv.getService(serviceClass$iv);
                if (object2 == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                object = (XmlTagNameSynchronizer)object2;
                if (object != null) {
                    EditorImpl editorImpl = $this$scheduleEnsureSynchronizerCreated instanceof EditorImpl ? (EditorImpl)$this$scheduleEnsureSynchronizerCreated : null;
                    if (editorImpl == null) {
                        return;
                    }
                    ((XmlTagNameSynchronizer)object).scheduleEnsureSynchronizerCreated(editorImpl);
                }
            }
        }
    }
}

