/*
 * Decompiled with CFR 0.152.
 */
package andel.text;

import andel.editor.Caret;
import andel.editor.CaretPosition;
import andel.editor.MutableDocument;
import andel.text.Direction;
import andel.text.TextRange;
import andel.text.TextView;
import andel.text.TextViewExtKt;
import fleet.codepoints.CharSequenceExtensionsKt;
import fleet.codepoints.Codepoint;
import fleet.codepoints.CodepointClass;
import fleet.codepoints.CodepointClassKt;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a0\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001H\u0002\u001a.\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001\u001a&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001\u001a0\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001H\u0002\u001a&\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\u0001\u001a(\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00012\b\b\u0002\u0010\u0012\u001a\u00020\u0001\u001a0\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\u00012\b\b\u0002\u0010\u0012\u001a\u00020\u0001\u001a\u001e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\u0001\u001a \u0010\u0017\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0013\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u0001\u00a8\u0006\u0019"}, d2={"stopOnCodepointClass", "", "before", "Lfleet/codepoints/CodepointClass;", "after", "direction", "Landel/text/Direction;", "honorCamelHumps", "stopAfterSpace", "textRight", "", "offset", "text", "Landel/text/TextView;", "range", "Landel/text/TextRange;", "textLeft", "textAround", "requireWordAtCaret", "caret", "Landel/editor/CaretPosition;", "document", "Landel/editor/MutableDocument;", "textAroundOrNull", "Landel/editor/Caret;", "fleet.andel"})
@SourceDebugExtension(value={"SMAP\nNavigation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Navigation.kt\nandel/text/NavigationKt\n+ 2 CharSequenceExtensions.kt\nfleet/codepoints/CharSequenceExtensionsKt\n*L\n1#1,165:1\n32#2,15:166\n49#2,14:181\n*S KotlinDebug\n*F\n+ 1 Navigation.kt\nandel/text/NavigationKt\n*L\n55#1:166,15\n81#1:181,14\n*E\n"})
public final class NavigationKt {
    private static final boolean stopOnCodepointClass(CodepointClass before, CodepointClass after, Direction direction, boolean honorCamelHumps, boolean stopAfterSpace) {
        boolean upDownSwitchCase = before == CodepointClass.UPPERCASE && after == CodepointClass.LOWERCASE;
        boolean downUpSwitchCase = before == CodepointClass.LOWERCASE && after == CodepointClass.UPPERCASE;
        boolean underscoreIsPrev = before == CodepointClass.UNDERSCORE && after != CodepointClass.UNDERSCORE;
        boolean underscoreIsNext = before != CodepointClass.UNDERSCORE && after == CodepointClass.UNDERSCORE;
        return before == CodepointClass.CARET ? false : (before == after ? false : (before == CodepointClass.SPACE ? stopAfterSpace : (before == CodepointClass.SEPARATOR ? true : (after == CodepointClass.SEPARATOR ? true : (after == CodepointClass.NEWLINE ? true : (after == CodepointClass.SPACE ? true : (underscoreIsPrev || underscoreIsNext ? honorCamelHumps : (downUpSwitchCase ? direction == Direction.FORWARD && honorCamelHumps : (upDownSwitchCase ? direction == Direction.BACKWARD && honorCamelHumps : true)))))))));
    }

    public static final long textRight(long offset, @NotNull TextView text, @NotNull TextRange range, boolean honorCamelHumps, boolean stopAfterSpace) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        if (offset == range.getEnd()) {
            return offset;
        }
        CodepointClass classBefore = null;
        classBefore = CodepointClass.CARET;
        long charOffset = 0L;
        charOffset = offset;
        CharSequence $this$forEachCodepoint$iv = TextViewExtKt.charSequence(text, offset, text.getCharCount());
        boolean $i$f$forEachCodepoint = false;
        int i$iv = 0;
        int len$iv = $this$forEachCodepoint$iv.length();
        while (i$iv < len$iv) {
            CodepointClass classAfter;
            boolean bl;
            int codepoint;
            char c2$iv;
            char c1$iv;
            if (Character.isHighSurrogate(c1$iv = $this$forEachCodepoint$iv.charAt(i$iv++)) && i$iv < len$iv && Character.isLowSurrogate(c2$iv = $this$forEachCodepoint$iv.charAt(i$iv))) {
                ++i$iv;
                codepoint = Codepoint.Companion.fromChars-vIWkmjQ(c1$iv, c2$iv);
                bl = false;
                classAfter = CodepointClassKt.codepointClass((int)codepoint);
                if (NavigationKt.stopOnCodepointClass(classBefore, classAfter, Direction.FORWARD, honorCamelHumps, stopAfterSpace) || charOffset >= range.getEnd()) {
                    return charOffset;
                }
                charOffset += (long)Codepoint.getCharCount-impl((int)codepoint);
                classBefore = classAfter;
                continue;
            }
            codepoint = Codepoint.constructor-impl((int)c1$iv);
            bl = false;
            classAfter = CodepointClassKt.codepointClass((int)codepoint);
            if (NavigationKt.stopOnCodepointClass(classBefore, classAfter, Direction.FORWARD, honorCamelHumps, stopAfterSpace) || charOffset >= range.getEnd()) {
                return charOffset;
            }
            charOffset += (long)Codepoint.getCharCount-impl((int)codepoint);
            classBefore = classAfter;
        }
        return charOffset;
    }

    public static final long textRight(long offset, @NotNull TextView text, boolean honorCamelHumps, boolean stopAfterSpace) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return NavigationKt.textRight(offset, text, new TextRange(0L, (long)text.getCharCount()), honorCamelHumps, stopAfterSpace);
    }

    private static final long textLeft(long offset, TextView text, TextRange range, boolean honorCamelHumps, boolean stopAfterSpace) {
        if (offset == range.getStart()) {
            return offset;
        }
        CodepointClass classBefore = null;
        classBefore = CodepointClass.CARET;
        long charOffset = 0L;
        charOffset = offset;
        CharSequence $this$forEachCodepointReversed$iv = TextViewExtKt.charSequence(text, 0L, offset);
        boolean $i$f$forEachCodepointReversed = false;
        int i$iv = $this$forEachCodepointReversed$iv.length() - 1;
        while (i$iv >= 0) {
            CodepointClass classAfter;
            boolean bl;
            int codepoint;
            char c1$iv;
            char c2$iv;
            if (Character.isLowSurrogate(c2$iv = $this$forEachCodepointReversed$iv.charAt(i$iv--)) && i$iv >= 0 && Character.isHighSurrogate(c1$iv = $this$forEachCodepointReversed$iv.charAt(i$iv))) {
                --i$iv;
                codepoint = Codepoint.Companion.fromChars-vIWkmjQ(c1$iv, c2$iv);
                bl = false;
                classAfter = CodepointClassKt.codepointClass((int)codepoint);
                if (NavigationKt.stopOnCodepointClass(classBefore, classAfter, Direction.BACKWARD, honorCamelHumps, stopAfterSpace)) {
                    return charOffset;
                }
                charOffset -= (long)Codepoint.getCharCount-impl((int)codepoint);
                classBefore = classAfter;
                continue;
            }
            codepoint = Codepoint.constructor-impl((int)c2$iv);
            bl = false;
            classAfter = CodepointClassKt.codepointClass((int)codepoint);
            if (NavigationKt.stopOnCodepointClass(classBefore, classAfter, Direction.BACKWARD, honorCamelHumps, stopAfterSpace)) {
                return charOffset;
            }
            charOffset -= (long)Codepoint.getCharCount-impl((int)codepoint);
            classBefore = classAfter;
        }
        return charOffset;
    }

    public static final long textLeft(long offset, @NotNull TextView text, boolean honorCamelHumps, boolean stopAfterSpace) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return NavigationKt.textLeft(offset, text, new TextRange(0L, (long)text.getCharCount()), honorCamelHumps, stopAfterSpace);
    }

    @NotNull
    public static final TextRange textAround(long offset, @NotNull TextView text, boolean honorCamelHumps, boolean requireWordAtCaret) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return NavigationKt.textAround(offset, text, new TextRange(0L, (long)text.getCharCount()), honorCamelHumps, requireWordAtCaret);
    }

    public static /* synthetic */ TextRange textAround$default(long l, TextView textView, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 8) != 0) {
            bl2 = true;
        }
        return NavigationKt.textAround(l, textView, bl, bl2);
    }

    @NotNull
    public static final TextRange textAround(long offset, @NotNull TextView text, @NotNull TextRange range, boolean honorCamelHumps, boolean requireWordAtCaret) {
        TextRange textRange;
        CodepointClass codepointClass;
        CodepointClass rightCodepoint;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Object[] objectArray = new CodepointClass[]{CodepointClass.LOWERCASE, CodepointClass.UPPERCASE, CodepointClass.UNDERSCORE};
        Set validCodepoints = SetsKt.setOf((Object[])objectArray);
        boolean bl = 0L <= offset ? offset < (long)text.getCharCount() : false;
        if (bl) {
            int cursor = CharSequenceExtensionsKt.codePointAt((CharSequence)TextViewExtKt.charSequence(text), (int)((int)offset));
            boolean bl2 = false;
            v1 = CodepointClassKt.codepointClass((int)cursor);
        } else {
            v1 = rightCodepoint = null;
        }
        boolean bl3 = 1L <= offset ? offset <= (long)text.getCharCount() : false;
        if (bl3) {
            int cursor = CharSequenceExtensionsKt.codePointBefore((CharSequence)TextViewExtKt.charSequence(text), (int)((int)offset));
            boolean bl4 = false;
            codepointClass = CodepointClassKt.codepointClass((int)cursor);
        } else {
            codepointClass = null;
        }
        CodepointClass leftCodepoint = codepointClass;
        boolean isWordOnTheRight = CollectionsKt.contains((Iterable)validCodepoints, (Object)rightCodepoint);
        boolean isWordOnTheLeft = CollectionsKt.contains((Iterable)validCodepoints, (Object)leftCodepoint);
        if (!isWordOnTheRight && !isWordOnTheLeft && requireWordAtCaret) {
            return new TextRange(offset, offset);
        }
        if (isWordOnTheRight) {
            long end = NavigationKt.textRight(offset, text, range, honorCamelHumps, false);
            long start = NavigationKt.textLeft(end, text, range, honorCamelHumps, false);
            textRange = new TextRange(start, end);
        } else {
            long start = NavigationKt.textLeft(offset, text, range, honorCamelHumps, false);
            long end = NavigationKt.textRight(start, text, range, honorCamelHumps, false);
            textRange = new TextRange(start, end);
        }
        return textRange;
    }

    public static /* synthetic */ TextRange textAround$default(long l, TextView textView, TextRange textRange, boolean bl, boolean bl2, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        return NavigationKt.textAround(l, textView, textRange, bl, bl2);
    }

    @NotNull
    public static final TextRange textAround(@NotNull CaretPosition caret, @NotNull MutableDocument document2, boolean honorCamelHumps) {
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        return NavigationKt.textAround$default(caret.getOffset(), document2.getText().view(), honorCamelHumps, false, 8, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final TextRange textAroundOrNull(@NotNull Caret caret, @NotNull TextView text, boolean honorCamelHumps) {
        Intrinsics.checkNotNullParameter((Object)caret, (String)"caret");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        TextRange result = NavigationKt.textAround$default(caret.getOffset(), text, honorCamelHumps, false, 8, null);
        if (result.getStart() >= result.getEnd()) return null;
        long l = result.getStart();
        long l2 = result.getEnd();
        long l3 = caret.getOffset();
        if (l > l3) return null;
        if (l3 > l2) return null;
        boolean bl = true;
        if (!bl) return null;
        TextRange textRange = result;
        return textRange;
    }
}

