/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.inspections.invalid;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssBundle;
import com.intellij.psi.css.CssCustomPropertyAtRule;
import com.intellij.psi.css.CssElementVisitor;
import com.intellij.psi.css.codeStyle.CssCodeStyleSettings;
import com.intellij.psi.css.inspections.CssBaseInspection;
import com.intellij.psi.css.inspections.CssFixFactory;
import com.intellij.psi.css.inspections.CssInvalidCustomPropertyAtRuleDeclarationUtils;
import com.intellij.psi.css.inspections.invalid.CssInvalidCustomPropertyAtRuleDeclarationInspection;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/psi/css/inspections/invalid/CssInvalidCustomPropertyAtRuleDeclarationInspection;", "Lcom/intellij/psi/css/inspections/CssBaseInspection;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "intellij.css.analysis"})
public final class CssInvalidCustomPropertyAtRuleDeclarationInspection
extends CssBaseInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return (PsiElementVisitor)new CssElementVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitCssCustomPropertyAtRule(CssCustomPropertyAtRule customProperty) {
                Intrinsics.checkNotNullParameter((Object)customProperty, (String)"customProperty");
                CssBlock cssBlock = (CssBlock)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)customProperty), CssBlock.class);
                if (cssBlock != null) {
                    PsiElement context = customProperty.getContext();
                    char quote = '\"';
                    if (context != null) {
                        quote = CssCodeStyleSettings.getLanguageSpecificQuote((PsiElement)context);
                    }
                    ASTNode aSTNode = cssBlock.getNode();
                    Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"getNode(...)");
                    Map<String, String> absentProperties = CssInvalidCustomPropertyAtRuleDeclarationUtils.Companion.getAbsentDeclarations(aSTNode, quote);
                    if (absentProperties.isEmpty()) {
                        return;
                    }
                    PsiElement propertySymbol = customProperty.getFirstChild();
                    if (absentProperties.size() == 1) {
                        Object[] objectArray = new Object[]{CollectionsKt.first((Iterable)absentProperties.keySet())};
                        String string = CssBundle.message((String)"css.inspections.invalid.custom.property.at.rule.declaration.description", (Object[])objectArray);
                        objectArray = new LocalQuickFix[]{CssFixFactory.getInstance().addDeclarationsForCustomProperty()};
                        this.$holder.registerProblem(propertySymbol, string, ProblemHighlightType.GENERIC_ERROR, (LocalQuickFix[])objectArray);
                    } else {
                        String properties = CollectionsKt.joinToString$default((Iterable)absentProperties.keySet(), (CharSequence)", ", null, null, (int)0, null, buildVisitor.1::visitCssCustomPropertyAtRule$lambda$0, (int)30, null);
                        Object[] objectArray = new Object[]{properties};
                        String string = CssBundle.message((String)"css.inspections.invalid.custom.property.at.rule.declaration.description.plural", (Object[])objectArray);
                        objectArray = new LocalQuickFix[]{CssFixFactory.getInstance().addDeclarationsForCustomProperty()};
                        this.$holder.registerProblem(propertySymbol, string, ProblemHighlightType.GENERIC_ERROR, (LocalQuickFix[])objectArray);
                    }
                }
            }

            private static final CharSequence visitCssCustomPropertyAtRule$lambda$0(String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return "'" + it + "'";
            }
        };
    }
}

