/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.InvokerDelegate;
import com.intellij.util.concurrency.InvokerService;
import java.awt.EventQueue;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.Promise;

public abstract class Invoker
implements Disposable {
    private static final int THRESHOLD = Integer.MAX_VALUE;
    static final Logger LOG = Logger.getInstance(Invoker.class);
    private static final AtomicInteger UID = new AtomicInteger();
    final InvokerDelegate delegate;
    private final AtomicInteger count;
    private final ThreeState useReadAction;
    private volatile boolean disposed;

    private Invoker(@NotNull InvokerDelegate delegate, @NotNull ThreeState useReadAction) {
        if (delegate == null) {
            Invoker.$$$reportNull$$$0(0);
        }
        if (useReadAction == null) {
            Invoker.$$$reportNull$$$0(1);
        }
        this.count = new AtomicInteger();
        this.delegate = delegate;
        Disposer.register((Disposable)this, (Disposable)this.delegate);
        this.useReadAction = useReadAction;
    }

    @NotNull
    private static String newDescription(@NotNull String prefix, @NotNull String parentName, @NotNull ThreeState useReadAction) {
        String description;
        if (prefix == null) {
            Invoker.$$$reportNull$$$0(2);
        }
        if (parentName == null) {
            Invoker.$$$reportNull$$$0(3);
        }
        if (useReadAction == null) {
            Invoker.$$$reportNull$$$0(4);
        }
        String readActionDescriptionPart = useReadAction != ThreeState.UNSURE ? ".ReadAction=" + String.valueOf(useReadAction) : "";
        String string = description = "Invoker." + UID.getAndIncrement() + "." + prefix + readActionDescriptionPart + ": " + parentName;
        if (string == null) {
            Invoker.$$$reportNull$$$0(5);
        }
        return string;
    }

    public String toString() {
        return this.delegate.getDescription();
    }

    public void dispose() {
        this.disposed = true;
    }

    public boolean isValidThread() {
        if (this.useReadAction != ThreeState.NO) {
            return true;
        }
        Application application = ApplicationManager.getApplication();
        return application == null || !application.isReadAccessAllowed();
    }

    @NotNull
    public final <T> CancellablePromise<T> compute(@NotNull Supplier<? extends T> task) {
        if (task == null) {
            Invoker.$$$reportNull$$$0(6);
        }
        return this.promise(new Task.Sync<T>(task));
    }

    @NotNull
    public final <T> CancellablePromise<T> computeAsync(@NotNull Supplier<Promise<? extends T>> task) {
        if (task == null) {
            Invoker.$$$reportNull$$$0(7);
        }
        return this.promise(new Task.Async<T>(task));
    }

    @NotNull
    public final <T> CancellablePromise<T> computeLater(@NotNull Supplier<? extends T> task) {
        if (task == null) {
            Invoker.$$$reportNull$$$0(8);
        }
        return this.promise(new Task.Sync<T>(task), 0);
    }

    @NotNull
    public final CancellablePromise<?> invoke(@NotNull Runnable task) {
        if (task == null) {
            Invoker.$$$reportNull$$$0(9);
        }
        return this.compute(new Wrapper(task));
    }

    @NotNull
    public final CancellablePromise<?> invokeLater(@NotNull Runnable task) {
        if (task == null) {
            Invoker.$$$reportNull$$$0(10);
        }
        return this.invokeLater(task, 0);
    }

    @NotNull
    public final CancellablePromise<?> invokeLater(@NotNull Runnable task, int delay) {
        if (task == null) {
            Invoker.$$$reportNull$$$0(11);
        }
        return this.promise(new Task.Sync<Void>(new Wrapper(task)), delay);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    public final CancellablePromise<?> runOrInvokeLater(@NotNull Runnable task) {
        if (task == null) {
            Invoker.$$$reportNull$$$0(12);
        }
        return this.invoke(task);
    }

    public final int getTaskCount() {
        return this.disposed ? 0 : this.count.get();
    }

    abstract void offer(@NotNull Runnable var1, int var2, Promise<?> var3);

    private void offerSafely(@NotNull Task<?, ?> task, int attempt, int delay) {
        if (task == null) {
            Invoker.$$$reportNull$$$0(13);
        }
        try {
            this.count.incrementAndGet();
            this.offer(() -> this.invokeSafely(task, attempt), delay, (Promise<?>)task.promise);
        }
        catch (RejectedExecutionException exception) {
            this.count.decrementAndGet();
            if (LOG.isTraceEnabled()) {
                LOG.debug("Executor is shutdown");
            }
            task.promise.setError("shutdown");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeSafely(@NotNull Task<?, ?> task, int attempt) {
        if (task == null) {
            Invoker.$$$reportNull$$$0(14);
        }
        try {
            if (task.canInvoke(this.disposed)) {
                if (!this.delegate.run(task, task.promise)) {
                    this.offerRestart(task, attempt);
                    return;
                }
                if (task instanceof Task.Async) {
                    Task.Async t = (Task.Async)task;
                    Promise incomplete = t.setDone();
                    if (incomplete != null) {
                        this.count.incrementAndGet();
                        incomplete.onError(th -> this.handleTaskError(task, (Throwable)th, attempt)).onProcessed(r -> this.count.decrementAndGet());
                    }
                } else if (task instanceof Task.Sync) {
                    Task.Sync t = (Task.Sync)task;
                    t.setDone();
                }
            }
        }
        catch (Throwable throwable) {
            this.handleTaskError(task, throwable, attempt);
        }
        finally {
            this.count.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleTaskError(@NotNull Task<?, ?> task, @NotNull Throwable throwable, int attempt) {
        if (task == null) {
            Invoker.$$$reportNull$$$0(15);
        }
        if (throwable == null) {
            Invoker.$$$reportNull$$$0(16);
        }
        if (throwable instanceof ProcessCanceledException || throwable == AsyncPromise.CANCELED || throwable instanceof IndexNotReadyException) {
            this.offerRestart(task, attempt);
            return;
        }
        try {
            LOG.error(throwable);
        }
        finally {
            task.promise.setError(throwable);
        }
    }

    private void offerRestart(@NotNull Task<?, ?> task, int attempt) {
        if (task == null) {
            Invoker.$$$reportNull$$$0(17);
        }
        if (task.canRestart(this.disposed, attempt)) {
            this.offerSafely(task, attempt + 1, 10);
            if (LOG.isTraceEnabled()) {
                LOG.debug("Task is restarted");
            }
        }
    }

    @NotNull
    private <T> CancellablePromise<T> promise(@NotNull Task<T, ?> task) {
        if (task == null) {
            Invoker.$$$reportNull$$$0(18);
        }
        if (!this.isValidThread()) {
            return this.promise(task, 0);
        }
        this.count.incrementAndGet();
        this.invokeSafely(task, 0);
        AsyncPromise asyncPromise = task.promise;
        if (asyncPromise == null) {
            Invoker.$$$reportNull$$$0(19);
        }
        return asyncPromise;
    }

    @NotNull
    private <T> CancellablePromise<T> promise(@NotNull Task<T, ?> task, int delay) {
        if (task == null) {
            Invoker.$$$reportNull$$$0(20);
        }
        if (delay < 0) {
            throw new IllegalArgumentException("delay must be non-negative: " + delay);
        }
        if (task.canInvoke(this.disposed)) {
            this.offerSafely(task, 0, delay);
        }
        AsyncPromise asyncPromise = task.promise;
        if (asyncPromise == null) {
            Invoker.$$$reportNull$$$0(21);
        }
        return asyncPromise;
    }

    @NotNull
    public static Invoker forEventDispatchThread(@NotNull Disposable parent) {
        if (parent == null) {
            Invoker.$$$reportNull$$$0(22);
        }
        return new EDT(parent);
    }

    @NotNull
    public static Invoker forBackgroundPoolWithReadAction(@NotNull Disposable parent) {
        if (parent == null) {
            Invoker.$$$reportNull$$$0(23);
        }
        return new Background(parent, true, 8);
    }

    @NotNull
    public static Invoker forBackgroundPoolWithoutReadAction(@NotNull Disposable parent) {
        if (parent == null) {
            Invoker.$$$reportNull$$$0(24);
        }
        return new Background(parent, false, 8);
    }

    @NotNull
    public static Invoker forBackgroundThreadWithReadAction(@NotNull Disposable parent) {
        if (parent == null) {
            Invoker.$$$reportNull$$$0(25);
        }
        return new Background(parent, true, 1);
    }

    @NotNull
    public static Invoker forBackgroundThreadWithoutReadAction(@NotNull Disposable parent) {
        if (parent == null) {
            Invoker.$$$reportNull$$$0(26);
        }
        return new Background(parent, false, 1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 19, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "useReadAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentName";
                break;
            }
            case 5: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/concurrency/Invoker";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwable";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/concurrency/Invoker";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "newDescription";
                break;
            }
            case 19: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "promise";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "newDescription";
                break;
            }
            case 5: 
            case 19: 
            case 21: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "compute";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "computeAsync";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "computeLater";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "invokeLater";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "runOrInvokeLater";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "offerSafely";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "invokeSafely";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "handleTaskError";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "offerRestart";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "promise";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "forEventDispatchThread";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "forBackgroundPoolWithReadAction";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "forBackgroundPoolWithoutReadAction";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "forBackgroundThreadWithReadAction";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "forBackgroundThreadWithoutReadAction";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 19, 21 -> new IllegalStateException(string);
        };
    }

    static abstract class Task<T, R>
    implements Runnable {
        final AsyncPromise<T> promise;
        private final Supplier<? extends R> supplier;
        private volatile R result;

        Task(@NotNull Supplier<? extends R> supplier) {
            if (supplier == null) {
                Task.$$$reportNull$$$0(0);
            }
            this.promise = new AsyncPromise();
            this.supplier = supplier;
        }

        boolean canRestart(boolean disposed, int attempt) {
            if (LOG.isTraceEnabled()) {
                LOG.debug("Task is canceled");
            }
            if (attempt < Integer.MAX_VALUE) {
                return this.canInvoke(disposed);
            }
            LOG.warn("Task is always canceled: " + String.valueOf(this.supplier));
            this.promise.setError("timeout");
            return false;
        }

        boolean canInvoke(boolean disposed) {
            Obsolescent obsolescent;
            if (this.promise.isDone()) {
                if (LOG.isTraceEnabled()) {
                    LOG.debug("Promise is cancelled: ", new Object[]{this.promise.isCancelled()});
                }
                return false;
            }
            if (disposed) {
                if (LOG.isTraceEnabled()) {
                    LOG.debug("Invoker is disposed");
                }
                this.promise.setError("disposed");
                return false;
            }
            Supplier<? extends R> supplier = this.supplier;
            if (supplier instanceof Obsolescent && (obsolescent = (Obsolescent)supplier).isObsolete()) {
                if (LOG.isTraceEnabled()) {
                    LOG.debug("Task is obsolete");
                }
                this.promise.setError("obsolete");
                return false;
            }
            return true;
        }

        R getResult() {
            return this.result;
        }

        void setDone(T r) {
            this.promise.setResult(r);
        }

        @Override
        public void run() {
            this.result = this.supplier.get();
        }

        public String toString() {
            return "Invoker.Task: " + String.valueOf(this.supplier);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supplier", "com/intellij/util/concurrency/Invoker$Task", "<init>"));
        }

        static class Async<T>
        extends Task<T, Promise<? extends T>> {
            Async(@NotNull Supplier<? extends Promise<? extends T>> supplier) {
                if (supplier == null) {
                    Async.$$$reportNull$$$0(0);
                }
                super(supplier);
            }

            @Nullable
            Promise<? extends T> setDone() {
                Promise res = (Promise)this.getResult();
                if (res == null) {
                    this.setDone(null);
                    return null;
                }
                if (res.getState() == Promise.State.PENDING) {
                    return res.onSuccess(this::setDone);
                }
                try {
                    this.setDone(res.blockingGet(0));
                }
                catch (ExecutionException e) {
                    ExceptionUtil.rethrow((Throwable)e.getCause());
                }
                catch (TimeoutException e) {
                    ExceptionUtil.rethrow((Throwable)e);
                }
                return null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supplier", "com/intellij/util/concurrency/Invoker$Task$Async", "<init>"));
            }
        }

        static class Sync<T>
        extends Task<T, T> {
            Sync(@NotNull Supplier<? extends T> supplier) {
                if (supplier == null) {
                    Sync.$$$reportNull$$$0(0);
                }
                super(supplier);
            }

            void setDone() {
                this.setDone(this.getResult());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "supplier", "com/intellij/util/concurrency/Invoker$Task$Sync", "<init>"));
            }
        }
    }

    private static final class Wrapper
    implements Obsolescent,
    Supplier<Void> {
        private final Runnable task;

        Wrapper(@NotNull Runnable task) {
            if (task == null) {
                Wrapper.$$$reportNull$$$0(0);
            }
            this.task = task;
        }

        @Override
        public Void get() {
            this.task.run();
            return null;
        }

        public boolean isObsolete() {
            return this.task instanceof Obsolescent && ((Obsolescent)this.task).isObsolete();
        }

        public String toString() {
            return this.task.toString();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/intellij/util/concurrency/Invoker$Wrapper", "<init>"));
        }
    }

    public static final class EDT
    extends Invoker {
        @Deprecated(forRemoval=true)
        public EDT(@NotNull Disposable parent) {
            if (parent == null) {
                EDT.$$$reportNull$$$0(0);
            }
            super(InvokerService.getInstance().forEdt(Invoker.newDescription("EDT", parent.toString(), ThreeState.UNSURE)), ThreeState.UNSURE);
            Disposer.register((Disposable)parent, (Disposable)this);
        }

        @Override
        public boolean isValidThread() {
            return EventQueue.isDispatchThread();
        }

        @Override
        void offer(@NotNull Runnable runnable, int delay, Promise<?> promise) {
            if (runnable == null) {
                EDT.$$$reportNull$$$0(1);
            }
            this.delegate.offer(runnable, delay, promise);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/concurrency/Invoker$EDT";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "offer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static final class Background
    extends Invoker {
        private final Set<Thread> threads;

        @Deprecated(forRemoval=true)
        public Background(@NotNull Disposable parent, int maxThreads) {
            if (parent == null) {
                Background.$$$reportNull$$$0(0);
            }
            this(parent, true, maxThreads);
        }

        private Background(@NotNull Disposable parent, boolean useReadAction, int maxThreads) {
            if (parent == null) {
                Background.$$$reportNull$$$0(1);
            }
            super(InvokerService.getInstance().forBgt(Invoker.newDescription((String)(maxThreads != 1 ? "Pool(" + maxThreads + ")" : "Thread"), String.valueOf(parent.toString()), useReadAction ? ThreeState.YES : ThreeState.NO), useReadAction, maxThreads), useReadAction ? ThreeState.YES : ThreeState.NO);
            this.threads = ConcurrentCollectionFactory.createConcurrentSet();
            Disposer.register((Disposable)parent, (Disposable)this);
        }

        @Override
        public boolean isValidThread() {
            return this.threads.contains(Thread.currentThread()) && super.isValidThread();
        }

        @Override
        void offer(@NotNull Runnable runnable, int delay, Promise<?> promise) {
            if (runnable == null) {
                Background.$$$reportNull$$$0(2);
            }
            this.delegate.offer(new ThreadTrackingRunnable(runnable, this.threads), delay, promise);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parent";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/concurrency/Invoker$Background";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "offer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ThreadTrackingRunnable
    implements Runnable {
        final Runnable myRunnable;
        final Set<Thread> myThreads;

        private ThreadTrackingRunnable(Runnable runnable, Set<Thread> threads) {
            this.myRunnable = runnable;
            this.myThreads = threads;
        }

        @Override
        public void run() {
            Thread thread = Thread.currentThread();
            if (!this.myThreads.add(thread)) {
                LOG.error("current thread is already used");
            } else {
                try {
                    this.myRunnable.run();
                }
                finally {
                    if (!this.myThreads.remove(thread)) {
                        LOG.error("current thread is already removed");
                    }
                }
            }
        }

        public String toString() {
            return "ThreadTrackingRunnable";
        }
    }
}

