/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.index;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.JavaFeature;
import com.intellij.psi.PsiJavaModule;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.impl.search.JavaSourceFilterScope;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StringStubIndexExtension;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaModuleNameIndex
extends StringStubIndexExtension<PsiJavaModule> {
    private static final int MIN_JAVA_VERSION = JavaFeature.MODULES.getMinimumLevel().feature();
    private static final JavaModuleNameIndex ourInstance = new JavaModuleNameIndex();

    public static JavaModuleNameIndex getInstance() {
        return ourInstance;
    }

    public int getVersion() {
        return super.getVersion() + 2;
    }

    @NotNull
    public StubIndexKey<String, PsiJavaModule> getKey() {
        StubIndexKey stubIndexKey = JavaStubIndexKeys.MODULE_NAMES;
        if (stubIndexKey == null) {
            JavaModuleNameIndex.$$$reportNull$$$0(0);
        }
        return stubIndexKey;
    }

    @Deprecated
    public Collection<PsiJavaModule> get(@NotNull String name, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        if (name == null) {
            JavaModuleNameIndex.$$$reportNull$$$0(1);
        }
        if (project == null) {
            JavaModuleNameIndex.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            JavaModuleNameIndex.$$$reportNull$$$0(3);
        }
        return this.getModules(name, project, scope);
    }

    public Collection<PsiJavaModule> getModules(@NotNull String name, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        Collection<PsiJavaModule> modules;
        if (name == null) {
            JavaModuleNameIndex.$$$reportNull$$$0(4);
        }
        if (project == null) {
            JavaModuleNameIndex.$$$reportNull$$$0(5);
        }
        if (scope == null) {
            JavaModuleNameIndex.$$$reportNull$$$0(6);
        }
        if ((modules = StubIndex.getElements(this.getKey(), (Object)name, (Project)project, (GlobalSearchScope)new JavaSourceFilterScope(scope), PsiJavaModule.class)).size() > 1) {
            modules = JavaModuleNameIndex.filterHighestVersions(project, modules);
        }
        return modules;
    }

    @NotNull
    private static Collection<PsiJavaModule> filterHighestVersions(@NotNull Project project, @NotNull Collection<PsiJavaModule> modules) {
        if (project == null) {
            JavaModuleNameIndex.$$$reportNull$$$0(7);
        }
        if (modules == null) {
            JavaModuleNameIndex.$$$reportNull$$$0(8);
        }
        ProjectFileIndex index = ProjectFileIndex.getInstance((Project)project);
        HashSet roots = new HashSet();
        for (PsiJavaModule javaModule : modules) {
            VirtualFile file = index.getClassRootForFile(javaModule.getContainingFile().getVirtualFile());
            ContainerUtil.addIfNotNull(roots, (Object)file);
        }
        HashSet<VirtualFile> filter = new HashSet<VirtualFile>();
        for (VirtualFile root : roots) {
            Collection<VirtualFile> descriptors = JavaModuleNameIndex.getSortedFileDescriptors(root);
            boolean found = false;
            for (VirtualFile descriptor : descriptors) {
                if (!found && JavaModuleNameIndex.isCorrectModulePath(root, descriptor)) {
                    found = true;
                    continue;
                }
                filter.add(descriptor);
            }
        }
        if (!filter.isEmpty()) {
            modules = ContainerUtil.filter(modules, m -> !filter.contains(m.getContainingFile().getVirtualFile()));
        }
        List list = modules;
        if (list == null) {
            JavaModuleNameIndex.$$$reportNull$$$0(9);
        }
        return list;
    }

    private static boolean isCorrectModulePath(@NotNull VirtualFile root, @Nullable VirtualFile descriptor) {
        if (root == null) {
            JavaModuleNameIndex.$$$reportNull$$$0(10);
        }
        if (descriptor == null) {
            return false;
        }
        return root.equals(descriptor.getParent()) || JavaModuleNameIndex.version(descriptor.getParent()) >= MIN_JAVA_VERSION;
    }

    public boolean traceKeyHashToVirtualFileMapping() {
        return true;
    }

    @NotNull
    private static Collection<VirtualFile> getSortedFileDescriptors(@NotNull VirtualFile root) {
        VirtualFile versionsDir;
        if (root == null) {
            JavaModuleNameIndex.$$$reportNull$$$0(11);
        }
        TreeMap<Integer, VirtualFile> results = new TreeMap<Integer, VirtualFile>((i1, i2) -> Integer.compare(i2, i1));
        VirtualFile rootModuleInfo = root.findChild("module-info.class");
        if (rootModuleInfo != null) {
            results.put(MIN_JAVA_VERSION, rootModuleInfo);
        }
        if ((versionsDir = root.findFileByRelativePath("META-INF/versions")) != null) {
            VirtualFile[] versions;
            for (VirtualFile version : versions = versionsDir.getChildren()) {
                VirtualFile moduleInfo = version.findChild("module-info.class");
                if (moduleInfo == null) continue;
                results.put(JavaModuleNameIndex.version(version), moduleInfo);
            }
        }
        Collection<VirtualFile> collection = results.values();
        if (collection == null) {
            JavaModuleNameIndex.$$$reportNull$$$0(12);
        }
        return collection;
    }

    private static int version(VirtualFile dir) {
        try {
            return Integer.parseInt(dir.getName());
        }
        catch (RuntimeException ignore) {
            return Integer.MIN_VALUE;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6, 7, 8, 10, 11 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/java/stubs/index/JavaModuleNameIndex";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modules";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/java/stubs/index/JavaModuleNameIndex";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "filterHighestVersions";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedFileDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getModules";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "filterHighestVersions";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isCorrectModulePath";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSortedFileDescriptors";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6, 7, 8, 10, 11 -> new IllegalArgumentException(string);
        };
    }
}

