/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.java.stubs.serializers;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.impl.cache.TypeInfo;
import com.intellij.psi.impl.java.stubs.PsiClassReferenceListStub;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.java.stubs.PsiJavaFileStub;
import com.intellij.psi.impl.java.stubs.impl.PsiClassReferenceListStubImpl;
import com.intellij.psi.impl.java.stubs.index.JavaStubIndexKeys;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.psi.stubs.StubSerializer;
import com.intellij.psi.tree.java.IJavaElementType;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class JavaClassReferenceListStubSerializer
implements StubSerializer<PsiClassReferenceListStub> {
    @NotNull
    private final IJavaElementType myType;

    public JavaClassReferenceListStubSerializer(@NotNull IJavaElementType elementType) {
        if (elementType == null) {
            JavaClassReferenceListStubSerializer.$$$reportNull$$$0(0);
        }
        this.myType = elementType;
    }

    public void serialize(@NotNull PsiClassReferenceListStub stub, @NotNull StubOutputStream dataStream) throws IOException {
        if (stub == null) {
            JavaClassReferenceListStubSerializer.$$$reportNull$$$0(1);
        }
        if (dataStream == null) {
            JavaClassReferenceListStubSerializer.$$$reportNull$$$0(2);
        }
        TypeInfo[] types = stub.getTypes();
        dataStream.writeVarInt(types.length);
        for (TypeInfo info : types) {
            TypeInfo.writeTYPE((StubOutputStream)dataStream, (TypeInfo)info);
        }
    }

    @NotNull
    public PsiClassReferenceListStub deserialize(@NotNull StubInputStream dataStream, StubElement parentStub) throws IOException {
        int len;
        if (dataStream == null) {
            JavaClassReferenceListStubSerializer.$$$reportNull$$$0(3);
        }
        TypeInfo[] infos = (len = dataStream.readVarInt()) == 0 ? TypeInfo.EMPTY_ARRAY : new TypeInfo[len];
        for (int i = 0; i < infos.length; ++i) {
            infos[i] = TypeInfo.readTYPE((StubInputStream)dataStream);
        }
        return new PsiClassReferenceListStubImpl(this.myType, parentStub, infos);
    }

    public void indexStub(@NotNull PsiClassReferenceListStub stub, @NotNull IndexSink sink) {
        PsiReferenceList.Role role;
        if (stub == null) {
            JavaClassReferenceListStubSerializer.$$$reportNull$$$0(4);
        }
        if (sink == null) {
            JavaClassReferenceListStubSerializer.$$$reportNull$$$0(5);
        }
        if ((role = stub.getRole()) == PsiReferenceList.Role.EXTENDS_LIST || role == PsiReferenceList.Role.IMPLEMENTS_LIST) {
            StubElement parentStub;
            String[] names;
            for (String name : names = stub.getReferencedNames()) {
                String shortName = PsiNameHelper.getShortClassName((String)name);
                if (StringUtil.isEmptyOrSpaces((String)shortName)) continue;
                sink.occurrence(JavaStubIndexKeys.SUPER_CLASSES, (Object)shortName);
            }
            if (role == PsiReferenceList.Role.EXTENDS_LIST && (parentStub = stub.getParentStub()) instanceof PsiClassStub) {
                PsiClassStub psiClassStub = (PsiClassStub)parentStub;
                if (psiClassStub.isEnum()) {
                    sink.occurrence(JavaStubIndexKeys.SUPER_CLASSES, (Object)"Enum");
                }
                if (psiClassStub.isAnnotationType()) {
                    sink.occurrence(JavaStubIndexKeys.SUPER_CLASSES, (Object)"Annotation");
                }
            }
        }
    }

    public boolean isAlwaysLeaf(@NotNull StubBase<?> root) {
        if (root == null) {
            JavaClassReferenceListStubSerializer.$$$reportNull$$$0(6);
        }
        return root instanceof PsiJavaFileStub && ((PsiJavaFileStub)root).isCompiled();
    }

    @NotNull
    public String getExternalId() {
        String string = "java." + String.valueOf(this.myType);
        if (string == null) {
            JavaClassReferenceListStubSerializer.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/java/stubs/serializers/JavaClassReferenceListStubSerializer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/java/stubs/serializers/JavaClassReferenceListStubSerializer";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "deserialize";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "indexStub";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAlwaysLeaf";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

