/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.ide.highlighter.JavaClassFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;

public class JavaSourceFilterScope
extends DelegatingGlobalSearchScope {
    @Nullable
    private final FileIndexFacade myIndex;
    private final boolean myIncludeLibrarySources;

    public JavaSourceFilterScope(@NotNull GlobalSearchScope delegate) {
        if (delegate == null) {
            JavaSourceFilterScope.$$$reportNull$$$0(0);
        }
        this(delegate, false);
    }

    public JavaSourceFilterScope(@NotNull GlobalSearchScope delegate, boolean includeLibrarySources) {
        if (delegate == null) {
            JavaSourceFilterScope.$$$reportNull$$$0(1);
        }
        super(delegate);
        Project project = this.getProject();
        this.myIndex = project == null ? null : FileIndexFacade.getInstance((Project)project);
        this.myIncludeLibrarySources = includeLibrarySources;
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            JavaSourceFilterScope.$$$reportNull$$$0(2);
        }
        if (!super.contains(file)) {
            return false;
        }
        if (this.myIndex == null) {
            return false;
        }
        if (FileTypeRegistry.getInstance().isFileOfType(file, (FileType)JavaClassFileType.INSTANCE)) {
            return this.myIndex.isInLibraryClasses(file);
        }
        return this.myIndex.isUnderSourceRootOfType(file, JavaModuleSourceRootTypes.SOURCES) || (this.myIncludeLibrarySources || this.myBaseScope.isForceSearchingInLibrarySources()) && this.myIndex.isInLibrarySource(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "delegate";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/search/JavaSourceFilterScope";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "contains";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

