/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.Strings;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.impl.ResolveScopeManager;
import com.intellij.psi.impl.source.resolve.JavaResolveUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiUtil;
import com.intellij.reference.SoftReference;
import java.lang.ref.Reference;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;

public final class RelaxedDirectInheritorChecker {
    private final String myBaseClassName;
    private final PsiClass myBaseClass;
    private final NotNullLazyValue<ClassesAndAmbiguities> myClasses;
    private final ProjectFileIndex myFileIndex;
    private static final String LOCAL_CLASS_FOUND = "?LOCAL_CLASS_FOUND";
    private static final String AMBIGUITY_FOUND = "?AMBIGUITY_FOUND";

    public RelaxedDirectInheritorChecker(@NotNull PsiClass baseClass) {
        if (baseClass == null) {
            RelaxedDirectInheritorChecker.$$$reportNull$$$0(0);
        }
        this.myBaseClass = baseClass;
        this.myBaseClassName = Objects.requireNonNull(baseClass.getName());
        this.myClasses = NotNullLazyValue.volatileLazy(() -> RelaxedDirectInheritorChecker.getClassesAndTheirAmbiguities(this.myBaseClass.getProject(), this.myBaseClassName));
        this.myFileIndex = ProjectFileIndex.getInstance((Project)this.myBaseClass.getProject());
    }

    @NotNull
    private static ClassesAndAmbiguities getClassesAndTheirAmbiguities(@NotNull Project project, @NotNull String classShortName) {
        Map cache;
        ClassesAndAmbiguities result;
        if (project == null) {
            RelaxedDirectInheritorChecker.$$$reportNull$$$0(1);
        }
        if (classShortName == null) {
            RelaxedDirectInheritorChecker.$$$reportNull$$$0(2);
        }
        if ((result = (ClassesAndAmbiguities)SoftReference.dereference((Reference)((Reference)(cache = (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> CachedValueProvider.Result.create(new ConcurrentHashMap(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}))).get(classShortName)))) == null) {
            PsiClass[] classes = PsiShortNamesCache.getInstance((Project)project).getClassesByName(classShortName, GlobalSearchScope.allScope((Project)project));
            String ambiguity = null;
            PsiFile[] files = new PsiFile[classes.length];
            for (int i = 0; i < classes.length; ++i) {
                PsiClass psiClass = classes[i];
                ambiguity = RelaxedDirectInheritorChecker.hasAmbiguitiesSoFar(psiClass, ambiguity);
                files[i] = psiClass.getContainingFile();
            }
            boolean ambiguities = Strings.areSameInstance(ambiguity, (String)AMBIGUITY_FOUND);
            result = new ClassesAndAmbiguities(classes, files, ambiguities);
            cache.put(classShortName, new java.lang.ref.SoftReference<ClassesAndAmbiguities>(result));
        }
        ClassesAndAmbiguities classesAndAmbiguities = result;
        if (classesAndAmbiguities == null) {
            RelaxedDirectInheritorChecker.$$$reportNull$$$0(3);
        }
        return classesAndAmbiguities;
    }

    private static String hasAmbiguitiesSoFar(@NotNull PsiClass psiClass, String oldFqn) {
        if (psiClass == null) {
            RelaxedDirectInheritorChecker.$$$reportNull$$$0(4);
        }
        if (Strings.areSameInstance((String)oldFqn, (String)AMBIGUITY_FOUND)) {
            return AMBIGUITY_FOUND;
        }
        String qName = Objects.requireNonNullElse(psiClass.getQualifiedName(), LOCAL_CLASS_FOUND);
        return oldFqn == null || oldFqn.equals(qName) && !oldFqn.equals(LOCAL_CLASS_FOUND) ? qName : AMBIGUITY_FOUND;
    }

    public boolean checkInheritance(@NotNull PsiClass inheritorCandidate) {
        if (inheritorCandidate == null) {
            RelaxedDirectInheritorChecker.$$$reportNull$$$0(5);
        }
        if (!inheritorCandidate.isValid() || !this.myBaseClass.isValid()) {
            return false;
        }
        PsiFile inheritorCandidateContainingFile = inheritorCandidate.getContainingFile();
        if (this.myFileIndex.isInSourceContent(inheritorCandidateContainingFile.getVirtualFile())) {
            ClassesAndAmbiguities value = (ClassesAndAmbiguities)this.myClasses.getValue();
            boolean hasGlobalAmbiguities = value.isAmbiguous;
            if (!hasGlobalAmbiguities) {
                return true;
            }
            PsiClass[] classes = value.classes;
            PsiFile[] files = value.containingFiles;
            GlobalSearchScope scope = ResolveScopeManager.getInstance((Project)inheritorCandidateContainingFile.getProject()).getResolveScope((PsiElement)inheritorCandidateContainingFile);
            String ambiguity = null;
            boolean hasBaseClass = false;
            for (int i = 0; i < classes.length; ++i) {
                PsiClass base = classes[i];
                PsiFile file = files[i];
                if (!PsiSearchScopeUtil.isInScope((GlobalSearchScope)scope, (PsiElement)file) || !RelaxedDirectInheritorChecker.isAccessibleLight(inheritorCandidate, inheritorCandidateContainingFile, base)) continue;
                hasBaseClass |= base.equals((Object)this.myBaseClass);
                ambiguity = RelaxedDirectInheritorChecker.hasAmbiguitiesSoFar(base, ambiguity);
            }
            if (!Strings.areSameInstance(ambiguity, (String)AMBIGUITY_FOUND)) {
                return hasBaseClass;
            }
        }
        if (inheritorCandidate instanceof PsiCompiledElement && this.isEnumOrAnnotationInheritor(inheritorCandidate)) {
            return true;
        }
        return inheritorCandidate.isInheritor(this.myBaseClass, false);
    }

    private boolean isEnumOrAnnotationInheritor(@NotNull PsiClass inheritorCandidate) {
        if (inheritorCandidate == null) {
            RelaxedDirectInheritorChecker.$$$reportNull$$$0(6);
        }
        return inheritorCandidate.isEnum() && "java.lang.Enum".equals(this.myBaseClass.getQualifiedName()) || inheritorCandidate.isAnnotationType() && "java.lang.annotation.Annotation".equals(this.myBaseClass.getQualifiedName());
    }

    private static boolean isAccessibleLight(@NotNull PsiClass inheritorCandidate, @NotNull PsiFile inheritorCandidateContainingFile, @NotNull PsiClass base) {
        PsiModifierList modifierList;
        if (inheritorCandidate == null) {
            RelaxedDirectInheritorChecker.$$$reportNull$$$0(7);
        }
        if (inheritorCandidateContainingFile == null) {
            RelaxedDirectInheritorChecker.$$$reportNull$$$0(8);
        }
        if (base == null) {
            RelaxedDirectInheritorChecker.$$$reportNull$$$0(9);
        }
        if ((modifierList = base.getModifierList()) != null && PsiUtil.getAccessLevel((PsiModifierList)modifierList) == 3) {
            return true;
        }
        return JavaResolveUtil.isAccessible((PsiMember)base, (PsiClass)base.getContainingClass(), (PsiModifierList)modifierList, (PsiElement)inheritorCandidate, null, null, (PsiFile)inheritorCandidateContainingFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classShortName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/search/RelaxedDirectInheritorChecker";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inheritorCandidate";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inheritorCandidateContainingFile";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/search/RelaxedDirectInheritorChecker";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassesAndTheirAmbiguities";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getClassesAndTheirAmbiguities";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasAmbiguitiesSoFar";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkInheritance";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isEnumOrAnnotationInheritor";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isAccessibleLight";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }

    private record ClassesAndAmbiguities(@NotNull @NotNull PsiClass @NotNull [] classes, @NotNull @NotNull PsiFile @NotNull [] containingFiles, boolean isAmbiguous) {
        @NotNull
        private final @NotNull PsiClass @NotNull [] classes;
        @NotNull
        private final @NotNull PsiFile @NotNull [] containingFiles;

        private ClassesAndAmbiguities(@NotNull @NotNull PsiClass @NotNull [] classes, @NotNull @NotNull PsiFile @NotNull [] containingFiles, boolean isAmbiguous) {
            if (classes == null) {
                ClassesAndAmbiguities.$$$reportNull$$$0(0);
            }
            if (containingFiles == null) {
                ClassesAndAmbiguities.$$$reportNull$$$0(1);
            }
        }

        @NotNull
        public @NotNull PsiClass @NotNull [] classes() {
            if (this.classes == null) {
                ClassesAndAmbiguities.$$$reportNull$$$0(2);
            }
            return this.classes;
        }

        @NotNull
        public @NotNull PsiFile @NotNull [] containingFiles() {
            if (this.containingFiles == null) {
                ClassesAndAmbiguities.$$$reportNull$$$0(3);
            }
            return this.containingFiles;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "classes";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "containingFiles";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/impl/search/RelaxedDirectInheritorChecker$ClassesAndAmbiguities";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/impl/search/RelaxedDirectInheritorChecker$ClassesAndAmbiguities";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "classes";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "containingFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

