/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.lang.spi.SPILanguage;
import com.intellij.openapi.application.QueryExecutorBase;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.ClassUtil;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;

public final class SPIReferencesSearcher
extends QueryExecutorBase<PsiReference, ReferencesSearch.SearchParameters> {
    public SPIReferencesSearcher() {
        super(true);
    }

    public void processQuery(@NotNull ReferencesSearch.SearchParameters p, @NotNull Processor<? super PsiReference> consumer) {
        block10: {
            String[] filenames;
            SearchScope scope;
            PsiElement element;
            block9: {
                PsiFile[] files;
                if (p == null) {
                    SPIReferencesSearcher.$$$reportNull$$$0(0);
                }
                if (consumer == null) {
                    SPIReferencesSearcher.$$$reportNull$$$0(1);
                }
                if (!(element = p.getElementToSearch()).isValid()) {
                    return;
                }
                scope = p.getEffectiveSearchScope();
                if (!(scope instanceof GlobalSearchScope)) {
                    return;
                }
                if (!(element instanceof PsiClass)) break block9;
                PsiClass aClass = (PsiClass)element;
                String jvmClassName = ClassUtil.getJVMClassName((PsiClass)aClass);
                if (jvmClassName == null) {
                    return;
                }
                for (PsiFile file : files = FilenameIndex.getFilesByName((Project)aClass.getProject(), (String)jvmClassName, (GlobalSearchScope)((GlobalSearchScope)scope))) {
                    PsiReference reference;
                    if (file.getLanguage() != SPILanguage.INSTANCE || (reference = file.getReference()) == null) continue;
                    consumer.process((Object)reference);
                }
                break block10;
            }
            if (!(element instanceof PsiPackage)) break block10;
            String qualifiedName = ((PsiPackage)element).getQualifiedName();
            Project project = element.getProject();
            for (String filename : filenames = FilenameIndex.getAllFilenames((Project)project)) {
                PsiFile[] files;
                if (!filename.startsWith(qualifiedName + ".")) continue;
                for (PsiFile file : files = FilenameIndex.getFilesByName((Project)project, (String)filename, (GlobalSearchScope)((GlobalSearchScope)scope))) {
                    PsiReference[] references;
                    if (file.getLanguage() != SPILanguage.INSTANCE) continue;
                    for (PsiReference reference : references = file.getReferences()) {
                        if (!reference.getCanonicalText().equals(qualifiedName)) continue;
                        consumer.process((Object)reference);
                    }
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "p";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "consumer";
                break;
            }
        }
        objectArray[1] = "com/intellij/psi/impl/search/SPIReferencesSearcher";
        objectArray[2] = "processQuery";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

