/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ui.AvailableFactories;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.ChangesGroupingPolicyFactory;
import com.intellij.openapi.vcs.changes.ui.DefaultChangesGroupingPolicy;
import com.intellij.openapi.vcs.changes.ui.GroupingPolicyFactoryHolder;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.tree.DefaultTreeModel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 02\u00020\u0001:\u0003./0B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0016\u0010\u0019\u001a\u00020\u00062\u000b\u0010\u001a\u001a\u00070\u0011\u00a2\u0006\u0002\b\u001bH\u0086\u0002J\u0019\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u0006H\u0087\u0002J\u0016\u0010%\u001a\u00020\u001d2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00110'H\u0007J\u0016\u0010(\u001a\u00020\u001d2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00110'H\u0007J\u0010\u0010)\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\u0011H\u0016J\u000e\u0010*\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020,J\u000e\u0010-\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020,R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u000f\u001a2\u0012\u000e\u0012\f0\u0011\u00a2\u0006\u0002\b\u0012\u00a2\u0006\u0002\b\u0013 \u0015*\u0017\u0012\u000e\u0012\f0\u0011\u00a2\u0006\u0002\b\u0012\u00a2\u0006\u0002\b\u00130\u0014\u00a2\u0006\u0002\b\u00120\u0010\u00a2\u0006\u0002\b\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0016\u001a\u0012\u0012\u000e\u0012\f0\u0011\u00a2\u0006\u0002\b\u0012\u00a2\u0006\u0002\b\u00130\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u001f\u001a\u00020 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\fR\u0011\u0010$\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\f\u00a8\u00061"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingSupport;", "", "project", "Lcom/intellij/openapi/project/Project;", "source", "showConflictsNode", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/Object;Z)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getShowConflictsNode", "()Z", "changeSupport", "Ljava/beans/PropertyChangeSupport;", "_groupingKeys", "", "", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "", "kotlin.jvm.PlatformType", "groupingKeys", "getGroupingKeys", "()Ljava/util/Set;", "get", "groupingKey", "Lorg/jetbrains/annotations/NonNls;", "set", "", "state", "grouping", "Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingPolicyFactory;", "getGrouping", "()Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingPolicyFactory;", "isNone", "isDirectory", "setGroupingKeysOrSkip", "newGroupingKeys", "", "setGroupingKeys", "isAvailable", "addPropertyChangeListener", "listener", "Ljava/beans/PropertyChangeListener;", "removePropertyChangeListener", "CombinedGroupingPolicyFactory", "Disabled", "Companion", "intellij.platform.vcs.impl.shared"})
@SourceDebugExtension(value={"SMAP\nChangesGroupingSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangesGroupingSupport.kt\ncom/intellij/openapi/vcs/changes/ui/ChangesGroupingSupport\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n777#2:114\n873#2,2:115\n*S KotlinDebug\n*F\n+ 1 ChangesGroupingSupport.kt\ncom/intellij/openapi/vcs/changes/ui/ChangesGroupingSupport\n*L\n49#1:114\n49#1:115,2\n*E\n"})
public class ChangesGroupingSupport {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    private final boolean showConflictsNode;
    @NotNull
    private final PropertyChangeSupport changeSupport;
    @NotNull
    private final Set<String> _groupingKeys;
    @JvmField
    @NotNull
    public static final DataKey<ChangesGroupingSupport> KEY = DataKey.Companion.create("ChangesTree.GroupingSupport");
    @NotNull
    public static final String PROP_GROUPING_KEYS = "ChangesGroupingKeys";
    @NotNull
    public static final String DIRECTORY_GROUPING = "directory";
    @NotNull
    public static final String MODULE_GROUPING = "module";
    @NotNull
    public static final String REPOSITORY_GROUPING = "repository";
    @NotNull
    public static final String NONE_GROUPING = "none";

    public ChangesGroupingSupport(@NotNull Project project, @NotNull Object source, boolean showConflictsNode) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.project = project;
        this.showConflictsNode = showConflictsNode;
        this.changeSupport = new PropertyChangeSupport(source);
        Set set = ConcurrentCollectionFactory.createConcurrentSet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"createConcurrentSet(...)");
        this._groupingKeys = set;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final boolean getShowConflictsNode() {
        return this.showConflictsNode;
    }

    @NotNull
    public final Set<String> getGroupingKeys() {
        return CollectionsKt.toSet((Iterable)this._groupingKeys);
    }

    public final boolean get(@NotNull String groupingKey) {
        Intrinsics.checkNotNullParameter((Object)groupingKey, (String)"groupingKey");
        if (!this.isAvailable(groupingKey)) {
            return false;
        }
        return this._groupingKeys.contains(groupingKey);
    }

    @RequiresEdt
    public final void set(@NotNull String groupingKey, boolean state) {
        Intrinsics.checkNotNullParameter((Object)groupingKey, (String)"groupingKey");
        if (!this.isAvailable(groupingKey)) {
            throw new IllegalArgumentException("Unknown grouping " + groupingKey);
        }
        boolean currentState = this._groupingKeys.contains(groupingKey);
        if (currentState == state) {
            return;
        }
        Set oldGroupingKeys = CollectionsKt.toSet((Iterable)this._groupingKeys);
        if (state) {
            ((Collection)this._groupingKeys).add(groupingKey);
        } else {
            ((Collection)this._groupingKeys).remove(groupingKey);
        }
        this.changeSupport.firePropertyChange(PROP_GROUPING_KEYS, oldGroupingKeys, CollectionsKt.toSet((Iterable)this._groupingKeys));
    }

    @NotNull
    public final ChangesGroupingPolicyFactory getGrouping() {
        return new CombinedGroupingPolicyFactory();
    }

    public final boolean isNone() {
        return this._groupingKeys.isEmpty();
    }

    public final boolean isDirectory() {
        return this.get(DIRECTORY_GROUPING);
    }

    /*
     * WARNING - void declaration
     */
    @RequiresEdt
    public final void setGroupingKeysOrSkip(@NotNull Collection<String> newGroupingKeys) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(newGroupingKeys, (String)"newGroupingKeys");
        this._groupingKeys.clear();
        Collection collection = this._groupingKeys;
        Iterable $this$filter$iv = newGroupingKeys;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String groupingKey = (String)element$iv$iv;
            boolean bl = false;
            if (!this.isAvailable(groupingKey)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable iterable2 = (List)destination$iv$iv;
        CollectionsKt.addAll((Collection)collection, (Iterable)iterable2);
    }

    @ApiStatus.Internal
    @RequiresEdt
    public final void setGroupingKeys(@NotNull Collection<String> groupingKeys) {
        Intrinsics.checkNotNullParameter(groupingKeys, (String)"groupingKeys");
        Set oldGroupingKeys = CollectionsKt.toSet((Iterable)this._groupingKeys);
        this.setGroupingKeysOrSkip(groupingKeys);
        if (!Intrinsics.areEqual((Object)oldGroupingKeys, this._groupingKeys)) {
            this.changeSupport.firePropertyChange(PROP_GROUPING_KEYS, oldGroupingKeys, CollectionsKt.toSet((Iterable)this._groupingKeys));
        }
    }

    public boolean isAvailable(@NotNull String groupingKey) {
        Intrinsics.checkNotNullParameter((Object)groupingKey, (String)"groupingKey");
        return Companion.findFactory(groupingKey) != null;
    }

    public final void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public final void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        this.changeSupport.removePropertyChangeListener(listener);
    }

    @JvmStatic
    @Nullable
    public static final ChangesGroupingPolicyFactory findFactory(@NotNull String key) {
        return Companion.findFactory(key);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingSupport$CombinedGroupingPolicyFactory;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingPolicyFactory;", "<init>", "(Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingSupport;)V", "createGroupingPolicy", "Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingPolicy;", "project", "Lcom/intellij/openapi/project/Project;", "model", "Ljavax/swing/tree/DefaultTreeModel;", "intellij.platform.vcs.impl.shared"})
    @SourceDebugExtension(value={"SMAP\nChangesGroupingSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangesGroupingSupport.kt\ncom/intellij/openapi/vcs/changes/ui/ChangesGroupingSupport$CombinedGroupingPolicyFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,113:1\n1915#2:114\n1916#2:116\n1#3:115\n*S KotlinDebug\n*F\n+ 1 ChangesGroupingSupport.kt\ncom/intellij/openapi/vcs/changes/ui/ChangesGroupingSupport$CombinedGroupingPolicyFactory\n*L\n75#1:114\n75#1:116\n*E\n"})
    private final class CombinedGroupingPolicyFactory
    extends ChangesGroupingPolicyFactory {
        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public ChangesGroupingPolicy createGroupingPolicy(@NotNull Project project, @NotNull DefaultTreeModel model) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)model, (String)"model");
            Ref.ObjectRef result = new Ref.ObjectRef();
            result.element = new DefaultChangesGroupingPolicy.Factory(ChangesGroupingSupport.this.getShowConflictsNode()).createGroupingPolicy(project, model);
            Iterable $this$forEach$iv = Companion.sortedFactoriesFor(ChangesGroupingSupport.this._groupingKeys);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$createGroupingPolicy_u24lambda_u240_u240;
                ChangesGroupingPolicy changesGroupingPolicy;
                ChangesGroupingPolicyFactory factory = (ChangesGroupingPolicyFactory)element$iv;
                boolean bl = false;
                ChangesGroupingPolicy changesGroupingPolicy2 = changesGroupingPolicy = factory.createGroupingPolicy(project, model);
                Ref.ObjectRef objectRef = result;
                boolean bl2 = false;
                $this$createGroupingPolicy_u24lambda_u240_u240.setNextGroupingPolicy((ChangesGroupingPolicy)result.element);
                Intrinsics.checkNotNullExpressionValue((Object)changesGroupingPolicy, (String)"apply(...)");
                objectRef.element = objectRef.element;
            }
            return (ChangesGroupingPolicy)result.element;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\bH\u0007J\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\b0\u0013H\u0002R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingSupport$Companion;", "", "<init>", "()V", "KEY", "Lcom/intellij/openapi/actionSystem/DataKey;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingSupport;", "PROP_GROUPING_KEYS", "", "DIRECTORY_GROUPING", "MODULE_GROUPING", "REPOSITORY_GROUPING", "NONE_GROUPING", "findFactory", "Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingPolicyFactory;", "key", "sortedFactoriesFor", "", "keys", "", "intellij.platform.vcs.impl.shared"})
    @SourceDebugExtension(value={"SMAP\nChangesGroupingSupport.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ChangesGroupingSupport.kt\ncom/intellij/openapi/vcs/changes/ui/ChangesGroupingSupport$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,113:1\n1080#2:114\n1586#2:115\n1661#2,3:116\n*S KotlinDebug\n*F\n+ 1 ChangesGroupingSupport.kt\ncom/intellij/openapi/vcs/changes/ui/ChangesGroupingSupport$Companion\n*L\n106#1:114\n107#1:115\n107#1:116,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final ChangesGroupingPolicyFactory findFactory(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            AvailableFactories availableFactories = GroupingPolicyFactoryHolder.Companion.getInstance().getFactories();
            return availableFactories.getKeyToFactory().get(key);
        }

        /*
         * WARNING - void declaration
         */
        private final List<ChangesGroupingPolicyFactory> sortedFactoriesFor(Collection<String> keys) {
            void $this$mapTo$iv$iv;
            AvailableFactories availableFactories = GroupingPolicyFactoryHolder.Companion.getInstance().getFactories();
            Iterable $this$sortedByDescending$iv = keys;
            boolean $i$f$sortedByDescending = false;
            Iterable $this$map$iv = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(availableFactories){
                final /* synthetic */ AvailableFactories $availableFactories$inlined;
                {
                    this.$availableFactories$inlined = availableFactories;
                }

                public final int compare(T a, T b) {
                    String it = (String)b;
                    boolean bl = false;
                    Integer n = this.$availableFactories$inlined.getKeyToWeight().get(it);
                    it = (String)a;
                    Comparable comparable = Integer.valueOf(n != null ? n : 100);
                    bl = false;
                    Integer n2 = this.$availableFactories$inlined.getKeyToWeight().get(it);
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(n2 != null ? n2 : 100));
                }
            });
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void groupingKey;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                ChangesGroupingPolicyFactory changesGroupingPolicyFactory = availableFactories.getKeyToFactory().get(groupingKey);
                if (changesGroupingPolicyFactory == null) {
                    throw new IllegalArgumentException("Unknown grouping: " + (String)groupingKey);
                }
                collection.add(changesGroupingPolicyFactory);
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingSupport$Disabled;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesGroupingSupport;", "project", "Lcom/intellij/openapi/project/Project;", "source", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/Object;)V", "isAvailable", "", "groupingKey", "", "intellij.platform.vcs.impl.shared"})
    public static final class Disabled
    extends ChangesGroupingSupport {
        public Disabled(@NotNull Project project, @NotNull Object source) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)source, (String)"source");
            super(project, source, false);
        }

        @Override
        public boolean isAvailable(@NotNull String groupingKey) {
            Intrinsics.checkNotNullParameter((Object)groupingKey, (String)"groupingKey");
            return false;
        }
    }
}

