/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNode;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserNodeRenderer;
import com.intellij.openapi.vcs.changes.ui.RepositoryChangesBrowserNodeBaseKt;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.FontUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\b&\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\rH\u0016J\b\u0010\u0010\u001a\u00020\u0011H$J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0017\u0010\u0013\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u0005\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0014J\u001a\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\u00172\u0006\u0010\u0018\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010\u0019J\u001a\u0010\u001a\u001a\u00070\u0016\u00a2\u0006\u0002\b\u00172\u0006\u0010\u0018\u001a\u00028\u0001H\u0014\u00a2\u0006\u0002\u0010\u0019J\b\u0010\u001b\u001a\u00020\u001cH\u0016\u00a8\u0006\u001d"}, d2={"Lcom/intellij/openapi/vcs/changes/ui/RepositoryChangesBrowserNodeBase;", "R", "B", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNode$NodeWithFilePath;", "repository", "<init>", "(Ljava/lang/Object;)V", "render", "", "renderer", "Lcom/intellij/openapi/vcs/changes/ui/ChangesBrowserNodeRenderer;", "selected", "", "expanded", "hasFocus", "getIcon", "Ljavax/swing/Icon;", "appendCurrentBranch", "getCurrentBranch", "(Ljava/lang/Object;)Ljava/lang/Object;", "getBranchText", "", "Lorg/jetbrains/annotations/Nls;", "branch", "(Ljava/lang/Object;)Ljava/lang/String;", "getBranchTooltipText", "getSortWeight", "", "intellij.platform.vcs.impl.shared"})
public abstract class RepositoryChangesBrowserNodeBase<R, B>
extends ChangesBrowserNode<R>
implements ChangesBrowserNode.NodeWithFilePath {
    public RepositoryChangesBrowserNodeBase(R repository) {
        super(repository);
    }

    @Override
    public void render(@NotNull ChangesBrowserNodeRenderer renderer, boolean selected, boolean expanded, boolean hasFocus) {
        Intrinsics.checkNotNullParameter((Object)((Object)renderer), (String)"renderer");
        renderer.setIcon(this.getIcon());
        renderer.append(" " + this.getTextPresentation(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        this.appendCount(renderer);
        if (renderer.isShowingLocalChanges()) {
            this.appendCurrentBranch(renderer);
        }
    }

    @NotNull
    protected abstract Icon getIcon();

    private final void appendCurrentBranch(ChangesBrowserNodeRenderer renderer) {
        Object repository = this.getUserObject();
        B branch = this.getCurrentBranch(repository);
        if (branch != null) {
            renderer.append(FontUtil.spaceAndThinSpace());
            String string = " " + this.getBranchText(branch) + " ";
            Color color = renderer.getBackground();
            if (color == null) {
                Color color2 = UIUtil.getTreeBackground();
                color = color2;
                Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getTreeBackground(...)");
            }
            renderer.append(string, RepositoryChangesBrowserNodeBaseKt.access$getBranchLabelAttributes(color));
            renderer.setBackgroundInsets(RepositoryChangesBrowserNodeBaseKt.access$getBRANCH_BACKGROUND_INSETS$p());
            renderer.setToolTipText(this.getBranchTooltipText(branch));
        }
    }

    @Nullable
    protected B getCurrentBranch(R repository) {
        return null;
    }

    @NotNull
    protected String getBranchText(B branch) {
        return "";
    }

    @NotNull
    protected String getBranchTooltipText(B branch) {
        return "";
    }

    @Override
    public int getSortWeight() {
        return 3;
    }
}

