/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.AnnotationPanelModel;
import com.intellij.core.JavaPsiBundle;
import com.intellij.ide.util.TreeClassChooser;
import com.intellij.ide.util.TreeClassChooserFactory;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.BooleanTableCellRenderer;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.dsl.builder.DslComponentProperty;
import com.intellij.ui.dsl.builder.VerticalComponentGap;
import com.intellij.ui.table.JBTable;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.UI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class NullableAnnotationsPanel {
    private final Project myProject;
    private final Set<String> myDefaultAnnotations;
    private final JBTable myTable;
    private final JPanel myComponent;
    private final ComboBox<String> myCombo;
    protected final DefaultTableModel myTableModel;

    public NullableAnnotationsPanel(Project project, @NotNull AnnotationPanelModel model, boolean showInstrumentationOptions) {
        if (model == null) {
            NullableAnnotationsPanel.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.myDefaultAnnotations = new HashSet<String>(model.getDefaultAnnotations());
        List<String> annotations = model.getAnnotations();
        this.myCombo = new ComboBox((Object[])((String[])annotations.stream().sorted().toArray(String[]::new)));
        String defaultAnnotation = model.getDefaultAnnotation();
        if (!annotations.contains(defaultAnnotation)) {
            this.addAnnotationToCombo(defaultAnnotation);
        }
        if (model.hasAdvancedAnnotations()) {
            this.loadAdvancedAnnotations(model);
        }
        this.myCombo.setSelectedItem((Object)defaultAnnotation);
        this.myTableModel = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 1;
            }
        };
        this.myTableModel.setColumnCount(showInstrumentationOptions ? 2 : 1);
        for (String annotation : annotations) {
            this.addRow(annotation, model.getCheckedAnnotations().contains(annotation));
        }
        DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
        columnModel.addColumn(new TableColumn(0, 100, (TableCellRenderer)new ColoredTableCellRenderer(){

            public void acquireState(JTable table, boolean isSelected, boolean hasFocus, int row, int column) {
                super.acquireState(table, isSelected, false, row, column);
            }

            protected void customizeCellRenderer(@NotNull JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                if (table == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.append((String)value, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/codeInsight/NullableAnnotationsPanel$2", "customizeCellRenderer"));
            }
        }, null));
        this.myTable = new JBTable((TableModel)this.myTableModel, (TableColumnModel)columnModel);
        if (!showInstrumentationOptions) {
            this.myTable.setTableHeader(null);
        }
        if (showInstrumentationOptions) {
            columnModel.getColumn(0).setHeaderValue(JavaPsiBundle.message((String)"node.annotation.tooltip", (Object[])new Object[0]));
            TableColumn checkColumn = new TableColumn(1, 100, (TableCellRenderer)new BooleanTableCellRenderer(), (TableCellEditor)new BooleanTableCellEditor());
            columnModel.addColumn(checkColumn);
            checkColumn.setHeaderValue(" " + JavaBundle.message("nullable.notnull.annotations.panel.column.instrument", new Object[0]) + " ");
            TableCellRenderer headerRenderer = this.createHeaderRenderer();
            this.myTable.getTableHeader().setDefaultRenderer(headerRenderer);
            checkColumn.setHeaderRenderer(headerRenderer);
            checkColumn.sizeWidthToFit();
        }
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator((JTable)this.myTable).setMoveUpAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                int selectedRow = NullableAnnotationsPanel.this.myTable.getSelectedRow();
                if (selectedRow < 1) {
                    return;
                }
                List vector = NullableAnnotationsPanel.this.myTableModel.getDataVector().get(selectedRow);
                NullableAnnotationsPanel.this.myTableModel.removeRow(selectedRow);
                NullableAnnotationsPanel.this.myTableModel.insertRow(selectedRow - 1, vector.toArray());
                NullableAnnotationsPanel.this.myTable.setRowSelectionInterval(selectedRow - 1, selectedRow - 1);
            }
        }).setMoveDownAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                int selectedRow = NullableAnnotationsPanel.this.myTable.getSelectedRow();
                if (selectedRow < 0 || selectedRow >= NullableAnnotationsPanel.this.myTableModel.getRowCount() - 1) {
                    return;
                }
                List vector = NullableAnnotationsPanel.this.myTableModel.getDataVector().get(selectedRow);
                NullableAnnotationsPanel.this.myTableModel.removeRow(selectedRow);
                NullableAnnotationsPanel.this.myTableModel.insertRow(selectedRow + 1, vector.toArray());
                NullableAnnotationsPanel.this.myTable.setRowSelectionInterval(selectedRow + 1, selectedRow + 1);
            }
        }).setAddAction(b -> this.chooseAnnotation(model.getName())).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                String selectedValue = NullableAnnotationsPanel.this.getSelectedAnnotation();
                if (selectedValue == null) {
                    return;
                }
                NullableAnnotationsPanel.this.myCombo.removeItem((Object)selectedValue);
                int rowIndex = -1;
                for (int i = 0; i < NullableAnnotationsPanel.this.myTableModel.getDataVector().size(); ++i) {
                    if (!NullableAnnotationsPanel.this.myTableModel.getDataVector().get(i).contains(selectedValue)) continue;
                    rowIndex = i;
                    break;
                }
                if (rowIndex != -1) {
                    NullableAnnotationsPanel.this.myTableModel.removeRow(rowIndex);
                }
            }
        }).setRemoveActionUpdater(e -> !this.myDefaultAnnotations.contains(this.getSelectedAnnotation()));
        this.myTable.setSelectionMode(0);
        this.myTable.setRowSelectionAllowed(true);
        this.myTable.setShowGrid(false);
        JPanel tablePanel = UI.PanelFactory.panel((JComponent)toolbarDecorator.createPanel()).withLabel(JavaBundle.message("nullable.notnull.annotations.panel.title", model.getName())).withComment(JavaBundle.message("nullable.notnull.annotations.panel.description", new Object[0])).moveLabelOnTop().resizeY(true).createPanel();
        tablePanel.setPreferredSize((Dimension)new JBDimension(tablePanel.getPreferredSize().width, 200));
        this.myComponent = new JPanel(new GridBagLayout());
        this.myComponent.putClientProperty(DslComponentProperty.VERTICAL_COMPONENT_GAP, VerticalComponentGap.BOTH);
        GridBag constraints = new GridBag().setDefaultAnchor(17);
        this.myComponent.add((Component)new JLabel(JavaBundle.message("nullable.notnull.annotation.used.label", new Object[0])), constraints.nextLine().next());
        this.myComponent.add((Component)this.myCombo, constraints.next().fillCellHorizontally().weightx(1.0).insetBottom(4));
        this.myComponent.add((Component)tablePanel, constraints.nextLine().coverLine().fillCell().weighty(1.0));
    }

    @NotNull
    private TableCellRenderer createHeaderRenderer() {
        TableCellRenderer headerRenderer;
        final TableCellRenderer defaultRenderer = this.myTable.getTableHeader().getDefaultRenderer();
        TableCellRenderer tableCellRenderer = headerRenderer = new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component component = defaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (component instanceof JComponent) {
                    ((JComponent)component).setToolTipText(column == 1 ? JavaBundle.message("nullable.notnull.annotations.runtime.instrumentation.tooltip", new Object[0]) : null);
                }
                return component;
            }
        };
        if (tableCellRenderer == null) {
            NullableAnnotationsPanel.$$$reportNull$$$0(1);
        }
        return tableCellRenderer;
    }

    private void loadAdvancedAnnotations(@NotNull AnnotationPanelModel model) {
        if (model == null) {
            NullableAnnotationsPanel.$$$reportNull$$$0(2);
        }
        if (this.myProject.isDefault()) {
            return;
        }
        final String loading = JavaBundle.message("loading.additional.annotations", new Object[0]);
        this.myCombo.addItem((Object)loading);
        DumbService.getInstance((Project)this.myProject).runWhenSmart(() -> ReadAction.nonBlocking(model::getAdvancedAnnotations).finishOnUiThread(ModalityState.any(), advancedAnnotations -> {
            this.myCombo.removeItem((Object)loading);
            int count = this.myCombo.getItemCount();
            Object selectedItem = this.myCombo.getSelectedItem();
            List<String> newItems = Stream.concat(IntStream.range(0, count).mapToObj(arg_0 -> this.myCombo.getItemAt(arg_0)), advancedAnnotations.stream()).distinct().toList();
            this.myCombo.removeAllItems();
            newItems.forEach(arg_0 -> this.myCombo.addItem(arg_0));
            this.myCombo.setSelectedItem(selectedItem);
        }).submit((Executor)AppExecutorUtil.getAppExecutorService()));
        this.myCombo.addActionListener(new ActionListener(){
            Object previous;
            {
                this.previous = NullableAnnotationsPanel.this.myCombo.getSelectedItem();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Object item = NullableAnnotationsPanel.this.myCombo.getSelectedItem();
                if (item == loading) {
                    NullableAnnotationsPanel.this.myCombo.setSelectedItem(this.previous);
                } else {
                    this.previous = item;
                }
            }
        });
    }

    private void addRow(String annotation, boolean checked) {
        int row;
        int n = row = this.myTable == null ? -1 : this.myTable.getSelectedRow();
        if (row == -1) {
            this.myTableModel.addRow(new Object[]{annotation, checked});
        } else {
            this.myTableModel.insertRow(row + 1, new Object[]{annotation, checked});
        }
    }

    private Integer selectAnnotation(String annotation) {
        for (int i = 0; i < this.myTableModel.getRowCount(); ++i) {
            if (!annotation.equals(this.myTableModel.getValueAt(i, 0))) continue;
            this.myTable.setRowSelectionInterval(i, i);
            this.myTable.scrollRectToVisible(this.myTable.getCellRect(i, 0, true));
            return i;
        }
        return null;
    }

    @NlsSafe
    private String getSelectedAnnotation() {
        int selectedRow = this.myTable.getSelectedRow();
        return selectedRow < 0 ? null : (String)this.myTableModel.getValueAt(selectedRow, 0);
    }

    private void chooseAnnotation(@NlsSafe String title) {
        TreeClassChooser chooser = TreeClassChooserFactory.getInstance(this.myProject).createNoInnerClassesScopeChooser(JavaBundle.message("dialog.title.choose.annotation", title), GlobalSearchScope.allScope((Project)this.myProject), PsiClass::isAnnotationType, null);
        chooser.showDialog();
        PsiClass selected = chooser.getSelected();
        if (selected == null) {
            return;
        }
        String qualifiedName = selected.getQualifiedName();
        if (this.selectAnnotation(qualifiedName) == null) {
            this.addRow(qualifiedName, false);
            this.addAnnotationToCombo(qualifiedName);
            Integer added = this.selectAnnotation(qualifiedName);
            assert (added != null);
            this.myTable.requestFocus();
        }
    }

    private void addAnnotationToCombo(@NlsSafe String annotation) {
        int insertAt;
        for (insertAt = 0; insertAt < this.myCombo.getItemCount() && ((String)this.myCombo.getItemAt(insertAt)).compareTo(annotation) < 0; ++insertAt) {
        }
        this.myCombo.insertItemAt((Object)annotation, insertAt);
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    String getDefaultAnnotation() {
        return (String)this.myCombo.getItem();
    }

    public String[] getAnnotations() {
        int size = this.myTableModel.getRowCount();
        String[] result = new String[size];
        for (int i = 0; i < size; ++i) {
            result[i] = (String)this.myTableModel.getValueAt(i, 0);
        }
        return result;
    }

    List<String> getCheckedAnnotations() {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < this.myTableModel.getRowCount(); ++i) {
            if (!Boolean.TRUE.equals(this.myTableModel.getValueAt(i, 1))) continue;
            result.add((String)this.myTableModel.getValueAt(i, 0));
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/NullableAnnotationsPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/NullableAnnotationsPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createHeaderRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadAdvancedAnnotations";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

