/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.NullabilityAnnotationPanelModel;
import com.intellij.codeInsight.NullableAnnotationsPanel;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.java.JavaBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.components.JBTabbedPane;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class NullableNotNullDialog
extends DialogWrapper {
    private final Project myProject;
    private final NullableAnnotationsPanel myNullablePanel;
    private final NullableAnnotationsPanel myNotNullPanel;
    private final boolean myShowInstrumentationOptions;
    @NlsSafe
    public static final String NULLABLE = "Nullable";
    @NlsSafe
    public static final String NOT_NULL = "NotNull";

    public NullableNotNullDialog(@NotNull Project project) {
        if (project == null) {
            NullableNotNullDialog.$$$reportNull$$$0(0);
        }
        this(project, false);
    }

    private NullableNotNullDialog(@NotNull Project project, boolean showInstrumentationOptions) {
        if (project == null) {
            NullableNotNullDialog.$$$reportNull$$$0(1);
        }
        super(project, true);
        this.myProject = project;
        this.myShowInstrumentationOptions = showInstrumentationOptions;
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)this.myProject);
        this.myNullablePanel = new NullableAnnotationsPanel(project, new NullabilityAnnotationPanelModel.NullableModel(manager), false);
        this.myNotNullPanel = new NullableAnnotationsPanel(project, new NullabilityAnnotationPanelModel.NotNullModel(manager), showInstrumentationOptions);
        this.init();
        this.setTitle(JavaBundle.message("nullable.notnull.configuration.dialog.title", new Object[0]));
    }

    public static JButton createConfigureAnnotationsButton(@NotNull Project project) {
        if (project == null) {
            NullableNotNullDialog.$$$reportNull$$$0(2);
        }
        JButton button = new JButton(JavaBundle.message("configure.annotations.option", new Object[0]));
        button.addActionListener(NullableNotNullDialog.createActionListener(project));
        return button;
    }

    private static ActionListener createActionListener(final @NotNull Project context) {
        if (context == null) {
            NullableNotNullDialog.$$$reportNull$$$0(3);
        }
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NullableNotNullDialog.showDialog(context, false);
            }
        };
    }

    public static void showDialogWithInstrumentationOptions(@NotNull Project project) {
        if (project == null) {
            NullableNotNullDialog.$$$reportNull$$$0(4);
        }
        NullableNotNullDialog.showDialog(project, true);
    }

    private static void showDialog(@NotNull Project project, boolean showInstrumentationOptions) {
        if (project == null) {
            NullableNotNullDialog.$$$reportNull$$$0(5);
        }
        NullableNotNullDialog dialog = new NullableNotNullDialog(project, showInstrumentationOptions);
        dialog.show();
    }

    protected JComponent createCenterPanel() {
        JBTabbedPane pane = new JBTabbedPane();
        pane.insertTab(NULLABLE, null, (Component)this.myNullablePanel.getComponent(), "", 0);
        pane.insertTab(NOT_NULL, null, (Component)this.myNotNullPanel.getComponent(), "", 1);
        return pane;
    }

    protected void doOKAction() {
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)this.myProject);
        manager.setNotNulls(this.myNotNullPanel.getAnnotations());
        manager.setDefaultNotNull(this.myNotNullPanel.getDefaultAnnotation());
        manager.setNullables(this.myNullablePanel.getAnnotations());
        manager.setDefaultNullable(this.myNullablePanel.getDefaultAnnotation());
        if (this.myShowInstrumentationOptions) {
            manager.setInstrumentedNotNulls(this.myNotNullPanel.getCheckedAnnotations());
        }
        super.doOKAction();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/NullableNotNullDialog";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "createConfigureAnnotationsButton";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createActionListener";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "showDialogWithInstrumentationOptions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "showDialog";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

