/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion.util;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.util.MethodParenthesesHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiFormatUtil;
import org.jetbrains.annotations.NotNull;

public class SimpleMethodCallLookupElement
extends LookupElement {
    private final PsiMethod myMethod;

    public SimpleMethodCallLookupElement(PsiMethod method) {
        this.myMethod = method;
    }

    @NotNull
    public String getLookupString() {
        String string = this.myMethod.getName();
        if (string == null) {
            SimpleMethodCallLookupElement.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void handleInsert(@NotNull InsertionContext context) {
        if (context == null) {
            SimpleMethodCallLookupElement.$$$reportNull$$$0(1);
        }
        new MethodParenthesesHandler(this.myMethod, true).handleInsert(context, this);
    }

    public PsiMethod getMethod() {
        return this.myMethod;
    }

    public void renderElement(@NotNull LookupElementPresentation presentation) {
        if (presentation == null) {
            SimpleMethodCallLookupElement.$$$reportNull$$$0(2);
        }
        presentation.setIcon(this.myMethod.getIcon(1));
        presentation.setItemText(this.myMethod.getName());
        presentation.setTailText(PsiFormatUtil.formatMethod((PsiMethod)this.myMethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)256, (int)3));
        PsiType returnType = this.myMethod.getReturnType();
        if (returnType != null) {
            presentation.setTypeText(returnType.getCanonicalText());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/completion/util/SimpleMethodCallLookupElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupString";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/completion/util/SimpleMethodCallLookupElement";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "handleInsert";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "renderElement";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

