/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.library;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.ThrottledLogger;
import com.intellij.openapi.fileEditor.FileDocumentManagerListener;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.SimpleModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.ForcefulReparseModificationTracker;
import com.intellij.util.messages.MessageBusConnection;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
@ApiStatus.Experimental
public final class JavaLibraryModificationTracker
implements ModificationTracker,
Disposable {
    private final ModificationTracker myProjectRootManager;
    private final ModificationTracker myDumbServiceModificationTracker;
    private final ModificationTracker myForcefulReparseModificationTracker;
    private final SimpleModificationTracker myOnContentReloadModificationTracker = new SimpleModificationTracker();
    private static final ThrottledLogger THROTTLED_LOG = new ThrottledLogger(Logger.getInstance(JavaLibraryModificationTracker.class), TimeUnit.SECONDS.toMillis(30L));
    private final Throwable creationStack = new Throwable();

    public JavaLibraryModificationTracker(final Project project) {
        this.myProjectRootManager = ProjectRootManager.getInstance((Project)project);
        this.myDumbServiceModificationTracker = DumbService.getInstance((Project)project).getModificationTracker();
        this.myForcefulReparseModificationTracker = ForcefulReparseModificationTracker.getInstance();
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)this);
        connection.subscribe(FileDocumentManagerListener.TOPIC, (Object)new FileDocumentManagerListener(){
            private final GlobalSearchScope projectLibraryScope;
            {
                this.projectLibraryScope = ProjectScope.getLibrariesScope((Project)project);
            }

            public void fileWithNoDocumentChanged(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!project.isInitialized()) {
                    THROTTLED_LOG.warn("SearchScope.contains(file) would log an error because WorkspaceFileIndex is not yet initialized. Probably JavaLibraryModificationTracker was created too early. See JavaLibraryModificationTracker creation stacktrace: ", JavaLibraryModificationTracker.this.creationStack);
                    return;
                }
                if (this.projectLibraryScope.contains(file)) {
                    JavaLibraryModificationTracker.this.myOnContentReloadModificationTracker.incModificationCount();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/java/library/JavaLibraryModificationTracker$1", "fileWithNoDocumentChanged"));
            }
        });
    }

    public long getModificationCount() {
        return this.myProjectRootManager.getModificationCount() + this.myDumbServiceModificationTracker.getModificationCount() + this.myForcefulReparseModificationTracker.getModificationCount() + this.myOnContentReloadModificationTracker.getModificationCount();
    }

    @TestOnly
    public void incModificationCount() {
        this.myOnContentReloadModificationTracker.incModificationCount();
    }

    public void dispose() {
    }

    public static ModificationTracker getInstance(Project project) {
        return (ModificationTracker)project.getService(JavaLibraryModificationTracker.class);
    }

    @TestOnly
    public static void incModificationCount(Project project) {
        ((JavaLibraryModificationTracker)project.getService(JavaLibraryModificationTracker.class)).incModificationCount();
    }
}

