/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.SdkTypeId;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.psi.PsiElement;
import java.util.Comparator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaSdkVersionUtil {
    public static boolean isAtLeast(@NotNull PsiElement element, @NotNull JavaSdkVersion expected) {
        JavaSdkVersion version;
        if (element == null) {
            JavaSdkVersionUtil.$$$reportNull$$$0(0);
        }
        if (expected == null) {
            JavaSdkVersionUtil.$$$reportNull$$$0(1);
        }
        return (version = JavaSdkVersionUtil.getJavaSdkVersion(element)) == null || version.isAtLeast(expected);
    }

    @Contract(value="null, _ -> true")
    public static boolean isAtLeast(@Nullable Sdk jdk, @NotNull JavaSdkVersion expected) {
        JavaSdkVersion actual;
        if (expected == null) {
            JavaSdkVersionUtil.$$$reportNull$$$0(2);
        }
        return (actual = JavaSdkVersionUtil.getJavaSdkVersion(jdk)) == null || actual.isAtLeast(expected);
    }

    @Nullable
    public static JavaSdkVersion getJavaSdkVersion(@NotNull PsiElement element) {
        Module module;
        if (element == null) {
            JavaSdkVersionUtil.$$$reportNull$$$0(3);
        }
        return (module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element)) != null ? JavaSdkVersionUtil.getJavaSdkVersion(ModuleRootManager.getInstance((Module)module).getSdk()) : null;
    }

    @Nullable
    public static JavaSdkVersion getJavaSdkVersion(@Nullable Sdk sdk) {
        if (sdk != null) {
            SdkTypeId sdkType = sdk.getSdkType();
            if (!(sdkType instanceof JavaSdk) && sdkType instanceof SdkType) {
                sdkType = ((SdkType)sdkType).getDependencyType();
            }
            if (sdkType instanceof JavaSdk) {
                return ((JavaSdk)sdkType).getVersion(sdk);
            }
        }
        return null;
    }

    @ApiStatus.Obsolete
    @Nullable
    public static Sdk findJdkByVersion(@NotNull JavaSdkVersion version) {
        if (version == null) {
            JavaSdkVersionUtil.$$$reportNull$$$0(4);
        }
        JavaSdk javaSdk = JavaSdk.getInstance();
        Sdk candidate = null;
        for (Sdk sdk : ProjectJdkTable.getInstance().getSdksOfType((SdkTypeId)javaSdk)) {
            String homePath = sdk.getHomePath();
            if (homePath == null || !javaSdk.isValidSdkHome(homePath)) continue;
            JavaSdkVersion v = javaSdk.getVersion(sdk);
            if (v == version) {
                return sdk;
            }
            if (candidate != null || v == null || !v.isAtLeast(version)) continue;
            candidate = sdk;
        }
        return candidate;
    }

    @NotNull
    public static Comparator<Sdk> naturalJavaSdkOrder(boolean nullsFirst) {
        Comparator javaSdkVersionComparator = nullsFirst ? Comparator.nullsFirst(Comparator.naturalOrder()) : Comparator.nullsLast(Comparator.naturalOrder());
        Comparator comparator = (sdk1, sdk2) -> {
            JavaSdkVersion jdkVersion1 = JavaSdkVersionUtil.getJavaSdkVersion(sdk1);
            JavaSdkVersion jdkVersion2 = JavaSdkVersionUtil.getJavaSdkVersion(sdk2);
            return javaSdkVersionComparator.compare(jdkVersion1, jdkVersion2);
        };
        if (comparator == null) {
            JavaSdkVersionUtil.$$$reportNull$$$0(5);
        }
        return comparator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expected";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/JavaSdkVersionUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/JavaSdkVersionUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "naturalJavaSdkOrder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAtLeast";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getJavaSdkVersion";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findJdkByVersion";
                break;
            }
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }
}

