/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.actions.vcs;

import com.intellij.DynamicBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsType;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.tasks.ChangeListInfo;
import com.intellij.tasks.LocalTask;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.impl.TaskManagerImpl;
import com.intellij.tasks.ui.TaskDialogPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class VcsCloseTaskPanel
extends TaskDialogPanel {
    private JPanel myPanel;
    private JPanel myVcsPanel;
    private JCheckBox myCommitChanges;
    private JBCheckBox myMergeBranches;
    private final Project myProject;
    private final LocalTask myTask;
    private final TaskManagerImpl myTaskManager;

    public VcsCloseTaskPanel(Project project, LocalTask task2) {
        this.myProject = project;
        this.myTask = task2;
        this.$$$setupUI$$$();
        this.myTaskManager = (TaskManagerImpl)TaskManager.getManager((Project)project);
        boolean hasChanges = !task2.getChangeLists().isEmpty();
        this.myCommitChanges.setEnabled(hasChanges);
        this.myCommitChanges.setSelected(hasChanges && this.myTaskManager.getState().commitChanges);
        if (this.myTaskManager.getActiveVcs().getType() == VcsType.distributed) {
            boolean enabled = !task2.getBranches(true).isEmpty() && !task2.getBranches(false).isEmpty();
            this.myMergeBranches.setEnabled(enabled);
            this.myMergeBranches.setSelected(enabled && this.myTaskManager.getState().mergeBranch);
        } else {
            this.myMergeBranches.setVisible(false);
        }
    }

    @Override
    @NotNull
    public JComponent getPanel() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            VcsCloseTaskPanel.$$$reportNull$$$0(0);
        }
        return jPanel;
    }

    boolean isCommitChanges() {
        return this.myCommitChanges.isSelected();
    }

    boolean isMergeBranch() {
        return this.myMergeBranches.isSelected();
    }

    @Override
    public void commit() {
        if (this.myCommitChanges.isEnabled()) {
            this.myTaskManager.getState().commitChanges = this.isCommitChanges();
        }
        if (this.myMergeBranches.isEnabled()) {
            this.myTaskManager.getState().mergeBranch = this.isMergeBranch();
        }
        if (this.isCommitChanges()) {
            ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myProject);
            for (ChangeListInfo info : this.myTask.getChangeLists()) {
                LocalChangeList list = changeListManager.getChangeList(info.id);
                if (list == null) continue;
                changeListManager.commitChanges(list, new ArrayList(list.getChanges()));
            }
        }
        if (this.isMergeBranch()) {
            this.myTaskManager.mergeBranch(this.myTask);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/tasks/actions/vcs/VcsCloseTaskPanel", "getPanel"));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JCheckBox jCheckBox;
        JPanel jPanel;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myVcsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)DynamicBundle.getBundle((String)"messages/TaskBundle", VcsCloseTaskPanel.class).getString("vcs.operations"), (int)0, (int)0, null, null));
        this.myCommitChanges = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/TaskBundle", VcsCloseTaskPanel.class).getString("commit.changes"));
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 1, 9, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myMergeBranches = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/TaskBundle", VcsCloseTaskPanel.class).getString("merge.branche.s"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

