/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.css.util;

import com.intellij.css.util.CssPsiUtilCore;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.lang.css.CssLanguageProperties;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElementFactory;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssMedia;
import com.intellij.psi.css.CssPropertyDescriptor;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.CssValueOwner;
import com.intellij.psi.css.descriptor.CssMediaType;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CssPsiUtil {
    private CssPsiUtil() {
    }

    @NotNull
    public static Set<String> getRulesetTags(@NotNull CssRuleset ruleset) {
        if (ruleset == null) {
            CssPsiUtil.$$$reportNull$$$0(0);
        }
        HashSet<String> result = new HashSet<String>();
        for (CssSelector selector : ruleset.getSelectors()) {
            CssSimpleSelector lastElement = (CssSimpleSelector)ArrayUtil.getLastElement((Object[])selector.getSimpleSelectors());
            if (lastElement == null) continue;
            result.add(lastElement.getElementName());
        }
        HashSet<String> hashSet = result;
        if (hashSet == null) {
            CssPsiUtil.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    public static boolean isInFunction(@Nullable PsiElement element) {
        CssValueOwner termListOwner = (CssValueOwner)PsiTreeUtil.getParentOfType((PsiElement)element, CssValueOwner.class);
        return termListOwner instanceof CssFunction;
    }

    @NotNull
    public static String getDeclarationsTerminatorFromContext(@Nullable PsiElement context) {
        CssLanguageProperties languageProperties = CssPsiUtil.getLanguagePropertiesFromContext(context);
        return languageProperties != null ? languageProperties.getDeclarationsTerminator() : ";";
    }

    public static boolean isIndentBasedCssLanguage(@Nullable PsiElement context) {
        CssLanguageProperties languageProperties = CssPsiUtil.getLanguagePropertiesFromContext(context);
        return languageProperties != null && languageProperties.isIndentBased();
    }

    @Nullable
    private static CssLanguageProperties getLanguagePropertiesFromContext(@Nullable PsiElement context) {
        Language stylesheetLanguage = CssPsiUtilCore.getStylesheetLanguage((PsiElement)context);
        if (stylesheetLanguage instanceof CssLanguageProperties) {
            return (CssLanguageProperties)stylesheetLanguage;
        }
        return null;
    }

    @NotNull
    public static Set<CssMediaType> getAllowedMediaTypesInContext(@Nullable PsiElement context) {
        CssMedia customMedia;
        String attributeValue;
        CssMedia media = (CssMedia)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{CssMedia.class});
        if (media != null) {
            Set set = media.getMediaTypes();
            if (set == null) {
                CssPsiUtil.$$$reportNull$$$0(2);
            }
            return set;
        }
        HtmlTag htmlTag = (HtmlTag)PsiTreeUtil.getNonStrictParentOfType((PsiElement)context, (Class[])new Class[]{HtmlTag.class});
        if (htmlTag != null && "style".equals(htmlTag.getName()) && StringUtil.isNotEmpty((String)(attributeValue = htmlTag.getAttributeValue("media"))) && (customMedia = CssElementFactory.getInstance((Project)context.getProject()).createMedia(attributeValue, (Language)CSSLanguage.INSTANCE)) != null) {
            Set set = customMedia.getMediaTypes();
            if (set == null) {
                CssPsiUtil.$$$reportNull$$$0(3);
            }
            return set;
        }
        HashSet hashSet = ContainerUtil.newHashSet((Object[])new CssMediaType[]{CssMediaType.ALL});
        if (hashSet == null) {
            CssPsiUtil.$$$reportNull$$$0(4);
        }
        return hashSet;
    }

    public static boolean isCustomVariableReference(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            CssPsiUtil.$$$reportNull$$$0(5);
        }
        if ((parent = element.getParent()) instanceof CssTerm) {
            return CssPsiUtil.isTheOnlyFunctionArgument((CssTerm)parent, "var");
        }
        return false;
    }

    public static boolean isTheOnlyFunctionArgument(@NotNull CssTerm term, @NotNull String functionName) {
        PsiElement termList;
        if (term == null) {
            CssPsiUtil.$$$reportNull$$$0(6);
        }
        if (functionName == null) {
            CssPsiUtil.$$$reportNull$$$0(7);
        }
        if ((termList = term.getParent()) instanceof CssTermList) {
            PsiElement function = termList.getParent();
            if (function instanceof CssTermList && function.getChildren().length == 1) {
                function = function.getParent();
            }
            if (function instanceof CssFunction && functionName.equalsIgnoreCase(((CssFunction)function).getName())) {
                CssTerm[] terms = ((CssTermList)termList).getTerms();
                return terms.length == 1 || terms.length == 2 && term.getPrevSibling() == null;
            }
        }
        return false;
    }

    @NotNull
    public static Collection<? extends CssPropertyDescriptor> getFilteredPropertyDescriptors(@NotNull CssDeclaration declaration) {
        Collection filteredByMediaTypeDescriptors;
        if (declaration == null) {
            CssPsiUtil.$$$reportNull$$$0(8);
        }
        String name = declaration.getPropertyName();
        PsiElement nameIdentifier = declaration.getPropertyNameElement();
        if (StringUtil.isEmpty((String)name) || nameIdentifier == null) {
            List list = Collections.emptyList();
            if (list == null) {
                CssPsiUtil.$$$reportNull$$$0(9);
            }
            return list;
        }
        Collection descriptors = declaration.getDescriptors();
        Collection filteredByContextDescriptors = CssDescriptorsUtil.filterDescriptorsByContext(descriptors, nameIdentifier);
        if (!filteredByContextDescriptors.isEmpty() && !(filteredByMediaTypeDescriptors = CssDescriptorsUtil.filterDescriptorsByMediaType(descriptors = filteredByContextDescriptors, nameIdentifier)).isEmpty()) {
            descriptors = filteredByMediaTypeDescriptors;
        }
        Collection collection = descriptors;
        if (collection == null) {
            CssPsiUtil.$$$reportNull$$$0(10);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 9, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ruleset";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/css/util/CssPsiUtil";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "term";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionName";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/css/util/CssPsiUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRulesetTags";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllowedMediaTypesInContext";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteredPropertyDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRulesetTags";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 9: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isCustomVariableReference";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isTheOnlyFunctionArgument";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFilteredPropertyDescriptors";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 9, 10 -> new IllegalStateException(string);
        };
    }
}

